/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.ws.client.utils;

import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.BindingProvider;

public class RequestContextUtils {
    private static final String PROPERTIES = "/client.properties";
    private String url;
    private String username;
    private String password;

    public RequestContextUtils(String service) throws Exception {
        try {
            InputStream is = RequestContextUtils.class.getResourceAsStream(PROPERTIES);
            if (is == null) {
                throw new Exception("File [/client.properties] not found in classpath");
            }
            Properties props = new Properties();
            props.load(is);
            this.url = props.getProperty(service + ".url");
            this.username = props.getProperty(service + ".username");
            this.password = props.getProperty(service + ".password");
        }
        catch (Exception e) {
            Logger.getLogger(RequestContextUtils.class.getName()).log(Level.INFO, "Errore durante l'init del RequestContextUtils", e);
            throw e;
        }
    }

    public void addRequestContextParameters(BindingProvider provider) {
        if (this.url != null) {
            provider.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.url);
        }
        if (this.username != null && this.password != null) {
            provider.getRequestContext().put("javax.xml.ws.security.auth.username", this.username);
            provider.getRequestContext().put("javax.xml.ws.security.auth.password", this.password);
        }
        provider.getRequestContext().put("schema-validation-enabled", true);
    }
}

