/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.dao;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.plugins.ConfigurazioneServizioAzione;
import org.openspcoop2.core.plugins.dao.IConfigurazioneServizioAzioneServiceSearch;
import org.openspcoop2.core.transazioni.CredenzialeMittente;
import org.openspcoop2.core.transazioni.DumpAllegato;
import org.openspcoop2.core.transazioni.DumpContenuto;
import org.openspcoop2.core.transazioni.DumpHeaderTrasporto;
import org.openspcoop2.core.transazioni.DumpMessaggio;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.core.transazioni.constants.TipoAPI;
import org.openspcoop2.core.transazioni.dao.ICredenzialeMittenteService;
import org.openspcoop2.core.transazioni.dao.IDBDumpMessaggioServiceSearch;
import org.openspcoop2.core.transazioni.dao.IDumpMessaggioServiceSearch;
import org.openspcoop2.core.transazioni.dao.ITransazioneApplicativoServerServiceSearch;
import org.openspcoop2.core.transazioni.dao.ITransazioneService;
import org.openspcoop2.core.transazioni.dao.ITransazioneServiceSearch;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCDumpMessaggioStream;
import org.openspcoop2.core.transazioni.model.TransazioneModel;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.core.transazioni.utils.TransazioniIndexUtils;
import org.openspcoop2.core.transazioni.utils.credenziali.AbstractCredenzialeList;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeClientAddress;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchApi;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchClientAddress;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchEvento;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchGruppo;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchToken;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchTokenClient;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchTrasporto;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeTokenClient;
import org.openspcoop2.generic_project.beans.Function;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.UnixTimestampIntervalField;
import org.openspcoop2.generic_project.dao.IDBServiceUtilities;
import org.openspcoop2.generic_project.dao.IExpressionConstructor;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.Index;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.monitor.engine.condition.FilterImpl;
import org.openspcoop2.monitor.engine.config.BasicServiceLibrary;
import org.openspcoop2.monitor.engine.config.BasicServiceLibraryReader;
import org.openspcoop2.monitor.engine.config.SearchServiceLibrary;
import org.openspcoop2.monitor.engine.config.SearchServiceLibraryReader;
import org.openspcoop2.monitor.engine.config.TransactionServiceLibrary;
import org.openspcoop2.monitor.engine.config.TransactionServiceLibraryReader;
import org.openspcoop2.monitor.engine.config.ricerche.ConfigurazioneRicerca;
import org.openspcoop2.monitor.engine.config.ricerche.dao.IServiceManager;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazione;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazioneRisorsaContenuto;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazioneStato;
import org.openspcoop2.monitor.engine.config.transazioni.dao.IConfigurazioneTransazioneServiceSearch;
import org.openspcoop2.monitor.engine.dynamic.DynamicFactory;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.condition.IFilter;
import org.openspcoop2.monitor.sdk.exceptions.SearchException;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.pdd.config.DynamicClusterManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.PDNDTokenInfo;
import org.openspcoop2.protocol.sdk.PDNDTokenInfoDetails;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.web.monitor.core.bean.BaseSearchForm;
import org.openspcoop2.web.monitor.core.constants.CaseSensitiveMatch;
import org.openspcoop2.web.monitor.core.constants.ModalitaRicercaTransazioni;
import org.openspcoop2.web.monitor.core.constants.TipoMatch;
import org.openspcoop2.web.monitor.core.constants.TipoMessaggio;
import org.openspcoop2.web.monitor.core.constants.TipologiaRicerca;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.PermessiUtenteOperatore;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.dao.CredenzialiMittenteUtils;
import org.openspcoop2.web.monitor.core.dao.MBeanUtilsService;
import org.openspcoop2.web.monitor.core.datamodel.ResLive;
import org.openspcoop2.web.monitor.core.dynamic.DynamicComponentUtils;
import org.openspcoop2.web.monitor.core.exception.UserInvalidException;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.thread.ThreadExecutorManager;
import org.openspcoop2.web.monitor.core.utils.ParseUtility;
import org.openspcoop2.web.monitor.transazioni.bean.DumpMessaggioBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioniSearchForm;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniApplicativoServerService;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.openspcoop2.web.monitor.transazioni.dao.TransazioniApplicativoServerService;
import org.slf4j.Logger;

public class TransazioniService
implements ITransazioniService {
    private boolean timeoutEvent = false;
    private boolean profiloDifferenteEvent = false;
    private boolean soggettoDifferenteEvent = false;
    private Integer timeoutRicerche = null;
    private Integer timeoutRicercheLive = null;
    private transient Logger log = null;
    private TransazioniSearchForm searchForm;
    private Integer liveMaxResults;
    private DAOFactory daoFactory;
    private IConfigurazioneServizioAzioneServiceSearch confSerAzSearchDAO;
    private IConfigurazioneTransazioneServiceSearch confTransazioneSearchDAO;
    private org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager transazioniPluginsServiceManager;
    private IServiceManager ricerchePluginsServiceManager;
    private org.openspcoop2.core.plugins.dao.IServiceManager basePluginsServiceManager;
    private org.openspcoop2.core.transazioni.dao.IServiceManager transazioniServiceManager;
    private ITransazioneService transazioniDAO;
    private ITransazioneApplicativoServerServiceSearch transazioniApplicativoServerSearchDAO;
    private ITransazioneServiceSearch transazioniSearchDAO;
    private ICredenzialeMittenteService credenzialiMittenteDAO;
    private IDumpMessaggioServiceSearch dumpMessaggioSearchDAO;
    private org.openspcoop2.core.commons.search.dao.IServiceManager utilsServiceManager;
    private DriverConfigurazioneDB driverConfigurazioneDB;
    private ISQLFieldConverter transazioniFieldConverter = null;
    private BasicServiceLibraryReader basicServiceLibraryReader = null;
    private TransactionServiceLibraryReader transactionServiceLibraryReader = null;
    private SearchServiceLibraryReader searchServiceLibraryReader = null;
    private Integer liveUltimiGiorni = null;
    private boolean clusterDinamico = false;
    private int clusterDinamicoRefresh;
    private boolean isAttivoSqlFilterTransazioniIntegrationManager = true;
    private List<Index> forceIndexAndamentoTemporaleFindAll;
    private List<Index> forceIndexAndamentoTemporaleCount;
    private List<Index> forceIndexIdApplicativoBaseRichiestaFindAll;
    private List<Index> forceIndexIdApplicativoBaseRichiestaCount;
    private List<Index> forceIndexIdApplicativoBaseRispostaFindAll;
    private List<Index> forceIndexIdApplicativoBaseRispostaCount;
    private List<Index> forceIndexIdApplicativoAvanzataFindAll;
    private List<Index> forceIndexIdApplicativoAvanzataCount;
    private List<Index> forceIndexIdMessaggioRichiestaFindAll;
    private List<Index> forceIndexIdMessaggioRichiestaCount;
    private List<Index> forceIndexIdMessaggioRispostaFindAll;
    private List<Index> forceIndexIdMessaggioRispostaCount;
    private List<Index> forceIndexIdCollaborazioneFindAll;
    private List<Index> forceIndexIdCollaborazioneCount;
    private List<Index> forceIndexRiferimentoIdRichiestaFindAll;
    private List<Index> forceIndexRiferimentoIdRichiestaCount;
    private List<Index> forceIndexRiferimentoIdTokenFindAll;
    private List<Index> forceIndexRiferimentoIdTokenCount;
    private List<Index> forceIndexRiferimentoIdPurposeFindAll;
    private List<Index> forceIndexRiferimentoIdPurposeCount;
    private List<Index> forceIndexIdTransazioneFindAll;
    private List<Index> forceIndexIdTransazioneCount;
    private List<Index> forceIndexGetByIdTransazione;
    private static long virtualIdRequest = -999L;
    private static long virtualIdResponse = -888L;

    private void initForceIndex(PddMonitorProperties govwayMonitorProperties) throws Exception {
        Properties repositoryExternal = govwayMonitorProperties.getExternalForceIndexRepository();
        this.forceIndexAndamentoTemporaleFindAll = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexAndamentoTemporaleFindAll(repositoryExternal));
        this.forceIndexAndamentoTemporaleCount = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexAndamentoTemporaleCount(repositoryExternal));
        this.forceIndexIdApplicativoBaseRichiestaFindAll = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexIdApplicativoBaseRichiestaFindAll(repositoryExternal));
        this.forceIndexIdApplicativoBaseRichiestaCount = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexIdApplicativoBaseRichiestaCount(repositoryExternal));
        this.forceIndexIdApplicativoBaseRispostaFindAll = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexIdApplicativoBaseRispostaFindAll(repositoryExternal));
        this.forceIndexIdApplicativoBaseRispostaCount = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexIdApplicativoBaseRispostaCount(repositoryExternal));
        this.forceIndexIdApplicativoAvanzataFindAll = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexIdApplicativoAvanzataFindAll(repositoryExternal));
        this.forceIndexIdApplicativoAvanzataCount = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexIdApplicativoAvanzataCount(repositoryExternal));
        this.forceIndexIdMessaggioRichiestaFindAll = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexIdMessaggioRichiestaFindAll(repositoryExternal));
        this.forceIndexIdMessaggioRichiestaCount = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexIdMessaggioRichiestaCount(repositoryExternal));
        this.forceIndexIdMessaggioRispostaFindAll = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexIdMessaggioRispostaFindAll(repositoryExternal));
        this.forceIndexIdMessaggioRispostaCount = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexIdMessaggioRispostaCount(repositoryExternal));
        this.forceIndexIdCollaborazioneFindAll = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexIdCollaborazioneFindAll(repositoryExternal));
        this.forceIndexIdCollaborazioneCount = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexIdCollaborazioneCount(repositoryExternal));
        this.forceIndexRiferimentoIdRichiestaFindAll = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexRiferimentoIdRichiestaFindAll(repositoryExternal));
        this.forceIndexRiferimentoIdRichiestaCount = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexRiferimentoIdRichiestaCount(repositoryExternal));
        this.forceIndexRiferimentoIdTokenFindAll = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexRiferimentoIdTokenFindAll(repositoryExternal));
        this.forceIndexRiferimentoIdTokenCount = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexRiferimentoIdTokenCount(repositoryExternal));
        this.forceIndexRiferimentoIdPurposeFindAll = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexRiferimentoIdPurposeFindAll(repositoryExternal));
        this.forceIndexRiferimentoIdPurposeCount = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexRiferimentoIdPurposeCount(repositoryExternal));
        this.forceIndexIdTransazioneFindAll = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexIdTransazioneFindAll(repositoryExternal));
        this.forceIndexIdTransazioneCount = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexIdTransazioneCount(repositoryExternal));
        this.forceIndexGetByIdTransazione = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexGetByIdTransazione(repositoryExternal));
    }

    private List<Index> convertForceIndexList(List<String> l) {
        if (l != null && l.size() > 0) {
            ArrayList<Index> li = new ArrayList<Index>();
            for (String index : l) {
                li.add(new Index((IModel)Transazione.model(), index));
            }
            return li;
        }
        return null;
    }

    private List<Index> getIndexFindAll() {
        ModalitaRicercaTransazioni ricerca = ModalitaRicercaTransazioni.getFromString((String)this.searchForm.getModalitaRicercaStorico());
        switch (ricerca) {
            case ANDAMENTO_TEMPORALE: 
            case RICERCA_LIBERA: 
            case MITTENTE_TOKEN_INFO: 
            case MITTENTE_SOGGETTO: 
            case MITTENTE_APPLICATIVO: 
            case MITTENTE_IDENTIFICATIVO_AUTENTICATO: 
            case MITTENTE_INDIRIZZO_IP: {
                return this.forceIndexAndamentoTemporaleFindAll;
            }
            case ID_APPLICATIVO_BASE: {
                TipoMessaggio tipoRicerca = TipoMessaggio.valueOf((String)this.searchForm.getTipoIdMessaggio());
                switch (tipoRicerca) {
                    case Richiesta: {
                        return this.forceIndexIdApplicativoBaseRichiestaFindAll;
                    }
                    case Risposta: {
                        return this.forceIndexIdApplicativoBaseRispostaFindAll;
                    }
                }
                break;
            }
            case ID_APPLICATIVO_AVANZATA: {
                return this.forceIndexIdApplicativoAvanzataFindAll;
            }
            case ID_MESSAGGIO: {
                TipoMessaggio tipoMessaggio = TipoMessaggio.valueOf((String)this.searchForm.getTipoIdMessaggio());
                switch (tipoMessaggio) {
                    case Richiesta: {
                        return this.forceIndexIdMessaggioRichiestaFindAll;
                    }
                    case Risposta: {
                        return this.forceIndexIdMessaggioRispostaFindAll;
                    }
                    case Collaborazione: {
                        return this.forceIndexIdCollaborazioneFindAll;
                    }
                    case RiferimentoRichiesta: {
                        return this.forceIndexRiferimentoIdRichiestaFindAll;
                    }
                }
                break;
            }
            case ID_TOKEN: {
                return this.forceIndexRiferimentoIdTokenFindAll;
            }
            case PURPOSE_ID: {
                return this.forceIndexRiferimentoIdPurposeFindAll;
            }
            case ID_TRANSAZIONE: {
                return this.forceIndexIdTransazioneFindAll;
            }
        }
        return null;
    }

    private List<Index> getIndexCount() {
        ModalitaRicercaTransazioni ricerca = ModalitaRicercaTransazioni.getFromString((String)this.searchForm.getModalitaRicercaStorico());
        switch (ricerca) {
            case ANDAMENTO_TEMPORALE: 
            case RICERCA_LIBERA: 
            case MITTENTE_TOKEN_INFO: 
            case MITTENTE_SOGGETTO: 
            case MITTENTE_APPLICATIVO: 
            case MITTENTE_IDENTIFICATIVO_AUTENTICATO: 
            case MITTENTE_INDIRIZZO_IP: {
                return this.forceIndexAndamentoTemporaleCount;
            }
            case ID_APPLICATIVO_BASE: {
                TipoMessaggio tipoRicerca = TipoMessaggio.valueOf((String)this.searchForm.getTipoIdMessaggio());
                switch (tipoRicerca) {
                    case Richiesta: {
                        return this.forceIndexIdApplicativoBaseRichiestaCount;
                    }
                    case Risposta: {
                        return this.forceIndexIdApplicativoBaseRispostaCount;
                    }
                }
                break;
            }
            case ID_APPLICATIVO_AVANZATA: {
                return this.forceIndexIdApplicativoAvanzataCount;
            }
            case ID_MESSAGGIO: {
                TipoMessaggio tipoMessaggio = TipoMessaggio.valueOf((String)this.searchForm.getTipoIdMessaggio());
                switch (tipoMessaggio) {
                    case Richiesta: {
                        return this.forceIndexIdMessaggioRichiestaCount;
                    }
                    case Risposta: {
                        return this.forceIndexIdMessaggioRispostaCount;
                    }
                    case Collaborazione: {
                        return this.forceIndexIdCollaborazioneCount;
                    }
                    case RiferimentoRichiesta: {
                        return this.forceIndexRiferimentoIdRichiestaCount;
                    }
                }
                break;
            }
            case ID_TOKEN: {
                return this.forceIndexRiferimentoIdTokenCount;
            }
            case PURPOSE_ID: {
                return this.forceIndexRiferimentoIdPurposeCount;
            }
            case ID_TRANSAZIONE: {
                return this.forceIndexIdTransazioneCount;
            }
        }
        return null;
    }

    public TransazioniService() {
        this.log = LoggerManager.getPddMonitorSqlLogger();
        try {
            this.daoFactory = DAOFactory.getInstance((Logger)this.log);
            this.transazioniPluginsServiceManager = (org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.transazioni.utils.ProjectInfo.getInstance(), this.log);
            this.confTransazioneSearchDAO = this.transazioniPluginsServiceManager.getConfigurazioneTransazioneServiceSearch();
            this.ricerchePluginsServiceManager = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.ricerche.utils.ProjectInfo.getInstance(), this.log);
            this.basePluginsServiceManager = (org.openspcoop2.core.plugins.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance(), this.log);
            this.confSerAzSearchDAO = this.basePluginsServiceManager.getConfigurazioneServizioAzioneServiceSearch();
            this.transazioniServiceManager = (org.openspcoop2.core.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), this.log);
            this.transazioniSearchDAO = this.transazioniServiceManager.getTransazioneServiceSearch();
            this.transazioniDAO = this.transazioniServiceManager.getTransazioneService();
            this.transazioniApplicativoServerSearchDAO = this.transazioniServiceManager.getTransazioneApplicativoServerServiceSearch();
            this.credenzialiMittenteDAO = this.transazioniServiceManager.getCredenzialeMittenteService();
            this.dumpMessaggioSearchDAO = this.transazioniServiceManager.getDumpMessaggioServiceSearch();
            this.transazioniFieldConverter = ((IDBServiceUtilities)this.transazioniSearchDAO).getFieldConverter();
            this.utilsServiceManager = (org.openspcoop2.core.commons.search.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), this.log);
            String datasourceJNDIName = DAOFactoryProperties.getInstance((Logger)this.log).getDatasourceJNDIName((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            Properties datasourceJNDIContext = DAOFactoryProperties.getInstance((Logger)this.log).getDatasourceJNDIContext((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            String tipoDatabase = DAOFactoryProperties.getInstance((Logger)this.log).getTipoDatabase((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            this.driverConfigurazioneDB = new DriverConfigurazioneDB(datasourceJNDIName, datasourceJNDIContext, this.log, tipoDatabase);
            PddMonitorProperties monitorProperties = PddMonitorProperties.getInstance((Logger)this.log);
            this.liveUltimiGiorni = monitorProperties.getTransazioniLiveUltimiGiorni();
            if (monitorProperties.isAttivoModuloTransazioniPersonalizzate() || monitorProperties.isAttivoModuloRicerchePersonalizzate()) {
                this.basicServiceLibraryReader = new BasicServiceLibraryReader(this.basePluginsServiceManager, this.utilsServiceManager, true);
                if (monitorProperties.isAttivoModuloTransazioniPersonalizzate()) {
                    this.transactionServiceLibraryReader = new TransactionServiceLibraryReader(this.transazioniPluginsServiceManager, true);
                }
                if (monitorProperties.isAttivoModuloRicerchePersonalizzate()) {
                    this.searchServiceLibraryReader = new SearchServiceLibraryReader(this.ricerchePluginsServiceManager, true);
                }
            }
            this.clusterDinamico = monitorProperties.isClusterDinamico();
            if (this.clusterDinamico) {
                this.clusterDinamicoRefresh = monitorProperties.getClusterDinamicoRefresh();
            }
            this.isAttivoSqlFilterTransazioniIntegrationManager = monitorProperties.isAttivoSqlFilterTransazioniIntegrationManager();
            this.initForceIndex(monitorProperties);
            this.timeoutRicerche = monitorProperties.getIntervalloTimeoutRicercaTransazioniStorico();
            this.timeoutRicercheLive = monitorProperties.getIntervalloTimeoutRicercaTransazioniLive();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        this.liveMaxResults = 50;
    }

    public TransazioniService(Connection con, boolean autoCommit, Logger log) {
        this(con, autoCommit, null, log);
    }

    public TransazioniService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties, Logger log) {
        this.log = log;
        try {
            this.daoFactory = DAOFactory.getInstance((Logger)this.log);
            this.transazioniPluginsServiceManager = (org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.transazioni.utils.ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, this.log);
            this.confTransazioneSearchDAO = this.transazioniPluginsServiceManager.getConfigurazioneTransazioneServiceSearch();
            this.ricerchePluginsServiceManager = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.ricerche.utils.ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, this.log);
            this.basePluginsServiceManager = (org.openspcoop2.core.plugins.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, this.log);
            this.confSerAzSearchDAO = this.basePluginsServiceManager.getConfigurazioneServizioAzioneServiceSearch();
            this.transazioniServiceManager = (org.openspcoop2.core.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, this.log);
            this.transazioniSearchDAO = this.transazioniServiceManager.getTransazioneServiceSearch();
            this.transazioniDAO = this.transazioniServiceManager.getTransazioneService();
            this.transazioniApplicativoServerSearchDAO = this.transazioniServiceManager.getTransazioneApplicativoServerServiceSearch();
            this.credenzialiMittenteDAO = this.transazioniServiceManager.getCredenzialeMittenteService();
            this.dumpMessaggioSearchDAO = this.transazioniServiceManager.getDumpMessaggioServiceSearch();
            this.transazioniFieldConverter = ((IDBServiceUtilities)this.transazioniSearchDAO).getFieldConverter();
            this.utilsServiceManager = (org.openspcoop2.core.commons.search.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, this.log);
            String tipoDatabase = serviceManagerProperties != null && serviceManagerProperties.getDatabaseType() != null ? serviceManagerProperties.getDatabaseType() : DAOFactoryProperties.getInstance((Logger)log).getTipoDatabase((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            this.driverConfigurazioneDB = new DriverConfigurazioneDB(con, log, tipoDatabase);
            PddMonitorProperties monitorProperties = PddMonitorProperties.getInstance((Logger)this.log);
            this.liveUltimiGiorni = monitorProperties.getTransazioniLiveUltimiGiorni();
            if (monitorProperties.isAttivoModuloTransazioniPersonalizzate() || monitorProperties.isAttivoModuloRicerchePersonalizzate()) {
                this.basicServiceLibraryReader = new BasicServiceLibraryReader(this.basePluginsServiceManager, this.utilsServiceManager, true);
                if (monitorProperties.isAttivoModuloTransazioniPersonalizzate()) {
                    this.transactionServiceLibraryReader = new TransactionServiceLibraryReader(this.transazioniPluginsServiceManager, true);
                }
                if (monitorProperties.isAttivoModuloRicerchePersonalizzate()) {
                    this.searchServiceLibraryReader = new SearchServiceLibraryReader(this.ricerchePluginsServiceManager, true);
                }
            }
            this.clusterDinamico = monitorProperties.isClusterDinamico();
            if (this.clusterDinamico) {
                this.clusterDinamicoRefresh = monitorProperties.getClusterDinamicoRefresh();
            }
            this.isAttivoSqlFilterTransazioniIntegrationManager = monitorProperties.isAttivoSqlFilterTransazioniIntegrationManager();
            this.initForceIndex(monitorProperties);
            this.timeoutRicerche = monitorProperties.getIntervalloTimeoutRicercaTransazioniStorico();
            this.timeoutRicercheLive = monitorProperties.getIntervalloTimeoutRicercaTransazioniLive();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        this.liveMaxResults = 50;
    }

    @Override
    public ITransazioniApplicativoServerService getTransazioniApplicativoServerService() {
        return new TransazioniApplicativoServerService(this.daoFactory, this.transazioniServiceManager, this.transazioniApplicativoServerSearchDAO);
    }

    @Override
    public void setLiveMaxResults(Integer limit) {
        this.liveMaxResults = limit;
    }

    public void setSearch(TransazioniSearchForm search) {
        this.searchForm = search;
    }

    public TransazioniSearchForm getSearch() {
        return this.searchForm;
    }

    private void setOrderField(IExpression expr, SortOrder sortOrder, String sortField, boolean isCount) throws Exception {
        if (sortField != null) {
            if (sortField.equals("latenzaTotale")) {
                if (!isCount) {
                    UnixTimestampIntervalField latenza = new UnixTimestampIntervalField("tempoRisposta", this.transazioniFieldConverter, true, Transazione.model().DATA_USCITA_RISPOSTA, Transazione.model().DATA_INGRESSO_RICHIESTA);
                    expr.sortOrder(sortOrder);
                    expr.addOrder((IField)latenza);
                }
                expr.isNotNull(Transazione.model().DATA_USCITA_RISPOSTA);
                expr.isNotNull(Transazione.model().DATA_INGRESSO_RICHIESTA);
            } else if (sortField.equals("latenzaServizio")) {
                if (!isCount) {
                    UnixTimestampIntervalField latenza = new UnixTimestampIntervalField("tempoRisposta", this.transazioniFieldConverter, true, Transazione.model().DATA_INGRESSO_RISPOSTA, Transazione.model().DATA_USCITA_RICHIESTA);
                    expr.sortOrder(sortOrder);
                    expr.addOrder((IField)latenza);
                }
                expr.isNotNull(Transazione.model().DATA_INGRESSO_RISPOSTA);
                expr.isNotNull(Transazione.model().DATA_USCITA_RICHIESTA);
            } else if (sortField.equals("dataIngressoRichiesta") && !isCount) {
                expr.sortOrder(sortOrder);
                expr.addOrder(Transazione.model().DATA_INGRESSO_RICHIESTA);
            }
            return;
        }
        if (!isCount) {
            expr.sortOrder(sortOrder);
            expr.addOrder(Transazione.model().DATA_INGRESSO_RICHIESTA);
        }
    }

    private boolean isSearchById() {
        boolean isLiveSearch = false;
        ModalitaRicercaTransazioni ricerca = null;
        if (!isLiveSearch) {
            ricerca = ModalitaRicercaTransazioni.getFromString((String)this.searchForm.getModalitaRicercaStorico());
        }
        if (ricerca == null) {
            return false;
        }
        return ModalitaRicercaTransazioni.ID_MESSAGGIO.equals((Object)ricerca) || ModalitaRicercaTransazioni.ID_TRANSAZIONE.equals((Object)ricerca) || ModalitaRicercaTransazioni.ID_APPLICATIVO_BASE.equals((Object)ricerca);
    }

    private boolean isProfiloDifferente(List<Transazione> list) {
        String protocollo;
        if (this.searchForm.isBackRicerca()) {
            return false;
        }
        if (!this.isSearchById()) {
            return false;
        }
        if (this.searchForm.isCloned()) {
            return false;
        }
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (!this.searchForm.getModalita().equals("qualsiasi") && (protocollo = this.searchForm.getModalita()) != null && StringUtils.isNotEmpty((String)protocollo)) {
            for (Transazione transazione : list) {
                if (transazione != null && transazione.getProtocollo() != null && transazione.getProtocollo().equals(protocollo)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSoggettoDifferente(List<Transazione> list) {
        if (this.searchForm.isBackRicerca()) {
            return false;
        }
        if (!this.isSearchById()) {
            return false;
        }
        if (this.searchForm.isCloned()) {
            return false;
        }
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (Utility.isFiltroDominioAbilitato() && this.searchForm.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.searchForm.getSoggettoLocale()) && !"--".equals(this.searchForm.getSoggettoLocale())) {
            String tipoSoggettoLocale = this.searchForm.getTipoSoggettoLocale();
            String nomeSoggettoLocale = this.searchForm.getSoggettoLocale();
            String idPorta = null;
            try {
                idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (idPorta != null) {
                for (Transazione transazione : list) {
                    if (transazione != null && transazione.getPddCodice() != null && transazione.getPddCodice().equals(idPorta)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<TransazioneBean> findAll(int start, int limit, SortOrder sortOrder) {
        return this.findAll(start, limit, sortOrder, null);
    }

    @Override
    public List<TransazioneBean> findAll(int start, int limit, SortOrder sortOrder, String sortField) {
        ArrayList<TransazioneBean> listaBean = new ArrayList<TransazioneBean>();
        try {
            this.log.debug("Find All + Limit + Sorting: SortOrder[" + sortOrder.toString() + "], SortField[" + sortField + "]");
            IExpression expr = this.transazioniSearchDAO.newExpression();
            this.parseExpressionFilter(expr, false, false);
            this.setOrderField(expr, sortOrder, sortField, false);
            IPaginatedExpression pagExpr = this.transazioniSearchDAO.toPaginatedExpression(expr);
            pagExpr.offset(start).limit(limit);
            List<Index> forceIndexFindAll = this.getIndexFindAll();
            if (forceIndexFindAll != null && forceIndexFindAll.size() > 0) {
                for (Index index : forceIndexFindAll) {
                    pagExpr.addForceIndex(index);
                }
            }
            TransazioniIndexUtils.enableSoloColonneIndicizzateFullIndexSearch((IExpression)pagExpr);
            this.timeoutEvent = false;
            this.profiloDifferenteEvent = false;
            this.soggettoDifferenteEvent = false;
            List list = null;
            if (this.timeoutRicerche == null) {
                list = this.transazioniSearchDAO.findAll(pagExpr);
            } else {
                try {
                    list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.transazioniSearchDAO.findAll(pagExpr)).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    this.log.error(e.getMessage(), (Throwable)e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (list != null && list.size() > 0) {
                this.profiloDifferenteEvent = this.isProfiloDifferente(list);
                if (!this.profiloDifferenteEvent) {
                    this.soggettoDifferenteEvent = this.isSoggettoDifferente(list);
                }
                for (Transazione transazione : list) {
                    TransazioneBean bean = new TransazioneBean(transazione, this.searchForm != null ? this.searchForm.getSoggettoPddMonitor() : null);
                    bean.normalizeRichiedenteInfo(transazione, bean, this);
                    this.normalizeInfoTransazioniFromCredenzialiMittenteUriApi(bean, transazione);
                    bean.normalizeTipoApiInfo(this.utilsServiceManager, this.log);
                    bean.normalizeOperazioneInfo(this.utilsServiceManager, this.log);
                    this.normalizeInfoTransazioniFromCredenzialiMittenteGruppi(bean, transazione);
                    boolean normalizeHttpReturnCode = true;
                    this.normalizeInfoTransazioniFromCredenzialiMittenteEventi(bean, transazione, normalizeHttpReturnCode);
                    listaBean.add(bean);
                }
            }
        }
        catch (Exception e) {
            if (e != null && e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return listaBean;
    }

    public List<TransazioneBean> findAll(int start, int limit) {
        ArrayList<TransazioneBean> listaBean = new ArrayList<TransazioneBean>();
        try {
            this.log.debug("Find All + Limit");
            IExpression expr = this.transazioniSearchDAO.newExpression();
            this.parseExpressionFilter(expr, false, false);
            SortOrder sortOrder = this.searchForm.getSortOrder();
            String sortField = this.searchForm.getSortField();
            this.setOrderField(expr, sortOrder, sortField, false);
            IPaginatedExpression pagExpr = this.transazioniSearchDAO.toPaginatedExpression(expr);
            pagExpr.offset(start).limit(limit);
            List<Index> forceIndexFindAll = this.getIndexFindAll();
            if (forceIndexFindAll != null && forceIndexFindAll.size() > 0) {
                for (Index index : forceIndexFindAll) {
                    pagExpr.addForceIndex(index);
                }
            }
            TransazioniIndexUtils.enableSoloColonneIndicizzateFullIndexSearch((IExpression)pagExpr);
            this.timeoutEvent = false;
            this.profiloDifferenteEvent = false;
            this.soggettoDifferenteEvent = false;
            List list = null;
            if (this.timeoutRicerche == null) {
                list = this.transazioniSearchDAO.findAll(pagExpr);
            } else {
                try {
                    list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.transazioniSearchDAO.findAll(pagExpr)).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    this.log.error(e.getMessage(), (Throwable)e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (list != null && list.size() > 0) {
                this.profiloDifferenteEvent = this.isProfiloDifferente(list);
                if (!this.profiloDifferenteEvent) {
                    this.soggettoDifferenteEvent = this.isSoggettoDifferente(list);
                }
                for (Transazione transazione : list) {
                    TransazioneBean bean = new TransazioneBean(transazione, this.searchForm != null ? this.searchForm.getSoggettoPddMonitor() : null);
                    bean.normalizeRichiedenteInfo(transazione, bean, this);
                    this.normalizeInfoTransazioniFromCredenzialiMittenteUriApi(bean, transazione);
                    bean.normalizeTipoApiInfo(this.utilsServiceManager, this.log);
                    bean.normalizeOperazioneInfo(this.utilsServiceManager, this.log);
                    this.normalizeInfoTransazioniFromCredenzialiMittenteGruppi(bean, transazione);
                    boolean normalizeHttpReturnCode = true;
                    this.normalizeInfoTransazioniFromCredenzialiMittenteEventi(bean, transazione, normalizeHttpReturnCode);
                    listaBean.add(bean);
                }
            }
        }
        catch (Exception e) {
            if (e != null && e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return listaBean;
    }

    @Override
    public int totalCount(SortOrder sortOrder, String sortField) {
        try {
            this.log.debug("Count + Sorting: SortOrder[" + sortOrder.toString() + "], SortField[" + sortField + "]");
            IExpression expr = this.transazioniSearchDAO.newExpression();
            this.parseExpressionFilter(expr, true, false);
            this.setOrderField(expr, sortOrder, sortField, true);
            List<Index> forceIndexCount = this.getIndexCount();
            if (forceIndexCount != null && forceIndexCount.size() > 0) {
                for (Index index : forceIndexCount) {
                    expr.addForceIndex(index);
                }
            }
            NonNegativeNumber res = this.transazioniSearchDAO.count(expr);
            return (int)res.longValue();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public int totalCount() {
        try {
            this.log.debug("Count");
            IExpression expr = this.transazioniSearchDAO.newExpression();
            this.parseExpressionFilter(expr, true, false);
            SortOrder sortOrder = this.searchForm.getSortOrder();
            String sortField = this.searchForm.getSortField();
            this.setOrderField(expr, sortOrder, sortField, true);
            List<Index> forceIndexCount = this.getIndexCount();
            if (forceIndexCount != null && forceIndexCount.size() > 0) {
                for (Index index : forceIndexCount) {
                    expr.addForceIndex(index);
                }
            }
            NonNegativeNumber res = this.transazioniSearchDAO.count(expr);
            return (int)res.longValue();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public void delete(TransazioneBean obj) throws Exception {
    }

    public void deleteById(String key) {
    }

    public List<TransazioneBean> findAll() {
        ArrayList<TransazioneBean> listaBean = new ArrayList<TransazioneBean>();
        try {
            this.log.debug("Find All");
            IExpression expr = this.transazioniSearchDAO.newExpression();
            this.parseExpressionFilter(expr, false, false);
            SortOrder sortOrder = this.searchForm.getSortOrder();
            String sortField = this.searchForm.getSortField();
            this.setOrderField(expr, sortOrder, sortField, true);
            IPaginatedExpression pagExpr = this.transazioniSearchDAO.toPaginatedExpression(expr);
            List<Index> forceIndexFindAll = this.getIndexFindAll();
            if (forceIndexFindAll != null && forceIndexFindAll.size() > 0) {
                for (Index index : forceIndexFindAll) {
                    pagExpr.addForceIndex(index);
                }
            }
            TransazioniIndexUtils.enableSoloColonneIndicizzateFullIndexSearch((IExpression)pagExpr);
            this.timeoutEvent = false;
            this.profiloDifferenteEvent = false;
            this.soggettoDifferenteEvent = false;
            List list = null;
            if (this.timeoutRicerche == null) {
                list = this.transazioniSearchDAO.findAll(pagExpr);
            } else {
                try {
                    list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.transazioniSearchDAO.findAll(pagExpr)).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    this.log.error(e.getMessage(), (Throwable)e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (list != null && list.size() > 0) {
                this.profiloDifferenteEvent = this.isProfiloDifferente(list);
                if (!this.profiloDifferenteEvent) {
                    this.soggettoDifferenteEvent = this.isSoggettoDifferente(list);
                }
                for (Transazione transazione : list) {
                    TransazioneBean bean = new TransazioneBean(transazione, this.searchForm != null ? this.searchForm.getSoggettoPddMonitor() : null);
                    bean.normalizeRichiedenteInfo(transazione, bean, this);
                    this.normalizeInfoTransazioniFromCredenzialiMittenteUriApi(bean, transazione);
                    bean.normalizeTipoApiInfo(this.utilsServiceManager, this.log);
                    bean.normalizeOperazioneInfo(this.utilsServiceManager, this.log);
                    this.normalizeInfoTransazioniFromCredenzialiMittenteGruppi(bean, transazione);
                    boolean normalizeHttpReturnCode = true;
                    this.normalizeInfoTransazioniFromCredenzialiMittenteEventi(bean, transazione, normalizeHttpReturnCode);
                    listaBean.add(bean);
                }
            }
        }
        catch (Exception e) {
            if (e != null && e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return listaBean;
    }

    public TransazioneBean findById(String key) {
        this.log.debug("Find by id: " + key);
        try {
            throw new NotImplementedException("Metodo Eliminato");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void store(TransazioneBean obj) throws Exception {
    }

    @Override
    public List<TransazioneBean> findAllLive() {
        this.log.debug("Find All Live");
        ArrayList<TransazioneBean> listaBean = new ArrayList<TransazioneBean>();
        try {
            IExpression expr = this.transazioniSearchDAO.newExpression();
            this.parseExpressionFilter(expr, false, true);
            this.setOrderField(expr, SortOrder.DESC, null, false);
            IPaginatedExpression pagExpr = this.transazioniSearchDAO.toPaginatedExpression(expr);
            pagExpr.limit(this.liveMaxResults.intValue());
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)this.log);
            Properties repositoryExternal = govwayMonitorProperties.getExternalForceIndexRepository();
            List<Index> forceIndexFindAll = this.convertForceIndexList(govwayMonitorProperties.getTransazioniForceIndexLiveFindAll(repositoryExternal));
            if (forceIndexFindAll != null && forceIndexFindAll.size() > 0) {
                for (Index index : forceIndexFindAll) {
                    pagExpr.addForceIndex(index);
                }
            }
            TransazioniIndexUtils.enableSoloColonneIndicizzateFullIndexSearch((IExpression)pagExpr);
            this.timeoutEvent = false;
            this.profiloDifferenteEvent = false;
            this.soggettoDifferenteEvent = false;
            List list = null;
            if (this.timeoutRicercheLive == null) {
                list = this.transazioniSearchDAO.findAll(pagExpr);
            } else {
                try {
                    list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.transazioniSearchDAO.findAll(pagExpr)).get(this.timeoutRicercheLive.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    this.log.error(e.getMessage(), (Throwable)e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (list != null && list.size() > 0) {
                for (Transazione transazione : list) {
                    TransazioneBean bean = new TransazioneBean(transazione, this.searchForm != null ? this.searchForm.getSoggettoPddMonitor() : null);
                    bean.normalizeRichiedenteInfo(transazione, bean, this);
                    this.normalizeInfoTransazioniFromCredenzialiMittenteUriApi(bean, transazione);
                    bean.normalizeTipoApiInfo(this.utilsServiceManager, this.log);
                    bean.normalizeOperazioneInfo(this.utilsServiceManager, this.log);
                    this.normalizeInfoTransazioniFromCredenzialiMittenteGruppi(bean, transazione);
                    boolean normalizeHttpReturnCode = true;
                    this.normalizeInfoTransazioniFromCredenzialiMittenteEventi(bean, transazione, normalizeHttpReturnCode);
                    listaBean.add(bean);
                }
            }
        }
        catch (Exception e) {
            if (e != null && e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return listaBean;
    }

    @Override
    public ResLive getEsitiInfoLive(PermessiUtenteOperatore permessiUtente, Date lastDatePick, String protocolloSelected, String protocolloDefault) {
        this.log.debug("Get Esiti Info Live[idPorta: " + permessiUtente + "], [ LastDatePick: " + lastDatePick + "]");
        try {
            String modalita;
            Properties repositoryExternal;
            PddMonitorProperties govwayMonitorProperties;
            List<Index> forceIndexEsitiCount;
            String protocolloP = protocolloDefault;
            if (protocolloSelected != null) {
                protocolloP = protocolloSelected;
            }
            EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)this.log, (String)protocolloP);
            List esitiOk = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
            List esitiKo = esitiProperties.getEsitiCodeKo_senzaFaultApplicativo();
            List esitiFault = esitiProperties.getEsitiCodeFaultApplicativo();
            IExpression exprOk = this.transazioniSearchDAO.newExpression();
            exprOk.greaterThan(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)lastDatePick);
            exprOk.and().in(Transazione.model().ESITO, (Collection)esitiOk);
            if (permessiUtente != null) {
                IExpression permessi = permessiUtente.toExpression((IExpressionConstructor)this.transazioniSearchDAO, Transazione.model().PDD_CODICE, Transazione.model().TIPO_SOGGETTO_EROGATORE, Transazione.model().NOME_SOGGETTO_EROGATORE, Transazione.model().TIPO_SERVIZIO, Transazione.model().NOME_SERVIZIO, Transazione.model().VERSIONE_SERVIZIO);
                exprOk.and(new IExpression[]{permessi});
            }
            IExpression exprFaultApplicativo = this.transazioniSearchDAO.newExpression();
            exprFaultApplicativo.greaterThan(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)lastDatePick);
            exprFaultApplicativo.and().in(Transazione.model().ESITO, (Collection)esitiFault);
            if (permessiUtente != null) {
                IExpression permessi = permessiUtente.toExpression((IExpressionConstructor)this.transazioniSearchDAO, Transazione.model().PDD_CODICE, Transazione.model().TIPO_SOGGETTO_EROGATORE, Transazione.model().NOME_SOGGETTO_EROGATORE, Transazione.model().TIPO_SERVIZIO, Transazione.model().NOME_SERVIZIO, Transazione.model().VERSIONE_SERVIZIO);
                exprFaultApplicativo.and(new IExpression[]{permessi});
            }
            IExpression exprKo = this.transazioniSearchDAO.newExpression();
            exprKo.greaterThan(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)lastDatePick);
            exprKo.and().in(Transazione.model().ESITO, (Collection)esitiKo);
            if (permessiUtente != null) {
                IExpression permessi = permessiUtente.toExpression((IExpressionConstructor)this.transazioniSearchDAO, Transazione.model().PDD_CODICE, Transazione.model().TIPO_SOGGETTO_EROGATORE, Transazione.model().NOME_SOGGETTO_EROGATORE, Transazione.model().TIPO_SERVIZIO, Transazione.model().NOME_SERVIZIO, Transazione.model().VERSIONE_SERVIZIO);
                exprKo.and(new IExpression[]{permessi});
            }
            if ((forceIndexEsitiCount = this.convertForceIndexList((govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)this.log)).getTransazioniForceIndexEsitiCount(repositoryExternal = govwayMonitorProperties.getExternalForceIndexRepository()))) != null && forceIndexEsitiCount.size() > 0) {
                for (Index index : forceIndexEsitiCount) {
                    exprOk.addForceIndex(index);
                    exprFaultApplicativo.addForceIndex(index);
                    exprKo.addForceIndex(index);
                }
            }
            if (StringUtils.isNotEmpty((String)(modalita = Utility.getLoggedUtenteModalita())) && !modalita.equals("qualsiasi")) {
                exprOk.and().equals(Transazione.model().PROTOCOLLO, (Object)modalita);
                exprFaultApplicativo.and().equals(Transazione.model().PROTOCOLLO, (Object)modalita);
                exprKo.and().equals(Transazione.model().PROTOCOLLO, (Object)modalita);
            }
            NonNegativeNumber nnnOk = this.transazioniSearchDAO.count(exprOk);
            NonNegativeNumber nnnFaultApplicativo = this.transazioniSearchDAO.count(exprFaultApplicativo);
            NonNegativeNumber nnnKo = this.transazioniSearchDAO.count(exprKo);
            if (nnnKo != null && nnnOk != null) {
                return new ResLive(Long.valueOf(nnnOk.longValue()), Long.valueOf(nnnFaultApplicativo.longValue()), Long.valueOf(nnnKo.longValue()), new Date());
            }
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return new ResLive(Long.valueOf("0"), Long.valueOf("0"), Long.valueOf("0"));
    }

    @Override
    public TransazioneBean findByIdTransazione(String idTransazione) throws Exception {
        try {
            this.log.debug("Find By Id Transazione: " + idTransazione);
            IExpression expr = this.transazioniSearchDAO.newExpression();
            expr.equals(Transazione.model().ID_TRANSAZIONE, (Object)idTransazione);
            if (this.forceIndexGetByIdTransazione != null && this.forceIndexGetByIdTransazione.size() > 0) {
                for (Index index : this.forceIndexGetByIdTransazione) {
                    expr.addForceIndex(index);
                }
            }
            Transazione t = (Transazione)this.transazioniSearchDAO.find(expr);
            TransazioneBean transazioneBean = new TransazioneBean(t, this.searchForm != null ? this.searchForm.getSoggettoPddMonitor(false) : null);
            this.normalizeInfoTransazioniFromCredenzialiMittente(transazioneBean, t);
            this.normalizeInfoTransazioniFromCredenzialiMittenteUriApi(transazioneBean, t);
            transazioneBean.normalizeTipoApiInfo(this.utilsServiceManager, this.log);
            transazioneBean.normalizeOperazioneInfo(this.utilsServiceManager, this.log);
            return transazioneBean;
        }
        catch (NotFoundException expr) {
        }
        catch (Exception e) {
            this.log.error("Impossibile recuperare La Transazione con idTransazione: " + idTransazione, (Throwable)e);
            throw new Exception("Impossibile recuperare La Transazione con idTransazione: " + idTransazione, e);
        }
        return null;
    }

    public void normalizeInfoTransazioniFromCredenzialiMittente(TransazioneBean transazioneBean, Transazione t) throws ServiceException, MultipleResultException, NotImplementedException, ExpressionNotImplementedException {
        this.normalizeInfoTransazioniFromCredenzialiMittenteTrasporto(transazioneBean, t);
        this.normalizeInfoTransazioniFromCredenzialiMittenteToken(transazioneBean, t);
        boolean normalizeHttpReturnCode = true;
        this.normalizeInfoTransazioniFromCredenzialiMittenteEventi(transazioneBean, t, normalizeHttpReturnCode);
        this.normalizeInfoTransazioniFromCredenzialiMittenteGruppi(transazioneBean, t);
    }

    public void normalizeInfoTransazioniFromCredenzialiMittenteClientAddress(TransazioneBean transazioneBean, Transazione t) throws ServiceException, MultipleResultException, NotImplementedException {
        String clientAddress = t.getClientAddress();
        if (StringUtils.isNotEmpty((String)clientAddress)) {
            try {
                MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, this.log);
                CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(clientAddress)));
                if (credenzialeMittente != null) {
                    String credenziale = credenzialeMittente.getCredenziale();
                    String socket = CredenzialeClientAddress.convertSocketDBValueToOriginal((String)credenziale);
                    String transport = CredenzialeClientAddress.convertTransportDBValueToOriginal((String)credenziale);
                    transazioneBean.setSocketClientAddressLabel(socket);
                    transazioneBean.setTransportClientAddressLabel(transport);
                }
            }
            catch (NumberFormatException e) {
                transazioneBean.setTrasportoMittenteLabel("Informazione non disponibile");
            }
            catch (NotFoundException e) {
                transazioneBean.setTrasportoMittenteLabel("Informazione non piu' presente");
            }
        }
    }

    public void normalizeInfoTransazioniFromCredenzialiMittenteTrasporto(TransazioneBean transazioneBean, Transazione t) throws ServiceException, MultipleResultException, NotImplementedException {
        String trasportoMittente = t.getTrasportoMittente();
        if (StringUtils.isNotEmpty((String)trasportoMittente)) {
            try {
                MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, this.log);
                CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(trasportoMittente)));
                if (credenzialeMittente != null) {
                    transazioneBean.setTrasportoMittenteLabel(credenzialeMittente.getCredenziale());
                    transazioneBean.setTipoTrasportoMittenteLabel(credenzialeMittente.getTipo());
                }
            }
            catch (NumberFormatException e) {
                transazioneBean.setTrasportoMittenteLabel("Informazione non disponibile");
            }
            catch (NotFoundException e) {
                transazioneBean.setTrasportoMittenteLabel("Informazione non piu' presente");
            }
        }
    }

    public void normalizeInfoTransazioniFromCredenzialiMittenteToken(TransazioneBean transazioneBean, Transazione t) throws ServiceException, MultipleResultException, NotImplementedException, ExpressionNotImplementedException {
        this.normalizeInfoTransazioniFromCredenzialiMittenteTokenIssuer(transazioneBean, t);
        this.normalizeInfoTransazioniFromCredenzialiMittenteTokenClientID(transazioneBean, t);
        this.normalizeInfoTransazioniFromCredenzialiMittenteTokenPdnd(transazioneBean, t, true);
        this.normalizeInfoTransazioniFromCredenzialiMittenteTokenSubject(transazioneBean, t);
        this.normalizeInfoTransazioniFromCredenzialiMittenteTokenUsername(transazioneBean, t);
        this.normalizeInfoTransazioniFromCredenzialiMittenteTokenMail(transazioneBean, t);
    }

    public void normalizeInfoTransazioniFromCredenzialiMittenteTokenIssuer(TransazioneBean transazioneBean, Transazione t) throws ServiceException, MultipleResultException, NotImplementedException {
        String tokenIssuer = t.getTokenIssuer();
        if (StringUtils.isNotEmpty((String)tokenIssuer)) {
            try {
                MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, this.log);
                CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(tokenIssuer)));
                if (credenzialeMittente != null) {
                    transazioneBean.setTokenIssuerLabel(credenzialeMittente.getCredenziale());
                }
            }
            catch (NumberFormatException e) {
                transazioneBean.setTokenIssuerLabel("Informazione non disponibile");
            }
            catch (NotFoundException e) {
                transazioneBean.setTokenIssuerLabel("Informazione non piu' presente");
            }
        }
    }

    public void normalizeInfoTransazioniFromCredenzialiMittenteTokenClientID(TransazioneBean transazioneBean, Transazione t) throws ServiceException, MultipleResultException, NotImplementedException {
        block9: {
            String tokenClientID = t.getTokenClientId();
            if (StringUtils.isNotEmpty((String)tokenClientID)) {
                try {
                    MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, this.log);
                    CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(tokenClientID)));
                    if (credenzialeMittente == null) break block9;
                    String credenziale = credenzialeMittente.getCredenziale();
                    try {
                        String clientId = CredenzialeTokenClient.convertClientIdDBValueToOriginal((String)credenziale);
                        transazioneBean.setTokenClientIdLabel(clientId);
                    }
                    catch (Throwable e) {
                        transazioneBean.setTokenClientIdLabel("Informazione non disponibile");
                    }
                    try {
                        IDServizioApplicativo idSA = CredenzialeTokenClient.convertApplicationDBValueToOriginal((String)credenziale);
                        transazioneBean.setTokenClient(idSA);
                        if (idSA != null) {
                            transazioneBean.setTokenClientNameLabel(idSA.getNome());
                            transazioneBean.setTokenClientOrganizationNameLabel(NamingUtils.getLabelSoggetto((String)transazioneBean.getProtocollo(), (String)idSA.getIdSoggettoProprietario().getTipo(), (String)idSA.getIdSoggettoProprietario().getNome()));
                        }
                    }
                    catch (Throwable e) {
                        transazioneBean.setTokenClient(null);
                        transazioneBean.setTokenClientNameLabel("Informazione non disponibile");
                        transazioneBean.setTokenClientOrganizationNameLabel("Informazione non disponibile");
                    }
                }
                catch (NumberFormatException e) {
                    transazioneBean.setTokenClientIdLabel("Informazione non disponibile");
                    transazioneBean.setTokenClient(null);
                    transazioneBean.setTokenClientNameLabel("Informazione non disponibile");
                    transazioneBean.setTokenClientOrganizationNameLabel("Informazione non disponibile");
                }
                catch (NotFoundException e) {
                    transazioneBean.setTokenClientIdLabel("Informazione non piu' presente");
                    transazioneBean.setTokenClient(null);
                    transazioneBean.setTokenClientNameLabel("Informazione non piu' presente");
                    transazioneBean.setTokenClientOrganizationNameLabel("Informazione non piu' presente");
                }
            }
        }
    }

    public void normalizeInfoTransazioniFromCredenzialiMittenteTokenPdnd(TransazioneBean transazioneBean, Transazione t, boolean normalizeAllInfo) throws ServiceException, NotImplementedException, ExpressionNotImplementedException {
        if (!"modipa".equals(t.getProtocollo())) {
            return;
        }
        String tokenClientID = t.getTokenClientId();
        if (StringUtils.isNotEmpty((String)tokenClientID)) {
            Long lTokenClientID = Long.parseLong(tokenClientID);
            this.normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndOrganizationName(transazioneBean, lTokenClientID);
            if (normalizeAllInfo) {
                this.normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfo(transazioneBean, lTokenClientID);
            }
        }
    }

    private void normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndOrganizationName(TransazioneBean transazioneBean, Long tokenClientID) throws ServiceException, NotImplementedException, ExpressionNotImplementedException {
        try {
            MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, this.log);
            CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteByReferenceFromCache(TipoCredenzialeMittente.PDND_ORGANIZATION_NAME, tokenClientID);
            if (credenzialeMittente != null) {
                String credenziale = credenzialeMittente.getCredenziale();
                transazioneBean.setPdndOrganizationName(credenziale);
            }
        }
        catch (NumberFormatException | ExpressionException e) {
            transazioneBean.setPdndOrganizationName("Informazione non disponibile");
        }
        catch (NotFoundException e) {
            transazioneBean.setPdndOrganizationName(null);
        }
    }

    private void normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfo(TransazioneBean transazioneBean, Long tokenClientID) throws ServiceException, NotImplementedException, ExpressionNotImplementedException {
        this.normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoOrganization(transazioneBean, tokenClientID);
        this.normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoClient(transazioneBean, tokenClientID);
    }

    private void normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoOrganization(TransazioneBean transazioneBean, Long tokenClientID) throws ServiceException, NotImplementedException, ExpressionNotImplementedException {
        try {
            MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, this.log);
            CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteByReferenceFromCache(TipoCredenzialeMittente.PDND_ORGANIZATION_JSON, tokenClientID);
            if (credenzialeMittente != null) {
                String credenziale = credenzialeMittente.getCredenziale();
                PDNDTokenInfo pdndTokenOrganizationInfo = new PDNDTokenInfo();
                PDNDTokenInfoDetails idDetails = new PDNDTokenInfoDetails();
                idDetails.setDetails(credenziale);
                pdndTokenOrganizationInfo.setOrganization(idDetails);
                this.normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoSetOrganizationCategory(transazioneBean, pdndTokenOrganizationInfo);
                this.normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoSetOrganizationSubUnit(transazioneBean, pdndTokenOrganizationInfo);
                this.normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoSetOrganizationExternalId(transazioneBean, pdndTokenOrganizationInfo);
                this.normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoSetOrganizationConsumerId(transazioneBean, pdndTokenOrganizationInfo);
            }
        }
        catch (NumberFormatException | ExpressionException e) {
            transazioneBean.setPdndOrganizationCategory("Informazione non disponibile");
            transazioneBean.setPdndOrganizationSubUnit("Informazione non disponibile");
            transazioneBean.setPdndOrganizationExternalId("Informazione non disponibile");
            transazioneBean.setPdndOrganizationConsumerId("Informazione non disponibile");
        }
        catch (NotFoundException e) {
            transazioneBean.setPdndOrganizationCategory(null);
            transazioneBean.setPdndOrganizationSubUnit(null);
            transazioneBean.setPdndOrganizationExternalId(null);
            transazioneBean.setPdndOrganizationConsumerId(null);
        }
    }

    private void normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoClient(TransazioneBean transazioneBean, Long tokenClientID) throws ServiceException, NotImplementedException, ExpressionNotImplementedException {
        try {
            MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, this.log);
            CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteByReferenceFromCache(TipoCredenzialeMittente.PDND_CLIENT_JSON, tokenClientID);
            if (credenzialeMittente != null) {
                String credenziale = credenzialeMittente.getCredenziale();
                PDNDTokenInfo pdndTokenClientInfo = new PDNDTokenInfo();
                PDNDTokenInfoDetails idDetails = new PDNDTokenInfoDetails();
                idDetails.setDetails(credenziale);
                pdndTokenClientInfo.setClient(idDetails);
                this.normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoSetClientName(transazioneBean, pdndTokenClientInfo);
                this.normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoSetClientDescription(transazioneBean, pdndTokenClientInfo);
            }
        }
        catch (NumberFormatException | ExpressionException e) {
            transazioneBean.setPdndClientName("Informazione non disponibile");
            transazioneBean.setPdndClientDescription("Informazione non disponibile");
        }
        catch (NotFoundException e) {
            transazioneBean.setPdndClientName(null);
            transazioneBean.setPdndClientDescription(null);
        }
    }

    private void normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoSetOrganizationCategory(TransazioneBean transazioneBean, PDNDTokenInfo pdndTokenOrganizationInfo) {
        try {
            transazioneBean.setPdndOrganizationCategory(pdndTokenOrganizationInfo.getOrganizationCategory(this.log));
        }
        catch (Exception e) {
            transazioneBean.setPdndOrganizationCategory("Informazione non disponibile");
        }
    }

    private void normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoSetOrganizationSubUnit(TransazioneBean transazioneBean, PDNDTokenInfo pdndTokenOrganizationInfo) {
        try {
            transazioneBean.setPdndOrganizationSubUnit(pdndTokenOrganizationInfo.getOrganizationSubUnit(this.log));
        }
        catch (Exception e) {
            transazioneBean.setPdndOrganizationSubUnit("Informazione non disponibile");
        }
    }

    private void normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoSetOrganizationExternalId(TransazioneBean transazioneBean, PDNDTokenInfo pdndTokenOrganizationInfo) {
        try {
            Object pdndOrganizationExternalId = null;
            String origin = pdndTokenOrganizationInfo.getOrganizationExternalOrigin(this.log);
            String id = pdndTokenOrganizationInfo.getOrganizationExternalId(this.log);
            if (origin != null && StringUtils.isNotEmpty((String)origin) && id != null && StringUtils.isNotEmpty((String)id)) {
                pdndOrganizationExternalId = origin + " " + id;
            } else if (origin != null && StringUtils.isNotEmpty((String)origin)) {
                pdndOrganizationExternalId = origin;
            } else if (id != null && StringUtils.isNotEmpty((String)id)) {
                pdndOrganizationExternalId = id;
            }
            transazioneBean.setPdndOrganizationExternalId((String)pdndOrganizationExternalId);
        }
        catch (Exception e) {
            transazioneBean.setPdndOrganizationExternalId("Informazione non disponibile");
        }
    }

    private void normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoSetOrganizationConsumerId(TransazioneBean transazioneBean, PDNDTokenInfo pdndTokenOrganizationInfo) {
        try {
            String id = pdndTokenOrganizationInfo.getOrganizationId(this.log);
            transazioneBean.setPdndOrganizationConsumerId(id);
        }
        catch (Exception e) {
            transazioneBean.setPdndOrganizationConsumerId("Informazione non disponibile");
        }
    }

    private void normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoSetClientName(TransazioneBean transazioneBean, PDNDTokenInfo pdndTokenClientInfo) {
        try {
            transazioneBean.setPdndClientName(pdndTokenClientInfo.getClientName(this.log));
        }
        catch (Exception e) {
            transazioneBean.setPdndClientName("Informazione non disponibile");
        }
    }

    private void normalizeInfoTransazioniFromCredenzialiMittenteTokenPdndInfoSetClientDescription(TransazioneBean transazioneBean, PDNDTokenInfo pdndTokenClientInfo) {
        try {
            transazioneBean.setPdndClientDescription(pdndTokenClientInfo.getClientDescription(this.log));
        }
        catch (Exception e) {
            transazioneBean.setPdndClientDescription("Informazione non disponibile");
        }
    }

    public void normalizeInfoTransazioniFromCredenzialiMittenteTokenSubject(TransazioneBean transazioneBean, Transazione t) throws ServiceException, MultipleResultException, NotImplementedException {
        String tokenSubject = t.getTokenSubject();
        if (StringUtils.isNotEmpty((String)tokenSubject)) {
            try {
                MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, this.log);
                CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(tokenSubject)));
                if (credenzialeMittente != null) {
                    transazioneBean.setTokenSubjectLabel(credenzialeMittente.getCredenziale());
                }
            }
            catch (NumberFormatException e) {
                transazioneBean.setTokenSubjectLabel("Informazione non disponibile");
            }
            catch (NotFoundException e) {
                transazioneBean.setTokenSubjectLabel("Informazione non piu' presente");
            }
        }
    }

    public void normalizeInfoTransazioniFromCredenzialiMittenteTokenUsername(TransazioneBean transazioneBean, Transazione t) throws ServiceException, MultipleResultException, NotImplementedException {
        String tokenUsername = t.getTokenUsername();
        if (StringUtils.isNotEmpty((String)tokenUsername)) {
            try {
                MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, this.log);
                CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(tokenUsername)));
                if (credenzialeMittente != null) {
                    transazioneBean.setTokenUsernameLabel(credenzialeMittente.getCredenziale());
                }
            }
            catch (NumberFormatException e) {
                transazioneBean.setTokenUsernameLabel("Informazione non disponibile");
            }
            catch (NotFoundException e) {
                transazioneBean.setTokenUsernameLabel("Informazione non piu' presente");
            }
        }
    }

    public void normalizeInfoTransazioniFromCredenzialiMittenteTokenMail(TransazioneBean transazioneBean, Transazione t) throws ServiceException, MultipleResultException, NotImplementedException {
        String tokenMail = t.getTokenMail();
        if (StringUtils.isNotEmpty((String)tokenMail)) {
            try {
                MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, this.log);
                CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(tokenMail)));
                if (credenzialeMittente != null) {
                    transazioneBean.setTokenMailLabel(credenzialeMittente.getCredenziale());
                }
            }
            catch (NumberFormatException e) {
                transazioneBean.setTokenMailLabel("Informazione non disponibile");
            }
            catch (NotFoundException e) {
                transazioneBean.setTokenMailLabel("Informazione non piu' presente");
            }
        }
    }

    public void normalizeInfoTransazioniFromCredenzialiMittenteEventi(TransazioneBean transazioneBean, Transazione t, boolean normalizeHttpReturnCode) throws ServiceException, MultipleResultException, NotImplementedException {
        String eventi;
        String string = eventi = t instanceof TransazioneBean ? ((TransazioneBean)t).getEventiGestioneRawValue() : t.getEventiGestione();
        if (StringUtils.isNotEmpty((String)eventi)) {
            try {
                MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, this.log);
                CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(eventi)));
                if (credenzialeMittente != null) {
                    String valore = credenzialeMittente.getCredenziale();
                    transazioneBean.setEventiLabel(AbstractCredenzialeList.normalize((String)valore));
                }
                if (normalizeHttpReturnCode) {
                    Integer code;
                    if ((transazioneBean.getCodiceRispostaIngresso() == null || "".equals(transazioneBean.getCodiceRispostaIngresso())) && (code = transazioneBean.getInResponseCodeFromEventiGestione()) != null) {
                        transazioneBean.setCodiceRispostaIngresso("" + code);
                    }
                    if ((transazioneBean.getCodiceRispostaUscita() == null || "".equals(transazioneBean.getCodiceRispostaUscita())) && (code = transazioneBean.getOutResponseCodeFromEventiGestione()) != null) {
                        transazioneBean.setCodiceRispostaUscita("" + code);
                    }
                    if (transazioneBean.getTipoApi() <= 0 && (code = transazioneBean.getTipoApiFromEventiGestione()) != null) {
                        transazioneBean.setTipoApi(code);
                    }
                }
            }
            catch (NumberFormatException e) {
                transazioneBean.setEventiLabel("Informazione non disponibile");
            }
            catch (NotFoundException e) {
                transazioneBean.setEventiLabel("Informazione non piu' presente");
            }
        }
    }

    public void normalizeInfoTransazioniFromCredenzialiMittenteGruppi(TransazioneBean transazioneBean, Transazione t) throws ServiceException, MultipleResultException, NotImplementedException {
        String gruppi;
        String string = gruppi = t instanceof TransazioneBean ? ((TransazioneBean)t).getGruppiRawValue() : t.getGruppi();
        if (StringUtils.isNotEmpty((String)gruppi)) {
            try {
                MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, this.log);
                CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(gruppi)));
                if (credenzialeMittente != null) {
                    String valore = credenzialeMittente.getCredenziale();
                    transazioneBean.setGruppiLabel(AbstractCredenzialeList.normalize((String)valore));
                }
            }
            catch (NumberFormatException e) {
                transazioneBean.setGruppiLabel("Informazione non disponibile");
            }
            catch (NotFoundException e) {
                transazioneBean.setGruppiLabel("Informazione non piu' presente");
            }
        }
    }

    public void normalizeInfoTransazioniFromCredenzialiMittenteUriApi(TransazioneBean transazioneBean, Transazione t) throws ServiceException, MultipleResultException, NotImplementedException {
        if (transazioneBean.getUriAccordoServizio() == null || "".equals(transazioneBean.getUriAccordoServizio())) {
            String uriApi;
            String string = uriApi = t instanceof TransazioneBean ? ((TransazioneBean)t).getUriApi() : t.getUriApi();
            if (StringUtils.isNotEmpty((String)uriApi)) {
                try {
                    MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(this.credenzialiMittenteDAO, this.log);
                    CredenzialeMittente credenzialeMittente = mBeanUtilsService.getCredenzialeMittenteFromCache(Long.valueOf(Long.parseLong(uriApi)));
                    if (credenzialeMittente != null) {
                        String valore = credenzialeMittente.getCredenziale();
                        transazioneBean.setUriAccordoServizio(valore);
                    }
                }
                catch (NumberFormatException e) {
                    transazioneBean.setUriAccordoServizio("Informazione non disponibile");
                }
                catch (NotFoundException e) {
                    transazioneBean.setUriAccordoServizio("Informazione non piu' presente");
                }
                catch (Exception e) {
                    this.log.error("Parsing uri api failed: " + e.getMessage(), (Throwable)e);
                    transazioneBean.setUriAccordoServizio("Informazione non disponibile");
                }
            }
        }
    }

    private DumpMessaggio createVirtualMessageWithSdk(String idTransazione, String saErogatore, Date dataConsegnaErogatore, org.openspcoop2.core.transazioni.constants.TipoMessaggio tipoMessaggio) throws Exception {
        DumpMessaggio msg = new DumpMessaggio();
        msg.setTipoMessaggio(tipoMessaggio);
        msg.setIdTransazione(idTransazione);
        msg.setServizioApplicativoErogatore(saErogatore);
        msg.setDataConsegnaErogatore(dataConsegnaErogatore);
        if (org.openspcoop2.core.transazioni.constants.TipoMessaggio.RICHIESTA_INGRESSO.equals((Object)tipoMessaggio) || org.openspcoop2.core.transazioni.constants.TipoMessaggio.RICHIESTA_USCITA.equals((Object)tipoMessaggio)) {
            msg.setId(Long.valueOf(virtualIdRequest));
        } else {
            msg.setId(Long.valueOf(virtualIdResponse));
        }
        this.updateMessageWithSdk(msg);
        if (msg.getBody() != null || msg.sizeAllegatoList() > 0 || msg.sizeContenutoList() > 0 || msg.sizeHeaderTrasportoList() > 0) {
            return msg;
        }
        return null;
    }

    private void updateMessageWithSdk(DumpMessaggio mes) throws Exception {
        if (this.transactionServiceLibraryReader != null && mes != null) {
            TransactionServiceLibrary transactionServiceLibrary;
            BasicServiceLibrary basicServiceLibrary;
            IDServizio idServizio = null;
            String statoTransazione = null;
            try {
                List list;
                IPaginatedExpression expr = this.transazioniSearchDAO.newPaginatedExpression();
                expr.equals(Transazione.model().ID_TRANSAZIONE, (Object)mes.getIdTransazione());
                if (this.forceIndexGetByIdTransazione != null && this.forceIndexGetByIdTransazione.size() > 0) {
                    for (Index index : this.forceIndexGetByIdTransazione) {
                        expr.addForceIndex(index);
                    }
                }
                if ((list = this.transazioniSearchDAO.select(expr, new IField[]{Transazione.model().TIPO_SOGGETTO_EROGATORE, Transazione.model().NOME_SOGGETTO_EROGATORE, Transazione.model().TIPO_SERVIZIO, Transazione.model().NOME_SERVIZIO, Transazione.model().VERSIONE_SERVIZIO, Transazione.model().AZIONE, Transazione.model().STATO})) != null && list.size() > 0) {
                    Map map = (Map)list.get(0);
                    String tipoSoggettoErogatore = this.readObjectInMap(Transazione.model().TIPO_SOGGETTO_EROGATORE, map);
                    String nomeSoggettoErogatore = this.readObjectInMap(Transazione.model().NOME_SOGGETTO_EROGATORE, map);
                    String tipoServizio = this.readObjectInMap(Transazione.model().TIPO_SERVIZIO, map);
                    String nomeServizio = this.readObjectInMap(Transazione.model().NOME_SERVIZIO, map);
                    String azione = this.readObjectInMap(Transazione.model().AZIONE, map);
                    statoTransazione = this.readObjectInMap(Transazione.model().STATO, map);
                    String v = this.readObjectInMap(Transazione.model().VERSIONE_SERVIZIO, map);
                    if (tipoSoggettoErogatore != null && nomeSoggettoErogatore != null && tipoServizio != null && nomeServizio != null) {
                        idServizio = new IDServizio();
                        idServizio.setTipo(tipoServizio);
                        idServizio.setNome(nomeServizio);
                        idServizio.setSoggettoErogatore(new IDSoggetto(tipoSoggettoErogatore, nomeSoggettoErogatore));
                        idServizio.setAzione(azione);
                        idServizio.setVersione(Integer.valueOf(Integer.parseInt(v)));
                    }
                }
            }
            catch (NotFoundException e) {
                this.log.debug("Non \u00e8 stata trovata la transazione con id [" + mes.getIdTransazione() + "]");
            }
            if (idServizio != null && (basicServiceLibrary = this.basicServiceLibraryReader.read(idServizio, this.log)) != null && (transactionServiceLibrary = this.transactionServiceLibraryReader.readConfigurazioneTransazione(basicServiceLibrary, this.log)) != null) {
                IExpression expr = this.transazioniSearchDAO.newExpression();
                expr.equals(Transazione.model().ID_TRANSAZIONE, (Object)mes.getIdTransazione());
                if (this.forceIndexGetByIdTransazione != null && this.forceIndexGetByIdTransazione.size() > 0) {
                    for (Index index : this.forceIndexGetByIdTransazione) {
                        expr.addForceIndex(index);
                    }
                }
                Transazione trReadFromDB = (Transazione)this.transazioniSearchDAO.find(expr);
                transactionServiceLibrary.processResourcesAfterReadFromDatabase(trReadFromDB, mes, statoTransazione, this.log, this.daoFactory);
            }
        }
    }

    @Override
    public int countDumpMessaggiGByDataConsegnaErogatore(String idTransazione, String saErogatore) {
        try {
            this.log.debug("Count numero consegne [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "]");
            IExpression expr = this.dumpMessaggioSearchDAO.newExpression();
            expr.and().equals(DumpMessaggio.model().ID_TRANSAZIONE, (Object)idTransazione);
            if (saErogatore == null) {
                expr.isNull(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE);
            } else {
                expr.equals(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE, (Object)saErogatore);
            }
            expr.addGroupBy(DumpMessaggio.model().DATA_CONSEGNA_EROGATORE);
            NonNegativeNumber nnn = this.dumpMessaggioSearchDAO.count(expr);
            if (nnn != null) {
                return (int)nnn.longValue();
            }
        }
        catch (Exception e) {
            this.log.error("Impossibile Count numero consegne con idTransazione: " + idTransazione + "e SA Erogatore: " + saErogatore, (Throwable)e);
        }
        return 0;
    }

    @Override
    public List<DumpMessaggioBean> listDumpMessaggiGByDataConsegnaErogatore(String idTransazione, String saErogatore, int start, int limit) {
        ArrayList<DumpMessaggioBean> lista = new ArrayList<DumpMessaggioBean>();
        try {
            this.log.debug("Find All + Limit numero consegne [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "]");
            IExpression expr = this.dumpMessaggioSearchDAO.newExpression();
            expr.and().equals(DumpMessaggio.model().ID_TRANSAZIONE, (Object)idTransazione);
            if (saErogatore == null) {
                expr.isNull(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE);
            } else {
                expr.equals(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE, (Object)saErogatore);
            }
            expr.addGroupBy(DumpMessaggio.model().DATA_CONSEGNA_EROGATORE);
            IPaginatedExpression pagExpr = this.dumpMessaggioSearchDAO.toPaginatedExpression(expr);
            pagExpr.offset(start).limit(limit);
            pagExpr.addOrder(DumpMessaggio.model().DATA_CONSEGNA_EROGATORE, SortOrder.DESC);
            FunctionField fCount = new FunctionField(DumpMessaggio.model().DATA_CONSEGNA_EROGATORE, Function.COUNT, "numeroConsegnePerData");
            List groupBy = this.dumpMessaggioSearchDAO.groupBy(pagExpr, new FunctionField[]{fCount});
            this.log.debug("Trovate [" + groupBy.size() + "] consegne [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "]");
            for (Map row : groupBy) {
                Date data = (Date)row.get(GenericJDBCUtilities.getAlias((Object)DumpMessaggio.model().DATA_CONSEGNA_EROGATORE));
                DumpMessaggioBean bean = new DumpMessaggioBean();
                bean.setDataConsegnaErogatore(data);
                bean.setIdTransazione(idTransazione);
                bean.setServizioApplicativoErogatore(saErogatore);
                lista.add(bean);
            }
            for (DumpMessaggioBean dumpMessaggio : lista) {
                expr = this.dumpMessaggioSearchDAO.newExpression();
                expr.and().equals(DumpMessaggio.model().ID_TRANSAZIONE, (Object)dumpMessaggio.getIdTransazione());
                if (dumpMessaggio.getServizioApplicativoErogatore() == null) {
                    expr.isNull(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE);
                } else {
                    expr.equals(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE, (Object)dumpMessaggio.getServizioApplicativoErogatore());
                }
                expr.equals(DumpMessaggio.model().DATA_CONSEGNA_EROGATORE, (Object)dumpMessaggio.getDataConsegnaErogatore());
                pagExpr = this.dumpMessaggioSearchDAO.toPaginatedExpression(expr);
                pagExpr.addOrder(DumpMessaggio.model().TIPO_MESSAGGIO, SortOrder.ASC);
                List select = this.dumpMessaggioSearchDAO.select(pagExpr, DumpMessaggio.model().TIPO_MESSAGGIO);
                for (Object object : select) {
                    dumpMessaggio.getTipiMessaggio().add(org.openspcoop2.core.transazioni.constants.TipoMessaggio.toEnumConstant((String)((String)object)));
                }
                this.log.debug("Trovati [" + dumpMessaggio.getTipiMessaggio().size() + "] Tipi Dump [" + dumpMessaggio.getTipiMessaggio() + "] per la consegna [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ DATA_CONSEGNA_EROGATORE: " + dumpMessaggio.getDataConsegnaErogatore() + "] ");
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return lista;
    }

    @Override
    public DumpMessaggio getDumpMessaggio(String idTransazione, String saErogatore, Date dataConsegnaErogatore, org.openspcoop2.core.transazioni.constants.TipoMessaggio tipoMessaggio) throws Exception {
        try {
            this.log.debug("Get Dump Messaggio [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ tipomessaggio: " + tipoMessaggio.toString() + "]");
            IExpression expr = this.dumpMessaggioSearchDAO.newExpression();
            expr.equals(DumpMessaggio.model().TIPO_MESSAGGIO, (Object)org.openspcoop2.core.transazioni.constants.TipoMessaggio.toEnumConstant((String)tipoMessaggio.toString()));
            expr.and().equals(DumpMessaggio.model().ID_TRANSAZIONE, (Object)idTransazione);
            if (saErogatore == null) {
                expr.isNull(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE);
            } else {
                expr.equals(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE, (Object)saErogatore);
            }
            if (dataConsegnaErogatore != null) {
                expr.equals(DumpMessaggio.model().DATA_CONSEGNA_EROGATORE, (Object)dataConsegnaErogatore);
            }
            expr.addOrder(DumpMessaggio.model().DUMP_TIMESTAMP, SortOrder.DESC);
            DumpMessaggio mes = null;
            if (saErogatore != null && StringUtils.isNotEmpty((String)saErogatore) && dataConsegnaErogatore == null) {
                IPaginatedExpression pagExpr = this.dumpMessaggioSearchDAO.toPaginatedExpression(expr);
                pagExpr.limit(1);
                List list = this.dumpMessaggioSearchDAO.findAll(pagExpr);
                if (list != null && !list.isEmpty()) {
                    mes = (DumpMessaggio)list.get(0);
                }
            } else {
                mes = (DumpMessaggio)this.dumpMessaggioSearchDAO.find(expr);
            }
            this.updateMessageWithSdk(mes);
            return mes;
        }
        catch (NotFoundException nre) {
            DumpMessaggio mes = this.createVirtualMessageWithSdk(idTransazione, saErogatore, dataConsegnaErogatore, tipoMessaggio);
            if (mes != null) {
                return mes;
            }
        }
        catch (Exception e) {
            this.log.error("Impossibile recuperare DumpMessaggio con idTransazione: " + idTransazione + ", SA Erogatore: " + saErogatore + " e tipo: " + tipoMessaggio.toString(), (Throwable)e);
            throw new Exception("Impossibile recuperare DumpMessaggio con idTransazione: " + idTransazione + ", SA Erogatore: " + saErogatore + " e tipo: " + tipoMessaggio.toString(), e);
        }
        return null;
    }

    @Override
    public JDBCDumpMessaggioStream getContentInputStream(String idTransazione, String saErogatore, Date dataConsegnaErogatore, org.openspcoop2.core.transazioni.constants.TipoMessaggio tipoMessaggio) throws ServiceException {
        try {
            this.log.debug("Get Dump Messaggio [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ tipomessaggio: " + tipoMessaggio.toString() + "]");
            IExpression expr = this.dumpMessaggioSearchDAO.newExpression();
            expr.equals(DumpMessaggio.model().TIPO_MESSAGGIO, (Object)org.openspcoop2.core.transazioni.constants.TipoMessaggio.toEnumConstant((String)tipoMessaggio.toString()));
            expr.and().equals(DumpMessaggio.model().ID_TRANSAZIONE, (Object)idTransazione);
            if (saErogatore == null) {
                expr.isNull(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE);
            } else {
                expr.equals(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE, (Object)saErogatore);
            }
            if (dataConsegnaErogatore != null) {
                expr.equals(DumpMessaggio.model().DATA_CONSEGNA_EROGATORE, (Object)dataConsegnaErogatore);
            }
            expr.addOrder(DumpMessaggio.model().DUMP_TIMESTAMP, SortOrder.DESC);
            return ((IDBDumpMessaggioServiceSearch)this.dumpMessaggioSearchDAO).getContentInputStream(expr);
        }
        catch (Exception e) {
            this.log.error("Impossibile recuperare DumpMessaggio con idTransazione: " + idTransazione + ", SA Erogatore: " + saErogatore + " e tipo: " + tipoMessaggio.toString(), (Throwable)e);
            throw new ServiceException("Impossibile recuperare DumpMessaggio con idTransazione: " + idTransazione + ", SA Erogatore: " + saErogatore + " e tipo: " + tipoMessaggio.toString(), (Throwable)e);
        }
    }

    @Override
    public List<DumpAllegato> getAllegatiMessaggio(String idTransazione, String saErogatore, Date dataConsegnaErogatore, org.openspcoop2.core.transazioni.constants.TipoMessaggio tipoMessaggio, Long idDump) {
        try {
            this.log.debug("Get allegati Messaggio [idDump: " + idDump + "]");
            if (idDump == virtualIdRequest || idDump == virtualIdResponse) {
                throw new NotFoundException("Id Dump negative, possibile virtual message");
            }
            DumpMessaggio mes = (DumpMessaggio)((IDBDumpMessaggioServiceSearch)this.dumpMessaggioSearchDAO).get(idDump.longValue());
            this.updateMessageWithSdk(mes);
            if (mes != null) {
                return mes.getAllegatoList();
            }
        }
        catch (NotFoundException e) {
            this.log.debug("non sono state trovate Allegati per il messaggio con [id_messaggio: " + idDump + "]");
            try {
                DumpMessaggio mes = this.createVirtualMessageWithSdk(idTransazione, saErogatore, dataConsegnaErogatore, tipoMessaggio);
                if (mes != null) {
                    return mes.getAllegatoList();
                }
            }
            catch (Exception eVirtual) {
                this.log.error("Impossibile recuperare DumpAllegato con id_messaggio virtuale: " + idDump, (Throwable)eVirtual);
            }
        }
        catch (Exception e) {
            this.log.error("Impossibile recuperare DumpAllegato con id_messaggio: " + idDump, (Throwable)e);
        }
        return new ArrayList<DumpAllegato>();
    }

    private String readObjectInMap(IField field, Map<String, Object> map) {
        Object o = map.get(field.getFieldName());
        if (o != null && o instanceof String) {
            return (String)o;
        }
        return null;
    }

    @Override
    public List<DumpContenuto> getContenutiSpecifici(String idTransazione, String saErogatore, Date dataConsegnaErogatore, org.openspcoop2.core.transazioni.constants.TipoMessaggio tipoMessaggio, Long idDump) {
        try {
            this.log.debug("Get Contenuti specifici [idDump: " + idDump + "]");
            if (idDump == virtualIdRequest || idDump == virtualIdResponse) {
                throw new NotFoundException("Id Dump negative, possibile virtual message");
            }
            DumpMessaggio mes = (DumpMessaggio)((IDBDumpMessaggioServiceSearch)this.dumpMessaggioSearchDAO).get(idDump.longValue());
            if (mes != null) {
                this.updateMessageWithSdk(mes);
                return mes.getContenutoList();
            }
        }
        catch (NotFoundException e) {
            this.log.debug("non sono state trovate informazioni per DumpContenuto con [id_messaggio: " + idDump + "]");
            try {
                DumpMessaggio mes = this.createVirtualMessageWithSdk(idTransazione, saErogatore, dataConsegnaErogatore, tipoMessaggio);
                if (mes != null) {
                    return mes.getContenutoList();
                }
            }
            catch (Exception eVirtual) {
                this.log.error("Impossibile recuperare DumpContenuto con id_messaggio virtuale: " + idDump, (Throwable)eVirtual);
            }
        }
        catch (Exception e) {
            this.log.error("Impossibile recuperare DumpContenuto con id_messaggio: " + idDump, (Throwable)e);
        }
        return new ArrayList<DumpContenuto>();
    }

    @Override
    public Date getDataConsegnaErogatore(String idTransazione, String saErogatore, Date dataAccettazione) {
        try {
            this.log.info("Get data ultima consegna [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ dataAccettazione: " + dataAccettazione + "]");
            IExpression expr = this.dumpMessaggioSearchDAO.newExpression();
            expr.and().equals(DumpMessaggio.model().ID_TRANSAZIONE, (Object)idTransazione);
            if (saErogatore == null) {
                expr.isNull(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE);
            } else {
                expr.equals(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE, (Object)saErogatore);
            }
            if (dataAccettazione != null) {
                expr.greaterThan(DumpMessaggio.model().DUMP_TIMESTAMP, (Object)dataAccettazione);
            }
            expr.addOrder(DumpMessaggio.model().DUMP_TIMESTAMP, SortOrder.DESC);
            IPaginatedExpression pagExpr = this.dumpMessaggioSearchDAO.toPaginatedExpression(expr);
            pagExpr.offset(0).limit(1);
            List select = this.dumpMessaggioSearchDAO.select(pagExpr, DumpMessaggio.model().DATA_CONSEGNA_EROGATORE);
            if (select == null || select.isEmpty()) {
                return null;
            }
            Object obj = select.get(0);
            if (obj instanceof Date) {
                return (Date)obj;
            }
        }
        catch (NotFoundException e) {
            this.log.debug("non sono state trovate informazioni Dump per [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ dataAccettazione: " + dataAccettazione + "]");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean hasInfoDumpAvailable(String idTransazione, String saErogatore, Date dataConsegnaErogatore, org.openspcoop2.core.transazioni.constants.TipoMessaggio tipoMessaggio) {
        try {
            this.log.info("Has Info Dump Available [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ dataAccettazione: " + tipoMessaggio.toString() + "]");
            IExpression expr = this.dumpMessaggioSearchDAO.newExpression();
            expr.equals(DumpMessaggio.model().TIPO_MESSAGGIO, (Object)org.openspcoop2.core.transazioni.constants.TipoMessaggio.toEnumConstant((String)tipoMessaggio.toString()));
            expr.and().equals(DumpMessaggio.model().ID_TRANSAZIONE, (Object)idTransazione);
            if (saErogatore == null) {
                expr.isNull(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE);
            } else {
                expr.equals(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE, (Object)saErogatore);
            }
            if (dataConsegnaErogatore != null) {
                expr.equals(DumpMessaggio.model().DATA_CONSEGNA_EROGATORE, (Object)dataConsegnaErogatore);
            }
            expr.addOrder(DumpMessaggio.model().DUMP_TIMESTAMP, SortOrder.DESC);
            IPaginatedExpression pagExpr = this.dumpMessaggioSearchDAO.toPaginatedExpression(expr);
            pagExpr.offset(0).limit(1);
            List findAll = this.dumpMessaggioSearchDAO.findAll(pagExpr);
            if (findAll == null || findAll.isEmpty()) {
                throw new NotFoundException("Nessun messaggio trovato");
            }
            DumpMessaggio msg = (DumpMessaggio)findAll.get(0);
            this.updateMessageWithSdk(msg);
            if (msg != null) {
                return msg.getBody() != null || msg.sizeAllegatoList() > 0 || msg.sizeContenutoList() > 0 || msg.getContentLength() != null && msg.getContentLength() > 0L;
            }
        }
        catch (NotFoundException e) {
            this.log.debug("non sono state trovate informazioni Dump per [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ tipomessaggio: " + tipoMessaggio.toString() + "]");
            try {
                DumpMessaggio mes = this.createVirtualMessageWithSdk(idTransazione, saErogatore, dataConsegnaErogatore, tipoMessaggio);
                if (mes != null) {
                    return mes.getBody() != null || mes.sizeAllegatoList() > 0 || mes.sizeContenutoList() > 0;
                }
            }
            catch (Exception eVirtual) {
                this.log.error("Errore durante la costruzione virtuale del messaggio (hasInfoDumpAvailable) [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ tipomessaggio: " + tipoMessaggio.toString() + "]", (Throwable)eVirtual);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean hasInfoHeaderTrasportoAvailable(String idTransazione, String saErogatore, Date dataConsegnaErogatore, org.openspcoop2.core.transazioni.constants.TipoMessaggio tipoMessaggio) {
        this.log.info("Has Info Header Trasporto Available [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ tipomessaggio: " + tipoMessaggio.toString() + "]");
        try {
            IExpression expr = this.dumpMessaggioSearchDAO.newExpression();
            expr.equals(DumpMessaggio.model().TIPO_MESSAGGIO, (Object)org.openspcoop2.core.transazioni.constants.TipoMessaggio.toEnumConstant((String)tipoMessaggio.toString()));
            expr.and().equals(DumpMessaggio.model().ID_TRANSAZIONE, (Object)idTransazione);
            if (saErogatore == null) {
                expr.isNull(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE);
            } else {
                expr.equals(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE, (Object)saErogatore);
            }
            if (dataConsegnaErogatore != null) {
                expr.equals(DumpMessaggio.model().DATA_CONSEGNA_EROGATORE, (Object)dataConsegnaErogatore);
            }
            expr.addOrder(DumpMessaggio.model().DUMP_TIMESTAMP, SortOrder.DESC);
            IPaginatedExpression pagExpr = this.dumpMessaggioSearchDAO.toPaginatedExpression(expr);
            pagExpr.offset(0).limit(1);
            List findAll = this.dumpMessaggioSearchDAO.findAll(pagExpr);
            if (findAll == null || findAll.isEmpty()) {
                throw new NotFoundException("Nessun messaggio trovato");
            }
            DumpMessaggio msg = (DumpMessaggio)findAll.get(0);
            this.updateMessageWithSdk(msg);
            if (msg != null) {
                return msg.sizeHeaderTrasportoList() > 0;
            }
        }
        catch (NotFoundException e) {
            this.log.debug("non sono state trovate informazioni sull'Header Trasporto per [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ tipomessaggio: " + tipoMessaggio.toString() + "]");
            try {
                DumpMessaggio mes = this.createVirtualMessageWithSdk(idTransazione, saErogatore, dataConsegnaErogatore, tipoMessaggio);
                if (mes != null) {
                    return mes.sizeHeaderTrasportoList() > 0;
                }
            }
            catch (Exception eVirtual) {
                this.log.error("Errore durante la costruzione virtuale del messaggio (hasInfoHeaderTrasportoAvailable) [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ tipomessaggio: " + tipoMessaggio.toString() + "]", (Throwable)eVirtual);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    public List<DumpHeaderTrasporto> getHeaderTrasporto(String idTransazione, String saErogatore, Date dataConsegnaErogatore, org.openspcoop2.core.transazioni.constants.TipoMessaggio tipoMessaggio, Long idDump) {
        try {
            this.log.debug("Get Header Trasporto [idDump: " + idDump + "]");
            if (idDump == virtualIdRequest || idDump == virtualIdResponse) {
                throw new NotFoundException("Id Dump negative, possibile virtual message");
            }
            DumpMessaggio m = (DumpMessaggio)((IDBDumpMessaggioServiceSearch)this.dumpMessaggioSearchDAO).get(idDump.longValue());
            this.updateMessageWithSdk(m);
            if (m != null) {
                return m.getHeaderTrasportoList();
            }
        }
        catch (NotFoundException e) {
            this.log.debug("non sono state trovate informazioni dell'Header Trasporto con [id_messaggio: " + idDump + "]");
            try {
                DumpMessaggio mes = this.createVirtualMessageWithSdk(idTransazione, saErogatore, dataConsegnaErogatore, tipoMessaggio);
                if (mes != null) {
                    return mes.getHeaderTrasportoList();
                }
            }
            catch (Exception eVirtual) {
                this.log.error("Impossibile recuperare HeaderTrasporto con id_messaggio virtuale: " + idDump, (Throwable)eVirtual);
            }
        }
        catch (Exception e) {
            this.log.error("Impossibile recuperare DumpHeaderTrasporto con id_messaggio: " + idDump, (Throwable)e);
        }
        return new ArrayList<DumpHeaderTrasporto>();
    }

    @Override
    public List<TransazioneBean> findAllDuplicati(String idTransazione, String idEgov, boolean isRisposta, int start, int limit) {
        ArrayList<TransazioneBean> listaBean = new ArrayList<TransazioneBean>();
        try {
            List list;
            this.log.debug("Find All Duplicati [id transazione: " + idTransazione + "],[ idEgov: " + idEgov + "], [isRisposta: " + isRisposta + "]");
            IExpression expr = this.transazioniSearchDAO.newExpression();
            if (!isRisposta) {
                expr.equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)idEgov);
            } else {
                expr.equals(Transazione.model().ID_MESSAGGIO_RISPOSTA, (Object)idEgov);
            }
            expr.and();
            expr.notEquals(Transazione.model().ID_TRANSAZIONE, (Object)idTransazione);
            if (!isRisposta) {
                expr.equals(Transazione.model().PDD_RUOLO, (Object)TipoPdD.APPLICATIVA.getTipo());
            } else {
                expr.equals(Transazione.model().PDD_RUOLO, (Object)TipoPdD.DELEGATA.getTipo());
            }
            if (!isRisposta) {
                expr.sortOrder(SortOrder.ASC).addOrder(Transazione.model().DATA_INGRESSO_RICHIESTA);
            } else {
                expr.sortOrder(SortOrder.ASC).addOrder(Transazione.model().DATA_INGRESSO_RISPOSTA);
            }
            IPaginatedExpression pagExpr = this.transazioniSearchDAO.toPaginatedExpression(expr);
            pagExpr.offset(start).limit(limit);
            List<Index> forceIndexDuplicatiFindAll = this.forceIndexIdMessaggioRichiestaFindAll;
            if (isRisposta) {
                forceIndexDuplicatiFindAll = this.forceIndexIdMessaggioRispostaFindAll;
            }
            if (forceIndexDuplicatiFindAll != null && forceIndexDuplicatiFindAll.size() > 0) {
                for (Index index : forceIndexDuplicatiFindAll) {
                    pagExpr.addForceIndex(index);
                }
            }
            if ((list = this.transazioniSearchDAO.findAll(pagExpr)) != null && list.size() > 0) {
                for (Transazione transazione : list) {
                    TransazioneBean bean = new TransazioneBean(transazione, this.searchForm != null ? this.searchForm.getSoggettoPddMonitor() : null);
                    listaBean.add(bean);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return listaBean;
    }

    @Override
    public TransazioneBean findTransazioneOriginale(String idTransazioneDuplicata, String idEgov, boolean isRisposta) {
        this.log.info("Find Transazione Originale [id transazione duplicata: " + idTransazioneDuplicata + "],[ idEgov: " + idEgov + "], [isRisposta: " + isRisposta + "]");
        try {
            IExpression expr = this.transazioniSearchDAO.newExpression();
            if (!isRisposta) {
                expr.equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)idEgov);
            } else {
                expr.equals(Transazione.model().ID_MESSAGGIO_RISPOSTA, (Object)idEgov);
            }
            expr.and();
            expr.notEquals(Transazione.model().ID_TRANSAZIONE, (Object)idTransazioneDuplicata);
            if (!isRisposta) {
                expr.greaterThan(Transazione.model().DUPLICATI_RICHIESTA, (Object)0);
            } else {
                expr.greaterThan(Transazione.model().DUPLICATI_RISPOSTA, (Object)0);
            }
            List<Index> forceIndexDuplicatiFindAll = this.forceIndexIdMessaggioRichiestaFindAll;
            if (isRisposta) {
                forceIndexDuplicatiFindAll = this.forceIndexIdMessaggioRispostaFindAll;
            }
            if (forceIndexDuplicatiFindAll != null && forceIndexDuplicatiFindAll.size() > 0) {
                for (Index index : forceIndexDuplicatiFindAll) {
                    expr.addForceIndex(index);
                }
            }
            return new TransazioneBean((Transazione)this.transazioniSearchDAO.find(expr), this.searchForm != null ? this.searchForm.getSoggettoPddMonitor() : null);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public int countAllDuplicati(String idTransazione, String idEgov, boolean isRisposta) {
        this.log.debug("Count All Duplicati [id transazione: " + idTransazione + "],[ idEgov: " + idEgov + "], [isRisposta: " + isRisposta + "]");
        try {
            NonNegativeNumber res;
            IExpression expr = this.transazioniSearchDAO.newExpression();
            if (!isRisposta) {
                expr.equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)idEgov);
            } else {
                expr.equals(Transazione.model().ID_MESSAGGIO_RISPOSTA, (Object)idEgov);
            }
            expr.and();
            expr.notEquals(Transazione.model().ID_TRANSAZIONE, (Object)idTransazione);
            List<Index> forceIndexDuplicatiCount = this.forceIndexIdMessaggioRichiestaCount;
            if (isRisposta) {
                forceIndexDuplicatiCount = this.forceIndexIdMessaggioRispostaCount;
            }
            if (forceIndexDuplicatiCount != null && forceIndexDuplicatiCount.size() > 0) {
                for (Index index : forceIndexDuplicatiCount) {
                    expr.addForceIndex(index);
                }
            }
            if ((res = this.transazioniSearchDAO.count(expr)) == null) {
                return 0;
            }
            return (int)res.longValue();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    @Override
    public ResLive getEsiti(PermessiUtenteOperatore permessiUtente, Date min, Date max, String esitoContesto, String protocolloSelected, String protocolloDefault, TipologiaRicerca tipologiaRicerca) {
        this.log.debug("Get Esiti [permessiUtenti: " + permessiUtente + "],[ Date Min: " + min + "], [Date Max: " + max + "]");
        try {
            Properties repositoryExternal;
            PddMonitorProperties govwayMonitorProperties;
            List<Index> forceIndexEsitiCount;
            String protocolloP = protocolloDefault;
            if (protocolloSelected != null) {
                protocolloP = protocolloSelected;
            }
            EsitoUtils esitoUtils = new EsitoUtils(this.log, protocolloP);
            EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)this.log, (String)protocolloP);
            List esitiOk = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
            List esitiKo = esitiProperties.getEsitiCodeKo_senzaFaultApplicativo();
            List esitiFault = esitiProperties.getEsitiCodeFaultApplicativo();
            IExpression exprOk = this.transazioniSearchDAO.newExpression();
            exprOk.between(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)min, (Object)max);
            exprOk.and().in(Transazione.model().ESITO, (Collection)esitiOk);
            if (permessiUtente != null) {
                IExpression permessi = permessiUtente.toExpression((IExpressionConstructor)this.transazioniSearchDAO, Transazione.model().PDD_CODICE, Transazione.model().TIPO_SOGGETTO_EROGATORE, Transazione.model().NOME_SOGGETTO_EROGATORE, Transazione.model().TIPO_SERVIZIO, Transazione.model().NOME_SERVIZIO, Transazione.model().VERSIONE_SERVIZIO);
                exprOk.and(new IExpression[]{permessi});
            }
            esitoUtils.setExpressionContesto(exprOk, Transazione.model().ESITO_CONTESTO, esitoContesto);
            if (tipologiaRicerca != null) {
                if (TipologiaRicerca.ingresso.equals((Object)tipologiaRicerca)) {
                    exprOk.and().equals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.APPLICATIVA);
                } else if (TipologiaRicerca.uscita.equals((Object)tipologiaRicerca)) {
                    exprOk.and().equals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.DELEGATA);
                }
            }
            IExpression exprFault = this.transazioniSearchDAO.newExpression();
            exprFault.between(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)min, (Object)max);
            exprFault.and().in(Transazione.model().ESITO, (Collection)esitiFault);
            if (permessiUtente != null) {
                IExpression permessi = permessiUtente.toExpression((IExpressionConstructor)this.transazioniSearchDAO, Transazione.model().PDD_CODICE, Transazione.model().TIPO_SOGGETTO_EROGATORE, Transazione.model().NOME_SOGGETTO_EROGATORE, Transazione.model().TIPO_SERVIZIO, Transazione.model().NOME_SERVIZIO, Transazione.model().VERSIONE_SERVIZIO);
                exprFault.and(new IExpression[]{permessi});
            }
            esitoUtils.setExpressionContesto(exprFault, Transazione.model().ESITO_CONTESTO, esitoContesto);
            if (tipologiaRicerca != null) {
                if (TipologiaRicerca.ingresso.equals((Object)tipologiaRicerca)) {
                    exprFault.and().equals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.APPLICATIVA);
                } else if (TipologiaRicerca.uscita.equals((Object)tipologiaRicerca)) {
                    exprFault.and().equals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.DELEGATA);
                }
            }
            IExpression exprKo = this.transazioniSearchDAO.newExpression();
            exprKo.between(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)min, (Object)max);
            exprKo.and().in(Transazione.model().ESITO, (Collection)esitiKo);
            if (permessiUtente != null) {
                IExpression permessi = permessiUtente.toExpression((IExpressionConstructor)this.transazioniSearchDAO, Transazione.model().PDD_CODICE, Transazione.model().TIPO_SOGGETTO_EROGATORE, Transazione.model().NOME_SOGGETTO_EROGATORE, Transazione.model().TIPO_SERVIZIO, Transazione.model().NOME_SERVIZIO, Transazione.model().VERSIONE_SERVIZIO);
                exprKo.and(new IExpression[]{permessi});
            }
            esitoUtils.setExpressionContesto(exprKo, Transazione.model().ESITO_CONTESTO, esitoContesto);
            if (tipologiaRicerca != null) {
                if (TipologiaRicerca.ingresso.equals((Object)tipologiaRicerca)) {
                    exprKo.and().equals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.APPLICATIVA);
                } else if (TipologiaRicerca.uscita.equals((Object)tipologiaRicerca)) {
                    exprKo.and().equals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.DELEGATA);
                }
            }
            if (protocolloSelected != null) {
                exprOk.and().equals(Transazione.model().PROTOCOLLO, (Object)protocolloSelected);
                exprFault.and().equals(Transazione.model().PROTOCOLLO, (Object)protocolloSelected);
                exprKo.and().equals(Transazione.model().PROTOCOLLO, (Object)protocolloSelected);
            }
            if ((forceIndexEsitiCount = this.convertForceIndexList((govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)this.log)).getTransazioniForceIndexEsitiCount(repositoryExternal = govwayMonitorProperties.getExternalForceIndexRepository()))) != null && forceIndexEsitiCount.size() > 0) {
                for (Index index : forceIndexEsitiCount) {
                    exprOk.addForceIndex(index);
                    exprFault.addForceIndex(index);
                    exprKo.addForceIndex(index);
                }
            }
            NonNegativeNumber nnnOk = this.transazioniSearchDAO.count(exprOk);
            NonNegativeNumber nnnFault = this.transazioniSearchDAO.count(exprFault);
            NonNegativeNumber nnnKo = this.transazioniSearchDAO.count(exprKo);
            if (nnnKo != null && nnnOk != null) {
                return new ResLive(Long.valueOf(nnnOk.longValue()), Long.valueOf(nnnFault.longValue()), Long.valueOf(nnnKo.longValue()), new Date());
            }
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return new ResLive(Long.valueOf("0"), Long.valueOf("0"), Long.valueOf("0"));
    }

    public void deleteAll() throws Exception {
        try {
            this.log.debug("Delete All");
            IExpression expr = this.transazioniDAO.newExpression();
            this.parseExpressionFilter(expr, false, false);
            this.setOrderField(expr, SortOrder.DESC, null, false);
            this.transazioniDAO.deleteAll(expr);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigurazioneRicerca> getRicercheByValues(IDAccordo idAccordo, String nomeServizio, String nomeAzione) {
        this.log.debug("Find ricerche by Values[id Accordo: " + idAccordo + "],[ nomeAzione: " + nomeAzione + "], [nomeServizio: " + nomeServizio + "]");
        try {
            SearchServiceLibrary searchServiceLibrary;
            if (idAccordo == null || nomeServizio == null) {
                this.log.warn("Impossibile recuperare lista ricerche: idAccordo e/o nomeServizio non forniti.");
                return new ArrayList<ConfigurazioneRicerca>();
            }
            List<Object> lista = new ArrayList<ConfigurazioneRicerca>();
            BasicServiceLibrary basicServiceLibrary = this.basicServiceLibraryReader.read(idAccordo, nomeServizio, nomeAzione, this.log);
            if (basicServiceLibrary != null && (searchServiceLibrary = this.searchServiceLibraryReader.readConfigurazioneRicerche(basicServiceLibrary, this.log)) != null) {
                lista = searchServiceLibrary.mergeServiceActionSearchLibrary(true, true);
            }
            return lista;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return new ArrayList<ConfigurazioneRicerca>();
        }
    }

    @Override
    public List<Parameter<?>> instanceParameters(ConfigurazioneRicerca configurazioneRicerca, Context context) throws SearchException {
        this.log.info("Find Parametri By Ricerca ID [id Ricerca: " + configurazioneRicerca.getIdConfigurazioneRicerca() + "],[ className: " + configurazioneRicerca.getPlugin().getClassName() + "]");
        try {
            ArrayList<Parameter> res = null;
            IDynamicLoader bl = DynamicFactory.getInstance().newDynamicLoader(configurazioneRicerca.getPlugin().getTipoPlugin(), configurazioneRicerca.getPlugin().getTipo(), configurazioneRicerca.getPlugin().getClassName(), this.log);
            List sdkParameters = bl.getParameters(context);
            if (sdkParameters != null && sdkParameters.size() > 0) {
                res = new ArrayList<Parameter>();
                for (Parameter sdkParameter : sdkParameters) {
                    res.add(DynamicComponentUtils.createDynamicComponentParameter((Parameter)sdkParameter, (IDynamicLoader)bl));
                }
            }
            return res;
        }
        catch (SearchException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<ConfigurazioneTransazioneStato> getStatiByValues(IDAccordo idAccordo, String nomeServizio, String azione) {
        block14: {
            this.log.debug("get Stati By Values [idAccord: " + idAccordo + "],[ nomeAzione: " + azione + "], [nomeServizio: " + nomeServizio + "]");
            try {
                if (idAccordo == null || nomeServizio == null) {
                    this.log.error("Impossibile recuperare gli stati: idAccordo e/o nomeServizio non forniti.");
                    return new ArrayList<ConfigurazioneTransazioneStato>();
                }
                IExpression espr = this.confSerAzSearchDAO.newExpression();
                espr.equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, (Object)nomeServizio);
                espr.and();
                espr.equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, (Object)idAccordo.getNome());
                if (azione == null) {
                    espr.and().equals(ConfigurazioneServizioAzione.model().AZIONE, (Object)"*");
                } else {
                    IExpression azExpr = this.confSerAzSearchDAO.newExpression();
                    azExpr.equals(ConfigurazioneServizioAzione.model().AZIONE, (Object)"*").or().equals(ConfigurazioneServizioAzione.model().AZIONE, (Object)azione);
                    espr.and(new IExpression[]{azExpr});
                }
                if (idAccordo.getSoggettoReferente() != null) {
                    if (idAccordo.getSoggettoReferente().getTipo() != null) {
                        espr.and().equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, (Object)idAccordo.getSoggettoReferente().getTipo());
                    }
                    if (idAccordo.getSoggettoReferente().getNome() != null) {
                        espr.and().equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, (Object)idAccordo.getSoggettoReferente().getNome());
                    }
                }
                if (idAccordo.getVersione() != null) {
                    espr.and().equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, (Object)idAccordo.getVersione());
                }
                IPaginatedExpression pagExpr = this.confSerAzSearchDAO.toPaginatedExpression(espr);
                List lst = this.confSerAzSearchDAO.findAll(pagExpr);
                TreeMap<Long, ConfigurazioneTransazione> mappa = new TreeMap<Long, ConfigurazioneTransazione>();
                if (lst == null || lst.size() <= 0) break block14;
                IExpression expr = null;
                for (ConfigurazioneServizioAzione conf : lst) {
                    expr = this.confTransazioneSearchDAO.newExpression();
                    expr.equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.AZIONE, (Object)conf.getAzione());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, (Object)conf.getIdConfigurazioneServizio().getAccordo());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, (Object)conf.getIdConfigurazioneServizio().getNomeSoggettoReferente());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, (Object)conf.getIdConfigurazioneServizio().getTipoSoggettoReferente());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, (Object)conf.getIdConfigurazioneServizio().getServizio());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, (Object)conf.getIdConfigurazioneServizio().getVersione());
                    ConfigurazioneTransazione t = null;
                    try {
                        t = (ConfigurazioneTransazione)this.confTransazioneSearchDAO.find(expr);
                    }
                    catch (NotFoundException e) {
                        t = null;
                    }
                    if (t == null || mappa.containsKey(t.getId())) continue;
                    mappa.put(t.getId(), t);
                }
                if (mappa != null && mappa.size() > 0) {
                    ArrayList<ConfigurazioneTransazioneStato> ts = new ArrayList<ConfigurazioneTransazioneStato>();
                    for (ConfigurazioneTransazione tr : mappa.values()) {
                        ts.addAll(tr.getConfigurazioneTransazioneStatoList());
                    }
                    return ts;
                }
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<ConfigurazioneTransazioneStato>();
    }

    @Override
    public List<ConfigurazioneTransazioneRisorsaContenuto> getRisorseContenutoByValues(IDAccordo idAccordo, String nomeServizio, String nomeAzione, String nomeStato) {
        block15: {
            if (idAccordo == null || nomeServizio == null) {
                this.log.error("Impossibile recuperare gli stati: idAccordo e/o nomeServizio non forniti.");
                return null;
            }
            this.log.info("Get risorse contenuto by values[idAccord: " + idAccordo + "],[ nomeServizio: " + nomeServizio + "], [nomeAzione: " + nomeAzione + "], [nomeStato: " + nomeStato + "]");
            try {
                IExpression espr = this.confSerAzSearchDAO.newExpression();
                espr.equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, (Object)nomeServizio);
                espr.and();
                espr.equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, (Object)idAccordo.getNome());
                if (nomeAzione == null) {
                    espr.and().equals(ConfigurazioneServizioAzione.model().AZIONE, (Object)"*");
                } else {
                    IExpression azExpr = this.confSerAzSearchDAO.newExpression();
                    azExpr.equals(ConfigurazioneServizioAzione.model().AZIONE, (Object)"*").or().equals(ConfigurazioneServizioAzione.model().AZIONE, (Object)nomeAzione);
                    espr.and(new IExpression[]{azExpr});
                }
                if (idAccordo.getSoggettoReferente() != null) {
                    if (idAccordo.getSoggettoReferente().getTipo() != null) {
                        espr.and().equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, (Object)idAccordo.getSoggettoReferente().getTipo());
                    }
                    if (idAccordo.getSoggettoReferente().getNome() != null) {
                        espr.and().equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, (Object)idAccordo.getSoggettoReferente().getNome());
                    }
                }
                if (idAccordo.getVersione() != null) {
                    espr.and().equals(ConfigurazioneServizioAzione.model().ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, (Object)idAccordo.getVersione());
                }
                IPaginatedExpression pagExpr = this.confSerAzSearchDAO.toPaginatedExpression(espr);
                List lst = this.confSerAzSearchDAO.findAll(pagExpr);
                TreeMap<Long, ConfigurazioneTransazione> mappa = new TreeMap<Long, ConfigurazioneTransazione>();
                if (lst == null || lst.size() <= 0) break block15;
                IExpression expr = null;
                for (ConfigurazioneServizioAzione conf : lst) {
                    expr = this.confTransazioneSearchDAO.newExpression();
                    expr.equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.AZIONE, (Object)conf.getAzione());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, (Object)conf.getIdConfigurazioneServizio().getAccordo());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, (Object)conf.getIdConfigurazioneServizio().getNomeSoggettoReferente());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, (Object)conf.getIdConfigurazioneServizio().getTipoSoggettoReferente());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, (Object)conf.getIdConfigurazioneServizio().getServizio());
                    expr.and().equals(ConfigurazioneTransazione.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, (Object)conf.getIdConfigurazioneServizio().getVersione());
                    if (StringUtils.isNotBlank((String)nomeStato) && !"*".equals(nomeStato)) {
                        expr.and().equals(ConfigurazioneTransazione.model().CONFIGURAZIONE_TRANSAZIONE_STATO.NOME, (Object)nomeStato);
                    }
                    ConfigurazioneTransazione t = null;
                    try {
                        t = (ConfigurazioneTransazione)this.confTransazioneSearchDAO.find(expr);
                    }
                    catch (NotFoundException e) {
                        t = null;
                    }
                    if (t == null || mappa.containsKey(t.getId())) continue;
                    mappa.put(t.getId(), t);
                }
                if (mappa != null && mappa.size() > 0) {
                    ArrayList<ConfigurazioneTransazioneRisorsaContenuto> toRet = new ArrayList<ConfigurazioneTransazioneRisorsaContenuto>();
                    for (ConfigurazioneTransazione tr : mappa.values()) {
                        toRet.addAll(tr.getConfigurazioneTransazioneRisorsaContenutoList());
                    }
                    return toRet;
                }
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<ConfigurazioneTransazioneRisorsaContenuto>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseExpressionFilter(IExpression filter, boolean isCount, boolean isLiveSearch) throws ExpressionNotImplementedException, ExpressionException, CoreException, UserInvalidException, UtilsException, ProtocolException, ServiceException, NotImplementedException, NotFoundException {
        List listaCredenzialiMittente;
        IExpression permessi;
        ModalitaRicercaTransazioni ricerca = null;
        if (!isLiveSearch) {
            ricerca = ModalitaRicercaTransazioni.getFromString((String)this.searchForm.getModalitaRicercaStorico());
        }
        if (ricerca != null && ModalitaRicercaTransazioni.ID_MESSAGGIO.equals((Object)ricerca)) {
            if (!StringUtils.isNotEmpty((String)this.searchForm.getIdEgov())) throw new UtilsException("ID Messaggio non fornito");
            TipoMessaggio tipoMessaggio = TipoMessaggio.valueOf((String)this.searchForm.getTipoIdMessaggio());
            String value = this.searchForm.getIdEgov().trim();
            switch (tipoMessaggio) {
                case Richiesta: {
                    filter.equals(Transazione.model().ID_MESSAGGIO_RICHIESTA, (Object)value);
                    break;
                }
                case Risposta: {
                    filter.equals(Transazione.model().ID_MESSAGGIO_RISPOSTA, (Object)value);
                    break;
                }
                case Collaborazione: {
                    filter.equals(Transazione.model().ID_COLLABORAZIONE, (Object)value);
                    break;
                }
                case RiferimentoRichiesta: {
                    filter.equals(Transazione.model().ID_ASINCRONO, (Object)value);
                }
            }
            if (this.searchForm.getPermessiUtenteOperatore() == null) return;
            IExpression permessi2 = this.searchForm.getPermessiUtenteOperatore().toExpression((IExpressionConstructor)this.transazioniSearchDAO, Transazione.model().PDD_CODICE, Transazione.model().TIPO_SOGGETTO_EROGATORE, Transazione.model().NOME_SOGGETTO_EROGATORE, Transazione.model().TIPO_SERVIZIO, Transazione.model().NOME_SERVIZIO, Transazione.model().VERSIONE_SERVIZIO);
            filter.and(new IExpression[]{permessi2});
            filter.and();
            return;
        }
        if (ricerca != null && ModalitaRicercaTransazioni.ID_TOKEN.equals((Object)ricerca)) {
            if (!StringUtils.isNotEmpty((String)this.searchForm.getIdToken())) throw new UtilsException("Identificativo non fornito");
            String value = this.searchForm.getIdToken().trim();
            filter.equals(Transazione.model().TOKEN_ID, (Object)value);
            if (this.searchForm.getPermessiUtenteOperatore() == null) return;
            IExpression permessi3 = this.searchForm.getPermessiUtenteOperatore().toExpression((IExpressionConstructor)this.transazioniSearchDAO, Transazione.model().PDD_CODICE, Transazione.model().TIPO_SOGGETTO_EROGATORE, Transazione.model().NOME_SOGGETTO_EROGATORE, Transazione.model().TIPO_SERVIZIO, Transazione.model().NOME_SERVIZIO, Transazione.model().VERSIONE_SERVIZIO);
            filter.and(new IExpression[]{permessi3});
            filter.and();
            return;
        }
        if (ricerca != null && ModalitaRicercaTransazioni.PURPOSE_ID.equals((Object)ricerca)) {
            if (!StringUtils.isNotEmpty((String)this.searchForm.getPurposeId())) throw new UtilsException("Finalita non fornita");
            String value = this.searchForm.getPurposeId().trim();
            filter.equals(Transazione.model().TOKEN_PURPOSE_ID, (Object)value);
            if (this.searchForm.getPermessiUtenteOperatore() == null) return;
            IExpression permessi4 = this.searchForm.getPermessiUtenteOperatore().toExpression((IExpressionConstructor)this.transazioniSearchDAO, Transazione.model().PDD_CODICE, Transazione.model().TIPO_SOGGETTO_EROGATORE, Transazione.model().NOME_SOGGETTO_EROGATORE, Transazione.model().TIPO_SERVIZIO, Transazione.model().NOME_SERVIZIO, Transazione.model().VERSIONE_SERVIZIO);
            filter.and(new IExpression[]{permessi4});
            filter.and();
            return;
        }
        if (ricerca != null && ModalitaRicercaTransazioni.ID_TRANSAZIONE.equals((Object)ricerca)) {
            if (!StringUtils.isNotEmpty((String)this.searchForm.getIdTransazione())) throw new UtilsException("ID Transazione non fornito");
            String value = this.searchForm.getIdTransazione().trim();
            filter.equals(Transazione.model().ID_TRANSAZIONE, (Object)value);
            if (this.searchForm.getPermessiUtenteOperatore() == null) return;
            IExpression permessi5 = this.searchForm.getPermessiUtenteOperatore().toExpression((IExpressionConstructor)this.transazioniSearchDAO, Transazione.model().PDD_CODICE, Transazione.model().TIPO_SOGGETTO_EROGATORE, Transazione.model().NOME_SOGGETTO_EROGATORE, Transazione.model().TIPO_SERVIZIO, Transazione.model().NOME_SERVIZIO, Transazione.model().VERSIONE_SERVIZIO);
            filter.and(new IExpression[]{permessi5});
            filter.and();
            return;
        }
        if (ricerca != null && ModalitaRicercaTransazioni.ID_APPLICATIVO_BASE.equals((Object)ricerca)) {
            if (!StringUtils.isNotEmpty((String)this.searchForm.getIdCorrelazioneApplicativa())) throw new UtilsException("ID Applicativo non fornito");
            TipoMessaggio tipoMessaggio = TipoMessaggio.valueOf((String)this.searchForm.getTipoIdMessaggio());
            String value = this.searchForm.getIdCorrelazioneApplicativa().trim();
            switch (tipoMessaggio) {
                case Richiesta: {
                    filter.equals(Transazione.model().ID_CORRELAZIONE_APPLICATIVA, (Object)value);
                    break;
                }
                case Risposta: {
                    filter.equals(Transazione.model().ID_CORRELAZIONE_APPLICATIVA_RISPOSTA, (Object)value);
                    break;
                }
                default: {
                    throw new UtilsException("Tipo di ricerca non fornito");
                }
            }
            if (this.searchForm.getPermessiUtenteOperatore() == null) return;
            IExpression permessi6 = this.searchForm.getPermessiUtenteOperatore().toExpression((IExpressionConstructor)this.transazioniSearchDAO, Transazione.model().PDD_CODICE, Transazione.model().TIPO_SOGGETTO_EROGATORE, Transazione.model().NOME_SOGGETTO_EROGATORE, Transazione.model().TIPO_SERVIZIO, Transazione.model().NOME_SERVIZIO, Transazione.model().VERSIONE_SERVIZIO);
            filter.and(new IExpression[]{permessi6});
            filter.and();
            return;
        }
        boolean ricercaLibera = this.isRicercaLibera();
        boolean ricercaLiberaCaseSensitive = false;
        boolean ricercaLiberaEsatta = false;
        LikeMode ricercaLiberaLikeMode = null;
        if (ricercaLibera) {
            ricercaLiberaLikeMode = this.getRicercaLiberaEsattaLikeMode();
            ricercaLiberaEsatta = this.isRicercaLiberaEsatta();
            ricercaLiberaCaseSensitive = this.isRicercaLiberaCaseSensitive();
        }
        if (this.searchForm.getDataInizio() != null && !isLiveSearch) {
            filter.and().greaterEquals(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)this.searchForm.getDataInizio());
        }
        if (this.searchForm.getDataFine() != null && !isLiveSearch) {
            filter.and().lessEquals(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)this.searchForm.getDataFine());
        }
        if (this.searchForm.getDataRicerca() != null && !isLiveSearch) {
            filter.and().lessEquals(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)this.searchForm.getDataRicerca());
        }
        if (isLiveSearch && this.liveUltimiGiorni != null && this.liveUltimiGiorni != 0) {
            int numeroGiorni = this.liveUltimiGiorni;
            if (numeroGiorni > 0) {
                numeroGiorni *= -1;
            }
            Calendar c = Calendar.getInstance();
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            c.add(5, numeroGiorni);
            filter.and().greaterThan(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)c.getTime());
        }
        EsitoUtils esitoUtils = new EsitoUtils(this.log, this.searchForm.getSafeProtocol());
        esitoUtils.setExpression(filter, this.searchForm.getEsitoGruppo(), this.searchForm.getEsitoDettaglio(), this.searchForm.getEsitoDettaglioPersonalizzato(), this.searchForm.getEsitoContesto(), this.searchForm.isEscludiRichiesteScartate(), Transazione.model().ESITO, Transazione.model().ESITO_CONTESTO, this.transazioniSearchDAO.newExpression());
        if (this.searchForm.getTipologiaTransazioneSPCoop() == null || this.searchForm.getTipologiaTransazioneSPCoop().getValue() == null) {
            boolean addAnd = false;
            if (this.searchForm.getPermessiUtenteOperatore() != null) {
                permessi = this.searchForm.getPermessiUtenteOperatore().toExpression((IExpressionConstructor)this.transazioniSearchDAO, Transazione.model().PDD_CODICE, Transazione.model().TIPO_SOGGETTO_EROGATORE, Transazione.model().NOME_SOGGETTO_EROGATORE, Transazione.model().TIPO_SERVIZIO, Transazione.model().NOME_SERVIZIO, Transazione.model().VERSIONE_SERVIZIO);
                filter.and(new IExpression[]{permessi});
                addAnd = true;
            }
            if (this.searchForm.getTipologiaRicercaEnum() != null && !TipologiaRicerca.all.equals((Object)this.searchForm.getTipologiaRicercaEnum())) {
                if (TipologiaRicerca.ingresso.equals((Object)this.searchForm.getTipologiaRicercaEnum())) {
                    if (addAnd) {
                        filter.and();
                    }
                    filter.notEquals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.DELEGATA);
                    addAnd = true;
                } else {
                    if (addAnd) {
                        filter.and();
                    }
                    filter.notEquals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.APPLICATIVA);
                    addAnd = true;
                }
            }
        } else if (this.searchForm.getTipologiaTransazioneSPCoop().getValue().booleanValue()) {
            boolean addAnd = false;
            if (this.searchForm.getPermessiUtenteOperatore() != null) {
                permessi = this.searchForm.getPermessiUtenteOperatore().toExpression((IExpressionConstructor)this.transazioniSearchDAO, Transazione.model().PDD_CODICE, Transazione.model().TIPO_SOGGETTO_EROGATORE, Transazione.model().NOME_SOGGETTO_EROGATORE, Transazione.model().TIPO_SERVIZIO, Transazione.model().NOME_SERVIZIO, Transazione.model().VERSIONE_SERVIZIO);
                filter.and(new IExpression[]{permessi});
                addAnd = true;
            }
            if (this.searchForm.getTipologiaRicercaEnum() == null || TipologiaRicerca.all.equals((Object)this.searchForm.getTipologiaRicercaEnum())) {
                if (this.isAttivoSqlFilterTransazioniIntegrationManager) {
                    filter.notEquals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.INTEGRATION_MANAGER);
                }
            } else if (TipologiaRicerca.ingresso.equals((Object)this.searchForm.getTipologiaRicercaEnum())) {
                if (addAnd) {
                    filter.and();
                }
                filter.equals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.APPLICATIVA);
                addAnd = true;
            } else {
                if (addAnd) {
                    filter.and();
                }
                filter.equals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.DELEGATA);
                addAnd = true;
            }
        } else {
            if (this.searchForm.getPermessiUtenteOperatore() != null) {
                IExpression permessi7 = this.searchForm.getPermessiUtenteOperatore().toExpression((IExpressionConstructor)this.transazioniSearchDAO, Transazione.model().PDD_CODICE, Transazione.model().TIPO_SOGGETTO_EROGATORE, Transazione.model().NOME_SOGGETTO_EROGATORE, Transazione.model().TIPO_SERVIZIO, Transazione.model().NOME_SERVIZIO, Transazione.model().VERSIONE_SERVIZIO);
                filter.and(new IExpression[]{permessi7});
            }
            filter.and().equals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.INTEGRATION_MANAGER);
        }
        if (this.searchForm.getTipologiaTransazioneSPCoop() == null || this.searchForm.getTipologiaTransazioneSPCoop().getValue() == null || this.searchForm.getTipologiaTransazioneSPCoop().getValue().booleanValue()) {
            IExpression idcorrRisp;
            String nomeSoggettoLocale;
            if (Utility.isFiltroDominioAbilitato() && this.searchForm.getSoggettoLocale() != null && !StringUtils.isEmpty((String)this.searchForm.getSoggettoLocale()) && !"--".equals(this.searchForm.getSoggettoLocale())) {
                String tipoSoggettoLocale = this.searchForm.getTipoSoggettoLocale();
                nomeSoggettoLocale = this.searchForm.getSoggettoLocale();
                String idPorta = Utility.getIdentificativoPorta((String)tipoSoggettoLocale, (String)nomeSoggettoLocale);
                filter.and().equals(Transazione.model().PDD_CODICE, (Object)idPorta);
            }
            if (StringUtils.isNotBlank((String)this.searchForm.getNomeAzione())) {
                filter.and().equals(Transazione.model().AZIONE, (Object)this.searchForm.getNomeAzione());
            } else if (ricercaLibera && StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaAzione())) {
                if (ricercaLiberaCaseSensitive) {
                    filter.and().like(Transazione.model().AZIONE, this.searchForm.getRicercaLiberaAzione(), ricercaLiberaLikeMode);
                } else {
                    filter.and().ilike(Transazione.model().AZIONE, this.searchForm.getRicercaLiberaAzione(), ricercaLiberaLikeMode);
                }
            }
            if (StringUtils.isNotBlank((String)this.searchForm.getNomeServizio())) {
                String servizioString = this.searchForm.getNomeServizio();
                IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)servizioString);
                filter.and().equals(Transazione.model().TIPO_SOGGETTO_EROGATORE, (Object)idServizio.getSoggettoErogatore().getTipo()).equals(Transazione.model().NOME_SOGGETTO_EROGATORE, (Object)idServizio.getSoggettoErogatore().getNome()).equals(Transazione.model().TIPO_SERVIZIO, (Object)idServizio.getTipo()).equals(Transazione.model().NOME_SERVIZIO, (Object)idServizio.getNome()).equals(Transazione.model().VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
            } else if (ricercaLibera && StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaServizio())) {
                if (ricercaLiberaCaseSensitive) {
                    filter.and().like(Transazione.model().NOME_SERVIZIO, this.searchForm.getRicercaLiberaServizio(), ricercaLiberaLikeMode);
                } else {
                    filter.and().ilike(Transazione.model().NOME_SERVIZIO, this.searchForm.getRicercaLiberaServizio(), ricercaLiberaLikeMode);
                }
            }
            if (ricerca != null && ModalitaRicercaTransazioni.ID_APPLICATIVO_AVANZATA.equals((Object)ricerca)) {
                if (!StringUtils.isNotEmpty((String)this.searchForm.getIdCorrelazioneApplicativa())) throw new UtilsException("ID Applicativo non fornito");
                filter.and();
                IExpression idcorr = this.transazioniSearchDAO.newExpression();
                idcorrRisp = this.transazioniSearchDAO.newExpression();
                String value = this.searchForm.getIdCorrelazioneApplicativa().trim();
                CaseSensitiveMatch caseSensitiveMatch = CaseSensitiveMatch.valueOf((String)this.searchForm.getCorrelazioneApplicativaCaseSensitiveType());
                TipoMatch match = TipoMatch.valueOf((String)this.searchForm.getCorrelazioneApplicativaMatchingType());
                if (TipoMatch.LIKE.equals((Object)match)) {
                    if (CaseSensitiveMatch.SENSITIVE.equals((Object)caseSensitiveMatch)) {
                        idcorr.like(Transazione.model().ID_CORRELAZIONE_APPLICATIVA, value, LikeMode.ANYWHERE);
                        idcorrRisp.like(Transazione.model().ID_CORRELAZIONE_APPLICATIVA_RISPOSTA, value, LikeMode.ANYWHERE);
                    } else {
                        idcorr.ilike(Transazione.model().ID_CORRELAZIONE_APPLICATIVA, value, LikeMode.ANYWHERE);
                        idcorrRisp.ilike(Transazione.model().ID_CORRELAZIONE_APPLICATIVA_RISPOSTA, value, LikeMode.ANYWHERE);
                    }
                } else if (CaseSensitiveMatch.SENSITIVE.equals((Object)caseSensitiveMatch)) {
                    idcorr.equals(Transazione.model().ID_CORRELAZIONE_APPLICATIVA, (Object)value);
                    idcorrRisp.equals(Transazione.model().ID_CORRELAZIONE_APPLICATIVA_RISPOSTA, (Object)value);
                } else {
                    idcorr.ilike(Transazione.model().ID_CORRELAZIONE_APPLICATIVA, value, LikeMode.EXACT);
                    idcorrRisp.ilike(Transazione.model().ID_CORRELAZIONE_APPLICATIVA_RISPOSTA, value, LikeMode.EXACT);
                }
                filter.or(idcorr, idcorrRisp);
            } else if (ricercaLibera && StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaIdApplicativo())) {
                IExpression idcorr = this.transazioniSearchDAO.newExpression();
                idcorrRisp = this.transazioniSearchDAO.newExpression();
                if (ricercaLiberaCaseSensitive) {
                    idcorr.and().like(Transazione.model().ID_CORRELAZIONE_APPLICATIVA, this.searchForm.getRicercaLiberaIdApplicativo(), ricercaLiberaLikeMode);
                    idcorrRisp.and().like(Transazione.model().ID_CORRELAZIONE_APPLICATIVA_RISPOSTA, this.searchForm.getRicercaLiberaIdApplicativo(), ricercaLiberaLikeMode);
                } else {
                    idcorr.and().ilike(Transazione.model().ID_CORRELAZIONE_APPLICATIVA, this.searchForm.getRicercaLiberaIdApplicativo(), ricercaLiberaLikeMode);
                    idcorrRisp.and().ilike(Transazione.model().ID_CORRELAZIONE_APPLICATIVA_RISPOSTA, this.searchForm.getRicercaLiberaIdApplicativo(), ricercaLiberaLikeMode);
                }
                filter.or(idcorr, idcorrRisp);
            }
            if (StringUtils.isNotBlank((String)this.searchForm.getNomeStato())) {
                filter.and().equals(Transazione.model().STATO, (Object)this.searchForm.getNomeStato());
            }
            if (StringUtils.isNotBlank((String)this.searchForm.getNomeRisorsa())) {
                if (StringUtils.isBlank((String)this.searchForm.getValoreRisorsa())) {
                    throw new UtilsException("Valore della Risorsa '" + this.searchForm.getNomeRisorsa() + "' non fornito");
                }
                filter.and().equals(Transazione.model().DUMP_MESSAGGIO.CONTENUTO.NOME, (Object)this.searchForm.getNomeRisorsa()).equals(Transazione.model().DUMP_MESSAGGIO.CONTENUTO.VALORE, (Object)this.searchForm.getValoreRisorsa());
            }
            if (this.searchForm.getTipologiaRicercaEnum() == null || TipologiaRicerca.all.equals((Object)this.searchForm.getTipologiaRicercaEnum())) {
                boolean trafficoSoggetto = StringUtils.isNotBlank((String)this.searchForm.getTrafficoPerSoggetto());
                if (trafficoSoggetto) {
                    IExpression erogatore = this.transazioniSearchDAO.newExpression();
                    erogatore.and().equals(Transazione.model().NOME_SOGGETTO_EROGATORE, (Object)this.searchForm.getTrafficoPerSoggetto()).equals(Transazione.model().TIPO_SOGGETTO_EROGATORE, (Object)this.searchForm.getTipoTrafficoPerSoggetto());
                    IExpression fruitore = this.transazioniSearchDAO.newExpression();
                    fruitore.and().equals(Transazione.model().NOME_SOGGETTO_FRUITORE, (Object)this.searchForm.getTrafficoPerSoggetto()).equals(Transazione.model().TIPO_SOGGETTO_FRUITORE, (Object)this.searchForm.getTipoTrafficoPerSoggetto());
                    IExpression soggetti = this.transazioniSearchDAO.newExpression();
                    soggetti.or(erogatore, fruitore);
                    filter.and(new IExpression[]{soggetti});
                } else if (ricercaLibera) {
                    if (StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaSoggettoRemoto()) && StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaSoggettoLocale())) {
                        nomeSoggettoLocale = this.searchForm.getRicercaLiberaSoggettoLocale();
                        String nomeSoggettoRemoto = this.searchForm.getRicercaLiberaSoggettoRemoto();
                        IExpression erogazione = this.transazioniSearchDAO.newExpression();
                        IExpression fruizione = this.transazioniSearchDAO.newExpression();
                        if (ricercaLiberaCaseSensitive) {
                            erogazione.and().like(Transazione.model().NOME_SOGGETTO_EROGATORE, nomeSoggettoLocale, ricercaLiberaLikeMode).like(Transazione.model().NOME_SOGGETTO_FRUITORE, nomeSoggettoRemoto, ricercaLiberaLikeMode);
                            fruizione.and().like(Transazione.model().NOME_SOGGETTO_FRUITORE, nomeSoggettoLocale, ricercaLiberaLikeMode).like(Transazione.model().NOME_SOGGETTO_EROGATORE, nomeSoggettoRemoto, ricercaLiberaLikeMode);
                        } else {
                            erogazione.and().ilike(Transazione.model().NOME_SOGGETTO_EROGATORE, nomeSoggettoLocale, ricercaLiberaLikeMode).ilike(Transazione.model().NOME_SOGGETTO_FRUITORE, nomeSoggettoRemoto, ricercaLiberaLikeMode);
                            fruizione.and().ilike(Transazione.model().NOME_SOGGETTO_FRUITORE, nomeSoggettoLocale, ricercaLiberaLikeMode).ilike(Transazione.model().NOME_SOGGETTO_EROGATORE, nomeSoggettoRemoto, ricercaLiberaLikeMode);
                        }
                        IExpression soggetti = this.transazioniSearchDAO.newExpression();
                        soggetti.or(erogazione, fruizione);
                        filter.and(new IExpression[]{soggetti});
                    } else if (StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaSoggettoRemoto()) || StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaSoggettoLocale())) {
                        String nomeSoggetto = null;
                        nomeSoggetto = StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaSoggettoRemoto()) ? this.searchForm.getRicercaLiberaSoggettoRemoto() : this.searchForm.getRicercaLiberaSoggettoLocale();
                        IExpression erogatore = this.transazioniSearchDAO.newExpression();
                        IExpression fruitore = this.transazioniSearchDAO.newExpression();
                        if (ricercaLiberaCaseSensitive) {
                            erogatore.and().like(Transazione.model().NOME_SOGGETTO_EROGATORE, nomeSoggetto, ricercaLiberaLikeMode);
                            fruitore.and().like(Transazione.model().NOME_SOGGETTO_FRUITORE, nomeSoggetto, ricercaLiberaLikeMode);
                        } else {
                            erogatore.and().ilike(Transazione.model().NOME_SOGGETTO_EROGATORE, nomeSoggetto, ricercaLiberaLikeMode);
                            fruitore.and().ilike(Transazione.model().NOME_SOGGETTO_FRUITORE, nomeSoggetto, ricercaLiberaLikeMode);
                        }
                        IExpression soggetti = this.transazioniSearchDAO.newExpression();
                        soggetti.or(erogatore, fruitore);
                        filter.and(new IExpression[]{soggetti});
                    }
                }
            } else if (TipologiaRicerca.ingresso.equals((Object)this.searchForm.getTipologiaRicercaEnum())) {
                boolean ignoreSetMittente = false;
                if (StringUtils.isNotEmpty((String)this.searchForm.getRiconoscimento()) && this.searchForm.getRiconoscimento().equals("applicativo") && StringUtils.isNotBlank((String)this.searchForm.getIdentificazione()) && StringUtils.isNotBlank((String)this.searchForm.getServizioApplicativo()) && "commons.identificazione.token.label".equals(this.searchForm.getIdentificazione())) {
                    ignoreSetMittente = true;
                }
                boolean setMittente = false;
                if (StringUtils.isNotBlank((String)this.searchForm.getNomeMittente()) && !ignoreSetMittente) {
                    filter.and().equals(Transazione.model().NOME_SOGGETTO_FRUITORE, (Object)this.searchForm.getNomeMittente());
                    setMittente = true;
                }
                if (StringUtils.isNotBlank((String)this.searchForm.getTipoMittente()) && !ignoreSetMittente) {
                    filter.and().equals(Transazione.model().TIPO_SOGGETTO_FRUITORE, (Object)this.searchForm.getTipoMittente());
                    setMittente = true;
                }
                if (!setMittente && ricercaLibera && StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaSoggettoRemoto())) {
                    if (ricercaLiberaCaseSensitive) {
                        filter.and().like(Transazione.model().NOME_SOGGETTO_FRUITORE, this.searchForm.getRicercaLiberaSoggettoRemoto(), ricercaLiberaLikeMode);
                    } else {
                        filter.and().ilike(Transazione.model().NOME_SOGGETTO_FRUITORE, this.searchForm.getRicercaLiberaSoggettoRemoto(), ricercaLiberaLikeMode);
                    }
                }
                if (ricercaLibera && StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaSoggettoLocale())) {
                    if (ricercaLiberaCaseSensitive) {
                        filter.and().like(Transazione.model().NOME_SOGGETTO_EROGATORE, this.searchForm.getRicercaLiberaSoggettoLocale(), ricercaLiberaLikeMode);
                    } else {
                        filter.and().ilike(Transazione.model().NOME_SOGGETTO_EROGATORE, this.searchForm.getRicercaLiberaSoggettoLocale(), ricercaLiberaLikeMode);
                    }
                }
            } else {
                boolean setDestinatario = false;
                if (StringUtils.isNotBlank((String)this.searchForm.getNomeDestinatario())) {
                    filter.and().equals(Transazione.model().NOME_SOGGETTO_EROGATORE, (Object)this.searchForm.getNomeDestinatario());
                    setDestinatario = true;
                }
                if (StringUtils.isNotBlank((String)this.searchForm.getTipoDestinatario())) {
                    filter.and().equals(Transazione.model().TIPO_SOGGETTO_EROGATORE, (Object)this.searchForm.getTipoDestinatario());
                    setDestinatario = true;
                }
                if (!setDestinatario && ricercaLibera && StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaSoggettoRemoto())) {
                    if (ricercaLiberaCaseSensitive) {
                        filter.and().like(Transazione.model().NOME_SOGGETTO_EROGATORE, this.searchForm.getRicercaLiberaSoggettoRemoto(), ricercaLiberaLikeMode);
                    } else {
                        filter.and().ilike(Transazione.model().NOME_SOGGETTO_EROGATORE, this.searchForm.getRicercaLiberaSoggettoRemoto(), ricercaLiberaLikeMode);
                    }
                }
                if (ricercaLibera && StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaSoggettoLocale())) {
                    if (ricercaLiberaCaseSensitive) {
                        filter.and().like(Transazione.model().NOME_SOGGETTO_FRUITORE, this.searchForm.getRicercaLiberaSoggettoLocale(), ricercaLiberaLikeMode);
                    } else {
                        filter.and().ilike(Transazione.model().NOME_SOGGETTO_FRUITORE, this.searchForm.getRicercaLiberaSoggettoLocale(), ricercaLiberaLikeMode);
                    }
                }
            }
        }
        this.impostaFiltroDatiMittente(filter, this.transazioniSearchDAO, this.searchForm, Transazione.model(), isCount, isLiveSearch);
        if (this.searchForm.isSetFiltroProtocollo()) {
            filter.and().equals(Transazione.model().PROTOCOLLO, (Object)this.searchForm.getProtocollo());
        }
        if (StringUtils.isNotEmpty((String)this.searchForm.getEvento()) || StringUtils.isNotEmpty((String)this.searchForm.getCodiceRisposta())) {
            CredenzialeSearchEvento searchEventi = new CredenzialeSearchEvento();
            ArrayList<CredenzialeMittente> listaCredenzialiMittente2 = new ArrayList<CredenzialeMittente>();
            if (StringUtils.isNotEmpty((String)this.searchForm.getEvento())) {
                IPaginatedExpression pagExpr;
                String[] listaCredenzialiMittenteEvento;
                Object evento = this.searchForm.getEvento();
                if (evento != null && ((String)(evento = ((String)evento).trim())).toLowerCase().startsWith("API=".toLowerCase()) && ((String)evento).length() > "API=".length()) {
                    try {
                        String sub = ((String)evento).substring("API=".length());
                        if ("rest".equalsIgnoreCase(sub)) {
                            evento = "API=" + TipoAPI.REST.getValoreAsInt();
                        } else if ("soap".equalsIgnoreCase(sub)) {
                            evento = "API=" + TipoAPI.SOAP.getValoreAsInt();
                        }
                    }
                    catch (Throwable sub) {
                        // empty catch block
                    }
                }
                if ((listaCredenzialiMittenteEvento = this.credenzialiMittenteDAO.findAll(pagExpr = searchEventi.createExpression(this.credenzialiMittenteDAO, (String)evento, false, false))) != null && !listaCredenzialiMittenteEvento.isEmpty()) {
                    listaCredenzialiMittente2.addAll((Collection<CredenzialeMittente>)listaCredenzialiMittenteEvento);
                }
            }
            if (StringUtils.isNotEmpty((String)this.searchForm.getCodiceRisposta())) {
                ArrayList<String> l = new ArrayList<String>();
                if (this.searchForm.getCodiceRisposta().contains(",")) {
                    String[] tmp = this.searchForm.getCodiceRisposta().split(",");
                    if (tmp != null && tmp.length > 0) {
                        for (String v : tmp) {
                            l.add(v.trim());
                        }
                    } else {
                        l.add(this.searchForm.getCodiceRisposta());
                    }
                } else {
                    l.add(this.searchForm.getCodiceRisposta());
                }
                if (!l.isEmpty()) {
                    for (String codice : l) {
                        for (int i = 0; i < 2; ++i) {
                            String prefix = i == 0 ? "Out=" : "In=";
                            String searchCodice = prefix + codice;
                            IPaginatedExpression pagExpr = searchEventi.createExpression(this.credenzialiMittenteDAO, searchCodice, false, false);
                            List listaCredenzialiMittenteCodice = this.credenzialiMittenteDAO.findAll(pagExpr);
                            if (listaCredenzialiMittenteCodice == null || listaCredenzialiMittenteCodice.isEmpty()) continue;
                            listaCredenzialiMittente2.addAll(listaCredenzialiMittenteCodice);
                        }
                    }
                }
            }
            this.addListaCredenzialiMittente(filter, listaCredenzialiMittente2, Transazione.model());
        }
        if (StringUtils.isNotEmpty((String)this.searchForm.getGruppo())) {
            CredenzialeSearchGruppo searchGruppi = new CredenzialeSearchGruppo();
            IPaginatedExpression pagExpr = searchGruppi.createExpression(this.credenzialiMittenteDAO, this.searchForm.getGruppo(), true, true);
            listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
            this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, Transazione.model());
        } else if (ricercaLibera && StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaGruppo())) {
            CredenzialeSearchGruppo searchGruppi = new CredenzialeSearchGruppo();
            IPaginatedExpression pagExpr = searchGruppi.createExpression(this.credenzialiMittenteDAO, this.searchForm.getRicercaLiberaGruppo(), ricercaLiberaEsatta, ricercaLiberaCaseSensitive);
            listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
            this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, Transazione.model());
        }
        if (StringUtils.isNotEmpty((String)this.searchForm.getApi())) {
            CredenzialeSearchApi searchApi = new CredenzialeSearchApi();
            IPaginatedExpression pagExpr = searchApi.createExpression(this.credenzialiMittenteDAO, this.searchForm.getApi(), true, true);
            listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
            this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, Transazione.model());
        } else if (ricercaLibera && StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaApi())) {
            CredenzialeSearchApi searchApi = new CredenzialeSearchApi();
            IPaginatedExpression pagExpr = searchApi.createExpression(this.credenzialiMittenteDAO, this.searchForm.getRicercaLiberaApi(), ricercaLiberaEsatta, ricercaLiberaCaseSensitive);
            listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
            this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, Transazione.model());
        }
        if (StringUtils.isNotEmpty((String)this.searchForm.getClusterId())) {
            if (this.clusterDinamico) {
                List<String> listId = this.getClusterIdDinamici(this.searchForm.getClusterId().trim(), this.clusterDinamicoRefresh);
                if (listId != null && !listId.isEmpty()) {
                    filter.and().in(Transazione.model().CLUSTER_ID, listId);
                } else {
                    filter.and().equals(Transazione.model().CLUSTER_ID, (Object)"--");
                }
            } else {
                filter.and().equals(Transazione.model().CLUSTER_ID, (Object)this.searchForm.getClusterId().trim());
            }
        } else if (StringUtils.isNotEmpty((String)this.searchForm.getCanale())) {
            List listId = this.searchForm.getIdClusterByCanale(this.searchForm.getCanale());
            if (listId != null && !listId.isEmpty()) {
                filter.and().in(Transazione.model().CLUSTER_ID, (Collection)listId);
            } else {
                filter.and().equals(Transazione.model().CLUSTER_ID, (Object)"--");
            }
        }
        IFilter filtro = this.searchForm.getFiltro();
        if (filtro == null) return;
        FilterImpl f = (FilterImpl)filtro;
        filter.and(new IExpression[]{f.getExpression()});
    }

    private boolean isRicercaLibera() {
        if (!this.searchForm.isLive() && StringUtils.isNotEmpty((String)this.searchForm.getModalitaRicercaStorico())) {
            ModalitaRicercaTransazioni t = ModalitaRicercaTransazioni.getFromString((String)this.searchForm.getModalitaRicercaStorico());
            return ModalitaRicercaTransazioni.RICERCA_LIBERA.equals((Object)t);
        }
        return false;
    }

    private boolean isRicercaLiberaEsatta() {
        String r = this.searchForm.getRicercaLiberaMatchingType();
        if (r != null && !"".equals(r)) {
            TipoMatch tipo = TipoMatch.valueOf((String)r);
            return TipoMatch.EQUALS.equals((Object)tipo);
        }
        return false;
    }

    private boolean isRicercaLiberaCaseSensitive() {
        String r = this.searchForm.getRicercaLiberaCaseSensitiveType();
        if (r != null && !"".equals(r)) {
            CaseSensitiveMatch tipo = CaseSensitiveMatch.valueOf((String)r);
            return CaseSensitiveMatch.SENSITIVE.equals((Object)tipo);
        }
        return false;
    }

    private LikeMode getRicercaLiberaEsattaLikeMode() {
        return this.isRicercaLiberaEsatta() ? LikeMode.EXACT : LikeMode.ANYWHERE;
    }

    private void impostaFiltroDatiMittente(IExpression filter, ITransazioneServiceSearch transazioniSearchDAO, BaseSearchForm searchForm, TransazioneModel model, boolean isCount, boolean isLiveSearch) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException, NotFoundException {
        if (StringUtils.isNotEmpty((String)searchForm.getRiconoscimento())) {
            if (searchForm.getRiconoscimento().equals("soggetto")) {
                boolean soggettoDefined;
                boolean bl = soggettoDefined = StringUtils.isNotBlank((String)this.searchForm.getNomeMittente()) && StringUtils.isNotBlank((String)this.searchForm.getTipoMittente());
                if (!soggettoDefined) {
                    filter.and().equals(model.ID_TRANSAZIONE, (Object)"-1");
                }
            } else if (searchForm.getRiconoscimento().equals("applicativo")) {
                if (StringUtils.isNotBlank((String)searchForm.getIdentificazione())) {
                    if (StringUtils.isNotBlank((String)searchForm.getServizioApplicativo())) {
                        if ("commons.identificazione.trasporto.label".equals(searchForm.getIdentificazione())) {
                            IExpression saOr = transazioniSearchDAO.newExpression();
                            saOr.equals(model.SERVIZIO_APPLICATIVO_FRUITORE, (Object)searchForm.getServizioApplicativo());
                            filter.and(new IExpression[]{saOr});
                        } else if ("commons.identificazione.token.label".equals(searchForm.getIdentificazione())) {
                            boolean soggettoDefined;
                            boolean bl = soggettoDefined = StringUtils.isNotBlank((String)this.searchForm.getNomeMittente()) && StringUtils.isNotBlank((String)this.searchForm.getTipoMittente());
                            if (soggettoDefined) {
                                IDSoggetto idSoggetto = new IDSoggetto(this.searchForm.getTipoMittente(), this.searchForm.getNomeMittente());
                                IDServizioApplicativo idSA = new IDServizioApplicativo();
                                idSA.setIdSoggettoProprietario(idSoggetto);
                                idSA.setNome(searchForm.getServizioApplicativo());
                                String idSAasString = CredenzialeTokenClient.getApplicationAsString((IDServizioApplicativo)idSA);
                                String dbValue = CredenzialeTokenClient.getApplicationDBValue((String)idSAasString);
                                CredenzialeSearchTokenClient searchToken = new CredenzialeSearchTokenClient(false, true, false);
                                searchToken.disableConvertToDBValue();
                                boolean ricercaEsatta = false;
                                boolean caseSensitive = true;
                                try {
                                    IPaginatedExpression pagExpr = searchToken.createExpression(this.credenzialiMittenteDAO, dbValue, ricercaEsatta, caseSensitive);
                                    List listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
                                    this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, model);
                                }
                                catch (Exception e) {
                                    throw new ServiceException(e.getMessage(), (Throwable)e);
                                }
                            } else {
                                filter.and().equals(model.ID_TRANSAZIONE, (Object)"-1");
                            }
                        }
                    } else {
                        filter.and().equals(model.ID_TRANSAZIONE, (Object)"-1");
                    }
                } else {
                    filter.and().equals(model.ID_TRANSAZIONE, (Object)"-1");
                }
            } else {
                List<CredenzialeMittente> listaCredenzialiMittente = this.getIdCredenzialiFromFilter(searchForm, this.credenzialiMittenteDAO, isCount, isLiveSearch);
                this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, model);
            }
        } else if (this.isRicercaLibera()) {
            CredenzialeSearchTokenClient searchToken;
            List listaCredenzialiMittente;
            IPaginatedExpression pagExpr;
            boolean ricercaLiberaCaseSensitive = this.isRicercaLiberaCaseSensitive();
            boolean ricercaLiberaEsatta = this.isRicercaLiberaEsatta();
            LikeMode ricercaLiberaLikeMode = this.getRicercaLiberaEsattaLikeMode();
            if (StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaApplicativo())) {
                if (ricercaLiberaCaseSensitive) {
                    filter.and().like(Transazione.model().SERVIZIO_APPLICATIVO_FRUITORE, this.searchForm.getRicercaLiberaApplicativo(), ricercaLiberaLikeMode);
                } else {
                    filter.and().ilike(Transazione.model().SERVIZIO_APPLICATIVO_FRUITORE, this.searchForm.getRicercaLiberaApplicativo(), ricercaLiberaLikeMode);
                }
            }
            if (StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaIdentificativoAutenticato())) {
                try {
                    CredenzialeSearchTrasporto searchCredenzialiPrincipal;
                    IPaginatedExpression pagExprPrincipal;
                    List listaCredenzialiMittentePrincipal;
                    CredenzialeSearchTrasporto searchCredenzialiSsl;
                    IPaginatedExpression pagExprSsl;
                    List listaCredenzialiMittenteSsl;
                    ArrayList<CredenzialeMittente> allList = new ArrayList<CredenzialeMittente>();
                    CredenzialeSearchTrasporto searchCredenzialiBasic = new CredenzialeSearchTrasporto(TipoAutenticazione.BASIC.getValue());
                    IPaginatedExpression pagExprBasic = searchCredenzialiBasic.createExpression(this.credenzialiMittenteDAO, this.searchForm.getRicercaLiberaIdentificativoAutenticato(), ricercaLiberaEsatta, ricercaLiberaCaseSensitive);
                    List listaCredenzialiMittenteBasic = this.credenzialiMittenteDAO.findAll(pagExprBasic);
                    if (listaCredenzialiMittenteBasic != null && listaCredenzialiMittenteBasic.size() > 0) {
                        allList.addAll(listaCredenzialiMittenteBasic);
                    }
                    if ((listaCredenzialiMittenteSsl = this.credenzialiMittenteDAO.findAll(pagExprSsl = (searchCredenzialiSsl = new CredenzialeSearchTrasporto(TipoAutenticazione.SSL.getValue())).createExpression(this.credenzialiMittenteDAO, this.searchForm.getRicercaLiberaIdentificativoAutenticato(), ricercaLiberaEsatta, ricercaLiberaCaseSensitive))) != null && listaCredenzialiMittenteSsl.size() > 0) {
                        allList.addAll(listaCredenzialiMittenteSsl);
                    }
                    if ((listaCredenzialiMittentePrincipal = this.credenzialiMittenteDAO.findAll(pagExprPrincipal = (searchCredenzialiPrincipal = new CredenzialeSearchTrasporto(TipoAutenticazione.PRINCIPAL.getValue())).createExpression(this.credenzialiMittenteDAO, this.searchForm.getRicercaLiberaIdentificativoAutenticato(), ricercaLiberaEsatta, ricercaLiberaCaseSensitive))) != null && listaCredenzialiMittentePrincipal.size() > 0) {
                        allList.addAll(listaCredenzialiMittentePrincipal);
                    }
                    this.addListaCredenzialiMittente(filter, allList, Transazione.model());
                }
                catch (Exception e) {
                    throw new ServiceException(e.getMessage(), (Throwable)e);
                }
            }
            if (StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaIndirizzoIP())) {
                try {
                    CredenzialeSearchClientAddress searchClientAddress = new CredenzialeSearchClientAddress(true, true, false);
                    pagExpr = searchClientAddress.createExpression(this.credenzialiMittenteDAO, this.searchForm.getRicercaLiberaIndirizzoIP(), ricercaLiberaEsatta, ricercaLiberaCaseSensitive);
                    listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
                    this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, Transazione.model());
                }
                catch (Exception e) {
                    throw new ServiceException(e.getMessage(), (Throwable)e);
                }
            }
            if (StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaApplicativoToken())) {
                try {
                    searchToken = new CredenzialeSearchTokenClient(false, true, false);
                    pagExpr = searchToken.createExpression(this.credenzialiMittenteDAO, this.searchForm.getRicercaLiberaApplicativoToken(), ricercaLiberaEsatta, ricercaLiberaCaseSensitive);
                    listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
                    this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, Transazione.model());
                }
                catch (Exception e) {
                    throw new ServiceException(e.getMessage(), (Throwable)e);
                }
            }
            if (StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaTokenIssuer())) {
                try {
                    searchToken = new CredenzialeSearchToken(TipoCredenzialeMittente.TOKEN_ISSUER);
                    pagExpr = searchToken.createExpression(this.credenzialiMittenteDAO, this.searchForm.getRicercaLiberaTokenIssuer(), ricercaLiberaEsatta, ricercaLiberaCaseSensitive);
                    listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
                    this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, Transazione.model());
                }
                catch (Exception e) {
                    throw new ServiceException(e.getMessage(), (Throwable)e);
                }
            }
            if (StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaTokenSubject())) {
                try {
                    searchToken = new CredenzialeSearchToken(TipoCredenzialeMittente.TOKEN_SUBJECT);
                    pagExpr = searchToken.createExpression(this.credenzialiMittenteDAO, this.searchForm.getRicercaLiberaTokenSubject(), ricercaLiberaEsatta, ricercaLiberaCaseSensitive);
                    listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
                    this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, Transazione.model());
                }
                catch (Exception e) {
                    throw new ServiceException(e.getMessage(), (Throwable)e);
                }
            }
            if (StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaTokenClientID())) {
                try {
                    searchToken = new CredenzialeSearchToken(TipoCredenzialeMittente.TOKEN_CLIENT_ID);
                    pagExpr = searchToken.createExpression(this.credenzialiMittenteDAO, this.searchForm.getRicercaLiberaTokenClientID(), ricercaLiberaEsatta, ricercaLiberaCaseSensitive);
                    listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
                    this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, Transazione.model());
                }
                catch (Exception e) {
                    throw new ServiceException(e.getMessage(), (Throwable)e);
                }
            }
            if (StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaTokenUsername())) {
                try {
                    searchToken = new CredenzialeSearchToken(TipoCredenzialeMittente.TOKEN_USERNAME);
                    pagExpr = searchToken.createExpression(this.credenzialiMittenteDAO, this.searchForm.getRicercaLiberaTokenUsername(), ricercaLiberaEsatta, ricercaLiberaCaseSensitive);
                    listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
                    this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, Transazione.model());
                }
                catch (Exception e) {
                    throw new ServiceException(e.getMessage(), (Throwable)e);
                }
            }
            if (StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaTokenEmail())) {
                try {
                    searchToken = new CredenzialeSearchToken(TipoCredenzialeMittente.TOKEN_EMAIL);
                    pagExpr = searchToken.createExpression(this.credenzialiMittenteDAO, this.searchForm.getRicercaLiberaTokenEmail(), ricercaLiberaEsatta, ricercaLiberaCaseSensitive);
                    listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
                    this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, Transazione.model());
                }
                catch (Exception e) {
                    throw new ServiceException(e.getMessage(), (Throwable)e);
                }
            }
            if (StringUtils.isNotBlank((String)this.searchForm.getRicercaLiberaPdndOrganization())) {
                try {
                    searchToken = new CredenzialeSearchToken(TipoCredenzialeMittente.PDND_ORGANIZATION_NAME);
                    pagExpr = searchToken.createExpression(this.credenzialiMittenteDAO, this.searchForm.getRicercaLiberaPdndOrganization(), ricercaLiberaEsatta, ricercaLiberaCaseSensitive);
                    listaCredenzialiMittente = this.credenzialiMittenteDAO.findAll(pagExpr);
                    listaCredenzialiMittente = CredenzialiMittenteUtils.translateByRef((List)listaCredenzialiMittente, (ICredenzialeMittenteService)this.credenzialiMittenteDAO);
                    this.addListaCredenzialiMittente(filter, listaCredenzialiMittente, Transazione.model());
                }
                catch (Exception e) {
                    throw new ServiceException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private IField getCredenzialeField(CredenzialeMittente credenzialeMittente, TransazioneModel model) throws NotFoundException {
        IField fieldCredenziale = null;
        String credenzialeTipo = credenzialeMittente.getTipo();
        if (credenzialeTipo.startsWith("trasporto")) {
            fieldCredenziale = model.TRASPORTO_MITTENTE;
        } else {
            TipoCredenzialeMittente tcm = TipoCredenzialeMittente.toEnumConstant((String)credenzialeTipo, (boolean)true);
            switch (tcm) {
                case TOKEN_CLIENT_ID: {
                    fieldCredenziale = model.TOKEN_CLIENT_ID;
                    break;
                }
                case TOKEN_EMAIL: {
                    fieldCredenziale = model.TOKEN_MAIL;
                    break;
                }
                case TOKEN_ISSUER: {
                    fieldCredenziale = model.TOKEN_ISSUER;
                    break;
                }
                case TOKEN_SUBJECT: {
                    fieldCredenziale = model.TOKEN_SUBJECT;
                    break;
                }
                case TOKEN_USERNAME: {
                    fieldCredenziale = model.TOKEN_USERNAME;
                    break;
                }
                case CLIENT_ADDRESS: {
                    fieldCredenziale = model.CLIENT_ADDRESS;
                    break;
                }
                case EVENTI: {
                    fieldCredenziale = model.EVENTI_GESTIONE;
                    break;
                }
                case GRUPPI: {
                    fieldCredenziale = model.GRUPPI;
                    break;
                }
                case API: {
                    fieldCredenziale = model.URI_API;
                    break;
                }
                case PDND_ORGANIZATION_NAME: 
                case PDND_ORGANIZATION_EXTERNAL_ID: 
                case PDND_ORGANIZATION_CONSUMER_ID: {
                    fieldCredenziale = model.TOKEN_CLIENT_ID;
                    break;
                }
            }
        }
        return fieldCredenziale;
    }

    private List<CredenzialeMittente> getIdCredenzialiFromFilter(BaseSearchForm searchForm, ICredenzialeMittenteService credenzialeMittentiService, boolean isCount, boolean isLiveSearch) throws NotFoundException {
        List<Object> findAll = new ArrayList<CredenzialeMittente>();
        try {
            CaseSensitiveMatch caseSensitiveMatch = CaseSensitiveMatch.valueOf((String)searchForm.getMittenteCaseSensitiveType());
            TipoMatch match = TipoMatch.valueOf((String)searchForm.getMittenteMatchingType());
            boolean ricercaEsatta = TipoMatch.EQUALS.equals((Object)match);
            boolean caseSensitive = CaseSensitiveMatch.SENSITIVE.equals((Object)caseSensitiveMatch);
            Object valoreRiconoscimento = searchForm.getValoreRiconoscimento() != null ? searchForm.getValoreRiconoscimento().trim() : null;
            IPaginatedExpression pagExpr = null;
            boolean ricercaIdentificatoAutenticatoSsl = false;
            if (searchForm.getRiconoscimento().equals("identificativoAutenticato")) {
                CredenzialeSearchTrasporto searchTrasporto = new CredenzialeSearchTrasporto(searchForm.getAutenticazione());
                pagExpr = searchTrasporto.createExpression(credenzialeMittentiService, (String)valoreRiconoscimento, ricercaEsatta, caseSensitive);
                ricercaIdentificatoAutenticatoSsl = searchTrasporto.isSsl();
            }
            if (searchForm.getRiconoscimento().equals("ip")) {
                caseSensitive = true;
                boolean socketAddress = false;
                boolean trasportAddress = false;
                boolean and = false;
                if (ricercaEsatta) {
                    if ("socket".equals(searchForm.getClientAddressMode())) {
                        socketAddress = true;
                    } else if ("transport".equals(searchForm.getClientAddressMode())) {
                        trasportAddress = true;
                    } else {
                        socketAddress = true;
                        trasportAddress = true;
                    }
                }
                CredenzialeSearchClientAddress searchClientAddress = new CredenzialeSearchClientAddress(socketAddress, trasportAddress, and);
                pagExpr = searchClientAddress.createExpression(credenzialeMittentiService, (String)valoreRiconoscimento, ricercaEsatta, caseSensitive);
            }
            boolean searchByRefCredentials = false;
            if (searchForm.getRiconoscimento().equals("tokenInfo")) {
                TipoCredenzialeMittente tcm = TipoCredenzialeMittente.toEnumConstant((String)searchForm.getTokenClaim(), (boolean)true);
                CredenzialeSearchTokenClient searchToken = null;
                if (TipoCredenzialeMittente.TOKEN_CLIENT_ID.equals((Object)tcm)) {
                    searchToken = new CredenzialeSearchTokenClient(true, false, true);
                } else if (TipoCredenzialeMittente.PDND_ORGANIZATION_EXTERNAL_ID.equals((Object)tcm) || TipoCredenzialeMittente.PDND_ORGANIZATION_CONSUMER_ID.equals((Object)tcm)) {
                    searchToken = new CredenzialeSearchToken(TipoCredenzialeMittente.PDND_ORGANIZATION_JSON);
                    searchByRefCredentials = true;
                    if (ricercaEsatta) {
                        valoreRiconoscimento = "\"" + (String)valoreRiconoscimento + "\"";
                    }
                    ricercaEsatta = false;
                } else {
                    searchToken = new CredenzialeSearchToken(tcm);
                    searchByRefCredentials = TipoCredenzialeMittente.PDND_ORGANIZATION_NAME.equals((Object)tcm);
                }
                pagExpr = searchToken.createExpression(credenzialeMittentiService, (String)valoreRiconoscimento, ricercaEsatta, caseSensitive);
            }
            findAll = credenzialeMittentiService.findAll(pagExpr);
            if (searchByRefCredentials) {
                findAll = CredenzialiMittenteUtils.translateByRef(findAll, (ICredenzialeMittenteService)credenzialeMittentiService);
            }
            if (ricercaIdentificatoAutenticatoSsl && ricercaEsatta && findAll != null && !findAll.isEmpty()) {
                findAll = CredenzialeSearchTrasporto.filterList(findAll, (String)valoreRiconoscimento, (Logger)this.log);
            }
        }
        catch (ExpressionException | ExpressionNotImplementedException | NotImplementedException | ServiceException | UtilsException e) {
            this.log.error(e.getMessage(), e);
        }
        return findAll;
    }

    private void addListaCredenzialiMittente(IExpression filter, List<CredenzialeMittente> listaCredenzialiMittente, TransazioneModel model) throws ExpressionNotImplementedException, ExpressionException, NotFoundException {
        if (listaCredenzialiMittente.size() == 0) {
            filter.and().equals(model.ID_TRANSAZIONE, (Object)"-1");
        } else {
            CredenzialeMittente credenzialeMittente = listaCredenzialiMittente.get(0);
            IField fieldCredenziale = this.getCredenzialeField(credenzialeMittente, model);
            if (listaCredenzialiMittente.size() == 1) {
                filter.and().equals(fieldCredenziale, (Object)credenzialeMittente.getId().toString());
            } else {
                ArrayList<String> ids = new ArrayList<String>();
                for (CredenzialeMittente cMittente : listaCredenzialiMittente) {
                    ids.add(cMittente.getId().toString());
                }
                filter.and().in(fieldCredenziale, ids);
            }
        }
    }

    @Override
    public Long getContentLengthMessaggio(String idTransazione, String saErogatore, Date dataConsegnaErogatore, org.openspcoop2.core.transazioni.constants.TipoMessaggio tipoMessaggio) {
        try {
            this.log.info("getContentLengthMessaggio [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ dataAccettazione: " + tipoMessaggio.toString() + "]");
            IExpression expr = this.dumpMessaggioSearchDAO.newExpression();
            expr.equals(DumpMessaggio.model().TIPO_MESSAGGIO, (Object)org.openspcoop2.core.transazioni.constants.TipoMessaggio.toEnumConstant((String)tipoMessaggio.toString()));
            expr.and().equals(DumpMessaggio.model().ID_TRANSAZIONE, (Object)idTransazione);
            if (saErogatore == null) {
                expr.isNull(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE);
            } else {
                expr.equals(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE, (Object)saErogatore);
            }
            if (dataConsegnaErogatore != null) {
                expr.equals(DumpMessaggio.model().DATA_CONSEGNA_EROGATORE, (Object)dataConsegnaErogatore);
            }
            expr.addOrder(DumpMessaggio.model().DUMP_TIMESTAMP, SortOrder.DESC);
            IPaginatedExpression pagExpr = this.dumpMessaggioSearchDAO.toPaginatedExpression(expr);
            pagExpr.offset(0).limit(1);
            List select = this.dumpMessaggioSearchDAO.select(pagExpr, DumpMessaggio.model().CONTENT_LENGTH);
            if (select == null || select.isEmpty()) {
                return null;
            }
            Object obj = select.get(0);
            if (obj instanceof Long) {
                return (Long)obj;
            }
        }
        catch (NotFoundException e) {
            this.log.debug("non sono state trovate informazioni Dump per [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ tipomessaggio: " + tipoMessaggio.toString() + "]");
            try {
                DumpMessaggio mes = this.createVirtualMessageWithSdk(idTransazione, saErogatore, dataConsegnaErogatore, tipoMessaggio);
                if (mes != null) {
                    return mes.getContentLength();
                }
            }
            catch (Exception eVirtual) {
                this.log.error("Errore durante la costruzione virtuale del messaggio (hasInfoDumpAvailable) [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ tipomessaggio: " + tipoMessaggio.toString() + "]", (Throwable)eVirtual);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public String getContentTypeMessaggio(String idTransazione, String saErogatore, Date dataConsegnaErogatore, org.openspcoop2.core.transazioni.constants.TipoMessaggio tipoMessaggio) {
        try {
            this.log.info("getContentTypeMessaggio [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ dataAccettazione: " + tipoMessaggio.toString() + "]");
            IExpression expr = this.dumpMessaggioSearchDAO.newExpression();
            expr.equals(DumpMessaggio.model().TIPO_MESSAGGIO, (Object)org.openspcoop2.core.transazioni.constants.TipoMessaggio.toEnumConstant((String)tipoMessaggio.toString()));
            expr.and().equals(DumpMessaggio.model().ID_TRANSAZIONE, (Object)idTransazione);
            if (saErogatore == null) {
                expr.isNull(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE);
            } else {
                expr.equals(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE, (Object)saErogatore);
            }
            if (dataConsegnaErogatore != null) {
                expr.equals(DumpMessaggio.model().DATA_CONSEGNA_EROGATORE, (Object)dataConsegnaErogatore);
            }
            expr.addOrder(DumpMessaggio.model().DUMP_TIMESTAMP, SortOrder.DESC);
            IPaginatedExpression pagExpr = this.dumpMessaggioSearchDAO.toPaginatedExpression(expr);
            pagExpr.offset(0).limit(1);
            List select = this.dumpMessaggioSearchDAO.select(pagExpr, DumpMessaggio.model().CONTENT_TYPE);
            if (select == null || select.isEmpty()) {
                return null;
            }
            Object obj = select.get(0);
            if (obj instanceof String) {
                return (String)obj;
            }
        }
        catch (NotFoundException e) {
            this.log.debug("non sono state trovate informazioni Dump per [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ tipomessaggio: " + tipoMessaggio.toString() + "]");
            try {
                DumpMessaggio mes = this.createVirtualMessageWithSdk(idTransazione, saErogatore, dataConsegnaErogatore, tipoMessaggio);
                if (mes != null) {
                    return mes.getContentType();
                }
            }
            catch (Exception eVirtual) {
                this.log.error("Errore durante la costruzione virtuale del messaggio (getContentTypeMessaggio) [id transazione: " + idTransazione + "],[SA Erogatore: " + saErogatore + "],[ tipomessaggio: " + tipoMessaggio.toString() + "]", (Throwable)eVirtual);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getHostnames(String gruppo, int refreshSecondsInterval) {
        Connection con = null;
        List<String> lNull = null;
        try {
            con = this.driverConfigurazioneDB.getConnection("TransazioniService.getHostnames");
            List list = DynamicClusterManager.getHostnames((Connection)con, (String)this.driverConfigurazioneDB.getTipoDB(), (String)gruppo, (int)refreshSecondsInterval);
            return list;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            List<String> list = lNull;
            return list;
        }
        finally {
            try {
                this.driverConfigurazioneDB.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<String> getClusterIdDinamici(String gruppo, int refreshSecondsInterval) {
        List<String> l = this.getHostnames(gruppo, refreshSecondsInterval);
        ArrayList<String> list = null;
        if (l != null && !l.isEmpty()) {
            list = new ArrayList<String>();
            for (String id : l) {
                list.add(DynamicClusterManager.hashClusterId((String)id));
            }
        }
        return list;
    }

    @Override
    public boolean isTimeoutEvent() {
        return this.timeoutEvent;
    }

    @Override
    public boolean isProfiloDifferenteEvent() {
        return this.profiloDifferenteEvent;
    }

    @Override
    public boolean isSoggettoDifferenteEvent() {
        return this.soggettoDifferenteEvent;
    }
}

