/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.datamodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.openspcoop2.protocol.sdk.diagnostica.DriverMsgDiagnosticiNotFoundException;
import org.openspcoop2.protocol.sdk.diagnostica.FiltroRicercaDiagnostici;
import org.openspcoop2.protocol.sdk.diagnostica.FiltroRicercaDiagnosticiConPaginazione;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticDriver;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.datamodel.BaseDataModel;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.BeanUtils;
import org.openspcoop2.web.monitor.transazioni.mbean.DiagnosticiBean;
import org.openspcoop2.web.monitor.transazioni.mbean.MsgDiagnosticoBean;
import org.slf4j.Logger;

public class DiagnosticiDM
extends BaseDataModel<Integer, MsgDiagnostico, IDiagnosticDriver> {
    private static final long serialVersionUID = 6120236437017709423L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private DiagnosticiBean diagnosticiBean;

    public DiagnosticiDM() {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            this.setDataProvider(govwayMonitorProperties.getDriverMsgDiagnostici());
        }
        catch (Exception e) {
            log.error("Inizializzazione driverDiagnostici fallita.....", (Throwable)e);
        }
    }

    public void setDiagnosticiBean(DiagnosticiBean diagnosticiBean) {
        this.diagnosticiBean = diagnosticiBean;
    }

    public int getRowCount() {
        try {
            if (this.rowCount == null) {
                FiltroRicercaDiagnostici filter = new FiltroRicercaDiagnostici();
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("id_transazione", this.diagnosticiBean.getIdTransazione());
                filter.setProperties(properties);
                filter.setCheckApplicativoIsNull(this.diagnosticiBean.getForceNomeServizioApplicativoNull());
                filter.setApplicativo(this.diagnosticiBean.getNomeServizioApplicativo());
                this.rowCount = ((IDiagnosticDriver)this.getDataProvider()).countMessaggiDiagnostici(filter);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.rowCount = 0;
        }
        return this.rowCount;
    }

    public Object getRowData() {
        try {
            if (this.currentPk == null) {
                return null;
            }
            return this.wrappedData.get(this.currentPk);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) throws IOException {
        block7: {
            try {
                if (this.detached) {
                    for (Integer key : this.wrappedKeys) {
                        this.setRowKey(key);
                        visitor.process(context, (Object)key, argument);
                    }
                    break block7;
                }
                int start = ((SequenceRange)range).getFirstRow();
                int limit = ((SequenceRange)range).getRows();
                this.wrappedKeys = new ArrayList();
                FiltroRicercaDiagnosticiConPaginazione filter = new FiltroRicercaDiagnosticiConPaginazione();
                filter.setOffset(start);
                filter.setLimit(limit);
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("id_transazione", this.diagnosticiBean.getIdTransazione());
                filter.setProperties(properties);
                filter.setCheckApplicativoIsNull(this.diagnosticiBean.getForceNomeServizioApplicativoNull());
                filter.setApplicativo(this.diagnosticiBean.getNomeServizioApplicativo());
                ArrayList msgs = null;
                try {
                    msgs = ((IDiagnosticDriver)this.getDataProvider()).getMessaggiDiagnostici(filter);
                }
                catch (DriverMsgDiagnosticiNotFoundException notFound) {
                    msgs = new ArrayList();
                    log.debug(notFound.getMessage(), (Throwable)notFound);
                }
                ArrayList metodiEsclusi = new ArrayList(0);
                for (int i = 0; i < msgs.size(); ++i) {
                    MsgDiagnostico msgDiagnostico = (MsgDiagnostico)msgs.get(i);
                    MsgDiagnosticoBean msgDiagnosticoBean = new MsgDiagnosticoBean();
                    BeanUtils.copy((Object)((Object)msgDiagnosticoBean), (Object)msgDiagnostico, metodiEsclusi);
                    Integer k = msgDiagnostico.getId().intValue();
                    this.wrappedData.put(k, msgDiagnosticoBean);
                    this.wrappedKeys.add(k);
                    visitor.process(context, (Object)k, argument);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

