/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.datamodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.openspcoop2.web.monitor.core.datamodel.BaseDataModel;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.transazioni.bean.DumpMessaggioBean;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.openspcoop2.web.monitor.transazioni.mbean.DiagnosticiBean;
import org.slf4j.Logger;

public class DumpMessaggiDM
extends BaseDataModel<Long, DumpMessaggioBean, ITransazioniService> {
    private static final long serialVersionUID = 6120236437017709423L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private DiagnosticiBean diagnosticiBean;

    public void setDiagnosticiBean(DiagnosticiBean diagnosticiBean) {
        this.diagnosticiBean = diagnosticiBean;
    }

    public int getRowCount() {
        try {
            if (this.rowCount == null) {
                this.rowCount = ((ITransazioniService)this.getDataProvider()).countDumpMessaggiGByDataConsegnaErogatore(this.diagnosticiBean.getIdTransazione(), this.diagnosticiBean.getNomeServizioApplicativo());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.rowCount = 0;
        }
        return this.rowCount;
    }

    public Object getRowData() {
        try {
            if (this.currentPk == null) {
                return null;
            }
            return this.wrappedData.get(this.currentPk);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) throws IOException {
        try {
            if (this.detached) {
                for (Long key : this.wrappedKeys) {
                    this.setRowKey(key);
                    visitor.process(context, (Object)key, argument);
                }
            } else {
                int start = ((SequenceRange)range).getFirstRow();
                int limit = ((SequenceRange)range).getRows();
                this.wrappedKeys = new ArrayList();
                List<DumpMessaggioBean> lista = ((ITransazioniService)this.getDataProvider()).listDumpMessaggiGByDataConsegnaErogatore(this.diagnosticiBean.getIdTransazione(), this.diagnosticiBean.getNomeServizioApplicativo(), start, limit);
                for (int i = 0; i < lista.size(); ++i) {
                    DumpMessaggioBean dump = lista.get(i);
                    dump.setProtocollo(this.diagnosticiBean.getProtocollo());
                    this.wrappedData.put(dump.getId(), dump);
                    this.wrappedKeys.add(dump.getId());
                    visitor.process(context, (Object)dump.getId(), argument);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

