/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.datamodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.web.monitor.core.datamodel.BaseDataModel;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.openspcoop2.web.monitor.transazioni.mbean.DettagliBean;
import org.slf4j.Logger;

public class TransazioniDuplicatiDM
extends BaseDataModel<Long, Transazione, ITransazioniService> {
    private static final long serialVersionUID = 8645779291901248165L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private DettagliBean dettagliBean;
    private Boolean isRichiesta = false;

    public void setRichiesta(Boolean isRichiesta) {
        this.isRichiesta = isRichiesta;
    }

    public void setDettagliBean(DettagliBean dettagliBean) {
        this.dettagliBean = dettagliBean;
    }

    public int getRowCount() {
        try {
            int duplicati;
            TransazioneBean dettaglio = this.dettagliBean.getDettaglio();
            String idtransazione = dettaglio.getIdTransazione();
            String idEgov = this.isRichiesta == false ? dettaglio.getIdMessaggioRisposta() : dettaglio.getIdMessaggioRichiesta();
            int n = duplicati = this.isRichiesta == false ? dettaglio.getDuplicatiRisposta() : dettaglio.getDuplicatiRichiesta();
            if (duplicati > 0) {
                return ((ITransazioniService)this.getDataProvider()).countAllDuplicati(idtransazione, idEgov, this.isRichiesta == false);
            }
            if (duplicati == -1) {
                return 1;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) throws IOException {
        try {
            if (this.detached) {
                for (Long key : this.wrappedKeys) {
                    this.setRowKey(key);
                    visitor.process(context, (Object)key, argument);
                }
            } else {
                String idEgov;
                int start = ((SequenceRange)range).getFirstRow();
                int limit = ((SequenceRange)range).getRows();
                this.wrappedKeys = new ArrayList();
                List<TransazioneBean> list = null;
                TransazioneBean dettaglio = this.dettagliBean.getDettaglio();
                int duplicati = this.isRichiesta == false ? dettaglio.getDuplicatiRisposta() : dettaglio.getDuplicatiRichiesta();
                String idtransazione = dettaglio.getIdTransazione();
                String string = idEgov = this.isRichiesta == false ? dettaglio.getIdMessaggioRisposta() : dettaglio.getIdMessaggioRichiesta();
                if (duplicati > 0) {
                    list = ((ITransazioniService)this.getDataProvider()).findAllDuplicati(idtransazione, idEgov, this.isRichiesta == false, start, limit);
                }
                if (duplicati == -1) {
                    TransazioneBean t = ((ITransazioniService)this.getDataProvider()).findTransazioneOriginale(idtransazione, idEgov, this.isRichiesta == false);
                    list = new ArrayList<TransazioneBean>();
                    list.add(t);
                }
                for (TransazioneBean r : list) {
                    this.wrappedData.put(r.getId(), r);
                    this.wrappedKeys.add(r.getId());
                    visitor.process(context, (Object)r.getId(), argument);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

