/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.mbean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaSerializer;
import org.openspcoop2.protocol.sdk.tracciamento.TracciaExtInfo;
import org.openspcoop2.utils.MapEntry;
import org.openspcoop2.utils.beans.BlackListElement;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.BeanUtils;
import org.openspcoop2.web.monitor.transazioni.mbean.EccezioneBean;
import org.openspcoop2.web.monitor.transazioni.mbean.RiscontroBean;
import org.openspcoop2.web.monitor.transazioni.mbean.TrasmissioneBean;
import org.slf4j.Logger;

public class BustaBean
extends Busta {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private transient IProtocolFactory<?> protocolFactory;
    private transient ITraduttore traduttore;
    private List<EccezioneBean> listaEccezioniBean;
    private List<RiscontroBean> listaRiscontriBean;
    private List<TrasmissioneBean> listaTrasmissioniBean;
    private ServiceBinding tipoApi;

    public BustaBean(String protocollo, ServiceBinding tipoApi) {
        super(protocollo);
        this.tipoApi = tipoApi;
    }

    public BustaBean(Busta busta, IProtocolFactory<?> protocolFactory, ServiceBinding tipoApi) {
        super(busta.getProtocollo());
        this.protocolFactory = protocolFactory;
        this.tipoApi = tipoApi;
        if (protocolFactory == null) {
            throw new RuntimeException("protocolFactory is null (verificare che sia presente il jar del protocollo " + busta.getProtocollo() + ")");
        }
        try {
            this.traduttore = this.protocolFactory.createTraduttore();
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
        ArrayList<BlackListElement> metodiEsclusi = new ArrayList<BlackListElement>(0);
        metodiEsclusi.add(new BlackListElement("setListaEccezioni", new Class[]{List.class}));
        metodiEsclusi.add(new BlackListElement("setListaRiscontri", new Class[]{List.class}));
        metodiEsclusi.add(new BlackListElement("setListaTrasmissioni", new Class[]{List.class}));
        metodiEsclusi.add(new BlackListElement("setProtocolFactory", new Class[]{IProtocolFactory.class}));
        metodiEsclusi.add(new BlackListElement("setTipoOraRegistrazioneValue", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setProfiloDiCollaborazioneValue", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setVersioneServizio", new Class[]{String.class}));
        BeanUtils.copy((Object)((Object)this), (Object)busta, metodiEsclusi);
        this.setTipoOraRegistrazione(busta.getTipoOraRegistrazione(), busta.getTipoOraRegistrazioneValue());
        this.setProfiloDiCollaborazione(busta.getProfiloDiCollaborazione(), busta.getProfiloDiCollaborazioneValue());
        this.setInoltro(busta.getInoltro(), busta.getInoltroValue());
        this.listaEccezioniBean = new ArrayList<EccezioneBean>(0);
        for (Eccezione eccezione : busta.getListaEccezioni()) {
            EccezioneBean eccezioneBean = new EccezioneBean(eccezione, protocolFactory);
            this.listaEccezioniBean.add(eccezioneBean);
        }
        this.listaRiscontriBean = new ArrayList<RiscontroBean>(0);
        for (Riscontro riscontro : busta.getListaRiscontri()) {
            RiscontroBean riscontroBean = new RiscontroBean(riscontro, protocolFactory);
            this.listaRiscontriBean.add(riscontroBean);
        }
        this.listaTrasmissioniBean = new ArrayList<TrasmissioneBean>(0);
        for (Trasmissione trasmissione : busta.getListaTrasmissioni()) {
            TrasmissioneBean trasmissioneBean = new TrasmissioneBean(trasmissione, protocolFactory);
            this.listaTrasmissioniBean.add(trasmissioneBean);
        }
    }

    public String getTipoOraRegistrazioneValue() {
        if (super.getTipoOraRegistrazioneValue() != null) {
            return super.getTipoOraRegistrazioneValue();
        }
        if (this.traduttore != null && this.getTipoOraRegistrazione() != null) {
            return this.traduttore.toString(this.getTipoOraRegistrazione());
        }
        return null;
    }

    public String getTipoOraRegistrazioneRicavato() {
        if (super.getTipoOraRegistrazioneValue() != null) {
            return super.getTipoOraRegistrazioneValue();
        }
        if (this.getTipoOraRegistrazione() != null) {
            return this.getTipoOraRegistrazione().getEngineValue();
        }
        return null;
    }

    public String getInoltroRicavato() {
        if (super.getInoltroValue() != null) {
            return super.getInoltroValue();
        }
        if (this.getInoltro() != null) {
            return this.getInoltro().getEngineValue();
        }
        return null;
    }

    public String getProfiloDiCollaborazioneRicavato() {
        if (super.getProfiloDiCollaborazioneValue() != null) {
            return super.getProfiloDiCollaborazioneValue();
        }
        if (this.getProfiloDiCollaborazione() != null) {
            return this.getProfiloDiCollaborazione().getEngineValue();
        }
        return null;
    }

    public String getProfiloDiCollaborazioneValue() {
        if (super.getProfiloDiCollaborazioneValue() != null) {
            return super.getProfiloDiCollaborazioneValue();
        }
        if (this.traduttore != null && this.getProfiloDiCollaborazione() != null) {
            return this.traduttore.toString(this.getProfiloDiCollaborazione());
        }
        return null;
    }

    public List<EccezioneBean> getListaEccezioniBean() {
        return this.listaEccezioniBean;
    }

    public List<RiscontroBean> getListaRiscontriBean() {
        return this.listaRiscontriBean;
    }

    public List<TrasmissioneBean> getListaTrasmissioniBean() {
        return this.listaTrasmissioniBean;
    }

    public Map<String, Map<String, String>> getExtInfoProperties() {
        HashMap<String, Map<String, String>> map;
        block9: {
            map = new HashMap<String, Map<String, String>>();
            try {
                ITracciaSerializer tracciaSerializer = this.protocolFactory.createTracciaSerializer();
                if (tracciaSerializer.isSupportedExtInfo()) {
                    List extInfoList = tracciaSerializer.extractExtInfo((Busta)this, this.tipoApi);
                    if (extInfoList == null || extInfoList.isEmpty()) {
                        Map<String, String> mapDefault = this.getProperties();
                        if (mapDefault != null && !mapDefault.isEmpty()) {
                            map.put("", mapDefault);
                        }
                    } else {
                        for (TracciaExtInfo tracciaExtInfo : extInfoList) {
                            map.put(tracciaExtInfo.getLabel() != null ? tracciaExtInfo.getLabel() : "", tracciaExtInfo.getProprietaAsMap());
                        }
                    }
                } else {
                    Map<String, String> mapDefault = this.getProperties();
                    if (mapDefault != null && !mapDefault.isEmpty()) {
                        map.put("", mapDefault);
                    }
                }
            }
            catch (Exception e) {
                log.error("Conversione extInfo properties fallita: " + e.getMessage(), (Throwable)e);
                Map<String, String> mapDefault = this.getProperties();
                if (mapDefault == null || mapDefault.isEmpty()) break block9;
                map.put("", mapDefault);
            }
        }
        return map;
    }

    public List<Map.Entry<String, List<Map.Entry<String, String>>>> getExtInfoPropertiesAsList() {
        ArrayList<Map.Entry<String, List<Map.Entry<String, String>>>> toRet = new ArrayList<Map.Entry<String, List<Map.Entry<String, String>>>>();
        try {
            ITracciaSerializer tracciaSerializer = this.protocolFactory.createTracciaSerializer();
            if (tracciaSerializer.isSupportedExtInfo()) {
                List extInfoList = tracciaSerializer.extractExtInfo((Busta)this, this.tipoApi);
                if (extInfoList == null || extInfoList.isEmpty()) {
                    Map.Entry<String, List<Map.Entry<String, String>>> entry = this.getMapEntryExtInfoDefault();
                    toRet.add(entry);
                } else {
                    for (TracciaExtInfo tracciaExtInfo : extInfoList) {
                        MapEntry entry = new MapEntry((Object)(tracciaExtInfo.getLabel() != null ? tracciaExtInfo.getLabel() : ""), (Object)tracciaExtInfo.getProprietaAsMapEntry());
                        toRet.add((Map.Entry<String, List<Map.Entry<String, String>>>)entry);
                    }
                }
            } else {
                Map.Entry<String, List<Map.Entry<String, String>>> entry = this.getMapEntryExtInfoDefault();
                toRet.add(entry);
            }
        }
        catch (Exception e) {
            log.error("Conversione extInfo properties fallita: " + e.getMessage(), (Throwable)e);
            Map.Entry<String, List<Map.Entry<String, String>>> entry = this.getMapEntryExtInfoDefault();
            toRet.add(entry);
        }
        return toRet;
    }

    private Map.Entry<String, List<Map.Entry<String, String>>> getMapEntryExtInfoDefault() {
        ArrayList<MapEntry> internalEntry = new ArrayList<MapEntry>();
        Map<String, String> internalMap = this.getProperties();
        ArrayList<String> listKeys = new ArrayList<String>();
        for (String internalKey : internalMap.keySet()) {
            listKeys.add(internalKey);
        }
        Collections.sort(listKeys);
        for (String internalKey : listKeys) {
            MapEntry entry = new MapEntry((Object)internalKey, (Object)internalMap.get(internalKey));
            internalEntry.add(entry);
        }
        MapEntry entry = new MapEntry((Object)"", internalEntry);
        return entry;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> listKeys = new ArrayList<String>();
        String[] propertiesNames = super.getPropertiesNames();
        if (propertiesNames != null) {
            for (int i = 0; i < propertiesNames.length; ++i) {
                listKeys.add(propertiesNames[i]);
            }
        }
        Collections.sort(listKeys);
        for (String key : listKeys) {
            String value = super.getProperty(key);
            if (key == null || value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public List<Map.Entry<String, String>> getPropertiesAsList() {
        ArrayList<Map.Entry<String, String>> toRet = new ArrayList<Map.Entry<String, String>>();
        if (super.sizeProperties() > 0) {
            ArrayList<String> keys = new ArrayList<String>();
            String[] pNames = super.getPropertiesNames();
            if (pNames != null && pNames.length > 0) {
                for (int i = 0; i < pNames.length; ++i) {
                    keys.add(pNames[i]);
                }
            }
            Collections.sort(keys);
            for (String key : keys) {
                MapEntry entry = new MapEntry((Object)key, (Object)super.getProperty(key));
                toRet.add((Map.Entry<String, String>)entry);
            }
        }
        return toRet;
    }
}

