/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.mbean;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaSerializer;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.dao.IService;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.mbean.PdDBaseBean;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.core.utils.MimeTypeUtils;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneApplicativoServerBean;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniApplicativoServerService;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.openspcoop2.web.monitor.transazioni.exporter.SingleFileExporter;
import org.openspcoop2.web.monitor.transazioni.mbean.DettagliBean;
import org.openspcoop2.web.monitor.transazioni.mbean.DiagnosticiBean;
import org.slf4j.Logger;

public class DettagliTransazioneApplicativoServerBean
extends PdDBaseBean<TransazioneApplicativoServerBean, Long, IService<TransazioneApplicativoServerBean, Long>> {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private String idTransazione;
    private String idEgov;
    private String identificativoPorta;
    private boolean isRisposta;
    private String servizioApplicativoErogatore;
    private TransazioneApplicativoServerBean dettaglio;
    private transient ITransazioniApplicativoServerService transazioniSAService;
    private transient ITransazioniService transazioniService;
    private boolean visualizzaIdCluster = false;
    private DiagnosticiBean diagnosticiBean;
    private String selectedTab = null;
    private String protocollo = null;
    private Date dataUltimaConsegna = null;
    private static Boolean enableHeaderInfo = null;
    private static boolean headersAsProperties = true;
    private static boolean contenutiAsProperties = false;
    private transient IProtocolFactory<?> protocolFactory;
    private boolean showFault = false;
    private boolean showFaultUltimoErrore = false;
    private boolean visualizzaDataAccettazione = false;
    private Boolean hasDumpBinarioUltimaConsegnaRichiestaUscita = null;
    private Boolean hasDumpBinarioUltimaConsegnaRispostaIngresso = null;
    private Boolean hasDumpUltimaConsegnaRichiestaUscita = null;
    private Boolean hasDumpUltimaConsegnaRispostaIngresso = null;
    private Boolean hasHeaderTrasportoUltimaConsegnaRichiestaUscita = null;
    private Boolean hasHeaderTrasportoUltimaConsegnaRispostaIngresso = null;
    private Boolean hasHeaderTrasportoBinarioUltimaConsegnaRichiestaUscita = null;
    private Boolean hasHeaderTrasportoBinarioUltimaConsegnaRispostaIngresso = null;
    private Boolean hasDumpBinarioMultipartUltimaConsegnaRichiestaUscita = null;
    private Boolean hasDumpBinarioMultipartUltimaConsegnaRispostaIngresso = null;
    private Date dataConsegnaErogatore = null;
    private Date ultimaConsegna = null;
    private TipoMessaggio exportContenuto;
    private Integer multipartThreshold = null;
    private Boolean exportContenutiMultipart;

    public String getExportContenuto() {
        if (this.exportContenuto == null) {
            return null;
        }
        return this.exportContenuto.toString();
    }

    public void setExportContenuto(String exportContenuto) {
        if (exportContenuto != null) {
            this.exportContenuto = (TipoMessaggio)TipoMessaggio.toEnumConstantFromString((String)exportContenuto);
        }
    }

    public DettagliTransazioneApplicativoServerBean() {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            List govwayMonitorare = govwayMonitorProperties.getListaPdDMonitorate_StatusPdD();
            this.setVisualizzaIdCluster(govwayMonitorare != null && govwayMonitorare.size() > 1);
            this.visualizzaDataAccettazione = govwayMonitorProperties.isAttivoTransazioniDataAccettazione();
            this.multipartThreshold = govwayMonitorProperties.getTransazioniDettaglioAnalisiMultipartThreshold();
        }
        catch (Exception e) {
            log.warn("Inizializzazione driverTracciamento fallita.....", (Throwable)e);
        }
    }

    public void setTransazioniService(ITransazioniService transazioniService) {
        this.transazioniService = transazioniService;
    }

    public void setTransazioniApplicativoServerService(ITransazioniApplicativoServerService transazioniService) {
        this.transazioniSAService = transazioniService;
    }

    public Boolean getHasDumpUltimaConsegnaRichiestaUscita() {
        if (this.hasDumpUltimaConsegnaRichiestaUscita == null) {
            this.hasDumpUltimaConsegnaRichiestaUscita = this.getHasDump(TipoMessaggio.RICHIESTA_USCITA);
        }
        return this.hasDumpUltimaConsegnaRichiestaUscita;
    }

    public Boolean getHasDumpUltimaConsegnaRispostaIngresso() {
        if (this.hasDumpUltimaConsegnaRispostaIngresso == null) {
            this.hasDumpUltimaConsegnaRispostaIngresso = this.getHasDump(TipoMessaggio.RISPOSTA_INGRESSO);
        }
        return this.hasDumpUltimaConsegnaRispostaIngresso;
    }

    public boolean getHasDumpBinarioUltimaConsegnaRichiestaUscita() {
        if (this.hasDumpBinarioUltimaConsegnaRichiestaUscita == null) {
            this.hasDumpBinarioUltimaConsegnaRichiestaUscita = this.getHasDump(TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO);
        }
        return this.hasDumpBinarioUltimaConsegnaRichiestaUscita;
    }

    public boolean getHasDumpBinarioUltimaConsegnaRispostaIngresso() {
        if (this.hasDumpBinarioUltimaConsegnaRispostaIngresso == null) {
            this.hasDumpBinarioUltimaConsegnaRispostaIngresso = this.getHasDump(TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO);
        }
        return this.hasDumpBinarioUltimaConsegnaRispostaIngresso;
    }

    public Boolean getHasHeaderTrasportoUltimaConsegnaRichiestaUscita() {
        if (this.hasHeaderTrasportoUltimaConsegnaRichiestaUscita == null) {
            this.hasHeaderTrasportoUltimaConsegnaRichiestaUscita = this.getHasHeaderTrasporto(TipoMessaggio.RICHIESTA_USCITA);
        }
        return this.hasHeaderTrasportoUltimaConsegnaRichiestaUscita;
    }

    public Boolean getHasHeaderTrasportoUltimaConsegnaRispostaIngresso() {
        if (this.hasHeaderTrasportoUltimaConsegnaRispostaIngresso == null) {
            this.hasHeaderTrasportoUltimaConsegnaRispostaIngresso = this.getHasHeaderTrasporto(TipoMessaggio.RISPOSTA_INGRESSO);
        }
        return this.hasHeaderTrasportoUltimaConsegnaRispostaIngresso;
    }

    public boolean getHasHeaderTrasportoBinarioUltimaConsegnaRichiestaUscita() {
        if (this.hasHeaderTrasportoBinarioUltimaConsegnaRichiestaUscita == null) {
            this.hasHeaderTrasportoBinarioUltimaConsegnaRichiestaUscita = this.getHasHeaderTrasporto(TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO);
        }
        return this.hasHeaderTrasportoBinarioUltimaConsegnaRichiestaUscita;
    }

    public boolean getHasHeaderTrasportoBinarioUltimaConsegnaRispostaIngresso() {
        if (this.hasHeaderTrasportoBinarioUltimaConsegnaRispostaIngresso == null) {
            this.hasHeaderTrasportoBinarioUltimaConsegnaRispostaIngresso = this.getHasHeaderTrasporto(TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO);
        }
        return this.hasHeaderTrasportoBinarioUltimaConsegnaRispostaIngresso;
    }

    public Boolean getHasDumpBinarioMultipartUltimaConsegnaRichiestaUscita() {
        if (this.hasDumpBinarioMultipartUltimaConsegnaRichiestaUscita == null) {
            String contentType = this.getContentType(TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO);
            Long contentLength = this.getContentLength(TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO);
            this.hasDumpBinarioMultipartUltimaConsegnaRichiestaUscita = DettagliBean.isVisualizzaContenutiMultipartButton(TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO, contentType, contentLength, this.multipartThreshold, log);
        }
        return this.hasDumpBinarioMultipartUltimaConsegnaRichiestaUscita;
    }

    public Boolean getHasDumpBinarioMultipartUltimaConsegnaRispostaIngresso() {
        if (this.hasDumpBinarioMultipartUltimaConsegnaRispostaIngresso == null) {
            String contentType = this.getContentType(TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO);
            Long contentLength = this.getContentLength(TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO);
            this.hasDumpBinarioMultipartUltimaConsegnaRispostaIngresso = DettagliBean.isVisualizzaContenutiMultipartButton(TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO, contentType, contentLength, this.multipartThreshold, log);
        }
        return this.hasDumpBinarioMultipartUltimaConsegnaRispostaIngresso;
    }

    private boolean getHasDump(TipoMessaggio tipo) {
        if (this.dettaglio.getNumeroTentativi() > 1) {
            return this.transazioniService.hasInfoDumpAvailable(this.idTransazione, this.dettaglio.getNomeServizioApplicativoErogatore(), this.getDataUltimaConsegna(), tipo);
        }
        return this.transazioniService.hasInfoDumpAvailable(this.idTransazione, this.dettaglio.getNomeServizioApplicativoErogatore(), null, tipo);
    }

    private boolean getHasHeaderTrasporto(TipoMessaggio tipo) {
        if (this.dettaglio.getNumeroTentativi() > 1) {
            return this.transazioniService.hasInfoHeaderTrasportoAvailable(this.idTransazione, this.dettaglio.getNomeServizioApplicativoErogatore(), this.getDataUltimaConsegna(), tipo);
        }
        return this.transazioniService.hasInfoHeaderTrasportoAvailable(this.idTransazione, this.dettaglio.getNomeServizioApplicativoErogatore(), null, tipo);
    }

    private String getContentType(TipoMessaggio tipo) {
        if (this.dettaglio.getNumeroTentativi() > 1) {
            return this.transazioniService.getContentTypeMessaggio(this.idTransazione, this.dettaglio.getNomeServizioApplicativoErogatore(), this.getDataUltimaConsegna(), tipo);
        }
        return this.transazioniService.getContentTypeMessaggio(this.idTransazione, this.dettaglio.getNomeServizioApplicativoErogatore(), null, tipo);
    }

    private Long getContentLength(TipoMessaggio tipo) {
        if (this.dettaglio.getNumeroTentativi() > 1) {
            return this.transazioniService.getContentLengthMessaggio(this.idTransazione, this.dettaglio.getNomeServizioApplicativoErogatore(), this.getDataUltimaConsegna(), tipo);
        }
        return this.transazioniService.getContentLengthMessaggio(this.idTransazione, this.dettaglio.getNomeServizioApplicativoErogatore(), null, tipo);
    }

    public static boolean isVisualizzaContenutiMultipartButton(TipoMessaggio tipoMessaggio, String contentType, Long contentLength, Integer multipartThreshold, Logger log) {
        switch (tipoMessaggio) {
            case RICHIESTA_INGRESSO_DUMP_BINARIO: 
            case RICHIESTA_USCITA_DUMP_BINARIO: 
            case RISPOSTA_INGRESSO_DUMP_BINARIO: 
            case RISPOSTA_USCITA_DUMP_BINARIO: {
                try {
                    if (ContentTypeUtilities.isMultipartContentType((String)contentType)) {
                        return contentLength.intValue() < multipartThreshold;
                    }
                }
                catch (UtilsException e) {
                    log.error("Errore nel check multipart: " + e.getMessage(), (Throwable)e);
                }
                break;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public Date getDataUltimaConsegna() {
        if (this.dataUltimaConsegna == null) {
            this.dataUltimaConsegna = this.transazioniService.getDataConsegnaErogatore(this.idTransazione, this.dettaglio.getNomeServizioApplicativoErogatore(), this.dettaglio.getDataAccettazioneRichiesta());
        }
        return this.dataUltimaConsegna;
    }

    public void setDataUltimaConsegna(Date dataUltimaConsegna) {
        this.dataUltimaConsegna = dataUltimaConsegna;
    }

    public String saveDiagnostici() {
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            HttpSession sessione = (HttpSession)context.getExternalContext().getSession(false);
            sessione.setAttribute("idTransazioniOriginali", (Object)this.dettaglio.getIdTransazione());
            sessione.setAttribute("isAllOriginale", (Object)false);
            response.sendRedirect(context.getExternalContext().getRequestContextPath() + "/diagnosticiexporter?isAll=false&ids=" + this.dettaglio.getIdTransazione());
            context.responseComplete();
        }
        catch (Exception e) {
            FacesContext.getCurrentInstance().responseComplete();
            log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'esportazione dei diagnostici.");
        }
        return null;
    }

    public String saveTracce() {
        try {
            String newLine;
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("id_transazione", this.dettaglio.getIdTransazione());
            Object tracciaRichiesta = null;
            Object tracciaRisposta = null;
            ArrayList tracce = new ArrayList();
            if (tracce.size() == 0) {
                MessageUtils.addWarnMsg((String)"Nessuna traccia trovata.");
                return null;
            }
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            String fileName = null;
            fileName = this.isRisposta ? "TracciaRisposta.zip" : "TracciaRichiesta.zip";
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
            response.setStatus(200);
            response.flushBuffer();
            byte[] buf = new byte[1024];
            ZipOutputStream zip = new ZipOutputStream((OutputStream)response.getOutputStream());
            InputStream in = null;
            ArrayList<String> errori = new ArrayList<String>(0);
            if (tracce.size() > 0) {
                zip.putNextEntry(new ZipEntry(this.dettaglio.getIdTransazione() + " (" + tracce.size() + " entries).xml"));
                if (enableHeaderInfo.booleanValue()) {
                    // empty if block
                }
                for (int j = 0; j < tracce.size(); ++j) {
                    Traccia tr = (Traccia)tracce.get(j);
                    newLine = j > 0 ? "\n\n" : "";
                    IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tr.getProtocollo());
                    ITracciaSerializer tracciaBuilder = pf.createTracciaSerializer();
                    try {
                        int len;
                        tracciaBuilder.setOmitXmlDeclaration(true);
                        String traccia = tracciaBuilder.toString(tr, TipoSerializzazione.DEFAULT);
                        in = new ByteArrayInputStream((newLine + traccia).getBytes());
                        while ((len = in.read(buf)) > 0) {
                            zip.write(buf, 0, len);
                        }
                        continue;
                    }
                    catch (ProtocolException e) {
                        String idTransazione = this.dettaglio.getIdTransazione();
                        String tipoTraccia = tr.getTipoMessaggio().getTipo();
                        String bustaAsString = tr.getBustaAsString();
                        String messaggioErrore = e.getMessage();
                        StringBuilder sb = new StringBuilder(0);
                        sb.append("ID Transazione: ").append(idTransazione).append("\n");
                        sb.append("Tipo Traccia: ").append(tipoTraccia).append("\n");
                        sb.append("Busta: \n").append(bustaAsString).append("\n\n");
                        sb.append("Errore: \n").append(messaggioErrore).append("\n");
                        errori.add(sb.toString());
                    }
                }
                zip.closeEntry();
                zip.flush();
                if (in != null) {
                    in.close();
                }
            }
            if (errori.size() > 0) {
                zip.putNextEntry(new ZipEntry(this.dettaglio.getIdTransazione() + " (" + errori.size() + " entries).xml.error"));
                for (int i = 0; i < errori.size(); ++i) {
                    int len;
                    String errore = (String)errori.get(i);
                    newLine = i > 0 ? "\n\n" : "";
                    in = new ByteArrayInputStream((newLine + errore).getBytes());
                    while ((len = in.read(buf)) > 0) {
                        zip.write(buf, 0, len);
                    }
                }
                zip.closeEntry();
                zip.flush();
                if (in != null) {
                    in.close();
                }
            }
            zip.flush();
            zip.close();
            context.responseComplete();
        }
        catch (Exception e) {
            FacesContext.getCurrentInstance().responseComplete();
            log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'esportazione delle tracce.");
        }
        return null;
    }

    public void showOriginaleSelected(ActionEvent ae) {
        this.dettaglio = null;
    }

    public void showDuplicatoSelected(ActionEvent ae) {
        this.dettaglio = null;
    }

    public TransazioneApplicativoServerBean getDettaglio() {
        if (this.dettaglio != null) {
            return this.dettaglio;
        }
        try {
            this.transazioniSAService.setIdTransazione(this.idTransazione);
            this.transazioniSAService.setProtocollo(this.protocollo);
            this.dettaglio = this.transazioniSAService.findByServizioApplicativoErogatore(this.servizioApplicativoErogatore);
            if (this.dettaglio != null && this.protocolFactory == null) {
                try {
                    this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(this.getProtocollo());
                }
                catch (ProtocolException e) {
                    log.error("Errore durante la creazione della Factory", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.dettaglio;
    }

    public String getNomeConnettore() {
        TransazioneApplicativoServerBean dettaglio = this.getDettaglio();
        if (dettaglio != null && dettaglio.getConnettoreNome() != null && StringUtils.isNotEmpty((String)dettaglio.getConnettoreNome())) {
            return dettaglio.getConnettoreNome();
        }
        return "";
    }

    public void visualizzaRichiestaListener(ActionEvent ae) {
        this.dettaglio = null;
    }

    public void visualizzaRispostaListener(ActionEvent ae) {
        this.dettaglio = null;
    }

    public String getIdEgov() {
        return this.idEgov;
    }

    public void setIdEgov(String idEgov) {
        this.idEgov = idEgov;
    }

    public boolean getIsRisposta() {
        return this.isRisposta;
    }

    public void setIsRisposta(boolean isRisposta) {
        this.isRisposta = isRisposta;
    }

    public String getIdentificativoPorta() {
        return this.identificativoPorta;
    }

    public void setIdentificativoPorta(String identificativoPorta) {
        this.identificativoPorta = identificativoPorta;
    }

    public String getIdTransazione() {
        return this.idTransazione;
    }

    public void setIdTransazione(String idTransazione) {
        this.idTransazione = idTransazione;
    }

    public boolean getShowFault() {
        return this.showFault;
    }

    public void setShowFault(boolean showFault) {
        this.showFault = showFault;
        this.showFaultUltimoErrore = false;
    }

    public boolean getShowFaultUltimoErrore() {
        return this.showFaultUltimoErrore;
    }

    public void setShowFaultUltimoErrore(boolean showFaultUltimoErrore) {
        this.showFaultUltimoErrore = showFaultUltimoErrore;
        this.showFault = false;
    }

    public void setDettaglio(TransazioneApplicativoServerBean dettaglio) {
        this.dettaglio = dettaglio;
        if (this.dettaglio != null && this.protocolFactory == null) {
            try {
                this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(this.dettaglio.getProtocollo());
            }
            catch (ProtocolException e) {
                log.error("Errore durante la creazione della Factory", (Throwable)e);
            }
        }
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    public boolean isVisualizzaDataAccettazione() {
        return this.visualizzaDataAccettazione;
    }

    public void setVisualizzaDataAccettazione(boolean visualizzaDataAccettazione) {
        this.visualizzaDataAccettazione = visualizzaDataAccettazione;
    }

    public String downloadTokenInfo() {
        log.debug("downloading TokenInfo: " + this.dettaglio.getId());
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            int read = 0;
            byte[] bytes = new byte[1024];
            String contentType = "application/json";
            response.setContentType(contentType);
            Object fileName = "tokenInfo";
            String ext = MimeTypeUtils.fileExtensionForMIMEType((String)contentType);
            fileName = (String)fileName + "." + ext;
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName, (String)contentType);
            ByteArrayInputStream bis = null;
            ServletOutputStream os = null;
            String toRet = "";
            JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
            byte[] contenutoBody = toRet.getBytes();
            bis = new ByteArrayInputStream(contenutoBody);
            os = response.getOutputStream();
            while ((read = bis.read(bytes)) != -1) {
                os.write(bytes, 0, read);
            }
            os.flush();
            os.close();
            FacesContext.getCurrentInstance().responseComplete();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante il download del token info");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportContenuti() {
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            String dirPath = null;
            Object fileName = this.exportContenuto.name().toLowerCase();
            fileName = (String)fileName + ".zip";
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
            response.setStatus(200);
            response.flushBuffer();
            ZipOutputStream zip = new ZipOutputStream((OutputStream)response.getOutputStream());
            Date dataConsegna = null;
            dataConsegna = this.ultimaConsegna == null ? this.dataConsegnaErogatore : this.ultimaConsegna;
            if (this.exportContenutiMultipart != null && this.exportContenutiMultipart.booleanValue()) {
                try {
                    SingleFileExporter.exportContenutiMultipart(log, this.dettaglio, dataConsegna, zip, dirPath, this.transazioniService, this.exportContenuto, headersAsProperties, contenutiAsProperties);
                }
                finally {
                    this.exportContenutiMultipart = null;
                }
            } else {
                SingleFileExporter.exportContenuti(log, this.dettaglio, dataConsegna, zip, dirPath, this.transazioniService, this.exportContenuto, headersAsProperties, contenutiAsProperties);
            }
            zip.flush();
            zip.close();
            context.responseComplete();
        }
        catch (Exception e) {
            FacesContext.getCurrentInstance().responseComplete();
            log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'esportazione dei contenuti.");
        }
        return null;
    }

    public String getSelectedTab() {
        return this.selectedTab;
    }

    public void setSelectedTab(String selectedTab) {
        this.selectedTab = selectedTab;
    }

    public DiagnosticiBean getDiagnosticiBean() {
        this.diagnosticiBean = new DiagnosticiBean();
        this.diagnosticiBean.setIdEgov(this.idEgov);
        this.diagnosticiBean.setIdentificativoPorta(this.identificativoPorta);
        this.diagnosticiBean.setIdTransazione(this.idTransazione);
        if (this.dettaglio != null) {
            this.diagnosticiBean.setProtocollo(this.dettaglio.getProtocollo());
            this.diagnosticiBean.setNomeServizioApplicativo(this.dettaglio.getNomeServizioApplicativoErogatore());
        }
        this.diagnosticiBean.setForceNomeServizioApplicativoNull(null);
        return this.diagnosticiBean;
    }

    public void setDiagnosticiBean(DiagnosticiBean diagnosticiBean) {
        this.diagnosticiBean = diagnosticiBean;
    }

    public String getProtocollo() {
        return this.protocollo;
    }

    public void setProtocollo(String protocollo) {
        this.protocollo = protocollo;
    }

    public boolean isVisualizzaIdCluster() {
        return this.visualizzaIdCluster;
    }

    public void setVisualizzaIdCluster(boolean visualizzaIdCluster) {
        this.visualizzaIdCluster = visualizzaIdCluster;
    }

    public boolean isVisualizzaTextAreaLocationConnettore() {
        return StringUtils.isNotEmpty((String)this.dettaglio.getLocationConnettore()) && this.dettaglio.getLocationConnettore().length() > 150;
    }

    public void setVisualizzaTextAreaLocationConnettore(boolean visualizzaTextAreaLocationConnettore) {
    }

    public boolean isVisualizzaTextAreaLocationUltimoErrore() {
        return StringUtils.isNotEmpty((String)this.dettaglio.getLocationUltimoErrore()) && this.dettaglio.getLocationUltimoErrore().length() > 150;
    }

    public String getServizioApplicativoErogatore() {
        return this.servizioApplicativoErogatore;
    }

    public void setServizioApplicativoErogatore(String servizioApplicativoErogatore) {
        this.servizioApplicativoErogatore = servizioApplicativoErogatore;
    }

    public boolean isVisualizzaTextAreaUltimoErrore() {
        return StringUtils.isNotEmpty((String)this.dettaglio.getUltimoErrore()) && this.dettaglio.getUltimoErrore().length() > 150;
    }

    public boolean isVisualizzaUltimoErrore() {
        return this.dettaglio.getUltimoErrore() != null && this.dettaglio.getDataUltimoErrore().equals(this.dettaglio.getDataUltimaConsegna());
    }

    public boolean isVisualizzaTabUltimaConsegnaErrore() {
        return this.dettaglio.isConsegnaTrasparente() && this.dettaglio.getNumeroTentativi() > 1 && this.dettaglio.getUltimoErrore() != null && !this.dettaglio.getDataUltimoErrore().equals(this.dettaglio.getDataUscitaRichiesta()) && !this.dettaglio.getDataUltimoErrore().equals(this.dettaglio.getDataAccettazioneRichiesta());
    }

    public Date getDataConsegnaErogatore() {
        return this.dataConsegnaErogatore;
    }

    public void setDataConsegnaErogatore(Date dataConsegnaErogatore) {
        this.dataConsegnaErogatore = dataConsegnaErogatore;
    }

    public Date getUltimaConsegna() {
        return this.ultimaConsegna;
    }

    public void setUltimaConsegna(Date ultimaConsegna) {
        this.ultimaConsegna = ultimaConsegna;
    }

    public Boolean getExportContenutiMultipart() {
        return this.exportContenutiMultipart;
    }

    public void setExportContenutiMultipart(Boolean exportContenutiMultipart) {
        this.exportContenutiMultipart = exportContenutiMultipart;
    }

    public void initExportListener(ActionEvent ae) {
        this.exportContenutiMultipart = null;
    }

    static {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            enableHeaderInfo = govwayMonitorProperties.isAttivoTransazioniExportHeader();
            headersAsProperties = govwayMonitorProperties.isAttivoTransazioniExportHeaderAsProperties();
            contenutiAsProperties = govwayMonitorProperties.isAttivoTransazioniExportContenutiAsProperties();
        }
        catch (Exception e) {
            log.warn("Inizializzazione servlet fallita, setto enableHeaderInfo=false", (Throwable)e);
        }
    }
}

