/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.XMLRootElement;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.diagnostica.FiltroRicercaDiagnosticiConPaginazione;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticDriver;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticSerializer;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.core.UtilityTransazioni;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DiagnosticiExporter
extends HttpServlet {
    private static final long serialVersionUID = 1272767433184676700L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static IDiagnosticDriver diagnosticiService = null;
    private static Boolean enableHeaderInfo = false;

    public static void setDiagnosticiService(IDiagnosticDriver diagnosticiService) {
        DiagnosticiExporter.diagnosticiService = diagnosticiService;
    }

    public static void setEnableHeaderInfo(Boolean enableHeaderInfo) {
        DiagnosticiExporter.enableHeaderInfo = enableHeaderInfo;
    }

    public void init() throws ServletException {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            DiagnosticiExporter.setEnableHeaderInfo(govwayMonitorProperties.isAttivoTransazioniExportHeader());
            DiagnosticiExporter.setDiagnosticiService(govwayMonitorProperties.getDriverMsgDiagnostici());
        }
        catch (Exception e) {
            log.error("Inizializzazione servlet fallita, setto enableHeaderInfo=false", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
            if (context == null) {
                throw new CoreException("Context is null");
            }
            ITransazioniService service = (ITransazioniService)context.getBean("transazioniService");
            HttpServletResponse response = resp;
            String isAllString = req.getParameter("isAll");
            Boolean isAll = Boolean.parseBoolean(isAllString);
            String idtransazioni = req.getParameter("ids");
            String[] ids = StringUtils.split((String)idtransazioni, (String)",");
            HttpSession sessione = req.getSession();
            Boolean isAllFromSession = (Boolean)sessione.getAttribute("isAllOriginale");
            String idTransazioniFromSession = (String)sessione.getAttribute("idTransazioniOriginali");
            sessione.removeAttribute("isAllOriginale");
            sessione.removeAttribute("idTransazioniOriginali");
            String[] idsFromSession = StringUtils.split((String)idTransazioniFromSession, (String)",");
            boolean exportConsentito = DiagnosticiExporter.checkParametri(isAll, ids, isAllFromSession, idsFromSession);
            if (!exportConsentito) {
                String msgErrore = "L'utente non dispone dei permessi necessari per effettuare l'export  dei messaggi diagnostici.";
                String redirectUrl = req.getContextPath() + "/public/error.jsf?msg_errore=" + msgErrore;
                response.sendRedirect(redirectUrl);
                return;
            }
            String fileName = "Diagnostici.zip";
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
            response.setStatus(200);
            response.flushBuffer();
            byte[] buf = new byte[1024];
            ZipOutputStream zip = new ZipOutputStream((OutputStream)response.getOutputStream());
            InputStream in = null;
            int start = 0;
            int limit = 25;
            List transazioni = new ArrayList<TransazioneBean>();
            Utility.setLoginMBean((LoginBean)((LoginBean)context.getBean("loginBean")));
            if (isAll != null && isAll.booleanValue()) {
                transazioni = service.findAll(start, limit);
            } else {
                for (int j = 0; j < ids.length; ++j) {
                    transazioni.add(service.findByIdTransazione(ids[j]));
                }
            }
            while (!transazioni.isEmpty()) {
                for (TransazioneBean t : transazioni) {
                    FiltroRicercaDiagnosticiConPaginazione filter = new FiltroRicercaDiagnosticiConPaginazione();
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("id_transazione", t.getIdTransazione());
                    filter.setProperties(properties);
                    List list = diagnosticiService.getMessaggiDiagnostici(filter);
                    zip.putNextEntry(new ZipEntry(t.getIdTransazione() + " (" + list.size() + " entries).xml"));
                    if (enableHeaderInfo != null && enableHeaderInfo.booleanValue()) {
                        zip.write(UtilityTransazioni.getHeaderTransazione(t).getBytes());
                    }
                    Object tail = null;
                    for (int j = 0; j < list.size(); ++j) {
                        int len;
                        Object head;
                        XMLRootElement xmlRootElement;
                        MsgDiagnostico msg = (MsgDiagnostico)list.get(j);
                        String newLine = j > 0 ? "\n\n" : "";
                        IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(msg.getProtocollo());
                        IDiagnosticSerializer diagnosticoBuilder = pf.createDiagnosticSerializer();
                        if (j == 0 && (xmlRootElement = diagnosticoBuilder.getXMLRootElement()) != null && (head = xmlRootElement.getAsStringStartTag()) != null && !"".equals(head)) {
                            head = (String)head + "\n\n";
                            zip.write(((String)head).getBytes(), 0, ((String)head).length());
                            tail = xmlRootElement.getAsStringEndTag();
                            if (tail != null && !"".equals(tail)) {
                                tail = "\n\n" + (String)tail;
                            }
                        }
                        diagnosticoBuilder.setOmitXmlDeclaration(true);
                        String msgDiagnostico = diagnosticoBuilder.toString(msg, TipoSerializzazione.DEFAULT);
                        in = new ByteArrayInputStream((newLine + msgDiagnostico).getBytes());
                        while ((len = in.read(buf)) > 0) {
                            zip.write(buf, 0, len);
                        }
                    }
                    if (tail != null && !"".equals(tail)) {
                        zip.write(((String)tail).getBytes(), 0, ((String)tail).length());
                    }
                    zip.closeEntry();
                    zip.flush();
                    in.close();
                }
                start += limit;
                response.flushBuffer();
                if (isAll == null || !isAll.booleanValue()) break;
                transazioni = service.findAll(start, limit);
            }
            zip.flush();
            zip.close();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    public static boolean checkParametri(Boolean isAll, String[] ids, Boolean isAllFromSession, String[] idsFromSession) {
        if (isAll == null || isAllFromSession == null || isAll.booleanValue() != isAllFromSession.booleanValue()) {
            return false;
        }
        if (!(ids != null && ids.length != 0 && idsFromSession != null && idsFromSession.length != 0 || isAll.booleanValue())) {
            return false;
        }
        if (ids != null && idsFromSession != null && ids.length != idsFromSession.length) {
            return false;
        }
        if (ids != null) {
            for (String id : ids) {
                boolean found = false;
                for (String idFromSession : idsFromSession) {
                    if (!id.equals(idFromSession)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }
}

