/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.utils;

import org.apache.commons.lang.StringUtils;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.pdd.logger.info.InfoEsitoTransazioneFormatUtils;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.web.monitor.core.core.Utils;
import org.slf4j.Logger;

public class FormatoFaultUtils {
    public static String getFaultPretty(String fault, String formatoFault) {
        String toRet = null;
        if (fault != null) {
            StringBuilder contenutoDocumentoStringBuilder = new StringBuilder();
            String errore = Utils.getTestoVisualizzabile((byte[])fault.getBytes(), (StringBuilder)contenutoDocumentoStringBuilder, (boolean)true);
            if (errore != null) {
                return "";
            }
            MessageType messageType = MessageType.XML;
            if (StringUtils.isNotEmpty((String)formatoFault)) {
                messageType = MessageType.valueOf((String)formatoFault);
            }
            switch (messageType) {
                case BINARY: 
                case MIME_MULTIPART: {
                    break;
                }
                case JSON: {
                    JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
                    try {
                        toRet = jsonUtils.toString(jsonUtils.getAsNode(fault));
                    }
                    catch (UtilsException utilsException) {}
                    break;
                }
                default: {
                    toRet = Utils.prettifyXml((String)fault);
                }
            }
        }
        if (toRet == null) {
            toRet = fault != null ? fault : "";
        }
        return toRet;
    }

    public static boolean isVisualizzaFault(String fault) {
        Logger log = LoggerWrapperFactory.getLogger(FormatoFaultUtils.class);
        return InfoEsitoTransazioneFormatUtils.isVisualizzaFault((Logger)log, (String)fault);
    }

    public static String getBrushFault(String fault, String formatoFault) {
        String toRet = null;
        if (fault != null) {
            MessageType messageType = MessageType.XML;
            if (StringUtils.isNotEmpty((String)formatoFault)) {
                messageType = MessageType.valueOf((String)formatoFault);
            }
            switch (messageType) {
                case JSON: {
                    toRet = "json";
                    break;
                }
                default: {
                    toRet = "xml";
                }
            }
        }
        return toRet;
    }

    public static String getErroreVisualizzaFault(String fault) {
        if (fault != null) {
            StringBuilder contenutoDocumentoStringBuilder = new StringBuilder();
            String errore = Utils.getTestoVisualizzabile((byte[])fault.getBytes(), (StringBuilder)contenutoDocumentoStringBuilder, (boolean)false);
            return errore;
        }
        return null;
    }
}

