/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.utils;

import org.openspcoop2.core.transazioni.constants.TipoAPI;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.pdd.logger.info.InfoEsitoTransazioneFormatUtils;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class TransazioniEsitiUtils {
    public static boolean isEsitoOk(Integer esito, String protocollo) {
        return InfoEsitoTransazioneFormatUtils.isEsitoOk((Logger)LoggerManager.getPddMonitorCoreLogger(), (Integer)esito, (String)protocollo);
    }

    public static boolean isEsitoFaultApplicativo(Integer esito, String protocollo) {
        return InfoEsitoTransazioneFormatUtils.isEsitoFaultApplicativo((Logger)LoggerManager.getPddMonitorCoreLogger(), (Integer)esito, (String)protocollo);
    }

    public static boolean isEsitoKo(Integer esito, String protocollo) {
        return InfoEsitoTransazioneFormatUtils.isEsitoKo((Logger)LoggerManager.getPddMonitorCoreLogger(), (Integer)esito, (String)protocollo);
    }

    public static String getEsitoLabel(Integer esito, String protocollo) {
        try {
            EsitoUtils esitoUtils = new EsitoUtils(LoggerManager.getPddMonitorCoreLogger(), protocollo);
            return esitoUtils.getEsitoLabelFromValue((Object)esito, false);
        }
        catch (Exception e) {
            LoggerManager.getPddMonitorCoreLogger().error("Errore durante il calcolo della label per l'esito [" + esito + "]: " + e.getMessage(), (Throwable)e);
            return "Conversione non riuscita";
        }
    }

    public static String getEsitoLabelSyntetic(Integer esito, String protocollo, Integer httpStatusCode, int tipoApi) {
        try {
            EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)LoggerManager.getPddMonitorCoreLogger(), (String)protocollo);
            Object esitoLabel = esitiProperties.getEsitoLabelSyntetic(esito);
            if (httpStatusCode != null && httpStatusCode > 0) {
                if (esitiProperties.convertoToCode(EsitoTransazioneName.OK).intValue() == esito.intValue()) {
                    esitoLabel = "HTTP " + httpStatusCode;
                } else if (esitiProperties.convertoToCode(EsitoTransazioneName.OK_PRESENZA_ANOMALIE).intValue() == esito.intValue()) {
                    esitoLabel = "HTTP " + httpStatusCode + " (Anomalia)";
                } else if (esitiProperties.convertoToCode(EsitoTransazioneName.CONTROLLO_TRAFFICO_POLICY_VIOLATA_WARNING_ONLY).intValue() == esito.intValue()) {
                    esitoLabel = "HTTP " + httpStatusCode + " (Rate Limiting)";
                } else if (esitiProperties.convertoToCode(EsitoTransazioneName.CONTROLLO_TRAFFICO_MAX_THREADS_WARNING_ONLY).intValue() == esito.intValue()) {
                    esitoLabel = "HTTP " + httpStatusCode + " (Limite Richieste)";
                } else if (esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA).intValue() == esito.intValue()) {
                    esitoLabel = "HTTP " + httpStatusCode + " (Consegna Asincrona in Coda)";
                } else if (esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA_IN_CORSO).intValue() == esito.intValue()) {
                    esitoLabel = "HTTP " + httpStatusCode + " (Consegna Asincrona in Corso)";
                } else if (esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA_COMPLETATA).intValue() == esito.intValue()) {
                    esitoLabel = "HTTP " + httpStatusCode + " (Consegna Asincrona)";
                } else if (esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA_FALLITA).intValue() == esito.intValue()) {
                    esitoLabel = "HTTP " + httpStatusCode + " (Consegna Asincrona Fallita)";
                } else if (esitiProperties.convertoToCode(EsitoTransazioneName.HTTP_3xx).intValue() == esito.intValue()) {
                    esitoLabel = ((String)esitoLabel).replace("Risposta ", "").replace("3xx", "" + httpStatusCode);
                } else if (esitiProperties.convertoToCode(EsitoTransazioneName.HTTP_4xx).intValue() == esito.intValue()) {
                    esitoLabel = ((String)esitoLabel).replace("Risposta ", "").replace("4xx", "" + httpStatusCode);
                } else if (esitiProperties.convertoToCode(EsitoTransazioneName.HTTP_5xx).intValue() == esito.intValue()) {
                    esitoLabel = ((String)esitoLabel).replace("Risposta ", "").replace("5xx", "" + httpStatusCode);
                } else if (esitiProperties.convertoToCode(EsitoTransazioneName.MESSAGE_BOX).intValue() != esito.intValue()) {
                    if (esitiProperties.convertoToCode(EsitoTransazioneName.ERRORE_APPLICATIVO).intValue() == esito.intValue()) {
                        esitoLabel = TipoAPI.REST.getValoreAsInt() == tipoApi ? "Problem Details " + httpStatusCode : (TipoAPI.SOAP.getValoreAsInt() == tipoApi ? "SOAP Fault " + httpStatusCode : (String)esitoLabel + " " + httpStatusCode);
                    } else if (esitiProperties.convertoToCode(EsitoTransazioneName.ERRORE_CONNESSIONE_CLIENT_NON_DISPONIBILE).intValue() != esito.intValue()) {
                        esitoLabel = (String)esitoLabel + " " + httpStatusCode;
                    }
                }
            }
            return esitoLabel;
        }
        catch (Exception e) {
            LoggerManager.getPddMonitorCoreLogger().error("Errore durante il calcolo della label per l'esito [" + esito + "]: " + e.getMessage(), (Throwable)e);
            return "Conversione non riuscita";
        }
    }

    public static String getEsitoLabelDescription(Integer esito, String protocollo, Integer httpOutStatusCode, Integer httpInStatusCode, int tipoApi) {
        try {
            EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)LoggerManager.getPddMonitorCoreLogger(), (String)protocollo);
            String esitoLabel = TransazioniEsitiUtils.getEsitoLabel(esito, protocollo);
            Object esitoRispostaIngresso = "";
            String esitoDescription = esitiProperties.getEsitoDescription(esito);
            if (httpOutStatusCode != null) {
                if (httpOutStatusCode > 0 && esitiProperties.convertoToCode(EsitoTransazioneName.HTTP_3xx).intValue() == esito.intValue()) {
                    esitoLabel = esitoLabel.replace("3xx", "" + httpOutStatusCode);
                } else if (httpOutStatusCode > 0 && esitiProperties.convertoToCode(EsitoTransazioneName.HTTP_4xx).intValue() == esito.intValue()) {
                    esitoLabel = esitoLabel.replace("4xx", "" + httpOutStatusCode);
                } else if (httpOutStatusCode > 0 && esitiProperties.convertoToCode(EsitoTransazioneName.HTTP_5xx).intValue() == esito.intValue()) {
                    esitoLabel = esitoLabel.replace("5xx", "" + httpOutStatusCode);
                } else if (esitiProperties.convertoToCode(EsitoTransazioneName.ERRORE_APPLICATIVO).intValue() == esito.intValue()) {
                    if (TipoAPI.REST.getValoreAsInt() == tipoApi) {
                        esitoLabel = "Problem Details";
                    } else if (TipoAPI.SOAP.getValoreAsInt() == tipoApi) {
                        esitoLabel = "SOAP Fault";
                    }
                }
                if (httpInStatusCode != null && httpInStatusCode.intValue() != httpOutStatusCode.intValue()) {
                    esitoRispostaIngresso = "<BR/>Codice Risposta API Invocata: " + httpInStatusCode;
                }
            }
            return esitoLabel + "<BR/>" + esitoDescription + (String)esitoRispostaIngresso;
        }
        catch (Exception e) {
            LoggerManager.getPddMonitorCoreLogger().error("Errore durante il calcolo della label per l'esito [" + esito + "]: " + e.getMessage(), (Throwable)e);
            return "Conversione non riuscita";
        }
    }

    public static String getEsitoContestoLabel(String esitoContesto, String protocollo) {
        try {
            EsitoUtils esitoUtils = new EsitoUtils(LoggerManager.getPddMonitorCoreLogger(), protocollo);
            return esitoUtils.getEsitoContestoLabelFromValue((Object)esitoContesto);
        }
        catch (Exception e) {
            LoggerManager.getPddMonitorCoreLogger().error("Errore durante il calcolo della label per il contesto esito [" + esitoContesto + "]: " + e.getMessage(), (Throwable)e);
            return "Conversione non riuscita";
        }
    }

    public static String getEsitoStyleClass(Integer esito, String protocollo) {
        try {
            EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)LoggerManager.getPddMonitorCoreLogger(), (String)protocollo);
            String name = esitiProperties.getEsitoName(esito);
            EsitoTransazioneName esitoName = EsitoTransazioneName.convertoTo((String)name);
            boolean casoSuccesso = esitiProperties.getEsitiCodeOk().contains(esito);
            if (EsitoTransazioneName.ERRORE_APPLICATIVO.equals((Object)esitoName)) {
                return "icon-alert-yellow";
            }
            if (casoSuccesso) {
                return "icon-verified-green";
            }
            return "icon-alert-red";
        }
        catch (Exception e) {
            LoggerManager.getPddMonitorCoreLogger().error("Errore durante il calcolo del layout dell'esito [" + esito + "]: " + e.getMessage(), (Throwable)e);
            return "icon-ko";
        }
    }
}

