/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.allarmi.bean;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.web.monitor.core.bean.BaseSearchForm;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.slf4j.Logger;

public class AllarmiSearchForm
extends BaseSearchForm {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private String nomeAllarme;
    private String statoSelezionato;
    private static final String STATO_DEFAULT_PAGINA_STATO_ALLARMI = "Non Disabilitato";
    private static final String STATO_DEFAULT_PAGINA_CONF_ALLARMI = "All";
    public static final String TIPOLOGIA_CONFIGURAZIONE = "configurazione";
    public static final String TIPOLOGIA_DELEGATA = CostantiConfigurazione.ALLARMI_TIPOLOGIA_DELEGATA;
    public static final String TIPOLOGIA_APPLICATIVA = CostantiConfigurazione.ALLARMI_TIPOLOGIA_APPLICATIVA;
    private String statoDefault;
    private String tipologiaAllarme;

    public AllarmiSearchForm() {
        try {
            PddMonitorProperties pddMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            this.setUseCount(pddMonitorProperties.isAttivoUtilizzaCountListaAllarmi());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected String eseguiFiltra() {
        this.setAggiornamentoDatiAbilitato(true);
        return super.eseguiFiltra();
    }

    public void initSearchListener(ActionEvent ae) {
        super.initSearchListener(ae);
        this.nomeAllarme = null;
        this.statoSelezionato = this.statoDefault;
        this.tipologiaAllarme = Utility.isAmministratore() ? TIPOLOGIA_CONFIGURAZIONE : TIPOLOGIA_APPLICATIVA;
        this.executeQuery = false;
    }

    public void menuClickSearchListener(ActionEvent ae) {
        UIComponent component = ae.getComponent();
        String id = component.getId();
        this.statoDefault = STATO_DEFAULT_PAGINA_STATO_ALLARMI;
        if (id != null && id.equals("confAllarmiLnk")) {
            this.statoDefault = STATO_DEFAULT_PAGINA_CONF_ALLARMI;
        }
        this.initSearchListener(ae);
    }

    public String getNomeAllarme() {
        return this.nomeAllarme;
    }

    public String getStatoSelezionato() {
        return this.statoSelezionato;
    }

    public void setNomeAllarme(String nomeAllarme) {
        this.nomeAllarme = nomeAllarme;
        if (StringUtils.isEmpty((String)nomeAllarme) || "--".equals(nomeAllarme)) {
            this.nomeAllarme = null;
        }
    }

    public void setStatoSelezionato(String statoSelezionato) {
        this.statoSelezionato = statoSelezionato;
        if (StringUtils.isEmpty((String)statoSelezionato) || "--".equals(statoSelezionato)) {
            this.statoSelezionato = null;
        }
    }

    protected String ripulisciValori() {
        this.initSearchListener(null);
        return null;
    }

    public void nomeAllarmeSelected(ActionEvent ae) {
    }

    protected String eseguiAggiorna() {
        return null;
    }

    public String getTipologiaAllarme() {
        return this.tipologiaAllarme;
    }

    public void setTipologiaAllarme(String tipologiaAllarme) {
        this.tipologiaAllarme = tipologiaAllarme;
    }

    public List<SelectItem> getTipologieRicerca() throws Exception {
        ArrayList<SelectItem> listaTipologie = new ArrayList<SelectItem>();
        if (Utility.isAmministratore()) {
            listaTipologie.add(new SelectItem((Object)TIPOLOGIA_CONFIGURAZIONE, MessageManager.getInstance().getMessage("allarmi.search.tipologia.configurazione.label")));
        }
        listaTipologie.add(new SelectItem((Object)TIPOLOGIA_APPLICATIVA, MessageManager.getInstance().getMessage("allarmi.search.tipologia.erogazione.label")));
        listaTipologie.add(new SelectItem((Object)TIPOLOGIA_DELEGATA, MessageManager.getInstance().getMessage("allarmi.search.tipologia.fruizione.label")));
        return listaTipologie;
    }

    public void tipologiaAllarmeListener(ActionEvent ae) {
    }
}

