/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.bean;

import java.io.Serializable;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.Search;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.commons.search.utils.ProjectInfo;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.plugins.utils.PluginsDriverUtils;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.IVersionInfo;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.VersionUtilities;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.bean.UserDetailsBean;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.listener.AbstractConsoleStartupListener;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.BrowserInfo;
import org.slf4j.Logger;

public class ApplicationBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static ApplicationBean instance = null;
    public static final String FUNZIONALITA_ALLARMI = "allarmi";
    public static final String FUNZIONALITA_STATISTICHE_BASE = "statistiche_base";
    public static final String FUNZIONALITA_STATISTICHE_PERSONALIZZATE = "statistiche_personalizzate";
    public static final String FUNZIONALITA_TRANSAZIONI_BASE = "transazioni_base";
    public static final String FUNZIONALITA_TRANSAZIONI_LIVE = "transazioni_live";
    public static final String FUNZIONALITA_TRANSAZIONI_LIVE_OPERATORE = "transazioni_live_operatore";
    public static final String FUNZIONALITA_EXPORT_TRANSAZIONI = "export_transazioni";
    public static final String FUNZIONALITA_TRANSAZIONI_CONTENUTI = "transazioni_contenuti";
    public static final String FUNZIONALITA_RICERCHE_PERSONALIZZATE = "ricerche_personalizzate";
    public static final String FUNZIONALITA_ESITI_LIVE = "esiti_live";
    public static final String FUNZIONALITA_ESITI_LIVE_OPERATORE = "esiti_live_operatore";
    public static final String FUNZIONALITA_PROCESSI = "processi";
    public static final String FUNZIONALITA_EXPORT_PROCESSI = "export_processi";
    public static final String FUNZIONALITA_SONDE_APPLICATIVE = "sonde_applicative";
    public static final String FUNZIONALITA_EVENTI = "eventi";
    public static final String FUNZIONALITA_ANALISI_DATI = "analisi_dati";
    public static final String FUNZIONALITA_UTENTI = "utenti";
    public static final String FUNZIONALITA_STATUS_PDD = "status_pdd";
    public static final String FUNZIONALITA_GENERICHE = "funzionalita_generiche";
    public static final String FUNZIONALITA_ARCHIVIAZIONE_DATI = "dump_contenuti";
    public static final String FUNZIONALITA_GESTIONE_PASSWORD = "gestione_password";
    public static final String FUNZIONALITA_GRAFICI_SVG = "grafici_svg";
    public static final String FUNZIONALITA_REPORT = "report";
    public static final String RUOLO_USER = "ROLE_USER";
    public static final String RUOLO_OPERATORE = "ROLE_OPERATORE";
    public static final String RUOLO_CONFIGURATORE = "ROLE_CONFIG";
    public static final String RUOLO_AMMINISTRATORE = "ROLE_ADMIN";
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private transient LoginBean loginBean;
    private Map<String, Boolean> funzionalita = new HashMap<String, Boolean>();
    private Map<String, Boolean> roles = null;
    private boolean permessoTransazioni = false;
    private boolean permessoStatistiche = false;
    private boolean loginApplication = true;
    private Locale locale;
    private static Map<String, Boolean> funzionalitaStaticInstance = null;
    private static final String CACHE_SEPARATOR = "\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationBean getInstance() {
        if (instance != null) return instance;
        Class<ApplicationBean> clazz = ApplicationBean.class;
        synchronized (ApplicationBean.class) {
            ApplicationBean.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static synchronized void init() {
        if (instance == null) {
            instance = new ApplicationBean();
        }
    }

    private void initializeFunzionalita(PddMonitorProperties govwayMonitorProperties) throws UtilsException {
        ApplicationBean._initializeFunzionalita(govwayMonitorProperties);
    }

    private static synchronized void _initializeFunzionalita(PddMonitorProperties govwayMonitorProperties) throws UtilsException {
        if (funzionalitaStaticInstance == null) {
            funzionalitaStaticInstance = new HashMap<String, Boolean>();
            funzionalitaStaticInstance.put(FUNZIONALITA_TRANSAZIONI_BASE, govwayMonitorProperties.isAttivoModuloTransazioniBase());
            funzionalitaStaticInstance.put(FUNZIONALITA_TRANSAZIONI_LIVE, govwayMonitorProperties.isAttivoModuloTransazioniBase());
            funzionalitaStaticInstance.put(FUNZIONALITA_TRANSAZIONI_LIVE_OPERATORE, govwayMonitorProperties.isAttivoModuloTransazioniBase() && govwayMonitorProperties.isAttivoLiveRuoloOperatore());
            funzionalitaStaticInstance.put(FUNZIONALITA_STATISTICHE_BASE, govwayMonitorProperties.isAttivoModuloTransazioniStatisticheBase());
            funzionalitaStaticInstance.put(FUNZIONALITA_ALLARMI, govwayMonitorProperties.isAllarmiEnabled());
            boolean attivoModuloTransazioniPersonalizzate = govwayMonitorProperties.isAttivoModuloTransazioniPersonalizzate();
            funzionalitaStaticInstance.put(FUNZIONALITA_TRANSAZIONI_CONTENUTI, attivoModuloTransazioniPersonalizzate);
            boolean attivoModuloRicerchePersonalizzate = govwayMonitorProperties.isAttivoModuloRicerchePersonalizzate();
            funzionalitaStaticInstance.put(FUNZIONALITA_RICERCHE_PERSONALIZZATE, attivoModuloRicerchePersonalizzate);
            boolean attivoModuloTransazioniStatistichePersonalizzate = govwayMonitorProperties.isAttivoModuloTransazioniStatistichePersonalizzate();
            funzionalitaStaticInstance.put(FUNZIONALITA_STATISTICHE_PERSONALIZZATE, attivoModuloTransazioniStatistichePersonalizzate);
            funzionalitaStaticInstance.put(FUNZIONALITA_PROCESSI, govwayMonitorProperties.isAttivoModuloProcessi());
            funzionalitaStaticInstance.put(FUNZIONALITA_SONDE_APPLICATIVE, govwayMonitorProperties.isAttivoModuloSonde());
            funzionalitaStaticInstance.put(FUNZIONALITA_EVENTI, govwayMonitorProperties.isAttivoModuloEventi());
            funzionalitaStaticInstance.put(FUNZIONALITA_ANALISI_DATI, attivoModuloTransazioniPersonalizzate || attivoModuloRicerchePersonalizzate || attivoModuloTransazioniStatistichePersonalizzate);
            funzionalitaStaticInstance.put(FUNZIONALITA_ESITI_LIVE, govwayMonitorProperties.isAttivoTransazioniEsitiLive());
            funzionalitaStaticInstance.put(FUNZIONALITA_ESITI_LIVE_OPERATORE, govwayMonitorProperties.isAttivoTransazioniEsitiLive() && govwayMonitorProperties.isAttivoLiveRuoloOperatore());
            funzionalitaStaticInstance.put(FUNZIONALITA_STATUS_PDD, govwayMonitorProperties.isStatusPdDEnabled());
            funzionalitaStaticInstance.put(FUNZIONALITA_UTENTI, true);
            funzionalitaStaticInstance.put(FUNZIONALITA_GENERICHE, true);
            funzionalitaStaticInstance.put(FUNZIONALITA_ARCHIVIAZIONE_DATI, true);
            funzionalitaStaticInstance.put(FUNZIONALITA_EXPORT_TRANSAZIONI, true);
            funzionalitaStaticInstance.put(FUNZIONALITA_EXPORT_PROCESSI, true);
            funzionalitaStaticInstance.put(FUNZIONALITA_GESTIONE_PASSWORD, govwayMonitorProperties.isGestionePasswordUtentiAttiva());
            funzionalitaStaticInstance.put(FUNZIONALITA_GRAFICI_SVG, govwayMonitorProperties.isGraficiSvgEnabled());
            funzionalitaStaticInstance.put(FUNZIONALITA_REPORT, govwayMonitorProperties.isAttivoModuloReports());
        }
    }

    public void disabilitaFunzionalita(String nomeFunzionalita) {
        this.funzionalita.remove(nomeFunzionalita);
        this.funzionalita.put(nomeFunzionalita, false);
        funzionalitaStaticInstance.remove(nomeFunzionalita);
        funzionalitaStaticInstance.put(nomeFunzionalita, false);
    }

    public ApplicationBean() {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance(log);
            this.initializeFunzionalita(govwayMonitorProperties);
            this.funzionalita.putAll(funzionalitaStaticInstance);
            this.loginApplication = govwayMonitorProperties.isLoginApplication();
            this.locale = govwayMonitorProperties.getConsoleLocale();
        }
        catch (Exception e) {
            log.error("Errore durante l'inizializzazione del ApplicationBean.", (Throwable)e);
        }
    }

    private void initRoles() {
        try {
            if (this.loginBean != null && this.loginBean.getLoggedUser() != null) {
                UserDetailsBean u = this.loginBean.getLoggedUser();
                this.roles = this.getRuoliUtente(u);
                this.permessoStatistiche = u.getUtente().getPermessi().isReportistica();
                this.permessoTransazioni = u.getUtente().getPermessi().isDiagnostica();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isFunzionalitaAbilitata(String function) {
        return this.funzionalita != null && this.funzionalita.get(function) != null && this.funzionalita.get(function) != false;
    }

    public boolean isRuoloAbilitato(String role) {
        return this.roles != null && this.roles.get(role) != null && this.roles.get(role) != false;
    }

    public Map<String, Boolean> getRuoliUtente(UserDetailsBean u) {
        HashMap<String, Boolean> ruoli = new HashMap<String, Boolean>();
        List<UserDetailsBean.RuoloBean> auths = u.getAuthorities();
        if (auths != null && !auths.isEmpty()) {
            ruoli.put(RUOLO_AMMINISTRATORE, false);
            ruoli.put(RUOLO_CONFIGURATORE, false);
            ruoli.put(RUOLO_OPERATORE, false);
            ruoli.put(RUOLO_USER, false);
            for (UserDetailsBean.RuoloBean grantedAuthority : auths) {
                String a = grantedAuthority.getAuthority();
                if (RUOLO_AMMINISTRATORE.equals(a)) {
                    ruoli.put(RUOLO_AMMINISTRATORE, true);
                }
                if (RUOLO_CONFIGURATORE.equals(a)) {
                    ruoli.put(RUOLO_CONFIGURATORE, true);
                }
                if (RUOLO_OPERATORE.equals(a)) {
                    ruoli.put(RUOLO_OPERATORE, true);
                }
                if (!RUOLO_USER.equals(a)) continue;
                ruoli.put(RUOLO_USER, true);
            }
        }
        return ruoli;
    }

    public LoginBean getLoginBean() {
        return this.loginBean;
    }

    public Map<String, Boolean> getModules() {
        return this.funzionalita;
    }

    public void setLoginBean(LoginBean loginBean) {
        this.loginBean = loginBean;
    }

    public void setModules(Map<String, Boolean> modules) {
        this.funzionalita = modules;
    }

    private void checkRoles() {
        if (this.roles == null) {
            this.initRoles();
        }
    }

    public boolean getShowTransazioniBase() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_TRANSAZIONI_BASE)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        if (!this.permessoTransazioni) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_OPERATORE);
    }

    public boolean getShowTransazioniContenuti() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_TRANSAZIONI_CONTENUTI)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        if (!this.permessoTransazioni) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_AMMINISTRATORE) || this.isRuoloAbilitato(RUOLO_OPERATORE);
    }

    public boolean getShowRicerchePersonalizzate() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_RICERCHE_PERSONALIZZATE)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        if (!this.permessoTransazioni) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_OPERATORE);
    }

    public boolean getShowSonde() {
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_SONDE_APPLICATIVE)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_AMMINISTRATORE) || this.isRuoloAbilitato(RUOLO_OPERATORE);
    }

    public boolean getShowAllarmi() {
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_ALLARMI)) {
            return false;
        }
        if (!this.existsPluginAllarmi()) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_AMMINISTRATORE) || this.isRuoloAbilitato(RUOLO_OPERATORE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsPluginAllarmi() {
        boolean bl;
        Logger sqlLogger = LoggerManager.getPddMonitorSqlLogger();
        String tipoDatabase = DAOFactoryProperties.getInstance((Logger)sqlLogger).getTipoDatabase((IProjectInfo)ProjectInfo.getInstance());
        String datasourceJNDIName = DAOFactoryProperties.getInstance((Logger)sqlLogger).getDatasourceJNDIName((IProjectInfo)ProjectInfo.getInstance());
        Properties datasourceJNDIContext = DAOFactoryProperties.getInstance((Logger)sqlLogger).getDatasourceJNDIContext((IProjectInfo)ProjectInfo.getInstance());
        DriverConfigurazioneDB driverConfigDB = new DriverConfigurazioneDB(datasourceJNDIName, datasourceJNDIContext, sqlLogger, tipoDatabase);
        Connection con = null;
        try {
            con = driverConfigDB.getConnection("existsPluginAllarmi");
            Search ricercaPlugin = new Search(true);
            ricercaPlugin.addFilter(Liste.CONFIGURAZIONE_PLUGINS_CLASSI, "filtroTipoPluginClassi", TipoPlugin.ALLARME.toString());
            List p = PluginsDriverUtils.pluginsClassiList((ISearch)ricercaPlugin, (Connection)con, (Logger)sqlLogger, (String)tipoDatabase);
            bl = p != null && !p.isEmpty();
        }
        catch (Throwable throwable) {
            try {
                driverConfigDB.releaseConnection("existsPluginAllarmi", con);
                throw throwable;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        driverConfigDB.releaseConnection("existsPluginAllarmi", con);
        return bl;
    }

    public boolean getShowTransazioniLive() {
        this.checkRoles();
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        if (!this.permessoTransazioni) {
            return false;
        }
        if (this.isRuoloAbilitato(RUOLO_AMMINISTRATORE) && this.isFunzionalitaAbilitata(FUNZIONALITA_TRANSAZIONI_BASE) && this.isFunzionalitaAbilitata(FUNZIONALITA_TRANSAZIONI_LIVE)) {
            return true;
        }
        return this.isRuoloAbilitato(RUOLO_OPERATORE) && this.isFunzionalitaAbilitata(FUNZIONALITA_TRANSAZIONI_BASE) && this.isFunzionalitaAbilitata(FUNZIONALITA_TRANSAZIONI_LIVE_OPERATORE);
    }

    public boolean getShowEsitiLive() {
        this.checkRoles();
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        if (!this.permessoTransazioni) {
            return false;
        }
        if (this.isRuoloAbilitato(RUOLO_AMMINISTRATORE) && this.isFunzionalitaAbilitata(FUNZIONALITA_TRANSAZIONI_BASE) && this.isFunzionalitaAbilitata(FUNZIONALITA_ESITI_LIVE)) {
            return true;
        }
        return this.isRuoloAbilitato(RUOLO_OPERATORE) && this.isFunzionalitaAbilitata(FUNZIONALITA_TRANSAZIONI_BASE) && this.isFunzionalitaAbilitata(FUNZIONALITA_ESITI_LIVE_OPERATORE);
    }

    public boolean getShowProcessi() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_PROCESSI)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_AMMINISTRATORE);
    }

    public boolean getShowEventi() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_EVENTI)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_AMMINISTRATORE);
    }

    public boolean getShowInformazioniContenutiTransazioniGrid() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_TRANSAZIONI_CONTENUTI)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        if (!this.permessoTransazioni) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_OPERATORE);
    }

    public boolean getShowInformazioniEventiTransazioniGrid() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_EVENTI)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_OPERATORE);
    }

    public boolean getShowStatisticheBase() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_STATISTICHE_BASE)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        if (!this.permessoStatistiche) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_OPERATORE);
    }

    public boolean getShowStatistichePersonalizzate() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_STATISTICHE_PERSONALIZZATE)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        if (!this.permessoStatistiche) {
            return false;
        }
        if (this.isRuoloAbilitato(RUOLO_OPERATORE)) {
            return true;
        }
        return this.isFunzionalitaAbilitata(FUNZIONALITA_STATISTICHE_BASE);
    }

    public boolean getShowStatisticheConfigurazioniGenerali() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_STATISTICHE_BASE)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        if (!this.permessoStatistiche) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_OPERATORE) || this.isRuoloAbilitato(RUOLO_AMMINISTRATORE);
    }

    public boolean getShowStatistichePdndTracing() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_STATISTICHE_BASE)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        if (!this.permessoStatistiche) {
            return false;
        }
        String loggedUtenteModalita = Utility.getLoggedUtenteModalita();
        boolean modalitaOk = "qualsiasi".equals(loggedUtenteModalita) || "modipa".equals(loggedUtenteModalita);
        try {
            modalitaOk = modalitaOk && ModIUtils.isTracingPDNDEnabled();
        }
        catch (Exception e) {
            throw new UtilsRuntimeException("isTracingPDNDEnabled failed: " + e.getMessage(), (Throwable)e);
        }
        return (this.isRuoloAbilitato(RUOLO_OPERATORE) || this.isRuoloAbilitato(RUOLO_AMMINISTRATORE)) && modalitaOk;
    }

    public boolean getShowSezioneConfigurazione() {
        this.checkRoles();
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return !(!this.getShowConfigurazioneAllarmi() && !this.getShowConfigurazioneSonde() && !this.getShowConfigurazioneLibreria() && !this.getShowConfigurazioneProcessi() || !this.isRuoloAbilitato(RUOLO_CONFIGURATORE) && !this.isRuoloAbilitato(RUOLO_AMMINISTRATORE));
    }

    public boolean getShowConfigStatistichePersonalizzate() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_STATISTICHE_PERSONALIZZATE)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_CONFIGURATORE);
    }

    public boolean getShowConfigRicerchePersonalizzate() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_RICERCHE_PERSONALIZZATE)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_CONFIGURATORE);
    }

    public boolean getShowConfigTransazioniContenuti() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_TRANSAZIONI_CONTENUTI)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_CONFIGURATORE);
    }

    public boolean getShowAnalisiContenuti() {
        this.checkRoles();
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_CONFIGURATORE);
    }

    public boolean getShowConfigurazioneSonde() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_SONDE_APPLICATIVE)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_CONFIGURATORE);
    }

    public boolean getShowConfigurazioneLibreria() {
        this.checkRoles();
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        if (!this.isRuoloAbilitato(RUOLO_CONFIGURATORE)) {
            return false;
        }
        return this.isFunzionalitaAbilitata(FUNZIONALITA_STATISTICHE_PERSONALIZZATE) || this.isFunzionalitaAbilitata(FUNZIONALITA_RICERCHE_PERSONALIZZATE) || this.isFunzionalitaAbilitata(FUNZIONALITA_TRANSAZIONI_CONTENUTI) || this.isFunzionalitaAbilitata(FUNZIONALITA_PROCESSI);
    }

    public boolean getShowCambiaPassword() {
        if (!this.loginApplication) {
            return false;
        }
        if (Utility.isUtenteLoggatoOAuth2()) {
            return false;
        }
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_GESTIONE_PASSWORD)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        return !this.roles.isEmpty();
    }

    public boolean getShowConfigurazioneProcessi() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_PROCESSI)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_CONFIGURATORE);
    }

    public boolean getShowConfigurazioneAllarmi() {
        return false;
    }

    public boolean getShowReport() {
        this.checkRoles();
        if (!this.isFunzionalitaAbilitata(FUNZIONALITA_REPORT)) {
            return false;
        }
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_OPERATORE);
    }

    public BrowserInfo getBrowserInfo() {
        BrowserInfo browserInfo = null;
        try {
            browserInfo = BrowserInfo.getBrowserInfo(FacesContext.getCurrentInstance());
        }
        catch (Exception e) {
            log.error("Errore durante la lettura delle info Browser:" + e.getMessage(), (Throwable)e);
        }
        return browserInfo;
    }

    public boolean isAmministratore() {
        this.checkRoles();
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_AMMINISTRATORE);
    }

    public void setAmministratore(boolean amministratore) {
    }

    public boolean isUser() {
        this.checkRoles();
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_USER);
    }

    public void setUser(boolean user) {
    }

    public boolean isConfiguratore() {
        this.checkRoles();
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_CONFIGURATORE);
    }

    public void setConfiguratore(boolean configuratore) {
    }

    public boolean isOperatore() {
        this.checkRoles();
        if (this.roles == null) {
            return false;
        }
        if (this.roles.isEmpty()) {
            return false;
        }
        return this.isRuoloAbilitato(RUOLO_OPERATORE);
    }

    public void setOperatore(boolean operatore) {
    }

    public boolean isGraficiSvgEnabled() {
        return this.isFunzionalitaAbilitata(FUNZIONALITA_GRAFICI_SVG);
    }

    public void cleanSVG() {
        BrowserInfo browserInfo = this.getBrowserInfo();
        try {
            if (browserInfo.getBrowserFamily().equals((Object)BrowserInfo.BrowserFamily.IE)) {
                HttpServletResponse response = BrowserInfo.getResponse(FacesContext.getCurrentInstance());
                response.setHeader("X-UA-Compatible", "IE=edge");
            }
        }
        catch (Exception e) {
            log.error("Errore durante la lettura delle info Browser:" + e.getMessage(), (Throwable)e);
        }
    }

    public String getIdProdotto() {
        Object pVersion = null;
        pVersion = "GovWay 3.3.18";
        try {
            String version = VersionUtilities.readVersion();
            if (version != null && !StringUtils.isEmpty((String)version)) {
                pVersion = version;
            }
        }
        catch (Exception version) {
            // empty catch block
        }
        String buildVersion = null;
        try {
            buildVersion = VersionUtilities.readBuildVersion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (buildVersion != null) {
            pVersion = (String)pVersion + " (build " + buildVersion + ")";
        }
        return pVersion;
    }

    public String getSito() {
        IVersionInfo versionInfo = this.loginBean != null ? this.loginBean.getvInfo() : null;
        String soggettoSelezionato = Utility.getSoggettoSelezionatoPerVersionInfo();
        if (versionInfo != null && !StringUtils.isEmpty((String)versionInfo.getWebSite(new Object[]{soggettoSelezionato}))) {
            return versionInfo.getWebSite(new Object[]{soggettoSelezionato});
        }
        return "https://govway.org";
    }

    public String getCopyright() {
        IVersionInfo versionInfo = this.loginBean != null ? this.loginBean.getvInfo() : null;
        String soggettoSelezionato = Utility.getSoggettoSelezionatoPerVersionInfo();
        if (versionInfo != null && !StringUtils.isEmpty((String)versionInfo.getCopyright(new Object[]{soggettoSelezionato}))) {
            return versionInfo.getCopyright(new Object[]{soggettoSelezionato});
        }
        return "2005-2025 Link.it srl";
    }

    public String getLicenza() {
        IVersionInfo versionInfo = this.loginBean != null ? this.loginBean.getvInfo() : null;
        String soggettoSelezionato = Utility.getSoggettoSelezionatoPerVersionInfo();
        if (versionInfo != null) {
            try {
                return versionInfo.getInfo(new Object[]{soggettoSelezionato});
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return "This program is free software: you can redistribute it and/or modify\nit under the terms of the GNU General Public License version 3, as published by\nthe Free Software Foundation.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program.  If not, see <http://www.gnu.org/licenses/>.";
            }
        }
        return "This program is free software: you can redistribute it and/or modify\nit under the terms of the GNU General Public License version 3, as published by\nthe Free Software Foundation.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program.  If not, see <http://www.gnu.org/licenses/>.";
    }

    public int getLicenzaRows() {
        String licenza = this.getLicenza();
        String[] split = licenza.split(CACHE_SEPARATOR);
        if (split == null || split.length > 11) {
            return 11;
        }
        return split.length + 1;
    }

    public String getLabelProfilo() {
        return "Profilo Interoperabilit\u00e0";
    }

    public String getLabelProfili() {
        return "Profili Interoperabilit\u00e0";
    }

    public String getLabelProfiloDi() {
        return "Profilo di Interoperabilit\u00e0";
    }

    public String getLabelProfiliDi() {
        return "Profili di Interoperabilit\u00e0";
    }

    public String getLabelProfiloCompact() {
        return "Profilo";
    }

    public String getLabelProfiliCompact() {
        return "Profili";
    }

    public String getLabelSoggettoDi() {
        return "Soggetto Operativo";
    }

    public String getLabelSoggettoCompact() {
        return "Soggetto Operativo";
    }

    public String getLabelSoggettiCompact() {
        return "Soggetti Operativi";
    }

    public String getLabelRisultatoSelezioneSoggetto() {
        if (this.loginBean.getSoggettoPddMonitor() == null || this.loginBean.getSoggettoPddMonitor().equals("qualsiasi")) {
            return MessageFormat.format("{0} disponibili: {1}", this.getLabelSoggettiCompact(), this.loginBean.getLabelSoggettoSenzaPrefisso());
        }
        return MessageFormat.format("{0} attuale: {1}", this.getLabelSoggettoCompact(), this.loginBean.getLabelSoggettoSenzaPrefisso());
    }

    private String getCacheDetailsEngine(String stato, String param) {
        String[] split = stato.split(CACHE_SEPARATOR);
        for (int i = 0; i < split.length; ++i) {
            String label = split[i];
            String value = "";
            if (!split[i].contains(":")) continue;
            label = split[i].split(":")[0];
            value = split[i].split(":")[1];
            if (!label.equalsIgnoreCase(param)) continue;
            return value;
        }
        return null;
    }

    public String resetAllCache() {
        this.resetCacheDatiConfigurazione();
        this.resetCacheRicercheConfigurazione();
        return null;
    }

    public boolean isCacheDatiConfigurazioneEnabled() {
        return AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null;
    }

    public String getCacheDatiConfigurazioneStato() {
        return this.isCacheDatiConfigurazioneEnabled() ? "abilitata" : "disabilitata";
    }

    public String getCacheDatiConfigurazioneAlgoritmo() {
        return this.isCacheDatiConfigurazioneEnabled() ? this.getCacheDetailsEngine(this.getCacheDatiConfigurazioneDetails(), "Algoritmo") : "-";
    }

    public String getCacheDatiConfigurazioneDimensione() {
        return this.isCacheDatiConfigurazioneEnabled() ? this.getCacheDetailsEngine(this.getCacheDatiConfigurazioneDetails(), "Dimensione") : "-";
    }

    public String getCacheDatiConfigurazioneElementiInCache() {
        return this.isCacheDatiConfigurazioneEnabled() ? this.getCacheDetailsEngine(this.getCacheDatiConfigurazioneDetails(), "ElementiInCache") : "-";
    }

    public String getCacheDatiConfigurazioneMemoriaOccupata() {
        return this.isCacheDatiConfigurazioneEnabled() ? this.getCacheDetailsEngine(this.getCacheDatiConfigurazioneDetails(), "MemoriaOccupata") : "-";
    }

    public String getCacheDatiConfigurazioneIdleTime() {
        return this.isCacheDatiConfigurazioneEnabled() ? this.getCacheDetailsEngine(this.getCacheDatiConfigurazioneDetails(), "IdleTime") : "-";
    }

    public String getCacheDatiConfigurazioneLifeTime() {
        return this.isCacheDatiConfigurazioneEnabled() ? this.getCacheDetailsEngine(this.getCacheDatiConfigurazioneDetails(), "LifeTime") : "-";
    }

    public String getCacheDatiConfigurazioneDetails() {
        try {
            return AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.printStatsCache(CACHE_SEPARATOR);
        }
        catch (Exception e) {
            LoggerManager.getPddMonitorCoreLogger().error(e.getMessage(), (Throwable)e);
            return "Informazioni non disponibili";
        }
    }

    public int getCacheDatiConfigurazioneDetailsRows() {
        String stato = this.getCacheDatiConfigurazioneDetails();
        String[] split = stato.split(CACHE_SEPARATOR);
        if (split == null || split.length > 11) {
            return 10;
        }
        return split.length + 1;
    }

    public String resetCacheDatiConfigurazione() {
        if (this.isCacheDatiConfigurazioneEnabled()) {
            try {
                AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.resetCache();
            }
            catch (Exception e) {
                LoggerManager.getPddMonitorCoreLogger().error("ResetCache 'dati': " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public boolean isCacheRicercheConfigurazioneEnabled() {
        return AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione != null;
    }

    public String getCacheRicercheConfigurazioneStato() {
        return this.isCacheRicercheConfigurazioneEnabled() ? "abilitata" : "disabilitata";
    }

    public String getCacheRicercheConfigurazioneAlgoritmo() {
        return this.isCacheRicercheConfigurazioneEnabled() ? this.getCacheDetailsEngine(this.getCacheRicercheConfigurazioneDetails(), "Algoritmo") : "-";
    }

    public String getCacheRicercheConfigurazioneDimensione() {
        return this.isCacheRicercheConfigurazioneEnabled() ? this.getCacheDetailsEngine(this.getCacheRicercheConfigurazioneDetails(), "Dimensione") : "-";
    }

    public String getCacheRicercheConfigurazioneElementiInCache() {
        return this.isCacheRicercheConfigurazioneEnabled() ? this.getCacheDetailsEngine(this.getCacheRicercheConfigurazioneDetails(), "ElementiInCache") : "-";
    }

    public String getCacheRicercheConfigurazioneMemoriaOccupata() {
        return this.isCacheRicercheConfigurazioneEnabled() ? this.getCacheDetailsEngine(this.getCacheRicercheConfigurazioneDetails(), "MemoriaOccupata") : "-";
    }

    public String getCacheRicercheConfigurazioneIdleTime() {
        return this.isCacheRicercheConfigurazioneEnabled() ? this.getCacheDetailsEngine(this.getCacheRicercheConfigurazioneDetails(), "IdleTime") : "-";
    }

    public String getCacheRicercheConfigurazioneLifeTime() {
        return this.isCacheRicercheConfigurazioneEnabled() ? this.getCacheDetailsEngine(this.getCacheRicercheConfigurazioneDetails(), "LifeTime") : "-";
    }

    public String getCacheRicercheConfigurazioneDetails() {
        try {
            return AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione.printStatsCache(CACHE_SEPARATOR);
        }
        catch (Exception e) {
            LoggerManager.getPddMonitorCoreLogger().error(e.getMessage(), (Throwable)e);
            return "Informazioni non disponibili";
        }
    }

    public int getCacheRicercheConfigurazioneDetailsRows() {
        String licenza = this.getLicenza();
        String[] split = licenza.split(CACHE_SEPARATOR);
        if (split == null || split.length > 11) {
            return 10;
        }
        return split.length + 1;
    }

    public String resetCacheRicercheConfigurazione() {
        if (this.isCacheRicercheConfigurazioneEnabled()) {
            try {
                AbstractConsoleStartupListener.dynamicUtilsServiceCache_ricercheConfigurazione.resetCache();
            }
            catch (Exception e) {
                LoggerManager.getPddMonitorCoreLogger().error("ResetCache 'ricerche': " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public String getTimeZone() {
        return TimeZone.getDefault().getID();
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }
}

