/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.converter;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;

public class SelectItemConverter
implements Converter {
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        List<SelectItem> selectItems;
        if (StringUtils.isEmpty((String)value)) {
            value = "*";
        }
        if ((selectItems = (List<SelectItem>)component.getAttributes().get("suggestionValues")) == null) {
            selectItems = this.getItems(context, component);
        }
        for (SelectItem selectItem : selectItems) {
            if (!selectItem.getLabel().equalsIgnoreCase(value)) continue;
            return selectItem.getValue();
        }
        return null;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value == null) {
            return "";
        }
        List<SelectItem> selectItems = (List<SelectItem>)component.getAttributes().get("suggestionValues");
        if (selectItems == null) {
            selectItems = this.getItems(context, component);
        }
        if (value instanceof String) {
            for (SelectItem selectItem : selectItems) {
                Object value2 = selectItem.getValue();
                if (!value2.equals(value)) continue;
                return selectItem.getLabel();
            }
        } else if (value instanceof Integer) {
            for (SelectItem selectItem : selectItems) {
                int v2;
                Object value2 = selectItem.getValue();
                if (value2 == null) continue;
                if (value2 instanceof Integer) {
                    int v1;
                    v2 = (Integer)value2;
                    if (v2 != (v1 = ((Integer)value).intValue())) continue;
                    return selectItem.getLabel();
                }
                if (!(value2 instanceof String)) continue;
                v2 = -1;
                try {
                    v2 = Integer.parseInt((String)value2);
                }
                catch (Exception v1) {
                    // empty catch block
                }
                if (v2 != (v1 = ((Integer)value).intValue())) continue;
                return selectItem.getLabel();
            }
        } else if (value instanceof Long) {
            for (SelectItem selectItem : selectItems) {
                long v2;
                Object value2 = selectItem.getValue();
                if (value2 instanceof Long) {
                    long v1;
                    v2 = (Long)value2;
                    if (v2 != (v1 = ((Long)value).longValue())) continue;
                    return selectItem.getLabel();
                }
                if (!(value2 instanceof String)) continue;
                v2 = -1L;
                try {
                    v2 = Long.parseLong((String)value2);
                }
                catch (Exception v1) {
                    // empty catch block
                }
                if (v2 != (v1 = ((Long)value).longValue())) continue;
                return selectItem.getLabel();
            }
        } else if (value instanceof Boolean) {
            for (SelectItem selectItem : selectItems) {
                boolean v2;
                Object value2 = selectItem.getValue();
                if (value2 instanceof Boolean) {
                    boolean v1;
                    v2 = (Boolean)value2;
                    if (v2 != (v1 = ((Boolean)value).booleanValue())) continue;
                    return selectItem.getLabel();
                }
                if (!(value2 instanceof String)) continue;
                v2 = false;
                try {
                    v2 = Boolean.parseBoolean((String)value2);
                }
                catch (Exception v1) {
                    // empty catch block
                }
                if (v2 != (v1 = ((Boolean)value).booleanValue())) continue;
                return selectItem.getLabel();
            }
        }
        if (value instanceof SelectItem) {
            SelectItem facesSelectItem = (SelectItem)value;
            return facesSelectItem.getLabel();
        }
        return "";
    }

    private List<SelectItem> getItems(FacesContext context, UIComponent component) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        List children = component.getChildren();
        ArrayList<UISelectItems> fSelectItems = new ArrayList<UISelectItems>();
        ArrayList<UISelectItem> listSelectItem = new ArrayList<UISelectItem>();
        for (UIComponent child : children) {
            if (child instanceof UISelectItems) {
                fSelectItems.add((UISelectItems)child);
                continue;
            }
            if (!(child instanceof UISelectItem)) continue;
            listSelectItem.add((UISelectItem)child);
        }
        if (fSelectItems.size() > 0) {
            for (UISelectItems uiSelectItems : fSelectItems) {
                List lst = (List)uiSelectItems.getValue();
                if (lst.size() <= 0) continue;
                selectItems.addAll(lst);
            }
        }
        if (listSelectItem.size() > 0) {
            for (UISelectItem uiSelectItem : listSelectItem) {
                SelectItem item = null;
                item = uiSelectItem.getValue() != null ? (SelectItem)uiSelectItem.getValue() : new SelectItem(uiSelectItem.getItemValue(), uiSelectItem.getItemLabel());
                selectItems.add(item);
            }
        }
        return selectItems;
    }
}

