/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.dao.IExpressionConstructor;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.web.monitor.core.bean.UserDetailsBean;
import org.openspcoop2.web.monitor.core.core.Utility;

public class PermessiUtenteOperatore {
    public static boolean CHECK_UNIQUE_SOGGETTO_SERVIZIO_UTENTE = false;
    private List<IDServizio> listIDServizi = new ArrayList<IDServizio>();
    private List<IDSoggetto> listIDSoggetti = new ArrayList<IDSoggetto>();

    public void addSoggetto(IDSoggetto idSoggetto) throws CoreException {
        for (IDSoggetto idSoggettoCheck : this.listIDSoggetti) {
            if (!idSoggettoCheck.equals((Object)idSoggetto)) continue;
            throw new CoreException("Soggetto [" + idSoggetto + "] gi\u00e0 aggiunto");
        }
        if (CHECK_UNIQUE_SOGGETTO_SERVIZIO_UTENTE) {
            for (IDServizio idServizio : this.listIDServizi) {
                if (!idServizio.getSoggettoErogatore().equals((Object)idSoggetto)) continue;
                throw new CoreException("Soggetto [" + idSoggetto + "] non pu\u00f2 essere aggiunto come filtro singolo poich\u00e8 gi\u00e0 esistono dei filtri sui servizi da lui erogati");
            }
        }
        this.listIDSoggetti.add(idSoggetto);
    }

    public void addServizio(IDServizio idServizio) throws CoreException {
        for (IDServizio idServizioCheck : this.listIDServizi) {
            if (!idServizioCheck.equals((Object)idServizio)) continue;
            throw new CoreException("Servizio [" + idServizio + "] gi\u00e0 aggiunto");
        }
        if (CHECK_UNIQUE_SOGGETTO_SERVIZIO_UTENTE) {
            for (IDSoggetto idSoggetto : this.listIDSoggetti) {
                if (!idSoggetto.equals((Object)idServizio.getSoggettoErogatore())) continue;
                throw new CoreException("Servizio [" + idServizio + "] non pu\u00f2 essere aggiunto poich\u00e8 esiste gi\u00e0 un filtro generale sul soggetto erogatore valido per tutti i servizi");
            }
        }
        this.listIDServizi.add(idServizio);
    }

    public void addPermessi(PermessiUtenteOperatore p) throws CoreException {
        for (IDSoggetto idSoggetto : p.listIDSoggetti) {
            this.addSoggetto(idSoggetto);
        }
        for (IDServizio idServizio : p.listIDServizi) {
            this.addServizio(idServizio);
        }
    }

    public void addPermessiSoggetti(PermessiUtenteOperatore p) throws CoreException {
        for (IDSoggetto idSoggetto : p.listIDSoggetti) {
            this.addSoggetto(idSoggetto);
        }
    }

    public void addPermessiServizi(PermessiUtenteOperatore p) throws CoreException {
        for (IDServizio idServizio : p.listIDServizi) {
            this.addServizio(idServizio);
        }
    }

    public List<IDServizio> getListIDServizi() {
        return this.listIDServizi;
    }

    public List<IDSoggetto> getListIDSoggetti() {
        return this.listIDSoggetti;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        if (this.listIDSoggetti.size() > 0) {
            for (IDSoggetto idSoggetto : this.listIDSoggetti) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                bf.append(idSoggetto.toString());
            }
        }
        if (this.listIDServizi.size() > 0) {
            for (IDServizio idServizio : this.listIDServizi) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                bf.append(idServizio.toString());
            }
        }
        return bf.toString();
    }

    public IExpression toExpression(IExpressionConstructor exprConstructor, IField fieldIdentificativoPorta, IField fieldTipoSoggettoErogatore, IField fieldNomeSoggettoErogatore, IField fieldTipoServizio, IField fieldNomeServizio, IField fieldVersioneServizio) throws CoreException {
        boolean includeTransazioniSenzaIdentificativoPorta = false;
        return this.toExpression(exprConstructor, fieldIdentificativoPorta, fieldTipoSoggettoErogatore, fieldNomeSoggettoErogatore, fieldTipoServizio, fieldNomeServizio, fieldVersioneServizio, includeTransazioniSenzaIdentificativoPorta);
    }

    public IExpression toExpression(IExpressionConstructor exprConstructor, IField fieldIdentificativoPorta, IField fieldTipoSoggettoErogatore, IField fieldNomeSoggettoErogatore, IField fieldTipoServizio, IField fieldNomeServizio, IField fieldVersioneServizio, boolean includeTransazioniSenzaIdentificativoPorta) throws CoreException {
        try {
            IExpression expr = exprConstructor.newExpression();
            expr.or();
            if (includeTransazioniSenzaIdentificativoPorta) {
                expr.isNull(fieldIdentificativoPorta);
                expr.equals(fieldIdentificativoPorta, (Object)"-");
            }
            if (this.listIDSoggetti.size() > 0) {
                ArrayList<String> identificativiPorta = new ArrayList<String>();
                for (IDSoggetto idSoggetto : this.listIDSoggetti) {
                    identificativiPorta.add(idSoggetto.getCodicePorta());
                }
                expr.in(fieldIdentificativoPorta, identificativiPorta);
            }
            if (this.listIDServizi.size() > 0) {
                ArrayList<IExpression> servizi = new ArrayList<IExpression>();
                for (IDServizio idServizio : this.listIDServizi) {
                    IExpression exprServ = exprConstructor.newExpression();
                    exprServ.and();
                    exprServ.isNotNull(fieldTipoSoggettoErogatore);
                    exprServ.equals(fieldTipoSoggettoErogatore, (Object)idServizio.getSoggettoErogatore().getTipo());
                    exprServ.isNotNull(fieldNomeSoggettoErogatore);
                    exprServ.equals(fieldNomeSoggettoErogatore, (Object)idServizio.getSoggettoErogatore().getNome());
                    exprServ.isNotNull(fieldTipoServizio);
                    exprServ.equals(fieldTipoServizio, (Object)idServizio.getTipo());
                    exprServ.isNotNull(fieldNomeServizio);
                    exprServ.equals(fieldNomeServizio, (Object)idServizio.getNome());
                    exprServ.isNotNull(fieldVersioneServizio);
                    exprServ.equals(fieldVersioneServizio, (Object)idServizio.getVersione());
                    servizi.add(exprServ);
                }
                expr.or(servizi.toArray(new IExpression[1]));
            }
            return expr;
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    public IExpression toExpressionAllarmi(IExpressionConstructor exprConstructor, IField fieldTipoMittente, IField fieldMittente, IField fieldTipoDestinatario, IField fieldDestinatario, IField fieldTipoServizio, IField fieldNomeServizio, IField fieldVersioneServizio) throws CoreException {
        try {
            IExpression expr = exprConstructor.newExpression();
            expr.or();
            if (this.listIDSoggetti.size() > 0) {
                IExpression mittenteQualsiasiExpr = exprConstructor.newExpression();
                mittenteQualsiasiExpr.and();
                mittenteQualsiasiExpr.isNull(fieldTipoMittente);
                mittenteQualsiasiExpr.isNull(fieldMittente);
                IExpression destinatarioQualsiasiExpr = exprConstructor.newExpression();
                destinatarioQualsiasiExpr.and();
                destinatarioQualsiasiExpr.isNull(fieldTipoDestinatario);
                destinatarioQualsiasiExpr.isNull(fieldDestinatario);
                IExpression soggettiGestioneExpr = exprConstructor.newExpression();
                soggettiGestioneExpr.or();
                IExpression destinatarioExpr = exprConstructor.newExpression();
                destinatarioExpr.or();
                for (IDSoggetto idSoggetto : this.listIDSoggetti) {
                    HashMap<IField, String> destSoggetto = new HashMap<IField, String>();
                    destSoggetto.put(fieldTipoDestinatario, idSoggetto.getTipo());
                    destSoggetto.put(fieldDestinatario, idSoggetto.getNome());
                    destinatarioExpr.allEquals(destSoggetto);
                }
                soggettiGestioneExpr.and(mittenteQualsiasiExpr, destinatarioExpr);
                IExpression mittenteExpr = exprConstructor.newExpression();
                mittenteExpr.or();
                for (IDSoggetto idSoggetto : this.listIDSoggetti) {
                    HashMap<IField, String> mittSoggetto = new HashMap<IField, String>();
                    mittSoggetto.put(fieldTipoMittente, idSoggetto.getTipo());
                    mittSoggetto.put(fieldMittente, idSoggetto.getNome());
                    mittenteExpr.allEquals(mittSoggetto);
                }
                soggettiGestioneExpr.and(destinatarioQualsiasiExpr, mittenteExpr);
                soggettiGestioneExpr.and(mittenteExpr, destinatarioExpr);
                expr.or(new IExpression[]{soggettiGestioneExpr});
            }
            if (this.listIDServizi.size() > 0) {
                ArrayList<IExpression> servizi = new ArrayList<IExpression>();
                for (IDServizio idServizio : this.listIDServizi) {
                    IExpression exprServ = exprConstructor.newExpression();
                    exprServ.and();
                    exprServ.isNotNull(fieldTipoDestinatario);
                    exprServ.equals(fieldTipoDestinatario, (Object)idServizio.getSoggettoErogatore().getTipo());
                    exprServ.isNotNull(fieldDestinatario);
                    exprServ.equals(fieldDestinatario, (Object)idServizio.getSoggettoErogatore().getNome());
                    exprServ.isNotNull(fieldTipoServizio);
                    exprServ.equals(fieldTipoServizio, (Object)idServizio.getTipo());
                    exprServ.isNotNull(fieldNomeServizio);
                    exprServ.equals(fieldNomeServizio, (Object)idServizio.getNome());
                    exprServ.isNotNull(fieldVersioneServizio);
                    exprServ.equals(fieldVersioneServizio, (Object)idServizio.getVersione());
                    servizi.add(exprServ);
                }
                expr.or(servizi.toArray(new IExpression[1]));
            }
            return expr;
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    public IExpression toExpressionConfigurazioneServizi(IExpressionConstructor exprConstructor, IField fieldTipoSoggetto, IField fieldNomeSoggetto, IField fieldTipoSoggettoErogatore, IField fieldNomeSoggettoErogatore, IField fieldTipoServizio, IField fieldNomeServizio, IField fieldVersioneServizio, boolean setNotNull) throws CoreException {
        try {
            IExpression expr = exprConstructor.newExpression();
            expr.or();
            if (this.listIDSoggetti.size() > 0) {
                ArrayList<IExpression> soggetti = new ArrayList<IExpression>();
                for (IDSoggetto idSoggetto : this.listIDSoggetti) {
                    IExpression exprSogg = exprConstructor.newExpression();
                    exprSogg.and();
                    if (setNotNull) {
                        exprSogg.isNotNull(fieldTipoSoggetto);
                    }
                    exprSogg.equals(fieldTipoSoggetto, (Object)idSoggetto.getTipo());
                    if (setNotNull) {
                        exprSogg.isNotNull(fieldNomeSoggetto);
                    }
                    exprSogg.equals(fieldNomeSoggetto, (Object)idSoggetto.getNome());
                    soggetti.add(exprSogg);
                }
                if (soggetti.size() > 0) {
                    expr.or(soggetti.toArray(new IExpression[1]));
                }
            }
            if (this.listIDServizi.size() > 0) {
                ArrayList<IExpression> servizi = new ArrayList<IExpression>();
                for (IDServizio idServizio : this.listIDServizi) {
                    IExpression exprServ = exprConstructor.newExpression();
                    exprServ.and();
                    if (setNotNull) {
                        exprServ.isNotNull(fieldTipoSoggettoErogatore);
                    }
                    exprServ.equals(fieldTipoSoggettoErogatore, (Object)idServizio.getSoggettoErogatore().getTipo());
                    if (setNotNull) {
                        exprServ.isNotNull(fieldNomeSoggettoErogatore);
                    }
                    exprServ.equals(fieldNomeSoggettoErogatore, (Object)idServizio.getSoggettoErogatore().getNome());
                    if (setNotNull) {
                        exprServ.isNotNull(fieldTipoServizio);
                    }
                    exprServ.equals(fieldTipoServizio, (Object)idServizio.getTipo());
                    if (setNotNull) {
                        exprServ.isNotNull(fieldNomeServizio);
                    }
                    exprServ.equals(fieldNomeServizio, (Object)idServizio.getNome());
                    if (setNotNull) {
                        exprServ.isNotNull(fieldVersioneServizio);
                    }
                    exprServ.equals(fieldVersioneServizio, (Object)idServizio.getVersione());
                    servizi.add(exprServ);
                }
                if (servizi.size() > 0) {
                    expr.or(servizi.toArray(new IExpression[1]));
                }
            }
            return expr;
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    public IExpression toExpressionStatistichePdndTracing(IExpressionConstructor exprConstructor, IField fieldIdentificativoPorta) throws CoreException {
        try {
            IExpression expr = exprConstructor.newExpression();
            expr.or();
            if (!this.listIDSoggetti.isEmpty()) {
                ArrayList<String> identificativiPorta = new ArrayList<String>();
                for (IDSoggetto idSoggetto : this.listIDSoggetti) {
                    identificativiPorta.add(idSoggetto.getCodicePorta());
                }
                expr.in(fieldIdentificativoPorta, identificativiPorta);
            }
            return expr;
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    public static PermessiUtenteOperatore getPermessiUtenteOperatore(UserDetailsBean u, String tipoSoggettoLocale, String nomeSoggettoLocale) throws CoreException {
        if (u.isAdmin()) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)nomeSoggettoLocale)) {
            // empty if block
        }
        return PermessiUtenteOperatore.getPermessiUtenteOperatore(u, null, null, null, null, null);
    }

    public static PermessiUtenteOperatore getPermessiUtenteOperatore(UserDetailsBean u, String tipoSoggettoLocale, String nomeSoggettoLocale, String tipoServizio, String nomeServizio, Integer versioneServizio) throws CoreException {
        boolean found;
        if (StringUtils.isNotEmpty((String)nomeSoggettoLocale) && StringUtils.isEmpty((String)nomeServizio) && !u.isAdmin()) {
            found = false;
            for (IDSoggetto utenteSoggetto : u.getUtenteSoggettoList()) {
                if (!utenteSoggetto.getTipo().equals(tipoSoggettoLocale) || !utenteSoggetto.getNome().equals(nomeSoggettoLocale)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new CoreException("L'utente '" + u.getUsername() + "' non ha i diritti necessari per esaminare le informazioni diagnostiche del soggetto " + tipoSoggettoLocale + "/" + nomeSoggettoLocale);
            }
        }
        if (StringUtils.isNotEmpty((String)nomeServizio) && !u.isAdmin()) {
            found = false;
            if (StringUtils.isNotEmpty((String)nomeSoggettoLocale)) {
                for (IDServizio idServizio : u.getUtenteServizioList()) {
                    if (!idServizio.getSoggettoErogatore().getTipo().equals(tipoSoggettoLocale) || !idServizio.getSoggettoErogatore().getNome().equals(nomeSoggettoLocale) || !idServizio.getTipo().equals(tipoServizio) || !idServizio.getNome().equals(nomeServizio) || idServizio.getVersione().intValue() != versioneServizio.intValue()) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new CoreException("L'utente '" + u.getUsername() + "' non ha i diritti necessari per esaminare le informazioni diagnostiche del servizio " + tipoServizio + "/" + nomeServizio + " erogato dal soggetto " + tipoSoggettoLocale + "/" + nomeSoggettoLocale);
                }
            } else {
                throw new CoreException("Utilizzo del metodo non valido. Se viene indicato il servizio deve anche essere indicato il soggeto erogatore");
            }
        }
        if (StringUtils.isNotEmpty((String)nomeSoggettoLocale) || StringUtils.isNotEmpty((String)nomeServizio)) {
            String idPorta = Utility.getIdentificativoPorta(tipoSoggettoLocale, nomeSoggettoLocale);
            PermessiUtenteOperatore permessi = new PermessiUtenteOperatore();
            IDSoggetto idSoggetto = new IDSoggetto(tipoSoggettoLocale, nomeSoggettoLocale, idPorta);
            if (StringUtils.isNotEmpty((String)nomeServizio)) {
                IDServizio idServizio = new IDServizio();
                idServizio.setSoggettoErogatore(idSoggetto);
                idServizio.setTipo(tipoServizio);
                idServizio.setNome(nomeServizio);
                idServizio.setVersione(versioneServizio);
                permessi.addServizio(idServizio);
            } else {
                permessi.addSoggetto(idSoggetto);
            }
            return permessi;
        }
        if (u.isAdmin()) {
            return null;
        }
        PermessiUtenteOperatore permessi = new PermessiUtenteOperatore();
        for (IDSoggetto idSoggetto : u.getUtenteSoggettoList()) {
            permessi.addSoggetto(idSoggetto);
        }
        for (IDServizio idServizio : u.getUtenteServizioList()) {
            permessi.addServizio(idServizio);
        }
        return permessi;
    }
}

