/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.dao;

import java.sql.Connection;
import java.util.Properties;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.commons.search.IdSoggetto;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.dao.IServiceManager;
import org.openspcoop2.core.commons.search.dao.ISoggettoServiceSearch;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.utils.IVersionInfo;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.VersionUtilities;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.CryptFactory;
import org.openspcoop2.utils.crypt.ICrypt;
import org.openspcoop2.web.lib.mvc.login.FailedAttempts;
import org.openspcoop2.web.lib.mvc.login.LoginException;
import org.openspcoop2.web.lib.users.DriverUsersDB;
import org.openspcoop2.web.lib.users.DriverUsersDBException;
import org.openspcoop2.web.lib.users.ProjectInfo;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.monitor.core.bean.UserDetailsBean;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.dao.ILoginDAO;
import org.openspcoop2.web.monitor.core.exception.UserInvalidException;
import org.slf4j.Logger;

public class DBLoginDAO
implements ILoginDAO {
    private static final long serialVersionUID = 2911265067726812578L;
    private static Logger log = LoggerWrapperFactory.getLogger(DBLoginDAO.class);
    private transient DriverUsersDB utenteDAO;
    private transient ISoggettoServiceSearch soggettoDAO;
    private transient IServiceManager utilsServiceManager;
    private transient DriverConfigurazioneDB driverConfigDB = null;
    private transient ICrypt passwordManager;
    private transient ICrypt passwordManagerBackwardCompatibility;
    public static final String UTENZA_BLOCCATA = "Utenza bloccata, superato il numero di tentativi di accesso massimo!";

    public void setPasswordManager(CryptConfig config) throws UtilsException {
        this.passwordManager = CryptFactory.getCrypt((Logger)log, (CryptConfig)config);
        if (config.isBackwardCompatibility()) {
            this.passwordManagerBackwardCompatibility = CryptFactory.getOldMD5Crypt((Logger)log);
        }
    }

    public DBLoginDAO() {
        try {
            this.utenteDAO = (DriverUsersDB)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance());
            this.utilsServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            this.soggettoDAO = this.utilsServiceManager.getSoggettoServiceSearch();
            String tipoDatabase = DAOFactoryProperties.getInstance((Logger)log).getTipoDatabase((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            String datasourceJNDIName = DAOFactoryProperties.getInstance((Logger)log).getDatasourceJNDIName((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            Properties datasourceJNDIContext = DAOFactoryProperties.getInstance((Logger)log).getDatasourceJNDIContext((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            this.driverConfigDB = new DriverConfigurazioneDB(datasourceJNDIName, datasourceJNDIContext, log, tipoDatabase);
            PddMonitorProperties pddMonitorProperties = PddMonitorProperties.getInstance(log);
            CryptConfig config = new CryptConfig(pddMonitorProperties.getUtentiPassword());
            this.passwordManager = CryptFactory.getCrypt((Logger)log, (CryptConfig)config);
            if (config.isBackwardCompatibility()) {
                this.passwordManagerBackwardCompatibility = CryptFactory.getOldMD5Crypt((Logger)log);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public DBLoginDAO(Connection con, boolean autoCommit) {
        this(con, autoCommit, null, log);
    }

    public DBLoginDAO(Connection con, boolean autoCommit, Logger log) {
        this(con, autoCommit, null, log);
    }

    public DBLoginDAO(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties) {
        this(con, autoCommit, serviceManagerProperties, log);
    }

    public DBLoginDAO(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties, Logger log) {
        try {
            this.utenteDAO = (DriverUsersDB)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, log);
            this.utilsServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, log);
            this.soggettoDAO = this.utilsServiceManager.getSoggettoServiceSearch();
            String tipoDatabase = null;
            tipoDatabase = serviceManagerProperties != null ? serviceManagerProperties.getDatabaseType() : DAOFactoryProperties.getInstance((Logger)log).getTipoDatabase((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            this.driverConfigDB = new DriverConfigurazioneDB(con, DBLoginDAO.log, tipoDatabase);
        }
        catch (Exception e) {
            DBLoginDAO.log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean login(String username, String pwd) throws ServiceException, LoginException {
        try {
            boolean existsUser = this.utenteDAO.existsUser(username);
            if (!existsUser) {
                throw new NotFoundException("Utente [" + username + "] non registrato");
            }
            User u = this.utenteDAO.getUser(username);
            boolean bloccaUtente = FailedAttempts.getInstance().bloccaUtente(log, username);
            if (bloccaUtente) {
                throw new LoginException(UTENZA_BLOCCATA);
            }
            boolean trovato = this.passwordManager.check(pwd, u.getPassword());
            if (!trovato && this.passwordManagerBackwardCompatibility != null) {
                trovato = this.passwordManagerBackwardCompatibility.check(pwd, u.getPassword());
            }
            if (!trovato) {
                FailedAttempts.getInstance().aggiungiTentativoFallitoUtente(log, username);
            } else {
                FailedAttempts.getInstance().resetTentativiUtente(log, username);
            }
            return trovato;
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (DriverUsersDBException e) {
            throw this.serviceException((Exception)((Object)e));
        }
    }

    @Override
    public Soggetto getSoggetto(IdSoggetto idSog) {
        try {
            return (Soggetto)this.soggettoDAO.find(this.soggettoDAO.newExpression().equals(Soggetto.model().NOME_SOGGETTO, (Object)idSog.getNome()).and().equals(Soggetto.model().TIPO_SOGGETTO, (Object)idSog.getTipo()));
        }
        catch (ExpressionException | ExpressionNotImplementedException | MultipleResultException | NotFoundException | NotImplementedException | ServiceException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public void salvaUtente(User user) throws NotFoundException, ServiceException {
        try {
            boolean existsUser = this.utenteDAO.existsUser(user.getLogin());
            if (!existsUser) {
                throw new NotFoundException("Utente [" + user.getLogin() + "] non registrato");
            }
            this.utenteDAO.updateUser(user);
        }
        catch (DriverUsersDBException e) {
            throw this.serviceException((Exception)((Object)e));
        }
    }

    @Override
    public void salvaModalita(User user) throws NotFoundException, ServiceException {
        try {
            boolean existsUser = this.utenteDAO.existsUser(user.getLogin());
            if (!existsUser) {
                throw new NotFoundException("Utente [" + user.getLogin() + "] non registrato");
            }
            this.utenteDAO.saveProtocolloUtilizzatoPddMonitor(user.getLogin(), user.getProtocolloSelezionatoPddMonitor());
        }
        catch (DriverUsersDBException e) {
            throw this.serviceException((Exception)((Object)e));
        }
    }

    @Override
    public void salvaSoggettoPddMonitor(User user) throws NotFoundException, ServiceException {
        try {
            boolean existsUser = this.utenteDAO.existsUser(user.getLogin());
            if (!existsUser) {
                throw new NotFoundException("Utente [" + user.getLogin() + "] non registrato");
            }
            this.utenteDAO.saveSoggettoUtilizzatoPddMonitor(user.getLogin(), user.getSoggettoSelezionatoPddMonitor());
        }
        catch (DriverUsersDBException e) {
            throw this.serviceException((Exception)((Object)e));
        }
    }

    @Override
    public UserDetailsBean loadUserByUsername(String username) throws NotFoundException, ServiceException, UserInvalidException {
        return this.loadUserByUsername(username, true);
    }

    public UserDetailsBean loadUserByUsername(String username, boolean check) throws NotFoundException, ServiceException, UserInvalidException {
        String msg = "cerco utente " + username;
        log.debug(msg);
        try {
            boolean existsUser = this.utenteDAO.existsUser(username);
            if (!existsUser) {
                throw new NotFoundException("Utente [" + username + "] non registrato");
            }
            User u = this.utenteDAO.getUser(username);
            UserDetailsBean details = new UserDetailsBean();
            details.setUtente(u, check);
            return details;
        }
        catch (NotFoundException | UserInvalidException e) {
            log.error(e.getMessage(), e);
            throw e;
        }
        catch (DriverUsersDBException e) {
            throw this.serviceException((Exception)((Object)e));
        }
    }

    @Override
    public Configurazione readConfigurazioneGenerale() throws ServiceException {
        try {
            return this.driverConfigDB.getConfigurazioneGenerale();
        }
        catch (Exception e) {
            throw this.serviceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IVersionInfo readVersionInfo() throws ServiceException {
        IVersionInfo vInfo = null;
        try {
            vInfo = VersionUtilities.readInfoVersion();
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
        if (vInfo != null) {
            Connection con = null;
            try {
                con = this.driverConfigDB.getConnection("readVersionInfo");
                String tipoDatabase = DAOFactoryProperties.getInstance((Logger)log).getTipoDatabase((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
                vInfo.init(log, new Object[]{con, tipoDatabase});
                IVersionInfo iVersionInfo = vInfo;
                return iVersionInfo;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.driverConfigDB.releaseConnection(con);
            }
        }
        return null;
    }

    private ServiceException serviceException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return new ServiceException((Throwable)e);
    }
}

