/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.datamodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SerializableDataModel;
import org.openspcoop2.generic_project.dao.IServiceSearchWithId;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.web.monitor.core.constants.Costanti;
import org.openspcoop2.web.monitor.core.dao.IService;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.slf4j.Logger;

public abstract class BaseDataModel<K, T, D>
extends SerializableDataModel {
    private static final long serialVersionUID = 8413193446969383169L;
    private static Logger log = LoggerWrapperFactory.getLogger(BaseDataModel.class);
    private transient D dataProvider;
    protected boolean detached = false;
    protected K currentPk;
    protected Map<K, T> wrappedData = new HashMap<K, T>();
    protected List<K> wrappedKeys = null;
    protected Integer rowCount;
    protected IExpression countFilter = null;
    protected Integer currentPage = 1;
    protected Integer rowsToDisplay = 25;
    protected Integer currentSearchSize = 0;

    public void update() {
        this.detached = false;
    }

    public Object getRowKey() {
        return this.currentPk;
    }

    public void setRowKey(Object key) {
        this.currentPk = key;
    }

    public abstract void walk(FacesContext var1, DataVisitor var2, Range var3, Object var4) throws IOException;

    public int getRowCount() {
        try {
            this.checkDataProvider();
            if (this.rowCount == null) {
                if (this.dataProvider instanceof IService) {
                    this.rowCount = this._executeTotalCountWithIService((IService)this.dataProvider);
                }
                if (this.dataProvider instanceof IServiceSearchWithId) {
                    IExpression filter = null;
                    filter = this.countFilter == null ? ((IServiceSearchWithId)this.dataProvider).newExpression() : this.countFilter;
                    this.rowCount = (int)((IServiceSearchWithId)this.dataProvider).count(filter).longValue();
                }
            }
            return this.rowCount != null ? this.rowCount : 0;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    protected int _executeTotalCountWithIService(IService<?, ?> service) throws Exception {
        return service.totalCount();
    }

    public Object getRowData() {
        try {
            this.checkDataProvider();
            if (this.currentPk == null) {
                return null;
            }
            Object m = this.wrappedData.get(this.currentPk);
            if (m == null) {
                if (this.dataProvider instanceof IService) {
                    m = ((IService)this.dataProvider).findById(this.currentPk);
                }
                if (this.dataProvider instanceof IServiceSearchWithId) {
                    m = ((IServiceSearchWithId)this.dataProvider).get(this.currentPk);
                }
                this.wrappedData.put(this.currentPk, m);
            }
            return m;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int getRowIndex() {
        return 0;
    }

    public Object getWrappedData() {
        throw new UnsupportedOperationException();
    }

    public boolean isRowAvailable() {
        if (this.wrappedData.isEmpty()) {
            return false;
        }
        boolean isAvailable = this.wrappedData.containsKey(this.currentPk);
        return isAvailable;
    }

    public void setRowIndex(int arg0) {
        log.debug("called setRowIndex " + arg0);
    }

    public void setWrappedData(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public D getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(D dataProvider) {
        this.dataProvider = dataProvider;
    }

    public SerializableDataModel getSerializableModel(Range range) {
        if (this.wrappedKeys != null) {
            this.detached = true;
            return this;
        }
        return null;
    }

    private void checkDataProvider() throws Exception {
        if (this.dataProvider instanceof IService) {
            return;
        }
        if (this.dataProvider instanceof IServiceSearchWithId) {
            return;
        }
        throw new Exception("DataProvider [" + this.dataProvider.getClass().getCanonicalName() + "] sconosciuto, non so come gestirlo.");
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getRowsToDisplay() {
        return this.rowsToDisplay;
    }

    public void setRowsToDisplay(Integer rowsToDisplay) {
        this.rowsToDisplay = rowsToDisplay;
    }

    public void rowsToDisplaySelected(ActionEvent ae) {
    }

    public List<SelectItem> getListaNumeroRisultati() {
        return Costanti.SELECT_ITEM_ENTRIES;
    }

    public Integer getNumeroMassimoRisultati() {
        return Costanti.SELECT_ITEM_VALORE_MASSIMO_ENTRIES;
    }

    public String getNumeroMassimoRisultatiLabel() {
        return MessageManager.getInstance().getMessageWithParamsFromResourceBundle("commons.search.selezionaNumeroMassimoEntries.label", Costanti.SELECT_ITEM_VALORE_MASSIMO_ENTRIES);
    }

    public String getSelezionatiPrimiElementiLabel() {
        return MessageManager.getInstance().getMessageWithParamsFromResourceBundle("commons.search.selezionatiPrimiElementi.label", Costanti.SELECT_ITEM_VALORE_MASSIMO_ENTRIES);
    }

    public Integer getCurrentSearchSize() {
        if (this.wrappedData != null) {
            this.currentSearchSize = this.wrappedData.size();
        }
        return this.currentSearchSize;
    }

    public void setCurrentSearchSize(Integer currentSearchSize) {
        this.currentSearchSize = currentSearchSize;
    }

    public boolean isVisualizzaSelezionePrimiElementi() {
        if (this.getRowsToDisplay().intValue() == this.getNumeroMassimoRisultati().intValue()) {
            return false;
        }
        if (this.getCurrentPage() == null) {
            return false;
        }
        int currentPage = this.getCurrentPage();
        return currentPage > 1 || currentPage == 1 && this.getCurrentSearchSize() != null && this.getRowsToDisplay() != null && this.getCurrentSearchSize().intValue() == this.getRowsToDisplay().intValue();
    }

    public void setVisualizzaSelezionePrimiElementi(boolean b) {
    }
}

