/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.datamodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.ajax4jsf.model.SerializableDataModel;
import org.openspcoop2.generic_project.dao.IServiceSearchWithId;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.web.monitor.core.bean.AbstractCoreSearchForm;
import org.openspcoop2.web.monitor.core.constants.Costanti;
import org.openspcoop2.web.monitor.core.dao.ISearchFormService;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.slf4j.Logger;

public abstract class BaseDataModelWithSearchForm<K, T, D, S extends AbstractCoreSearchForm>
extends SerializableDataModel {
    private static final long serialVersionUID = 8413193446969383169L;
    private static Logger log = LoggerWrapperFactory.getLogger(BaseDataModelWithSearchForm.class);
    protected transient D dataProvider;
    protected boolean detached = false;
    protected K currentPk;
    protected Map<K, T> wrappedData = new HashMap<K, T>();
    protected List<K> wrappedKeys = null;
    protected Integer rowCount;
    protected IExpression countFilter = null;
    protected Integer currentPage = 1;
    protected Integer rowsToDisplay = 25;
    protected S search;
    protected Integer currentSearchSize;
    private boolean firstEnabled = false;
    private boolean prevEnabled = false;
    private boolean nextEnabled = false;

    public void update() {
        this.detached = false;
        this.wrappedKeys = null;
        log.trace("update numero entries richieste: [" + this.rowsToDisplay + "], detached [" + this.detached + "] wrappedKeys [" + this.wrappedKeys + "] ID[" + ((Object)((Object)this)).toString() + "]");
        if (this.dataProvider != null && this.dataProvider instanceof ISearchFormService && ((ISearchFormService)this.dataProvider).getSearch() != null) {
            ((AbstractCoreSearchForm)((ISearchFormService)this.dataProvider).getSearch()).setDetached(this.detached);
            ((AbstractCoreSearchForm)((ISearchFormService)this.dataProvider).getSearch()).setWrappedKeys(this.wrappedKeys);
        }
    }

    public Object getRowKey() {
        return this.currentPk;
    }

    public void setRowKey(Object key) {
        this.currentPk = key;
    }

    public abstract K getId(T var1);

    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) throws IOException {
        try {
            this.checkDataProvider();
            AbstractCoreSearchForm searchForm = null;
            if (this.dataProvider instanceof ISearchFormService) {
                searchForm = (AbstractCoreSearchForm)((ISearchFormService)this.dataProvider).getSearch();
                boolean usaBuffer = this.detached || this.wrappedKeys != null;
                log.trace("walk numero entries richieste: [" + this.rowsToDisplay + "], usaBuffer [" + usaBuffer + "] ID[" + ((Object)((Object)this)).toString() + "]");
                if (usaBuffer) {
                    for (Object key : searchForm.getWrappedKeys()) {
                        this.setRowKey(key);
                        visitor.process(context, key, argument);
                    }
                } else {
                    int start = 0;
                    int limit = 0;
                    if (searchForm.isUseCount()) {
                        if (searchForm.isRestoreSearch()) {
                            start = searchForm.getStart();
                            limit = searchForm.getLimit();
                            searchForm.setRestoreSearch(false);
                            int pageIndex = start / limit + 1;
                            searchForm.setCurrentPage(pageIndex);
                        } else {
                            start = ((SequenceRange)range).getFirstRow();
                            limit = ((SequenceRange)range).getRows();
                        }
                        searchForm.setStart(start);
                        searchForm.setLimit(limit);
                    } else {
                        start = searchForm.getStart();
                        limit = searchForm.getLimit();
                    }
                    log.trace("walk numero entries richieste: [" + this.rowsToDisplay + "], Start [" + start + "]. Limit [" + limit + "] ID[" + ((Object)((Object)this)).toString() + "]");
                    List<T> bufferList = this.findObjects(start, limit, null, null);
                    this.currentSearchSize = bufferList != null ? bufferList.size() : 0;
                    searchForm.setCurrentSearchSize(this.currentSearchSize);
                    this.wrappedKeys = new ArrayList<K>();
                    if (bufferList != null) {
                        for (T obj : bufferList) {
                            this.wrappedData.put(this.getId(obj), obj);
                            this.wrappedKeys.add(this.getId(obj));
                            visitor.process(context, this.getId(obj), argument);
                        }
                    }
                    searchForm.setWrappedKeys(this.wrappedKeys);
                }
            } else {
                boolean usaBuffer = this.detached || this.wrappedKeys != null;
                log.trace("walk numero entries richieste: [" + this.rowsToDisplay + "], usaBuffer [" + usaBuffer + "] ID[" + ((Object)((Object)this)).toString() + "]");
                if (usaBuffer) {
                    for (K key : this.wrappedKeys) {
                        this.setRowKey(key);
                        visitor.process(context, key, argument);
                    }
                } else {
                    int start = 0;
                    int limit = 0;
                    start = ((SequenceRange)range).getFirstRow();
                    List<T> bufferList = this.findObjects(start, limit = ((SequenceRange)range).getRows(), null, null);
                    this.currentSearchSize = bufferList != null ? bufferList.size() : 0;
                    this.wrappedKeys = new ArrayList<K>();
                    if (bufferList != null) {
                        for (T obj : bufferList) {
                            this.wrappedData.put(this.getId(obj), obj);
                            this.wrappedKeys.add(this.getId(obj));
                            visitor.process(context, this.getId(obj), argument);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Errore durante la walk: " + e.getMessage(), (Throwable)e);
        }
    }

    public int getRowCount() {
        try {
            this.checkDataProvider();
            if (this.rowCount == null) {
                if (this.dataProvider instanceof ISearchFormService) {
                    this.rowCount = this._executeTotalCountWithIService((ISearchFormService)this.dataProvider);
                }
                if (this.dataProvider instanceof IServiceSearchWithId) {
                    IExpression filter = null;
                    filter = this.countFilter == null ? ((IServiceSearchWithId)this.dataProvider).newExpression() : this.countFilter;
                    this.rowCount = (int)((IServiceSearchWithId)this.dataProvider).count(filter).longValue();
                }
            }
            return this.rowCount != null ? this.rowCount : 0;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    protected int _executeTotalCountWithIService(ISearchFormService<T, K, S> service) throws Exception {
        if (((AbstractCoreSearchForm)service.getSearch()).isUseCount()) {
            if (((AbstractCoreSearchForm)service.getSearch()).isExecuteQuery()) {
                return service.totalCount();
            }
            return 0;
        }
        return this.rowsToDisplay;
    }

    protected abstract List<T> findObjects(int var1, int var2, String var3, SortOrder var4);

    public Object getRowData() {
        try {
            this.checkDataProvider();
            if (this.currentPk == null) {
                return null;
            }
            Object m = this.wrappedData.get(this.currentPk);
            if (m == null) {
                if (this.dataProvider instanceof ISearchFormService) {
                    m = ((ISearchFormService)this.dataProvider).findById(this.currentPk);
                }
                if (this.dataProvider instanceof IServiceSearchWithId) {
                    m = ((IServiceSearchWithId)this.dataProvider).get(this.currentPk);
                }
                this.wrappedData.put(this.currentPk, m);
            }
            return m;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int getRowIndex() {
        return 0;
    }

    public Object getWrappedData() {
        throw new UnsupportedOperationException();
    }

    public boolean isRowAvailable() {
        if (this.wrappedData.isEmpty()) {
            return false;
        }
        boolean isAvailable = this.wrappedData.containsKey(this.currentPk);
        return isAvailable;
    }

    public void setRowIndex(int arg0) {
        log.debug("called setRowIndex " + arg0);
    }

    public void setWrappedData(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public D getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(D dataProvider) {
        this.dataProvider = dataProvider;
    }

    public SerializableDataModel getSerializableModel(Range range) {
        if (this.wrappedKeys != null) {
            this.detached = true;
            if (this.dataProvider instanceof ISearchFormService) {
                ((AbstractCoreSearchForm)((ISearchFormService)this.dataProvider).getSearch()).setDetached(this.detached);
            }
            return this;
        }
        return null;
    }

    protected void checkDataProvider() throws Exception {
        if (this.dataProvider instanceof ISearchFormService) {
            return;
        }
        if (this.dataProvider instanceof IServiceSearchWithId) {
            return;
        }
        throw new Exception("DataProvider [" + this.dataProvider.getClass().getCanonicalName() + "] sconosciuto, non so come gestirlo.");
    }

    public Integer getCurrentPage() {
        if (this.dataProvider != null && this.dataProvider instanceof ISearchFormService && ((ISearchFormService)this.dataProvider).getSearch() != null) {
            return ((AbstractCoreSearchForm)((ISearchFormService)this.dataProvider).getSearch()).getCurrentPage();
        }
        return this.currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        Object searchForm;
        this.currentPage = currentPage;
        if (this.dataProvider != null && this.dataProvider instanceof ISearchFormService && (searchForm = ((ISearchFormService)this.dataProvider).getSearch()) != null) {
            ((AbstractCoreSearchForm)searchForm).setCurrentPage(currentPage);
            Integer limit = ((AbstractCoreSearchForm)searchForm).getLimit();
            int start = limit * (currentPage - 1);
            ((AbstractCoreSearchForm)searchForm).setStart(start);
        }
    }

    public String nextPage() {
        Integer currentPage = this.getCurrentPage();
        if (currentPage != null) {
            this.setCurrentPage(currentPage + 1);
        } else {
            this.setCurrentPage(1);
        }
        this.update();
        return null;
    }

    public String prevPage() {
        Integer currentPage = this.getCurrentPage();
        if (currentPage != null) {
            this.setCurrentPage(currentPage - 1);
        } else {
            this.setCurrentPage(1);
        }
        this.update();
        return null;
    }

    public String firstPage() {
        this.setCurrentPage(1);
        this.update();
        return null;
    }

    public boolean isFirstEnabled() {
        if (this.dataProvider != null && this.dataProvider instanceof ISearchFormService && ((ISearchFormService)this.dataProvider).getSearch() != null) {
            this.firstEnabled = ((AbstractCoreSearchForm)((ISearchFormService)this.dataProvider).getSearch()).getCurrentPage() > 1;
        }
        return this.firstEnabled;
    }

    public void setFirstEnabled(boolean firstEnabled) {
        this.firstEnabled = firstEnabled;
    }

    public boolean isPrevEnabled() {
        if (this.dataProvider != null && this.dataProvider instanceof ISearchFormService && ((ISearchFormService)this.dataProvider).getSearch() != null) {
            this.prevEnabled = ((AbstractCoreSearchForm)((ISearchFormService)this.dataProvider).getSearch()).getCurrentPage() > 1;
        }
        return this.prevEnabled;
    }

    public void setPrevEnabled(boolean prevEnabled) {
        this.prevEnabled = prevEnabled;
    }

    public boolean isNextEnabled() {
        Object searchForm;
        if (this.dataProvider != null && this.dataProvider instanceof ISearchFormService && (searchForm = ((ISearchFormService)this.dataProvider).getSearch()) != null) {
            this.nextEnabled = ((AbstractCoreSearchForm)searchForm).getCurrentSearchSize() != null && ((AbstractCoreSearchForm)searchForm).getCurrentSearchSize().intValue() == ((AbstractCoreSearchForm)searchForm).getLimit().intValue();
        }
        return this.nextEnabled;
    }

    public void setNextEnabled(boolean nextEnabled) {
        this.nextEnabled = nextEnabled;
    }

    public String getRecordLabel() {
        Object searchForm;
        if (this.dataProvider != null && this.dataProvider instanceof ISearchFormService && (searchForm = ((ISearchFormService)this.dataProvider).getSearch()) != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("record [");
            if (((AbstractCoreSearchForm)searchForm).getCurrentSearchSize() > 0) {
                int start = ((AbstractCoreSearchForm)searchForm).getStart() != null ? ((AbstractCoreSearchForm)searchForm).getStart() + 1 : 1;
                int end = ((AbstractCoreSearchForm)searchForm).getStart() != null ? ((AbstractCoreSearchForm)searchForm).getStart() + ((AbstractCoreSearchForm)searchForm).getCurrentSearchSize() : ((AbstractCoreSearchForm)searchForm).getCurrentSearchSize();
                sb.append(start);
                sb.append(" - ");
                sb.append(end);
            } else {
                sb.append("0 - 0");
            }
            sb.append("]");
            return sb.toString();
        }
        return null;
    }

    public void setRecordLabel(String recordLabel) {
    }

    public Integer getRowsToDisplay() {
        if (this.dataProvider != null && this.dataProvider instanceof ISearchFormService && ((ISearchFormService)this.dataProvider).getSearch() != null) {
            return ((AbstractCoreSearchForm)((ISearchFormService)this.dataProvider).getSearch()).getLimit();
        }
        return this.rowsToDisplay;
    }

    public void setRowsToDisplay(Integer rowsToDisplay) {
        Object searchForm;
        this.rowsToDisplay = rowsToDisplay;
        log.trace("setRowsToDisplay numero entries richieste: [" + this.rowsToDisplay + "] ID[" + ((Object)((Object)this)).toString() + "]");
        if (this.dataProvider != null && this.dataProvider instanceof ISearchFormService && (searchForm = ((ISearchFormService)this.dataProvider).getSearch()) != null) {
            ((AbstractCoreSearchForm)searchForm).setLimit(this.rowsToDisplay);
        }
    }

    public void rowsToDisplaySelected(ActionEvent ae) {
        log.trace("rowsToDisplaySelected numero entries richieste: [" + this.rowsToDisplay + "] ID[" + ((Object)((Object)this)).toString() + "]");
        this.firstPage();
    }

    public List<SelectItem> getListaNumeroRisultati() {
        Object searchForm;
        if (this.dataProvider != null && this.dataProvider instanceof ISearchFormService && (searchForm = ((ISearchFormService)this.dataProvider).getSearch()) != null) {
            return ((AbstractCoreSearchForm)searchForm).getListaNumeroRisultati();
        }
        return Costanti.SELECT_ITEM_ENTRIES;
    }

    public Integer getNumeroMassimoRisultati() {
        return Costanti.SELECT_ITEM_VALORE_MASSIMO_ENTRIES;
    }

    public String getNumeroMassimoRisultatiLabel() {
        return MessageManager.getInstance().getMessageWithParamsFromResourceBundle("commons.search.selezionaNumeroMassimoEntries.label", Costanti.SELECT_ITEM_VALORE_MASSIMO_ENTRIES);
    }

    public String getSelezionatiPrimiElementiLabel() {
        return MessageManager.getInstance().getMessageWithParamsFromResourceBundle("commons.search.selezionatiPrimiElementi.label", Costanti.SELECT_ITEM_VALORE_MASSIMO_ENTRIES);
    }

    public Integer getCurrentSearchSize() {
        if (this.dataProvider != null && this.dataProvider instanceof ISearchFormService && ((ISearchFormService)this.dataProvider).getSearch() != null) {
            this.currentSearchSize = ((AbstractCoreSearchForm)((ISearchFormService)this.dataProvider).getSearch()).getCurrentSearchSize();
        }
        return this.currentSearchSize;
    }

    public void setCurrentSearchSize(Integer currentSearchSize) {
        this.currentSearchSize = currentSearchSize;
    }

    public boolean isVisualizzaSelezionePrimiElementi() {
        if (this.getRowsToDisplay().intValue() == this.getNumeroMassimoRisultati().intValue()) {
            return false;
        }
        if (this.getCurrentPage() == null) {
            return false;
        }
        int currentPage = this.getCurrentPage();
        return currentPage > 1 || currentPage == 1 && this.getCurrentSearchSize() != null && this.getRowsToDisplay() != null && this.getCurrentSearchSize().intValue() == this.getRowsToDisplay().intValue();
    }

    public void setVisualizzaSelezionePrimiElementi(boolean b) {
    }
}

