/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.bean.UserDetailsBean;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.core.Utils;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.ContentAuthorizationManager;
import org.slf4j.Logger;

public class ContentAuthorizationFilter
implements Filter {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private FilterConfig filterConfig = null;
    private static final String msgErrorePre = "L'utente ";
    private static final String msgErrorePost = " non dispone delle autorizzazioni necessarie per visualizzare la pagina richiesta";
    private static final String jspErrore = "/commons/pages/welcome.jsf";
    private static final String jspLogin = "/public/login.jsf";
    private static final String msgErroreKey = "acclim";
    private static final String accLimKey = "acclimflag";
    private List<String> excludedPaths = null;

    public void destroy() {
        log.debug("DISTRUIZIONE FILTRO: AuthorizationFilter");
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) {
        String userName = "";
        try {
            UserDetailsBean user;
            LoginBean lb;
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            HttpSession session = request.getSession();
            String urlRichiesta = request.getServletPath();
            log.debug("Richiesta Risorsa [" + urlRichiesta + "]");
            boolean controlloAccessoRichiesto = Utils.isContentAuthorizationRequiredForThisResource(request, this.excludedPaths);
            log.debug("Controllo Accesso per La risorsa richiesta [" + controlloAccessoRichiesto + "]");
            boolean effettuaRedirect = false;
            boolean utenteLoggato = true;
            if (controlloAccessoRichiesto) {
                lb = Utility.getLoginBeanFromSession(session);
                log.debug("Richiesto Accesso per La risorsa protetta [" + urlRichiesta + "]");
                if (lb != null) {
                    user = lb.getLoggedUser();
                    if (user != null) {
                        Map<String, Boolean> ruoliUtente = ApplicationBean.getInstance().getRuoliUtente(user);
                        log.debug("[Analisi attributi User: " + user.getUsername() + " ]");
                        ApplicationBean applicationBean = ApplicationBean.getInstance();
                        boolean bl = effettuaRedirect = !ContentAuthorizationManager.getInstance().isRisorsaRichiestaAbilitata(urlRichiesta, applicationBean);
                        if (!effettuaRedirect) {
                            effettuaRedirect = !ContentAuthorizationManager.getInstance().checkRuoloRichiestoPerLaRisorsa(ruoliUtente, urlRichiesta, applicationBean);
                        }
                        log.debug("[La risorsa richiesta " + (effettuaRedirect ? "non " : "") + "e' disponibile per l'utente.]");
                    } else {
                        effettuaRedirect = true;
                        utenteLoggato = false;
                    }
                } else {
                    effettuaRedirect = true;
                    utenteLoggato = false;
                }
            } else if (StringUtils.contains((String)request.getRequestURI(), (String)"public/login.jsf") || StringUtils.contains((String)request.getRequestURI(), (String)"public/timeoutPage.jsf")) {
                lb = Utility.getLoginBeanFromSession(session);
                log.debug("Richiesto Accesso per La risorsa [" + urlRichiesta + "]");
                if (lb != null && (user = lb.getLoggedUser()) != null) {
                    log.debug("[User: " + user.getUsername() + "] e' autenticato ma ha richiesto la pagina di login o di timeout, redirect verso [/commons/pages/welcome.jsf]");
                    effettuaRedirect = true;
                    utenteLoggato = true;
                }
            }
            if (effettuaRedirect) {
                StringBuilder sb = new StringBuilder(0);
                sb.append(msgErrorePre).append(userName).append(msgErrorePost);
                String msgErrore = sb.toString();
                log.debug("Redirect: " + request.getContextPath() + jspErrore);
                if (utenteLoggato) {
                    session.setAttribute(msgErroreKey, (Object)msgErrore);
                    session.setAttribute(accLimKey, (Object)true);
                    response.sendRedirect(request.getContextPath() + jspErrore);
                } else {
                    response.sendRedirect(request.getContextPath() + jspLogin);
                }
                return;
            }
            if (urlRichiesta.indexOf("/pages/welcome.jsf") != -1) {
                boolean used;
                boolean bl = used = session.getAttribute(accLimKey) != null ? (Boolean)session.getAttribute(accLimKey) : false;
                if (used) {
                    session.setAttribute(accLimKey, (Object)false);
                } else {
                    session.setAttribute(accLimKey, (Object)false);
                    session.setAttribute(msgErroreKey, null);
                }
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        catch (ServletException e) {
            log.error(e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        this.excludedPaths = new ArrayList<String>();
        try {
            this.excludedPaths.addAll(Arrays.asList(ContentAuthorizationManager.getInstance().getListaPathConsentiti()));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

