/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.filters;

import java.io.IOException;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class CsrfFilter
implements Filter {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private FilterConfig filterConfig = null;
    private static final String jspErrore = "/commons/pages/welcome.jsf";
    private static final String msgErroreKey = "acclim";
    private static final String accLimKey = "acclimflag";
    private Integer validitaTokenCsrf = null;

    public void destroy() {
        log.debug("DISTRUIZIONE FILTRO: CsrfFilter");
        this.filterConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) {
        try {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            HttpSession session = request.getSession();
            String sessionTokenCSRF = CsrfFilter.leggiTokenCSRF(session);
            log.debug("Letto Token CSRF in sessione: [" + sessionTokenCSRF + "]");
            try {
                if (this.isRichiestaScrittura(request)) {
                    String tokenCSRF = request.getParameter("_csrf");
                    log.debug("Ricevuto Token CSRF: [" + tokenCSRF + "]");
                    boolean verificaTokenCSRF = ServletUtils.verificaTokenCSRF((String)tokenCSRF, (String)sessionTokenCSRF, (Integer)this.validitaTokenCsrf);
                    sessionTokenCSRF = null;
                    if (!verificaTokenCSRF) {
                        log.debug("Il Token CSRF ricevuto non e' valido.");
                        if (session != null) {
                            session.setAttribute(msgErroreKey, (Object)"Controllo validit\u00e0 CSRF non superato, l'operazione non verr\u00e0 eseguita.");
                            session.setAttribute(accLimKey, (Object)true);
                        }
                        response.sendRedirect(request.getContextPath() + jspErrore);
                        return;
                    }
                }
            }
            finally {
                if (sessionTokenCSRF == null) {
                    String nuovoTokenCSRF = CsrfFilter.generaESalvaTokenCSRF(session);
                    log.debug("Generato Nuovo Token CSRF: [" + nuovoTokenCSRF + "]");
                }
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ServletException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        try {
            PddMonitorProperties pddMonitorProperties = PddMonitorProperties.getInstance(log);
            this.validitaTokenCsrf = pddMonitorProperties.getValiditaTokenCsrf();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String generaESalvaTokenCSRF(HttpSession session) {
        String uuId = UUID.randomUUID().toString().replace("-", "");
        String nuovoToken = ServletUtils.generaTokenCSRF((String)uuId);
        session.setAttribute("csrf", (Object)nuovoToken);
        return nuovoToken;
    }

    public static String leggiTokenCSRF(HttpSession session) {
        if (session == null) {
            return null;
        }
        return (String)session.getAttribute("csrf");
    }

    private boolean isRichiestaScrittura(HttpServletRequest request) {
        return request.getParameter("salvaProfiloBtn") != null || request.getParameter("modificaPwd") != null;
    }
}

