/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.mbean;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.web.monitor.core.dao.IService;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.slf4j.Logger;

public abstract class BaseBean<T, K, ServiceType extends IService>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient ServiceType service;
    protected T selectedElement;
    protected Map<T, Boolean> selectedIds = new HashMap<T, Boolean>();
    protected ArrayList<T> toRemove;
    private static Logger log = LoggerWrapperFactory.getLogger(BaseBean.class);
    private boolean selectedAll = false;
    protected String elencoID = null;
    protected String exportErrorMessage = null;

    public abstract void setService(ServiceType var1);

    public IService getService() {
        return this.service;
    }

    public void isAddRequest(ActionEvent ae) {
        this.selectedElement = null;
    }

    public T getSelectedElement() {
        if (this.selectedElement == null) {
            try {
                ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
                this.selectedElement = Utilities.newInstance((Class)((Class)parameterizedType.getActualTypeArguments()[0]));
            }
            catch (Exception e) {
                log.error("errore cercando di istanziare il selectedElement ", (Throwable)e);
            }
        }
        return this.selectedElement;
    }

    public void setSelectedElement(T selectedElement) {
        this.selectedElement = selectedElement;
    }

    public Map<T, Boolean> getSelectedIds() {
        return this.selectedIds;
    }

    public void setSelectedIds(Map<T, Boolean> selectedIds) {
        this.selectedIds = selectedIds;
    }

    public String delete() {
        this.toRemove = new ArrayList();
        Iterator<T> it = this.selectedIds.keySet().iterator();
        while (it.hasNext()) {
            T elem = it.next();
            if (!this.selectedIds.get(elem).booleanValue()) continue;
            this.toRemove.add(elem);
            it.remove();
        }
        for (T elem : this.toRemove) {
            try {
                this.service.delete(elem);
            }
            catch (Exception e) {
                MessageUtils.addErrorMsg(e.getMessage());
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public List<FacesMessage> getMessages() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        Iterator ite = ctx.getMessages();
        ArrayList<FacesMessage> list = new ArrayList<FacesMessage>();
        while (ite.hasNext()) {
            list.add((FacesMessage)ite.next());
        }
        return list;
    }

    public boolean isSelectedAll() {
        return this.selectedAll;
    }

    public void setSelectedAll(boolean selectedAll) {
        this.selectedAll = selectedAll;
    }

    public String getElencoID() {
        return this.elencoID;
    }

    public void setElencoID(String elencoID) {
        this.elencoID = elencoID;
    }

    public void initExportListener(ActionEvent ae) {
    }

    public String getExportErrorMessage() {
        return this.exportErrorMessage;
    }

    public void setExportErrorMessage(String exportErrorMessage) {
        this.exportErrorMessage = exportErrorMessage;
    }
}

