/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.mbean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.NameValue;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.CryptFactory;
import org.openspcoop2.utils.crypt.ICrypt;
import org.openspcoop2.utils.crypt.PasswordVerifier;
import org.openspcoop2.web.lib.users.dao.Stato;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.lib.users.dao.UserPassword;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.bean.UserDetailsBean;
import org.openspcoop2.web.monitor.core.constants.Costanti;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.core.Utils;
import org.openspcoop2.web.monitor.core.dao.IService;
import org.openspcoop2.web.monitor.core.dao.UserService;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.mbean.PdDBaseBean;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.slf4j.Logger;

public class UtentiBean
extends PdDBaseBean<UtentiBean, String, IService<User, String>> {
    private static final String ERROR_MSG_LA_PASSWORD_SCELTA_NON_DEVE_CORRISPONDERE_AD_UNA_PRECEDENTE_PASSWORD = "La password scelta non deve corrispondere ad una precedente password";
    private static final String ERROR_MSG_LA_VECCHIA_PASSWORD_INDICATA_NON_E_CORRETTA = "La vecchia password indicata non \u00e8 corretta";
    private static final String ERROR_MSG_CAMBIO_PASSWORD_NON_RIUSCITO = "Cambio Password non riuscito";
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private User user;
    private String confermaPassword;
    private String vecchiaPassword;
    private boolean showFormCambiaPassword = false;
    private String nuovaPassword;
    private String userToUpdate;
    private Boolean showServizi = false;
    private String id;
    private boolean gestionePassword = true;
    private ICrypt passwordManager;
    private ICrypt passwordManager_backwardCompatibility;
    private PasswordVerifier passwordVerifier = null;
    private boolean salvaModificheProfiloInSessione = false;

    public UtentiBean() {
        this.service = new UserService();
        try {
            PddMonitorProperties pddMonitorProperties = PddMonitorProperties.getInstance(log);
            String utentiPasswordConfig = pddMonitorProperties.getUtentiPassword();
            this.gestionePassword = pddMonitorProperties.isGestionePasswordUtentiAttiva();
            if (utentiPasswordConfig != null) {
                this.passwordVerifier = new PasswordVerifier(utentiPasswordConfig);
                if (!this.passwordVerifier.existsRestrictionUpdate()) {
                    this.passwordVerifier = null;
                }
            }
            CryptConfig config = new CryptConfig(utentiPasswordConfig);
            this.passwordManager = CryptFactory.getCrypt((Logger)log, (CryptConfig)config);
            if (config.isBackwardCompatibility()) {
                this.passwordManager_backwardCompatibility = CryptFactory.getOldMD5Crypt((Logger)log);
            }
            this.salvaModificheProfiloInSessione = pddMonitorProperties.isModificaProfiloUtenteDaFormAggiornaSessione();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getNotePassword() {
        if (this.passwordVerifier != null) {
            return this.passwordVerifier.helpUpdate("<BR/>");
        }
        return null;
    }

    public void setId(String id) {
        this.id = id;
        this.user = null;
        if (this.id != null) {
            this.user = (User)this.service.findById(this.id);
        }
    }

    public String getId() {
        return this.id;
    }

    public User getUser() {
        if (this.user == null && this.id == null) {
            this.user = new User();
            if (!this.gestionePassword) {
                this.user.setPassword("*");
                this.setConfermaPassword("*");
            } else {
                this.user.setPassword(null);
                this.setConfermaPassword(null);
            }
        } else if (this.user == null && this.id != null) {
            this.user = (User)this.service.findById(this.id);
        }
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getConfermaPassword() {
        return this.confermaPassword;
    }

    public void setConfermaPassword(String confermaPassword) {
        this.confermaPassword = confermaPassword;
    }

    public void editListener(ActionEvent ae) {
        this.user = (User)this.service.findById(this.user.getLogin());
    }

    public String salvaProfilo() {
        User userToUpdateBean = (User)this.service.findById(this.user.getLogin());
        String modalitaDefaultUtente = this.user.getProtocolloSelezionatoPddMonitor();
        userToUpdateBean.setProtocolloSelezionatoPddMonitor(modalitaDefaultUtente != null && !modalitaDefaultUtente.equals("qualsiasi") ? modalitaDefaultUtente : null);
        String soggettoDefaultUtente = this.user.getSoggettoSelezionatoPddMonitor();
        userToUpdateBean.setSoggettoSelezionatoPddMonitor(soggettoDefaultUtente != null && !soggettoDefaultUtente.equals("qualsiasi") ? soggettoDefaultUtente : null);
        try {
            ((UserService)this.service).salvaModalita(userToUpdateBean.getLogin(), userToUpdateBean.getProtocolloSelezionatoPddMonitor());
            ((UserService)this.service).salvaSoggettoPddMonitor(userToUpdateBean.getLogin(), userToUpdateBean.getSoggettoSelezionatoPddMonitor());
            Stato statoHomePage = new Stato();
            statoHomePage.setOggetto("HOME_PAGE");
            statoHomePage.setStato(Utils.incapsulaValoreStato(this.getHomePageUtente()));
            ((UserService)this.service).saveTableState("HOME_PAGE", userToUpdateBean, statoHomePage);
            Stato statoIntevalloTemporaleHomePage = new Stato();
            statoIntevalloTemporaleHomePage.setOggetto(Costanti.OGGETTO_STATO_UTENTE_INTERVALLO_TEMPORALE_HOME_PAGE);
            statoIntevalloTemporaleHomePage.setStato(Utils.incapsulaValoreStato(this.getIntervalloTemporaleUtente()));
            ((UserService)this.service).saveTableState(Costanti.OGGETTO_STATO_UTENTE_INTERVALLO_TEMPORALE_HOME_PAGE, userToUpdateBean, statoIntevalloTemporaleHomePage);
            if (this.salvaModificheProfiloInSessione) {
                Utility.getLoggedUser().getUtente().setProtocolloSelezionatoPddMonitor(userToUpdateBean.getProtocolloSelezionatoPddMonitor());
                Utility.getLoggedUser().getUtente().setSoggettoSelezionatoPddMonitor(userToUpdateBean.getSoggettoSelezionatoPddMonitor());
            }
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Profilo Utente modificato correttamente"));
        }
        catch (Exception e) {
            log.error("Salvataggio Profilo Utente non riuscito", (Throwable)e);
            MessageUtils.addErrorMsg("Salvataggio Profilo Utente non riuscito");
            return null;
        }
        if (this.showFormCambiaPassword) {
            return this.cambioPassword();
        }
        return null;
    }

    public String cambioPassword() {
        try {
            boolean passwordObbligatoria = Utility.isPasswordUtenteObbligatoria();
            if (passwordObbligatoria && StringUtils.isEmpty((String)this.user.getPassword())) {
                MessageUtils.addErrorMsg("Il campo Nuova non pu\u00f2 essere vuoto");
                return null;
            }
            if (passwordObbligatoria && StringUtils.isEmpty((String)this.confermaPassword)) {
                MessageUtils.addErrorMsg("Il campo Conferma Nuova non pu\u00f2 essere vuoto");
                return null;
            }
            if (this.isShowVecchiaPassword()) {
                if (passwordObbligatoria && StringUtils.isEmpty((String)this.vecchiaPassword)) {
                    MessageUtils.addErrorMsg("Il campo Vecchia non pu\u00f2 essere vuoto");
                    return null;
                }
                User findById = (User)this.service.findById(this.user.getLogin());
                boolean trovato = this.passwordManager.check(this.vecchiaPassword, findById.getPassword());
                if (!trovato && this.passwordManager_backwardCompatibility != null) {
                    trovato = this.passwordManager_backwardCompatibility.check(this.vecchiaPassword, findById.getPassword());
                }
                if (!trovato) {
                    MessageUtils.addErrorMsg(ERROR_MSG_LA_VECCHIA_PASSWORD_INDICATA_NON_E_CORRETTA);
                    return null;
                }
                if (passwordObbligatoria && StringUtils.equals((String)this.vecchiaPassword, (String)this.user.getPassword())) {
                    MessageUtils.addErrorMsg("La nuova password non pu\u00f2 essere uguale alla vecchia");
                    return null;
                }
            }
            if (!StringUtils.equals((String)this.confermaPassword, (String)this.user.getPassword())) {
                MessageUtils.addErrorMsg("Le password inserite nei campi Nuova e Conferma Nuova non corrispondono");
                return null;
            }
            boolean updateStoricoPassword = false;
            if (this.passwordVerifier != null) {
                StringBuilder motivazioneErrore = new StringBuilder();
                if (!this.passwordVerifier.validate(this.user.getLogin(), this.user.getPassword(), motivazioneErrore)) {
                    MessageUtils.addErrorMsg(motivazioneErrore.toString());
                    return null;
                }
                if (this.passwordVerifier.isHistory()) {
                    List precedentiPassword = this.user.getPrecedentiPassword();
                    User findById = (User)this.service.findById(this.user.getLogin());
                    if (precedentiPassword == null || precedentiPassword.isEmpty()) {
                        boolean trovato = this.passwordManager.check(this.user.getPassword(), findById.getPassword());
                        if (!trovato && this.passwordManager_backwardCompatibility != null) {
                            trovato = this.passwordManager_backwardCompatibility.check(this.user.getPassword(), findById.getPassword());
                        }
                        if (trovato) {
                            MessageUtils.addErrorMsg(ERROR_MSG_LA_PASSWORD_SCELTA_NON_DEVE_CORRISPONDERE_AD_UNA_PRECEDENTE_PASSWORD);
                            return null;
                        }
                    }
                    for (UserPassword userPassword : precedentiPassword) {
                        boolean trovato = this.passwordManager.check(this.user.getPassword(), userPassword.getPassword());
                        if (!trovato && this.passwordManager_backwardCompatibility != null) {
                            trovato = this.passwordManager_backwardCompatibility.check(this.user.getPassword(), userPassword.getPassword());
                        }
                        if (!trovato) continue;
                        MessageUtils.addErrorMsg(ERROR_MSG_LA_PASSWORD_SCELTA_NON_DEVE_CORRISPONDERE_AD_UNA_PRECEDENTE_PASSWORD);
                        return null;
                    }
                    UserPassword userPassword = new UserPassword();
                    userPassword.setDatePassword(findById.getLastUpdatePassword());
                    userPassword.setPassword(findById.getPassword());
                    this.user.getPrecedentiPassword().add(userPassword);
                    updateStoricoPassword = true;
                }
            }
            this.user.setLastUpdatePassword(new Date());
            String newPassword = this.passwordManager.crypt(this.user.getPassword());
            if (updateStoricoPassword) {
                ((UserService)this.service).savePasswordStorico(this.user.getId(), this.user.getLogin(), newPassword, this.user.getLastUpdatePassword(), this.user.getPrecedentiPassword());
            } else {
                ((UserService)this.service).savePassword(this.user.getId(), this.user.getLogin(), newPassword, this.user.getLastUpdatePassword());
            }
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Password modificata correttamente"));
            this.showFormCambiaPassword = false;
        }
        catch (Exception e) {
            log.error(ERROR_MSG_CAMBIO_PASSWORD_NON_RIUSCITO, (Throwable)e);
            MessageUtils.addErrorMsg(ERROR_MSG_CAMBIO_PASSWORD_NON_RIUSCITO);
        }
        return null;
    }

    public String cambioPasswordScaduta() {
        try {
            User findById = (User)this.service.findById(this.userToUpdate);
            if (StringUtils.isEmpty((String)this.nuovaPassword)) {
                MessageUtils.addErrorMsg("Il campo Nuova non pu\u00f2 essere vuoto");
                return null;
            }
            if (StringUtils.isEmpty((String)this.confermaPassword)) {
                MessageUtils.addErrorMsg("Il campo Conferma Nuova non pu\u00f2 essere vuoto");
                return null;
            }
            if (this.nuovaPassword.indexOf(" ") != -1 || this.confermaPassword.indexOf(" ") != -1) {
                MessageUtils.addErrorMsg("Non inserire spazi nei campi di testo");
                return null;
            }
            if (StringUtils.isEmpty((String)this.vecchiaPassword)) {
                MessageUtils.addErrorMsg(ERROR_MSG_LA_VECCHIA_PASSWORD_INDICATA_NON_E_CORRETTA);
                return null;
            }
            if (this.vecchiaPassword.indexOf(" ") != -1) {
                MessageUtils.addErrorMsg("Non inserire spazi nei campi di testo");
                return null;
            }
            boolean trovato = this.passwordManager.check(this.vecchiaPassword, findById.getPassword());
            if (!trovato && this.passwordManager_backwardCompatibility != null) {
                trovato = this.passwordManager_backwardCompatibility.check(this.vecchiaPassword, findById.getPassword());
            }
            if (!trovato) {
                MessageUtils.addErrorMsg(ERROR_MSG_LA_VECCHIA_PASSWORD_INDICATA_NON_E_CORRETTA);
                return null;
            }
            if (StringUtils.equals((String)this.vecchiaPassword, (String)this.nuovaPassword)) {
                MessageUtils.addErrorMsg("La nuova password deve essere differente dalla vecchia");
                return null;
            }
            if (!StringUtils.equals((String)this.confermaPassword, (String)this.nuovaPassword)) {
                MessageUtils.addErrorMsg("Le password inserite nei campi Nuova e Conferma Nuova non corrispondono");
                return null;
            }
            boolean updateStoricoPassword = false;
            List precedentiPassword = null;
            if (this.passwordVerifier != null) {
                StringBuilder motivazioneErrore = new StringBuilder();
                if (!this.passwordVerifier.validate(this.userToUpdate, this.nuovaPassword, motivazioneErrore)) {
                    MessageUtils.addErrorMsg(motivazioneErrore.toString());
                    return null;
                }
                if (this.passwordVerifier.isHistory()) {
                    precedentiPassword = findById.getPrecedentiPassword();
                    if (precedentiPassword == null || precedentiPassword.isEmpty()) {
                        trovato = this.passwordManager.check(this.nuovaPassword, findById.getPassword());
                        if (!trovato && this.passwordManager_backwardCompatibility != null) {
                            trovato = this.passwordManager_backwardCompatibility.check(this.nuovaPassword, findById.getPassword());
                        }
                        if (trovato) {
                            MessageUtils.addErrorMsg(ERROR_MSG_LA_PASSWORD_SCELTA_NON_DEVE_CORRISPONDERE_AD_UNA_PRECEDENTE_PASSWORD);
                            return null;
                        }
                    }
                    if (precedentiPassword != null) {
                        for (UserPassword userPassword : precedentiPassword) {
                            trovato = this.passwordManager.check(this.nuovaPassword, userPassword.getPassword());
                            if (!trovato && this.passwordManager_backwardCompatibility != null) {
                                trovato = this.passwordManager_backwardCompatibility.check(this.nuovaPassword, userPassword.getPassword());
                            }
                            if (!trovato) continue;
                            MessageUtils.addErrorMsg(ERROR_MSG_LA_PASSWORD_SCELTA_NON_DEVE_CORRISPONDERE_AD_UNA_PRECEDENTE_PASSWORD);
                            return null;
                        }
                    }
                    UserPassword userPassword = new UserPassword();
                    userPassword.setDatePassword(findById.getLastUpdatePassword());
                    userPassword.setPassword(findById.getPassword());
                    if (precedentiPassword != null) {
                        precedentiPassword.add(userPassword);
                    }
                    updateStoricoPassword = true;
                }
            }
            String newPassword = this.passwordManager.crypt(this.nuovaPassword);
            if (updateStoricoPassword) {
                ((UserService)this.service).savePasswordStorico(findById.getId(), this.userToUpdate, newPassword, new Date(), precedentiPassword);
            } else {
                ((UserService)this.service).savePassword(findById.getId(), this.userToUpdate, newPassword, new Date());
            }
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Password aggiornata con successo"));
            return Utility.getLoginBean().ricaricaUtenteDopoCambioPasswordScaduta();
        }
        catch (Exception e) {
            log.error(ERROR_MSG_CAMBIO_PASSWORD_NON_RIUSCITO, (Throwable)e);
            MessageUtils.addErrorMsg(ERROR_MSG_CAMBIO_PASSWORD_NON_RIUSCITO);
            return null;
        }
    }

    @Override
    public String delete() {
        return null;
    }

    public int getSizeSoggetti() {
        return this.user.getSoggetti() != null ? this.user.getSoggetti().size() : 0;
    }

    public Boolean isShowServizi() {
        return this.showServizi;
    }

    public void setShowServizi(Boolean showServizi) {
        this.showServizi = showServizi;
    }

    public void setListaSoggettiAssociatiUtente(List<String> lst) {
    }

    public List<NameValue> getListaSoggettiAssociatiUtente() throws ProtocolException {
        ArrayList<NameValue> lst = new ArrayList<NameValue>();
        List utenteSoggettoList = this.user.getSoggetti();
        if (utenteSoggettoList != null && !utenteSoggettoList.isEmpty()) {
            for (IDSoggetto idSog : utenteSoggettoList) {
                NameValue val = new NameValue();
                val.setName(NamingUtils.getLabelSoggetto((IDSoggetto)idSog));
                val.setValue(NamingUtils.getLabelProtocollo((String)ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idSog.getTipo())));
                lst.add(val);
            }
        }
        return lst;
    }

    public void setListaServiziAssociatiUtente(List<String> lst) {
    }

    public List<NameValue> getListaServiziAssociatiUtente() throws ProtocolException {
        ArrayList<NameValue> lst = new ArrayList<NameValue>();
        List utenteServizioList = this.user.getServizi();
        if (utenteServizioList != null && !utenteServizioList.isEmpty()) {
            for (IDServizio serv : utenteServizioList) {
                NameValue val = new NameValue();
                val.setName(NamingUtils.getLabelAccordoServizioParteSpecifica((IDServizio)serv));
                val.setValue(NamingUtils.getLabelProtocollo((String)ProtocolFactoryManager.getInstance().getProtocolByServiceType(serv.getTipo())));
                lst.add(val);
            }
        }
        return lst;
    }

    public String getProfilo() {
        return "Profilo";
    }

    public void setProfilo(String profilo) {
    }

    public boolean isGestionePassword() {
        return this.gestionePassword;
    }

    public void setGestionePassword(boolean gestionePassword) {
        this.gestionePassword = gestionePassword;
    }

    public String getVecchiaPassword() {
        return this.vecchiaPassword;
    }

    public void setVecchiaPassword(String vecchiaPassword) {
        this.vecchiaPassword = vecchiaPassword;
    }

    public boolean isShowFormCambiaPassword() {
        return this.showFormCambiaPassword;
    }

    public void setShowFormCambiaPassword(boolean showFormCambiaPassword) {
        this.showFormCambiaPassword = showFormCambiaPassword;
    }

    public boolean isShowVecchiaPassword() {
        if (this.user.getId() != null && this.user.getId() > 0L) {
            UserDetailsBean loggedUser = Utility.getLoggedUser();
            if (this.user.getLogin().equals(loggedUser.getUsername())) {
                return true;
            }
        }
        return false;
    }

    public void setShowVecchiaPassword(boolean showVecchiaPassword) {
    }

    public String getModalitaDisponibiliUser() throws Exception {
        List<String> protocolliDisponibli = Utility.getLoginBean().listaProtocolliDisponibilePerUtentePddMonitor();
        StringBuilder sb = new StringBuilder();
        for (String protocollo : protocolliDisponibli) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(NamingUtils.getLabelProtocollo((String)protocollo));
        }
        return sb.toString();
    }

    public String getNuovaPassword() {
        return this.nuovaPassword;
    }

    public void setNuovaPassword(String nuovaPassword) {
        this.nuovaPassword = nuovaPassword;
    }

    public String getUserToUpdate() {
        return this.userToUpdate;
    }

    public void setUserToUpdate(String userToUpdate) {
        this.userToUpdate = userToUpdate;
    }

    public List<SelectItem> getModalitaDisponibiliItems() throws Exception {
        List<String> protocolliDisponibli = Utility.getLoginBean().listaProtocolliDisponibilePerUtentePddMonitor();
        ArrayList<SelectItem> modalita = new ArrayList<SelectItem>();
        for (String protocollo : protocolliDisponibli) {
            modalita.add(new SelectItem((Object)protocollo, NamingUtils.getLabelProtocollo((String)protocollo)));
        }
        modalita.add(0, new SelectItem((Object)"qualsiasi", "Tutti"));
        return modalita;
    }

    public String getModalitaDefault() throws Exception {
        if (this.getModalitaDefaultUtente().equals("qualsiasi")) {
            return "Tutti";
        }
        return NamingUtils.getLabelProtocollo((String)Utility.getLoginBean().listaProtocolliDisponibilePerUtentePddMonitor().get(0));
    }

    public boolean isVisualizzaSelectModalitaDisponibili() throws Exception {
        return Utility.getLoginBean().listaProtocolliDisponibilePerUtentePddMonitor().size() > 1;
    }

    public void setVisualizzaSelectModalitaDisponibili(boolean visualizzaSelectModalitaDisponibili) {
    }

    public String getModalitaDefaultUtente() {
        if (this.user.getProtocolloSelezionatoPddMonitor() == null) {
            return "qualsiasi";
        }
        return this.user.getProtocolloSelezionatoPddMonitor();
    }

    public void setModalitaDefaultUtente(String modalita) {
        this.user.setProtocolloSelezionatoPddMonitor(modalita);
    }

    public void modalitaDefaultUtenteSelected(ActionEvent ae) {
    }

    public String getSoggettoDefaultUtente() {
        if (this.user.getSoggettoSelezionatoPddMonitor() == null) {
            return "qualsiasi";
        }
        return this.user.getSoggettoSelezionatoPddMonitor();
    }

    public void setSoggettoDefaultUtente(String idSoggettoDefaultUtente) {
        this.user.setSoggettoSelezionatoPddMonitor(idSoggettoDefaultUtente);
    }

    public void idSoggettoDefaultUtenteSelected(ActionEvent ae) {
    }

    public boolean isVisualizzaSezioneSelezioneSoggetto() {
        return !this.getModalitaDefaultUtente().equals("qualsiasi");
    }

    public void setVisualizzaSezioneSelezioneSoggetto(boolean visualizzaSezioneSelezioneSoggetto) {
    }

    public boolean isVisualizzaSelectSoggettiDisponibili() {
        if (!this.getModalitaDefaultUtente().equals("qualsiasi")) {
            return LoginBean.listaSoggettiDisponibiliPerProtocollo(Utility.getLoggedUser(), this.getModalitaDefaultUtente()).size() > 1;
        }
        return false;
    }

    public String getSoggettoDefault() throws ProtocolException {
        if (LoginBean.listaSoggettiDisponibiliPerProtocollo(Utility.getLoggedUser(), this.getModalitaDefaultUtente()).size() > 1) {
            return "Tutti";
        }
        Soggetto soggetto = LoginBean.listaSoggettiDisponibiliPerProtocollo(Utility.getLoggedUser(), this.getModalitaDefaultUtente()).get(0);
        IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipoSoggetto(), soggetto.getNomeSoggetto());
        return NamingUtils.getLabelSoggetto((IDSoggetto)idSoggetto);
    }

    public List<SelectItem> getSoggettiDisponibiliItems() throws ProtocolException {
        List<Soggetto> soggettiDisponibli = LoginBean.listaSoggettiDisponibiliPerProtocollo(Utility.getLoggedUser(), this.getModalitaDefaultUtente());
        ArrayList<SelectItem> modalita = new ArrayList<SelectItem>();
        ArrayList<String> listaLabel = new ArrayList<String>();
        HashMap<String, IDSoggetto> mapLabelIds = new HashMap<String, IDSoggetto>();
        for (Soggetto soggetto : soggettiDisponibli) {
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipoSoggetto(), soggetto.getNomeSoggetto());
            String labelSoggetto = NamingUtils.getLabelSoggetto((IDSoggetto)idSoggetto);
            if (listaLabel.contains(labelSoggetto)) continue;
            listaLabel.add(labelSoggetto);
            mapLabelIds.put(labelSoggetto, idSoggetto);
        }
        Collections.sort(listaLabel, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toLowerCase().compareTo(o2.toLowerCase());
            }
        });
        for (String label : listaLabel) {
            modalita.add(new SelectItem((Object)NamingUtils.getSoggettoFromLabel((String)this.getModalitaDefaultUtente(), (String)label).toString(), label));
        }
        modalita.add(0, new SelectItem((Object)"qualsiasi", "Tutti"));
        return modalita;
    }

    public String getHomePageUtente() {
        for (Stato stato : this.user.getStati()) {
            if (!stato.getOggetto().equals("HOME_PAGE")) continue;
            return Utils.extractValoreStato(stato.getStato());
        }
        return "transazioni";
    }

    public void setHomePageUtente(String homePage) {
        boolean homePageFound = false;
        for (Stato stato : this.user.getStati()) {
            if (!stato.getOggetto().equals("HOME_PAGE")) continue;
            stato.setStato(Utils.incapsulaValoreStato(homePage));
            homePageFound = true;
            break;
        }
        if (!homePageFound) {
            Stato statoHomePage = new Stato();
            statoHomePage.setOggetto("HOME_PAGE");
            statoHomePage.setStato(Utils.incapsulaValoreStato(homePage));
            this.user.getStati().add(statoHomePage);
        }
    }

    public void homePageUtenteSelected(ActionEvent ae) {
        this.setIntervalloTemporaleUtente("Ultimi 7 giorni");
    }

    public List<SelectItem> getHomePagesDisponibili() {
        ArrayList<SelectItem> pagine = new ArrayList<SelectItem>();
        pagine.add(new SelectItem((Object)"transazioni", MessageManager.getInstance().getMessage("utenti.profilo.homePage.transazioni")));
        pagine.add(new SelectItem((Object)"summary", MessageManager.getInstance().getMessage("utenti.profilo.homePage.statistiche")));
        return pagine;
    }

    public List<SelectItem> getIntervalliTemporaliDisponibili() {
        ArrayList<SelectItem> intervalli = new ArrayList<SelectItem>();
        intervalli.add(new SelectItem((Object)"--", MessageManager.getInstance().getMessage("utenti.profilo.intervalloTemporaleHomePage.noGrafico")));
        intervalli.add(new SelectItem((Object)"Ultime 24 ore", MessageManager.getInstance().getMessage("utenti.profilo.intervalloTemporaleHomePage.ultime24ore")));
        intervalli.add(new SelectItem((Object)"Ultimi 7 giorni", MessageManager.getInstance().getMessage("utenti.profilo.intervalloTemporaleHomePage.ultimi7giorni")));
        intervalli.add(new SelectItem((Object)"Ultimi 30 giorni", MessageManager.getInstance().getMessage("utenti.profilo.intervalloTemporaleHomePage.ultimi30giorni")));
        intervalli.add(new SelectItem((Object)"Ultimo anno", MessageManager.getInstance().getMessage("utenti.profilo.intervalloTemporaleHomePage.ultimoAnno")));
        return intervalli;
    }

    public boolean isVisualizzaSelectIntervalloTemporale() {
        boolean visualizzaSelectIntervalloTemporale = false;
        for (Stato stato : this.user.getStati()) {
            if (!stato.getOggetto().equals("HOME_PAGE")) continue;
            if (!Utils.extractValoreStato(stato.getStato()).equals("summary")) break;
            visualizzaSelectIntervalloTemporale = true;
            break;
        }
        return visualizzaSelectIntervalloTemporale;
    }

    public void setVisualizzaSelectIntervalloTemporale(boolean visualizzaSelectIntervalloTemporale) {
    }

    public String getIntervalloTemporaleUtente() {
        for (Stato stato : this.user.getStati()) {
            if (!stato.getOggetto().equals(Costanti.OGGETTO_STATO_UTENTE_INTERVALLO_TEMPORALE_HOME_PAGE)) continue;
            return Utils.extractValoreStato(stato.getStato());
        }
        return "Ultime 24 ore";
    }

    public void setIntervalloTemporaleUtente(String intervalloTemporale) {
        boolean statoIntevalloTemporaleHomePageFound = false;
        for (Stato stato : this.user.getStati()) {
            if (!stato.getOggetto().equals(Costanti.OGGETTO_STATO_UTENTE_INTERVALLO_TEMPORALE_HOME_PAGE)) continue;
            stato.setStato(Utils.incapsulaValoreStato(intervalloTemporale));
            statoIntevalloTemporaleHomePageFound = true;
            break;
        }
        if (!statoIntevalloTemporaleHomePageFound) {
            Stato statoIntevalloTemporaleHomePage = new Stato();
            statoIntevalloTemporaleHomePage.setOggetto(Costanti.OGGETTO_STATO_UTENTE_INTERVALLO_TEMPORALE_HOME_PAGE);
            statoIntevalloTemporaleHomePage.setStato(Utils.incapsulaValoreStato(intervalloTemporale));
            this.user.getStati().add(statoIntevalloTemporaleHomePage);
        }
    }

    public boolean isPasswordObbligatoria() {
        return Utility.isPasswordUtenteObbligatoria();
    }
}

