/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.report;

import be.quodlibet.boxable.BaseTable;
import be.quodlibet.boxable.Cell;
import be.quodlibet.boxable.Row;
import be.quodlibet.boxable.Table;
import be.quodlibet.boxable.datatable.DataTable;
import be.quodlibet.boxable.line.LineStyle;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.constant.HorizontalTextAlignment;
import net.sf.dynamicreports.report.constant.VerticalTextAlignment;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.commons.lang.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.openspcoop2.web.monitor.core.report.Colonna;
import org.openspcoop2.web.monitor.core.report.CustomJRField;

public class Templates {
    public static final StyleBuilder rootStyle;
    public static final StyleBuilder columnStyle;
    public static final StyleBuilder columnTitleStyle;
    public static final FontBuilder rootFont;
    public static final float MARGIN = 10.0f;
    public static final float PDF_SPACE_TEXT_FONT_SIZE = 6.0f;
    public static final float PDF_TEXT_FONT_SIZE = 8.0f;
    public static final float PDF_TABLE_FONT_SIZE = 8.0f;
    public static final float PDF_TITLE_FONT_SIZE = 18.0f;
    public static final float PDF_SUBTITLE_FONT_SIZE = 14.0f;
    public static final String PDF_LINKIT_URL = "https://govway.org";
    public static final Color TABLE_HEADER_BACKGROUND_COLOR;
    public static final Color TABLE_EVEN_ROWS_BACKGROUND_COLOR;
    public static final Color TABLE_ODD_ROWS_BACKGROUND_COLOR;
    public static final Color BORDER_COLOR_BLACK;
    public static final LineStyle SOLID_BORDER_BLACK_1F;

    private Templates() {
    }

    public static void createTitleComponent(String titoloReport, String periodoOsservazione, PDDocument document) throws IOException {
        if ((periodoOsservazione == null || StringUtils.isEmpty((String)periodoOsservazione)) && titoloReport.contains(" ( dal ")) {
            int indexOf = titoloReport.indexOf(" ( dal ");
            periodoOsservazione = titoloReport.substring(indexOf);
            titoloReport = titoloReport.substring(0, indexOf);
        }
        titoloReport = titoloReport.trim();
        if (periodoOsservazione != null) {
            periodoOsservazione = periodoOsservazione.trim();
        }
        PDPage page = document.getPage(0);
        float width = page.getMediaBox().getWidth();
        float height = page.getMediaBox().getHeight();
        PDPageContentStream contentStream = new PDPageContentStream(document, page);
        contentStream.beginText();
        contentStream.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 18.0f);
        contentStream.newLineAtOffset(10.0f, height - 40.0f);
        contentStream.showText(titoloReport);
        contentStream.endText();
        contentStream.beginText();
        contentStream.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 14.0f);
        contentStream.newLineAtOffset(10.0f, height - 60.0f);
        contentStream.showText(periodoOsservazione);
        contentStream.endText();
        contentStream.beginText();
        contentStream.setFont((PDFont)PDType1Font.HELVETICA_OBLIQUE, 8.0f);
        contentStream.newLineAtOffset(10.0f, height - 110.0f);
        contentStream.showText(PDF_LINKIT_URL);
        contentStream.endText();
        float yLine = 116.0f;
        contentStream.setLineWidth(1.5f);
        contentStream.moveTo(10.0f, height - yLine);
        contentStream.lineTo(width - 10.0f, height - yLine);
        contentStream.stroke();
        contentStream.close();
    }

    private static List<List> convert(List<List<String>> src, List<Colonna> colonne) {
        List<List> lReturnNull = null;
        if (src == null || src.isEmpty()) {
            return lReturnNull;
        }
        if (colonne == null || colonne.isEmpty()) {
            return lReturnNull;
        }
        ArrayList<List> data = new ArrayList<List>();
        ArrayList<String> headers = new ArrayList<String>();
        for (Colonna colonna : colonne) {
            headers.add(colonna.getLabel());
        }
        data.add(headers);
        for (List list : src) {
            data.add(list);
        }
        return data;
    }

    public static void createTableComponent(List<Colonna> colonne, List<List<String>> dati, PDDocument document) throws IOException {
        if (colonne == null || colonne.isEmpty()) {
            throw new IOException("Colonne non fornite");
        }
        if (dati == null || dati.isEmpty()) {
            throw new IOException("Dati non forniti");
        }
        if (document == null) {
            throw new IOException("Document non fornito");
        }
        PDPage page = document.getPage(0);
        float height = page.getMediaBox().getHeight();
        float yStart = height - 130.0f;
        float startNewPageY = height - 20.0f;
        float bottomMargin = 10.0f;
        float tableWidth = page.getMediaBox().getWidth() - 20.0f;
        BaseTable dataTable = new BaseTable(yStart, startNewPageY, bottomMargin, tableWidth, 10.0f, document, page, true, true);
        DataTable t = new DataTable((Table)dataTable, page);
        t.addListToTable(Templates.convert(dati, colonne), DataTable.HASHEADER);
        int numeroColonne = colonne.size();
        float preferredColumWidth = tableWidth / (float)numeroColonne;
        for (int jColonna = 0; jColonna < dataTable.getHeader().getCells().size(); ++jColonna) {
            Colonna colonna = colonne.get(jColonna);
            ((Cell)dataTable.getHeader().getCells().get(jColonna)).setFillColor(TABLE_HEADER_BACKGROUND_COLOR);
            ((Cell)dataTable.getHeader().getCells().get(jColonna)).setAlign(colonna.getAlignment());
            ((Cell)dataTable.getHeader().getCells().get(jColonna)).setFontSize(8.0f);
            ((Cell)dataTable.getHeader().getCells().get(jColonna)).setWidth(preferredColumWidth);
            ((Cell)dataTable.getHeader().getCells().get(jColonna)).setFont((PDFont)PDType1Font.HELVETICA_BOLD);
        }
        for (int iRiga = 1; iRiga < dataTable.getRows().size(); ++iRiga) {
            for (int jColonna = 0; jColonna < ((Row)dataTable.getRows().get(iRiga)).getCells().size(); ++jColonna) {
                Colonna colonna = colonne.get(jColonna);
                if (iRiga % 2 == 0) {
                    ((Cell)((Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setFillColor(TABLE_EVEN_ROWS_BACKGROUND_COLOR);
                    ((Cell)((Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setBorderStyle(new LineStyle(TABLE_EVEN_ROWS_BACKGROUND_COLOR, 0.0f));
                } else {
                    ((Cell)((Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setFillColor(TABLE_ODD_ROWS_BACKGROUND_COLOR);
                    ((Cell)((Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setBorderStyle(new LineStyle(TABLE_ODD_ROWS_BACKGROUND_COLOR, 0.0f));
                }
                ((Cell)((Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setAlign(colonna.getAlignment());
                ((Cell)((Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setFontSize(8.0f);
                ((Cell)((Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setWidth(preferredColumWidth);
                ((Cell)((Row)dataTable.getRows().get(iRiga)).getCells().get(jColonna)).setFont((PDFont)PDType1Font.HELVETICA);
            }
        }
        dataTable.draw();
    }

    public static List<List<String>> estraiDatiPerTabellaPdfDaDataSource(JasperReportBuilder report, List<Colonna> colonne) throws JRException {
        DRDataSource dataSource = (DRDataSource)report.getDataSource();
        ArrayList<List<String>> dati = new ArrayList<List<String>>();
        while (dataSource.next()) {
            ArrayList<String> riga = new ArrayList<String>();
            for (Colonna colonna : colonne) {
                String name = colonna.getName();
                CustomJRField field = new CustomJRField(name);
                String fieldValue = (String)dataSource.getFieldValue((JRField)field);
                riga.add(fieldValue);
            }
            dati.add(riga);
        }
        return dati;
    }

    static {
        rootFont = DynamicReports.stl.font().setFontSize(Integer.valueOf(8));
        rootStyle = (StyleBuilder)((StyleBuilder)DynamicReports.stl.style().setPadding(Integer.valueOf(2))).setFont(rootFont);
        columnStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)rootStyle).setVerticalTextAlignment(VerticalTextAlignment.MIDDLE);
        columnTitleStyle = (StyleBuilder)((StyleBuilder)((StyleBuilder)((StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)columnStyle).setBorder(DynamicReports.stl.pen1Point())).setHorizontalTextAlignment(HorizontalTextAlignment.CENTER)).setBackgroundColor(Color.LIGHT_GRAY)).bold();
        TABLE_HEADER_BACKGROUND_COLOR = new Color(192, 192, 192);
        TABLE_EVEN_ROWS_BACKGROUND_COLOR = new Color(255, 255, 255);
        TABLE_ODD_ROWS_BACKGROUND_COLOR = new Color(240, 240, 240);
        BORDER_COLOR_BLACK = new Color(0, 0, 0);
        SOLID_BORDER_BLACK_1F = new LineStyle(BORDER_COLOR_BLACK, 1.0f);
    }
}

