/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.servlet;

import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.oauth2.OAuth2Utilities;
import org.openspcoop2.utils.transport.http.credential.IPrincipalReader;
import org.openspcoop2.utils.transport.http.credential.PrincipalReaderException;
import org.openspcoop2.utils.transport.http.credential.PrincipalReaderFactory;
import org.openspcoop2.utils.transport.http.credential.PrincipalReaderType;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.SessionUtils;
import org.slf4j.Logger;

public class OAuth2UserServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.engineDoGet(httpServletRequest, httpServletResponse);
    }

    private void engineDoGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        IPrincipalReader principalReader = null;
        String loginUtenteNonAutorizzatoRedirectUrl = null;
        String loginSessioneScadutaRedirectUrl = null;
        String oauth2LogoutUrl = null;
        try {
            String loginTipo = PddMonitorProperties.getInstance(log).getLoginTipo();
            if (StringUtils.isEmpty((String)loginTipo)) {
                loginTipo = PrincipalReaderType.PRINCIPAL.getValue();
            }
            Properties prop = PddMonitorProperties.getInstance(log).getLoginProperties();
            principalReader = this.caricaPrincipalReader(loginTipo, prop);
            loginUtenteNonAutorizzatoRedirectUrl = PddMonitorProperties.getInstance(log).getLoginUtenteNonAutorizzatoRedirectUrl();
            loginSessioneScadutaRedirectUrl = PddMonitorProperties.getInstance(log).getLoginSessioneScadutaRedirectUrl();
            oauth2LogoutUrl = prop.getProperty("oauth2.logout.endpoint");
            HttpSession sessione = httpServletRequest.getSession();
            LoginBean lb = (LoginBean)sessione.getAttribute("loginBean");
            log.debug("LoginBean trovato in sessione [{}]", (Object)(lb != null ? 1 : 0));
            lb = this.creaLoginBeanSeNonPresente(httpServletRequest, lb);
            log.debug("Login Bean Utente Loggato: [{}]", (Object)lb.isLoggedIn());
            if (!lb.isLoggedIn()) {
                String username = this.getPrincipal(httpServletRequest, principalReader);
                log.debug("Username trovato: [{}]", (Object)username);
                if (username != null) {
                    this.controllaEsistenzaUtente(httpServletRequest, httpServletResponse, loginUtenteNonAutorizzatoRedirectUrl, oauth2LogoutUrl, sessione, lb, username);
                } else {
                    this.utenteNonTrovatoInSessione(httpServletRequest, httpServletResponse, loginUtenteNonAutorizzatoRedirectUrl, sessione);
                }
            } else {
                this.verificaSessioneUtenteLoggato(httpServletRequest, httpServletResponse, loginSessioneScadutaRedirectUrl, lb);
            }
        }
        catch (PrincipalReaderException e) {
            httpServletResponse.setStatus(503);
            try {
                httpServletResponse.getWriter().write("Autenticazione Oauth2 non disponibile: si e' verificato un'errore: " + e.getMessage());
            }
            catch (IOException e1) {
                log.error("Errore durante la lettura del principal: " + e1.getMessage(), (Throwable)e1);
            }
        }
        catch (IOException e) {
            log.error("Errore durante esecuzione redirect: " + e.getMessage(), (Throwable)e);
            httpServletResponse.setStatus(503);
            try {
                httpServletResponse.getWriter().write("Autenticazione Oauth2 non disponibile: si e' verificato un'errore: " + e.getMessage());
            }
            catch (IOException e1) {
                log.error("Errore durante esecuzione redirect: " + e1.getMessage(), (Throwable)e1);
            }
        }
        catch (UtilsException e) {
            OAuth2Utilities.logError((Logger)log, (String)("Errore durante la lettura delle properties: " + e.getMessage()), (Throwable)e);
            httpServletResponse.setStatus(503);
            try {
                httpServletResponse.getWriter().write("Autenticazione Oauth2 non disponibile: si e' verificato un'errore: " + e.getMessage());
            }
            catch (IOException e1) {
                log.error("Errore durante la lettura delle properties: " + e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private String getPrincipal(HttpServletRequest httpServletRequest, IPrincipalReader principalReader) throws PrincipalReaderException {
        try {
            return principalReader.getPrincipal(httpServletRequest);
        }
        catch (PrincipalReaderException e) {
            OAuth2Utilities.logError((Logger)log, (String)("Errore durante la lettura del principal: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    private IPrincipalReader caricaPrincipalReader(String loginTipo, Properties prop) throws PrincipalReaderException {
        try {
            IPrincipalReader principalReader = PrincipalReaderFactory.getReader((Logger)log, (String)loginTipo);
            principalReader.init(new Object[]{prop});
            return principalReader;
        }
        catch (PrincipalReaderException e) {
            OAuth2Utilities.logError((Logger)log, (String)("Impossibile caricare il principal reader: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    private LoginBean creaLoginBeanSeNonPresente(HttpServletRequest httpServletRequest, LoginBean lb) {
        if (lb == null) {
            lb = this.leggiLoginBeanDallaSessioneJsf(lb);
        }
        log.debug("Controllo Locale in corso ...");
        Locale loc = this.leggiLocale();
        log.debug("Locale trovato Valore[{}]", (Object)loc);
        if (lb == null) {
            lb = this.creaLoginBeanNonLoggato(httpServletRequest);
        }
        return lb;
    }

    private void utenteNonTrovatoInSessione(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String loginUtenteNonAutorizzatoRedirectUrl, HttpSession sessione) throws IOException {
        sessione.setAttribute("loginBean", null);
        String redirPageUrl = StringUtils.isNotEmpty((String)loginUtenteNonAutorizzatoRedirectUrl) ? loginUtenteNonAutorizzatoRedirectUrl : httpServletRequest.getContextPath() + "/pages/welcome.jsf";
        log.debug("Username NULL redirect [{}]", (Object)redirPageUrl);
        sessione.setAttribute("principalErrorMsg", (Object)"Impossibile autenticare l'utente");
        httpServletResponse.sendRedirect(redirPageUrl);
    }

    private void controllaEsistenzaUtente(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String loginUtenteNonAutorizzatoRedirectUrl, String oauth2LogoutUrl, HttpSession sessione, LoginBean lb, String username) throws IOException, UtilsException {
        String loginUtenteNonValidoRedirectUrl = PddMonitorProperties.getInstance(log).getLoginUtenteNonValidoRedirectUrl();
        String loginErroreInternoRedirectUrl = PddMonitorProperties.getInstance(log).getLoginErroreInternoRedirectUrl();
        lb.setApplicationLogin(false);
        lb.setUsername(username);
        String loginResult = lb.login();
        if (loginResult.equals("login")) {
            log.debug("Utente non autorizzato: {}", (Object)lb.getLoginErrorMessage());
            String redirPageUrl = StringUtils.isNotEmpty((String)loginUtenteNonAutorizzatoRedirectUrl) ? loginUtenteNonAutorizzatoRedirectUrl : Utility.buildInternalRedirectUrl(httpServletRequest, "/public/error.jsf?principalShowForm=true");
            String idToken = (String)sessione.getAttribute("oauthIdToken");
            String logoutUrl = OAuth2Utilities.creaUrlLogout((String)idToken, (String)oauth2LogoutUrl, (String)redirPageUrl);
            sessione.setAttribute("principalErrorMsg", (Object)lb.getLoginErrorMessage());
            httpServletResponse.sendRedirect(logoutUrl);
        } else if (loginResult.equals("loginError")) {
            log.debug("Errore durante il login: {}", (Object)lb.getLoginErrorMessage());
            String redirPageUrl = StringUtils.isNotEmpty((String)loginErroreInternoRedirectUrl) ? loginErroreInternoRedirectUrl : Utility.buildInternalRedirectUrl(httpServletRequest, "/public/error.jsf?principalShowForm=true");
            String idToken = (String)sessione.getAttribute("oauthIdToken");
            String logoutUrl = OAuth2Utilities.creaUrlLogout((String)idToken, (String)oauth2LogoutUrl, (String)redirPageUrl);
            sessione.setAttribute("principalErrorMsg", (Object)lb.getLoginErrorMessage());
            httpServletResponse.sendRedirect(logoutUrl);
        } else if (loginResult.equals("loginUserInvalid")) {
            log.debug("Errore durante il caricamento informazioni utente: {}", (Object)lb.getLoginErrorMessage());
            String redirPageUrl = StringUtils.isNotEmpty((String)loginUtenteNonValidoRedirectUrl) ? loginUtenteNonValidoRedirectUrl : Utility.buildInternalRedirectUrl(httpServletRequest, "/public/error.jsf?principalShowForm=true");
            String idToken = (String)sessione.getAttribute("oauthIdToken");
            String logoutUrl = OAuth2Utilities.creaUrlLogout((String)idToken, (String)oauth2LogoutUrl, (String)redirPageUrl);
            sessione.setAttribute("principalErrorMsg", (Object)lb.getLoginErrorMessage());
            httpServletResponse.sendRedirect(logoutUrl);
        } else {
            log.debug("Utente autorizzato");
            sessione.setAttribute("loginBean", (Object)lb);
            String redirPageUrl = httpServletRequest.getContextPath() + "/index.jsp";
            httpServletResponse.sendRedirect(redirPageUrl);
        }
    }

    private void verificaSessioneUtenteLoggato(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String loginSessioneScadutaRedirectUrl, LoginBean lb) throws IOException {
        log.debug("Login Bean Utente Loggato controllo validita' sessione...");
        boolean isSessionInvalid = SessionUtils.isSessionInvalid(httpServletRequest);
        if (isSessionInvalid) {
            log.debug("Login Bean Utente Loggato controllo validita' sessione [invalida]");
            lb.logout();
            String redirPageUrl = StringUtils.isNotEmpty((String)loginSessioneScadutaRedirectUrl) ? loginSessioneScadutaRedirectUrl : httpServletRequest.getContextPath() + "/index.jsp";
            httpServletResponse.sendRedirect(redirPageUrl);
        } else {
            log.debug("Utente autorizzato");
            String redirPageUrl = httpServletRequest.getContextPath() + "/index.jsp";
            httpServletResponse.sendRedirect(redirPageUrl);
        }
    }

    private LoginBean creaLoginBeanNonLoggato(HttpServletRequest httpServletRequest) {
        Locale localeRequest = httpServletRequest.getLocale();
        log.debug("Locale trovato nella Request[{}]", (Object)localeRequest);
        LoginBean lb = new LoginBean(true);
        lb.setLoggedIn(false);
        return lb;
    }

    private Locale leggiLocale() {
        Locale loc = null;
        try {
            loc = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        }
        catch (Exception e) {
            log.debug("Errore durante controllo Locale: " + e.getMessage(), (Throwable)e);
            loc = Locale.getDefault();
        }
        return loc;
    }

    private LoginBean leggiLoginBeanDallaSessioneJsf(LoginBean lb) {
        try {
            FacesContext currentInstance = FacesContext.getCurrentInstance();
            log.debug("FacesContext not null [{}]", (Object)(currentInstance != null ? 1 : 0));
            if (currentInstance != null) {
                ExternalContext ec = currentInstance.getExternalContext();
                log.debug("ExternalContext not null [{}]", (Object)(ec != null ? 1 : 0));
                if (ec != null) {
                    lb = (LoginBean)ec.getSessionMap().get("loginBean");
                    log.debug("LoginBean trovato in nella SessionMap JSF [{}]", (Object)(lb != null ? 1 : 0));
                }
            }
        }
        catch (Exception e) {
            lb = null;
        }
        return lb;
    }
}

