/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.status;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.monitor.engine.constants.SondaStatus;
import org.openspcoop2.monitor.engine.status.GatewayStatus;
import org.openspcoop2.monitor.engine.status.IStatus;
import org.openspcoop2.monitor.engine.status.StatusUtilities;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntime;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.status.BaseSondaPdd;
import org.openspcoop2.web.monitor.core.status.ISondaPdd;
import org.slf4j.Logger;

public class SondaPddStatus
extends BaseSondaPdd
implements ISondaPdd {
    public static final String GATEWAY_DEFAULT = "Gateway";
    public static final String ALIAS_DEFAULT = "pdd";
    private static final long serialVersionUID = 1L;

    public SondaPddStatus(String identificativo, Logger log, Properties prop) throws Exception {
        super(identificativo, log, prop);
    }

    @Override
    protected void init() throws Exception {
        try {
            this.log.debug("Init Sonda Pdd Status in corso...");
            this.listaStatus = new ArrayList();
            PddMonitorProperties pddMonitorProperties = PddMonitorProperties.getInstance(this.log);
            List<String> listaPdDMonitorateStatusPdD = this.getListaPdDMonitorate_StatusPdD();
            ConfigurazioneNodiRuntime config = pddMonitorProperties.getConfigurazioneNodiRuntime();
            Iterator<String> iterator = listaPdDMonitorateStatusPdD.iterator();
            while (iterator.hasNext()) {
                String readConnectionTimeoutS;
                String url;
                String nomeSonda;
                String nomeNodoRuntime = nomeSonda = iterator.next();
                if (listaPdDMonitorateStatusPdD.size() == 1 && GATEWAY_DEFAULT.equals(nomeSonda) && !config.containsNode(nomeSonda) && config.containsNode(ALIAS_DEFAULT)) {
                    nomeNodoRuntime = ALIAS_DEFAULT;
                }
                if ((url = config.getCheckStatusUrl(nomeNodoRuntime)) == null) {
                    url = this.propertiesSonda.getProperty(nomeSonda + ".url");
                }
                if (url == null) {
                    url = config.getResourceUrl(nomeNodoRuntime);
                }
                if (url == null) {
                    String p1 = "statoPdD.sonde.standard." + nomeSonda + ".url";
                    throw new CoreException("Alternative Properties [" + p1 + "] or [remoteAccess.url] not found");
                }
                boolean https = false;
                boolean httpsVerificaHostName = true;
                boolean httpsAutenticazioneServer = true;
                String httpsTruststorePath = null;
                String httpsTruststoreType = null;
                String httpsTruststorePassword = null;
                Integer connectionTimeout = null;
                Integer readConnectionTimeout = null;
                String httpsP = this.propertiesSonda.getProperty(nomeSonda + ".https");
                https = httpsP != null ? "true".equals(httpsP.trim()) : config.isHttps(nomeNodoRuntime);
                String connectionTimeoutS = this.propertiesSonda.getProperty(nomeSonda + ".connectionTimeout");
                if (connectionTimeoutS == null) {
                    connectionTimeoutS = config.getConnectionTimeout(nomeNodoRuntime);
                }
                if (connectionTimeoutS != null) {
                    connectionTimeout = Integer.valueOf(connectionTimeoutS);
                }
                if ((readConnectionTimeoutS = this.propertiesSonda.getProperty(nomeSonda + ".readConnectionTimeout")) == null) {
                    readConnectionTimeoutS = config.getReadConnectionTimeout(nomeNodoRuntime);
                }
                if (readConnectionTimeoutS != null) {
                    readConnectionTimeout = Integer.valueOf(readConnectionTimeoutS);
                }
                if (https) {
                    String httpsPverificaHostName = this.propertiesSonda.getProperty(nomeSonda + ".https.verificaHostName");
                    httpsVerificaHostName = httpsPverificaHostName != null ? "false".equals(httpsPverificaHostName.trim()) : config.isHttps_verificaHostName(nomeNodoRuntime);
                    String httpsPautenticazioneServer = this.propertiesSonda.getProperty(nomeSonda + ".https.autenticazioneServer");
                    httpsAutenticazioneServer = httpsPautenticazioneServer != null ? "false".equals(httpsPautenticazioneServer.trim()) : config.isHttps_autenticazioneServer(nomeNodoRuntime);
                    if (httpsAutenticazioneServer) {
                        httpsTruststorePath = this.propertiesSonda.getProperty(nomeSonda + ".https.autenticazioneServer.truststorePath");
                        if (httpsTruststorePath == null) {
                            httpsTruststorePath = config.getHttps_autenticazioneServer_truststorePath(nomeNodoRuntime);
                        }
                        if (StringUtils.isEmpty((String)httpsTruststorePath)) {
                            throw new CoreException("[gateway:" + nomeSonda + "] TLS Truststore path non fornito");
                        }
                        httpsTruststoreType = this.propertiesSonda.getProperty(nomeSonda + ".https.autenticazioneServer.truststoreType");
                        if (httpsTruststoreType == null) {
                            httpsTruststoreType = config.getHttps_autenticazioneServer_truststoreType(nomeNodoRuntime);
                        }
                        if (StringUtils.isEmpty((String)httpsTruststoreType)) {
                            throw new CoreException("[gateway:" + nomeSonda + "] TLS Truststore type non fornito");
                        }
                        httpsTruststorePassword = this.propertiesSonda.getProperty(nomeSonda + ".https.autenticazioneServer.truststorePassword");
                        if (httpsTruststorePassword == null) {
                            httpsTruststorePassword = config.getHttps_autenticazioneServer_truststorePassword(nomeNodoRuntime);
                        }
                        if (StringUtils.isEmpty((String)httpsTruststorePassword)) {
                            throw new CoreException("[gateway:" + nomeSonda + "] TLS Truststore password non fornito");
                        }
                    }
                }
                GatewayStatus pddStat = new GatewayStatus();
                String descrizione = null;
                if (config.containsNode(nomeNodoRuntime)) {
                    descrizione = config.getDescrizione(nomeNodoRuntime);
                }
                pddStat.setNome(descrizione != null ? descrizione : nomeSonda);
                pddStat.setUrl(url);
                pddStat.setHttps(https);
                pddStat.setHttps_verificaHostName(httpsVerificaHostName);
                pddStat.setHttps_autenticazioneServer(httpsAutenticazioneServer);
                pddStat.setHttps_autenticazioneServer_truststorePath(httpsTruststorePath);
                pddStat.setHttps_autenticazioneServer_truststoreType(httpsTruststoreType);
                pddStat.setHttps_autenticazioneServer_truststorePassword(httpsTruststorePassword);
                if (connectionTimeout != null) {
                    pddStat.setConnectionTimeout(connectionTimeout.intValue());
                }
                if (readConnectionTimeout != null) {
                    pddStat.setReadConnectionTimeout(readConnectionTimeout.intValue());
                }
                this.listaStatus.add(pddStat);
            }
            this.log.debug("Init Sonda Pdd Status completato.");
        }
        catch (Exception e) {
            this.logError("Si e' verificato un errore durante l'Init Sonda Pdd Status: " + e.getMessage(), e);
            throw e;
        }
    }

    @Override
    public List<IStatus> updateStato() throws Exception {
        return StatusUtilities.updateStato((List)this.listaStatus, (Logger)this.log);
    }

    public List<String> getListaPdDMonitorate_StatusPdD() throws Exception {
        return PddMonitorProperties.getInstance(this.log).getListaPdDMonitorate_StatusPdD();
    }

    @Override
    public String getMessaggioStatoSondaPdd() throws Exception {
        return StatusUtilities.getDetailStatesProcess((List)this.listaStatus);
    }

    @Override
    public SondaStatus getStatoSondaPdd() throws Exception {
        return StatusUtilities.statesProcess((List)this.listaStatus);
    }
}

