/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.utils;

import java.io.Serializable;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class BrowserInfo
implements Serializable {
    public static final String USER_AGENT_HEADER_NAME = "User-Agent";
    private static final long serialVersionUID = 1L;
    private Double version;
    private String browserName;
    private BrowserFamily browserFamily;
    private String userAgentString;

    public Double getVersion() {
        return this.version;
    }

    public void setVersion(Double version) {
        this.version = version;
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    public BrowserFamily getBrowserFamily() {
        return this.browserFamily;
    }

    public void setBrowserFamily(BrowserFamily browserFamily) {
        this.browserFamily = browserFamily;
    }

    public String getUserAgentString() {
        return this.userAgentString;
    }

    public void setUserAgentString(String userAgentString) {
        this.userAgentString = userAgentString;
    }

    public static BrowserInfo getBrowserInfo(String Information) {
        String subsString;
        BrowserInfo browserInfo = new BrowserInfo();
        browserInfo.setUserAgentString(Information);
        String browser = browserInfo.getUserAgentString();
        String[] info = null;
        BrowserFamily bf = null;
        if (browser.contains("MSIE")) {
            subsString = browser.substring(browser.indexOf("MSIE"));
            info = subsString.split(";")[0].split(" ");
            bf = BrowserFamily.IE;
        } else if (browser.contains("msie")) {
            subsString = browser.substring(browser.indexOf("msie"));
            info = subsString.split(";")[0].split(" ");
            bf = BrowserFamily.IE;
        } else if (browser.contains("Trident")) {
            int idx;
            subsString = browser.substring(browser.indexOf("Trident"));
            info = new String[]{subsString.split(";")[0].split("/")[0], (idx = subsString.split(";")[1].indexOf(")")) > -1 ? ((String)subsString.split(";")[1].subSequence(0, idx)).split(":")[1] : ""};
            bf = BrowserFamily.IE;
        } else if (browser.contains("Firefox")) {
            subsString = browser.substring(browser.indexOf("Firefox"));
            info = subsString.split(" ")[0].split("/");
            bf = BrowserFamily.FIREFOX;
        } else if (browser.contains("Chrome")) {
            subsString = browser.substring(browser.indexOf("Chrome"));
            info = subsString.split(" ")[0].split("/");
            bf = BrowserFamily.CHROME;
        } else if (browser.contains("Opera")) {
            subsString = browser.substring(browser.indexOf("Opera"));
            info = subsString.split(" ")[0].split("/");
            bf = BrowserFamily.OPERA;
        } else if (browser.contains("Safari")) {
            subsString = browser.substring(browser.indexOf("Safari"));
            info = subsString.split(" ")[0].split("/");
            bf = BrowserFamily.SAFARI;
        }
        if (info != null) {
            browserInfo.setBrowserName(info[0]);
            try {
                if (StringUtils.isNotEmpty((String)info[1])) {
                    Object tmp = info[1];
                    while (((String)tmp).indexOf(".") != ((String)tmp).lastIndexOf(".")) {
                        String pt1 = ((String)tmp).substring(0, ((String)tmp).lastIndexOf("."));
                        String pt2 = "";
                        if (((String)tmp).substring(((String)tmp).lastIndexOf(".")).length() > 1) {
                            pt2 = ((String)tmp).substring(((String)tmp).lastIndexOf(".") + 1);
                        }
                        tmp = pt1 + pt2;
                    }
                    browserInfo.setVersion(StringUtils.isNotEmpty((String)tmp) ? Double.valueOf(Double.parseDouble((String)tmp)) : null);
                } else {
                    browserInfo.setVersion(null);
                }
            }
            catch (NumberFormatException e) {
                browserInfo.setVersion(null);
            }
        }
        browserInfo.setBrowserFamily(bf);
        return browserInfo;
    }

    public static BrowserInfo getBrowserInfo(FacesContext context) throws Exception {
        ExternalContext externalContext;
        if (context != null && (externalContext = context.getExternalContext()) != null) {
            HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
            String userAgent = request.getHeader(USER_AGENT_HEADER_NAME);
            return BrowserInfo.getBrowserInfo(userAgent);
        }
        return null;
    }

    public static HttpServletResponse getResponse(FacesContext context) throws Exception {
        ExternalContext externalContext;
        if (context != null && (externalContext = context.getExternalContext()) != null) {
            HttpServletResponse response = (HttpServletResponse)externalContext.getResponse();
            return response;
        }
        return null;
    }

    public static enum BrowserFamily {
        IE,
        CHROME,
        FIREFOX,
        SAFARI,
        OPERA;

    }
}

