/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.utils;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.search.AccordoServizioParteComune;
import org.openspcoop2.core.commons.search.AccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteComune;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteComuneGruppo;
import org.openspcoop2.core.commons.search.PortaApplicativa;
import org.openspcoop2.core.commons.search.PortaDelegata;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.constants.TipoPdD;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.web.monitor.core.bean.UserDetailsBean;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.PermessiUtenteOperatore;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.dao.DynamicUtilsService;
import org.openspcoop2.web.monitor.core.dao.IDynamicUtilsService;
import org.slf4j.Logger;

public class DynamicPdDBeanUtils
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Logger log = null;
    private transient IDynamicUtilsService dynamicUtilsService = null;
    private static DynamicPdDBeanUtils instance = null;
    public static Integer maxSelectItemsWidth = 700;
    public static Integer defaultSelectItemsWidth = 412;
    private transient AffineTransform affineTransform = null;
    private transient FontRenderContext fontRenderContext = null;
    private transient Font defaultFont = null;

    private void logDebug(String msg) {
        if (this.log != null) {
            this.log.debug(msg);
        }
    }

    private void logError(String msg) {
        if (this.log != null) {
            this.log.error(msg);
        }
    }

    private void logError(String msg, Exception e) {
        if (this.log != null) {
            this.log.error(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DynamicPdDBeanUtils getInstance(Logger log) {
        if (instance != null) return instance;
        Class<DynamicPdDBeanUtils> clazz = DynamicPdDBeanUtils.class;
        synchronized (DynamicPdDBeanUtils.class) {
            DynamicPdDBeanUtils.init(log);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static synchronized void init(Logger log) {
        if (instance == null) {
            instance = new DynamicPdDBeanUtils(log);
        }
    }

    public DynamicPdDBeanUtils(Logger log) {
        this(null, null, null, null, log);
    }

    public DynamicPdDBeanUtils(org.openspcoop2.core.commons.search.dao.IServiceManager serviceManager, IServiceManager pluginsServiceManager, DriverRegistroServiziDB driverRegistroServiziDB, DriverConfigurazioneDB driverConfigurazioneDB, Logger log) {
        this.log = log;
        try {
            this.logDebug("Init Dynamic Utils in corso...");
            this.dynamicUtilsService = serviceManager != null ? new DynamicUtilsService(serviceManager, pluginsServiceManager, driverRegistroServiziDB, driverConfigurazioneDB) : new DynamicUtilsService();
            String fontName = PddMonitorProperties.getInstance(log).getConsoleFontFamilyName();
            int fontStyle = PddMonitorProperties.getInstance(log).getConsoleFontStyle();
            this.defaultFont = new Font(fontName, fontStyle, 14);
            this.logDebug("Init Dynamic Utils in completato.");
        }
        catch (Exception e) {
            this.logError("Si e' verificato un errore durante la init: " + e.getMessage(), e);
        }
    }

    public boolean isTipoSoggettoCompatibile(String tipo1, String tipo2) throws ProtocolException {
        IProtocolFactory protocolFactory;
        if (StringUtils.isBlank((String)tipo1) || StringUtils.isBlank((String)tipo2)) {
            return true;
        }
        ArrayList<String> tipiDisponibili1 = new ArrayList<String>();
        ArrayList<String> tipiDisponibili2 = new ArrayList<String>();
        if (!tipo1.equals("*")) {
            protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByOrganizationType(tipo1);
            tipiDisponibili1.add(protocolFactory.getProtocol());
        }
        if (!tipo2.equals("*")) {
            protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByOrganizationType(tipo2);
            tipiDisponibili2.add(protocolFactory.getProtocol());
        }
        HashMap<String, String> mappaTipi = new HashMap<String, String>();
        if (tipiDisponibili1 != null && !tipiDisponibili1.isEmpty()) {
            for (String tipo : tipiDisponibili1) {
                if (mappaTipi.containsKey(tipo)) continue;
                mappaTipi.put(tipo, tipo);
            }
        }
        if (tipiDisponibili2 != null && !tipiDisponibili2.isEmpty()) {
            for (String tipo : tipiDisponibili2) {
                if (mappaTipi.containsKey(tipo)) continue;
                mappaTipi.put(tipo, tipo);
            }
        }
        if (!tipiDisponibili1.isEmpty() && tipiDisponibili1.size() != mappaTipi.keySet().size()) {
            return false;
        }
        return tipiDisponibili2.isEmpty() || tipiDisponibili2.size() == mappaTipi.keySet().size();
    }

    public boolean isTipoSoggettoCompatibileConProtocollo(String tipoSoggetto, String tipoProtocollo) throws ProtocolException {
        IProtocolFactory protocolFactory;
        if (StringUtils.isBlank((String)tipoSoggetto) || StringUtils.isBlank((String)tipoProtocollo)) {
            return true;
        }
        return tipoSoggetto.equals("*") || (protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByOrganizationType(tipoSoggetto)) != null && protocolFactory.getProtocol().equals(tipoProtocollo);
    }

    public boolean isTipoServizioCompatibileConProtocollo(String tipoServizio, String tipoProtocollo) throws ProtocolException {
        IProtocolFactory protocolFactory;
        if (StringUtils.isBlank((String)tipoServizio) || StringUtils.isBlank((String)tipoProtocollo)) {
            return true;
        }
        return tipoServizio.equals("*") || (protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByServiceType(tipoServizio)) != null && protocolFactory.getProtocol().equals(tipoProtocollo);
    }

    public boolean isAccordoCompatibileConProtocollo(String tipoErogatore, String nomeErogatore, String accordo, String tipoProtocollo) throws Exception {
        List<AccordoServizioParteSpecifica> servizi2;
        if (StringUtils.isBlank((String)accordo) || StringUtils.isBlank((String)tipoProtocollo)) {
            return true;
        }
        ArrayList<String> tipiDisponibili1 = new ArrayList<String>();
        if (!accordo.equals("*") && (servizi2 = this.dynamicUtilsService.getServizi(tipoProtocollo, accordo, tipoErogatore, nomeErogatore)) != null && servizi2.size() > 0) {
            for (AccordoServizioParteSpecifica accordoServizioParteSpecifica : servizi2) {
                IProtocolFactory protocolFactory;
                String tipo = accordoServizioParteSpecifica.getIdErogatore() != null ? accordoServizioParteSpecifica.getIdErogatore().getTipo() : null;
                if (tipo == null || tipiDisponibili1.contains((protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByOrganizationType(tipo)).getProtocol())) continue;
                tipiDisponibili1.add(protocolFactory.getProtocol());
            }
        }
        return tipoProtocollo.equals("*") || tipiDisponibili1.size() <= 0 || tipiDisponibili1.contains(tipoProtocollo);
    }

    public boolean isSupportataAutenticazioneApplicativiEsterniErogazione(String tipoProtocollo) throws Exception {
        if (tipoProtocollo == null || "".equals(tipoProtocollo) || StringUtils.isBlank((String)tipoProtocollo)) {
            return false;
        }
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tipoProtocollo);
        if (protocolFactory == null || !protocolFactory.getProtocol().equals(tipoProtocollo)) {
            return false;
        }
        return protocolFactory.createProtocolConfiguration().isSupportoAutenticazioneApplicativiEsterniErogazioni();
    }

    public List<Object> findElencoServiziApplicativiFromSoggettoLocale(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, boolean trasporto, boolean token) {
        List<Object> list = new ArrayList<Object>();
        Soggetto erogatore = this.dynamicUtilsService.findSoggettoByTipoNome(tipoSoggetto, nomeSoggetto);
        if (erogatore != null) {
            list = this.dynamicUtilsService.findElencoServiziApplicativi(tipoProtocollo, erogatore, trasporto, token);
        }
        return list;
    }

    public List<SelectItem> getListaSelectItemsServiziApplicativiFromSoggettoLocale(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, boolean trasporto, boolean token) {
        ArrayList<SelectItem> sa = new ArrayList<SelectItem>();
        List<Object> list = this.findElencoServiziApplicativiFromSoggettoLocale(tipoProtocollo, tipoSoggetto, nomeSoggetto, trasporto, token);
        for (Object res : list) {
            sa.add(new SelectItem((Object)((String)res)));
        }
        return sa;
    }

    public List<SelectItem> getSoggetti() {
        ArrayList<SelectItem> soggetti = new ArrayList<SelectItem>();
        String tipoProtocollo = null;
        String idPorta = null;
        List<Soggetto> list = this.dynamicUtilsService.findElencoSoggetti(tipoProtocollo, idPorta);
        for (Soggetto soggetto : list) {
            soggetti.add(new SelectItem((Object)(soggetto.getTipoSoggetto() + "/" + soggetto.getNomeSoggetto())));
        }
        return soggetti;
    }

    public List<SelectItem> getIdPorte() {
        ArrayList<SelectItem> idPorte = new ArrayList<SelectItem>();
        String tipoProtocollo = null;
        String idPorta = null;
        List<Soggetto> list = this.dynamicUtilsService.findElencoSoggetti(tipoProtocollo, idPorta);
        ArrayList<String> checkContains = new ArrayList<String>();
        for (Soggetto soggetto : list) {
            if (checkContains.contains(soggetto.getIdentificativoPorta())) continue;
            idPorte.add(new SelectItem((Object)soggetto.getIdentificativoPorta()));
            checkContains.add(soggetto.getIdentificativoPorta());
        }
        return idPorte;
    }

    public String getIdPortaFromSoggetto(String tipoSoggetto, String nomeSoggetto) {
        String idPorta = null;
        Soggetto soggetto = this.dynamicUtilsService.findSoggettoByTipoNome(tipoSoggetto, nomeSoggetto);
        if (soggetto != null) {
            idPorta = soggetto.getIdentificativoPorta();
        }
        return idPorta;
    }

    public List<SelectItem> getSoggettiFromIdPorta(String idPorta) {
        ArrayList<SelectItem> soggetti = new ArrayList<SelectItem>();
        String tipoProtocollo = null;
        List<Soggetto> list = this.dynamicUtilsService.findElencoSoggetti(tipoProtocollo, idPorta);
        for (Soggetto soggetto : list) {
            soggetti.add(new SelectItem((Object)(soggetto.getTipoSoggetto() + "/" + soggetto.getNomeSoggetto())));
        }
        return soggetti;
    }

    public String getServerFromSoggetto(String tipoSoggetto, String nomeSoggetto) {
        String idPorta = null;
        Soggetto soggetto = this.dynamicUtilsService.findSoggettoByTipoNome(tipoSoggetto, nomeSoggetto);
        if (soggetto != null) {
            idPorta = soggetto.getServer();
        }
        return idPorta;
    }

    public boolean checkTipoPdd(String nome, TipoPdD tipoPdD) {
        return this.dynamicUtilsService.checkTipoPdd(nome, tipoPdD);
    }

    public List<SelectItem> getListaGruppi(String tipoProtocollo) {
        ArrayList<SelectItem> gruppi = new ArrayList<SelectItem>();
        try {
            List<IDGruppo> lista = this.dynamicUtilsService.getGruppi(tipoProtocollo);
            if (lista != null && !lista.isEmpty()) {
                for (IDGruppo id : lista) {
                    SelectItem item = new SelectItem((Object)id.getNome(), id.getNome());
                    gruppi.add(item);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gruppi;
    }

    public List<String> getListaNomiGruppi() {
        return this.getListaNomiGruppi(null);
    }

    public List<String> getListaNomiGruppi(String tipoProtocollo) {
        ArrayList<String> gruppi = new ArrayList<String>();
        try {
            List<IDGruppo> lista = this.dynamicUtilsService.getGruppi(tipoProtocollo);
            if (lista != null && !lista.isEmpty()) {
                for (IDGruppo id : lista) {
                    gruppi.add(id.getNome());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gruppi;
    }

    public boolean existsGruppi(String tipoProtocollo) {
        return this.dynamicUtilsService.countGruppi(tipoProtocollo) > 0;
    }

    public Map<String, String> findAzioniFromServizio(String tipoProtocollo, IDServizio idServizio, String val) {
        String nomeServizio = idServizio.getNome();
        String tipoServizio = idServizio.getTipo();
        String nomeErogatore = idServizio.getSoggettoErogatore().getNome();
        String tipoErogatore = idServizio.getSoggettoErogatore().getTipo();
        Integer versioneServizio = idServizio.getVersione();
        return this.findAzioniFromServizio(tipoProtocollo, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, val);
    }

    public Map<String, String> findAzioniFromServizio(String tipoProtocollo, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String val) {
        Map<String, String> map = new HashMap<String, String>();
        this.logDebug("Get Lista Azioni from Servizio [nome: " + nomeServizio + "]");
        try {
            map = this.dynamicUtilsService.findAzioniFromServizio(tipoProtocollo, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, val);
        }
        catch (Exception e) {
            this.logError("Si e' verificato un errore durante la ricerca  Azioni per il servizio" + nomeServizio + "]", e);
        }
        return map;
    }

    public List<SelectItem> getListaSelectItemsAzioniFromServizio(String tipoProtocollo, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String val) {
        ArrayList<SelectItem> azioni = new ArrayList<SelectItem>();
        try {
            Map<String, String> map = this.findAzioniFromServizio(tipoProtocollo, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, val);
            for (String azione : map.keySet()) {
                SelectItem item = new SelectItem((Object)azione, map.get(azione));
                azioni.add(item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return azioni;
    }

    public List<SelectItem> getListaSelectItemsAzioniFromAPI(String tipoProtocollo, String nomeAccordo, String tipoReferente, String nomeReferente, Integer versioneAccordo, String val) {
        ArrayList<SelectItem> azioni = new ArrayList<SelectItem>();
        try {
            Map<String, String> map = this.findAzioniFromAPI(tipoProtocollo, nomeAccordo, tipoReferente, nomeReferente, versioneAccordo, val);
            for (String azione : map.keySet()) {
                SelectItem item = new SelectItem((Object)azione, map.get(azione));
                azioni.add(item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return azioni;
    }

    public Map<String, String> findAzioniFromAPI(String tipoProtocollo, String nome, String tipoReferente, String nomeReferente, Integer versione, String val) {
        Map<String, String> map = new HashMap<String, String>();
        this.logDebug("Get Lista Azioni from API [nome: " + nome + "]");
        try {
            map = this.dynamicUtilsService.findAzioniFromAPI(tipoProtocollo, nome, tipoReferente, nomeReferente, versione, val);
        }
        catch (Exception e) {
            this.logError("Si e' verificato un errore durante la ricerca Azioni per l'accordo " + nome + "]", e);
        }
        return map;
    }

    public List<Map<String, Object>> findElencoServiziSoggettoErogatore(String tipoProtocollo, Soggetto erogatore) {
        List<Map<String, Object>> list = null;
        this.logDebug("Find Lista Servizi per il Soggetto Erogatore [" + (erogatore != null ? erogatore.getNomeSoggetto() : "Null") + "]");
        try {
            list = this.dynamicUtilsService.findElencoServizi(tipoProtocollo, erogatore);
        }
        catch (Exception e) {
            this.logError("Si e' verificato un errore durante la ricerca dei servizi per il Soggetto Erogatore [" + (erogatore != null ? erogatore.getNomeSoggetto() : "Null") + "]");
        }
        return list;
    }

    public List<SelectItem> getListaSelectItemsElencoServiziSoggettoErogatore(String tipoProtocollo, Soggetto erogatore, boolean showTipoServizio, boolean showUriAccordo) {
        ArrayList<SelectItem> servizi;
        block9: {
            servizi = new ArrayList<SelectItem>();
            try {
                List<Map<String, Object>> mapServizi = this.findElencoServiziSoggettoErogatore(tipoProtocollo, erogatore);
                if (mapServizi == null || mapServizi.size() <= 0) break block9;
                for (Map<String, Object> res : mapServizi) {
                    String label = null;
                    StringBuilder uri = new StringBuilder();
                    Object obj = res.get(GenericJDBCUtilities.getAlias((Object)AccordoServizioParteSpecifica.model().NOME));
                    String nomeAsps = obj instanceof String ? (String)obj : null;
                    String tipoAsps = null;
                    if (showTipoServizio) {
                        obj = res.get(GenericJDBCUtilities.getAlias((Object)AccordoServizioParteSpecifica.model().TIPO));
                        String string = tipoAsps = obj instanceof String ? (String)obj : null;
                        if (tipoAsps != null) {
                            uri.append(tipoAsps).append("/");
                        }
                    }
                    uri.append(nomeAsps);
                    if (showUriAccordo) {
                        AccordoServizioParteComune aspc;
                        obj = res.get("idAccordo");
                        AccordoServizioParteComune accordoServizioParteComune = aspc = obj instanceof AccordoServizioParteComune ? (AccordoServizioParteComune)obj : null;
                        if (aspc != null) {
                            String nomeAspc = aspc.getNome();
                            Integer versioneAspc = aspc.getVersione();
                            String nomeReferenteAspc = aspc.getIdReferente() != null ? aspc.getIdReferente().getNome() : null;
                            String tipoReferenteAspc = aspc.getIdReferente() != null ? aspc.getIdReferente().getTipo() : null;
                            try {
                                uri.append(" (").append(IDAccordoFactory.getInstance().getUriFromValues(nomeAspc, tipoReferenteAspc, nomeReferenteAspc, versioneAspc));
                                uri.append(")");
                            }
                            catch (DriverRegistroServiziException e) {
                                uri = new StringBuilder();
                                uri.append("");
                            }
                        }
                    }
                    label = uri.toString();
                    servizi.add(new SelectItem((Object)label));
                }
            }
            catch (Throwable e) {
                this.logError("Si e' verificato un errore durante la ricerca dei servizi per il Soggetto Erogatore [" + (erogatore != null ? erogatore.getNomeSoggetto() : "Null") + "]");
            }
        }
        return servizi;
    }

    public List<SelectItem> getListaSelectItemsAccordiServizio(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, boolean isReferente, boolean isErogatore, String tag) {
        ArrayList<SelectItem> servizi = new ArrayList<SelectItem>();
        try {
            List<AccordoServizioParteComune> listaAccordi = this.dynamicUtilsService.getAccordiServizio(tipoProtocollo, tipoSoggetto, nomeSoggetto, isReferente, isErogatore, tag);
            ArrayList<String> lstLabelOrdinate = new ArrayList<String>();
            HashMap<String, String> mapElementi = new HashMap<String, String>();
            if (listaAccordi != null && listaAccordi.size() > 0) {
                for (AccordoServizioParteComune aspc : listaAccordi) {
                    if (aspc == null) continue;
                    String nomeAspc = aspc.getNome();
                    Integer versioneAspc = aspc.getVersione();
                    String nomeReferenteAspc = aspc.getIdReferente() != null ? aspc.getIdReferente().getNome() : null;
                    String tipoReferenteAspc = aspc.getIdReferente() != null ? aspc.getIdReferente().getTipo() : null;
                    String label = null;
                    String uri = null;
                    try {
                        uri = IDAccordoFactory.getInstance().getUriFromValues(nomeAspc, tipoReferenteAspc, nomeReferenteAspc, versioneAspc);
                        IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromValues(nomeAspc, tipoReferenteAspc, nomeReferenteAspc, versioneAspc);
                        label = NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idAccordo);
                    }
                    catch (DriverRegistroServiziException e) {
                        uri = "";
                    }
                    lstLabelOrdinate.add(label);
                    mapElementi.put(label, uri);
                }
            }
            if (!lstLabelOrdinate.isEmpty()) {
                Collections.sort(lstLabelOrdinate);
                for (String string : lstLabelOrdinate) {
                    servizi.add(new SelectItem(mapElementi.get(string), string));
                }
            }
        }
        catch (RuntimeException e) {
            this.logError("(Runtime) Si e' verificato un errore durante la ricerca degli Accordi di servizio il Soggetto [" + tipoSoggetto + "/" + nomeSoggetto + "] Referente [" + isReferente + "], Erogatore [" + isErogatore + "]");
        }
        catch (Exception e) {
            this.logError("Si e' verificato un errore durante la ricerca degli Accordi di servizio il Soggetto [" + tipoSoggetto + "/" + nomeSoggetto + "] Referente [" + isReferente + "], Erogatore [" + isErogatore + "]");
        }
        return servizi;
    }

    public List<SelectItem> getListaSelectItemsElencoServiziFromAccordoAndSoggettoErogatore(String tipoProtocollo, String gruppo, IDAccordo idAccordo, String uriAccordoServizio, String tipoSoggetto, String nomeSoggetto, String input) {
        return this.getListaSelectItemsElencoServiziFromAccordoAndSoggettoErogatore(tipoProtocollo, gruppo, idAccordo, uriAccordoServizio, tipoSoggetto, nomeSoggetto, input, false);
    }

    public List<SelectItem> getListaSelectItemsElencoServiziFromAccordoAndSoggettoErogatore(String tipoProtocollo, String gruppo, IDAccordo idAccordo, String uriAccordoServizio, String tipoSoggetto, String nomeSoggetto, String input, boolean soloOperativi) {
        ArrayList<SelectItem> servizi = new ArrayList<SelectItem>();
        try {
            UserDetailsBean user = Utility.getLoggedUser();
            PermessiUtenteOperatore permessiUtenteOperatoreRecheck = null;
            if (user != null && !user.isAdmin()) {
                permessiUtenteOperatoreRecheck = new PermessiUtenteOperatore();
                if (user.getUtenteSoggettoList() != null && !user.getUtenteSoggettoList().isEmpty()) {
                    permessiUtenteOperatoreRecheck.getListIDSoggetti().addAll(user.getUtenteSoggettoList());
                }
                if (user.getUtenteServizioList() != null && !user.getUtenteServizioList().isEmpty()) {
                    permessiUtenteOperatoreRecheck.getListIDServizi().addAll(user.getUtenteServizioList());
                }
            }
            if (permessiUtenteOperatoreRecheck != null) {
                List<IDServizio> listIdServiziErogazione = this.dynamicUtilsService.getServiziErogazione(tipoProtocollo, tipoSoggetto, nomeSoggetto, input, false, permessiUtenteOperatoreRecheck, true);
                List<IDServizio> listIdServiziFruizione = this.dynamicUtilsService.getServiziFruizione(tipoProtocollo, tipoSoggetto, nomeSoggetto, input, false, permessiUtenteOperatoreRecheck, true);
                ArrayList<IDServizio> listIdServizi = new ArrayList<IDServizio>();
                if (listIdServiziErogazione != null && !listIdServiziErogazione.isEmpty()) {
                    for (IDServizio idServizio : listIdServiziErogazione) {
                        if (listIdServizi.contains(idServizio)) continue;
                        listIdServizi.add(idServizio);
                    }
                }
                if (listIdServiziFruizione != null && !listIdServiziFruizione.isEmpty()) {
                    for (IDServizio idServizio : listIdServiziFruizione) {
                        if (listIdServizi.contains(idServizio)) continue;
                        listIdServizi.add(idServizio);
                    }
                }
                if (listIdServizi != null && !listIdServizi.isEmpty()) {
                    IDAccordoFactory idAccordoFactory = null;
                    if (idAccordo != null) {
                        idAccordoFactory = IDAccordoFactory.getInstance();
                    }
                    ArrayList<String> lstLabelOrdinate = new ArrayList<String>();
                    HashMap<String, String> mapElementi = new HashMap<String, String>();
                    for (IDServizio res : listIdServizi) {
                        if (gruppo != null && !"".equals(gruppo) || idAccordo != null) {
                            IDAccordo idAccordoDB;
                            AccordoServizioParteComune aspc = this.dynamicUtilsService.getAccordoServizio(tipoProtocollo, res.getSoggettoErogatore(), res.getTipo(), res.getNome(), res.getVersione());
                            if (idAccordo != null && !idAccordo.equals((Object)(idAccordoDB = idAccordoFactory.getIDAccordoFromValues(aspc.getNome(), aspc.getIdReferente().getTipo(), aspc.getIdReferente().getNome(), aspc.getVersione())))) continue;
                            if (gruppo != null && !"".equals(gruppo)) {
                                IdAccordoServizioParteComune idAspc = new IdAccordoServizioParteComune();
                                idAspc.setIdSoggetto(aspc.getIdReferente());
                                idAspc.setNome(aspc.getNome());
                                idAspc.setVersione(aspc.getVersione());
                                List<IdAccordoServizioParteComuneGruppo> lGruppi = this.dynamicUtilsService.getAccordoServizioGruppi(idAspc);
                                boolean found = false;
                                if (lGruppi != null && !lGruppi.isEmpty()) {
                                    for (IdAccordoServizioParteComuneGruppo gruppoCheck : lGruppi) {
                                        if (!gruppoCheck.getIdGruppo().getNome().equals(gruppo)) continue;
                                        found = true;
                                        break;
                                    }
                                }
                                if (!found) continue;
                            }
                        }
                        boolean add = true;
                        String value = null;
                        StringBuilder uri = new StringBuilder();
                        String nomeAsps = res.getNome();
                        String tipoAsps = res.getTipo();
                        if (tipoAsps != null) {
                            uri.append(tipoAsps).append("/");
                        }
                        uri.append(nomeAsps).append(":").append(res.getVersione());
                        uri.append(" (").append(res.getSoggettoErogatore().getTipo()).append("/").append(res.getSoggettoErogatore().getNome()).append(")");
                        IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipoAsps, nomeAsps, res.getSoggettoErogatore().getTipo(), res.getSoggettoErogatore().getNome(), res.getVersione().intValue());
                        String label = NamingUtils.getLabelAccordoServizioParteSpecifica((String)tipoProtocollo, (IDServizio)idServizio);
                        value = uri.toString();
                        if (soloOperativi) {
                            String nomePddFromSoggetto = this.getServerFromSoggetto(res.getSoggettoErogatore().getTipo(), res.getSoggettoErogatore().getNome());
                            add = this.checkTipoPdd(nomePddFromSoggetto, TipoPdD.OPERATIVO);
                        }
                        if (!add) continue;
                        lstLabelOrdinate.add(label);
                        mapElementi.put(label, value);
                    }
                    if (lstLabelOrdinate.size() > 0) {
                        Collections.sort(lstLabelOrdinate);
                        for (String string : lstLabelOrdinate) {
                            servizi.add(new SelectItem(mapElementi.get(string), string));
                        }
                    }
                }
            } else {
                List<AccordoServizioParteSpecifica> servizi2 = this.dynamicUtilsService.getServizi(tipoProtocollo, uriAccordoServizio, tipoSoggetto, nomeSoggetto, input);
                IDAccordoFactory idAccordoFactory = null;
                if (idAccordo != null) {
                    idAccordoFactory = IDAccordoFactory.getInstance();
                }
                if (servizi2 != null && servizi2.size() > 0) {
                    for (AccordoServizioParteSpecifica res : servizi2) {
                        if (gruppo != null && !"".equals(gruppo) || idAccordo != null) {
                            IDAccordo idAccordoDB;
                            if (idAccordo != null && !idAccordo.equals((Object)(idAccordoDB = idAccordoFactory.getIDAccordoFromValues(res.getIdAccordoServizioParteComune().getNome(), res.getIdAccordoServizioParteComune().getIdSoggetto().getTipo(), res.getIdAccordoServizioParteComune().getIdSoggetto().getNome(), res.getIdAccordoServizioParteComune().getVersione())))) continue;
                            if (gruppo != null && !"".equals(gruppo)) {
                                List<IdAccordoServizioParteComuneGruppo> lGruppi = this.dynamicUtilsService.getAccordoServizioGruppi(res.getIdAccordoServizioParteComune());
                                boolean found = false;
                                if (lGruppi != null && !lGruppi.isEmpty()) {
                                    for (IdAccordoServizioParteComuneGruppo gruppoCheck : lGruppi) {
                                        if (!gruppoCheck.getIdGruppo().getNome().equals(gruppo)) continue;
                                        found = true;
                                        break;
                                    }
                                }
                                if (!found) continue;
                            }
                        }
                        boolean add = true;
                        String value = null;
                        StringBuilder uri = new StringBuilder();
                        String nomeAsps = res.getNome();
                        String tipoAsps = res.getTipo();
                        if (tipoAsps != null) {
                            uri.append(tipoAsps).append("/");
                        }
                        uri.append(nomeAsps).append(":").append(res.getVersione());
                        uri.append(" (").append(res.getIdErogatore().getTipo()).append("/").append(res.getIdErogatore().getNome()).append(")");
                        IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipoAsps, nomeAsps, res.getIdErogatore().getTipo(), res.getIdErogatore().getNome(), res.getVersione().intValue());
                        String label = StringUtils.isEmpty((String)nomeSoggetto) ? NamingUtils.getLabelAccordoServizioParteSpecifica((String)tipoProtocollo, (IDServizio)idServizio) : NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((String)tipoProtocollo, (String)idServizio.getTipo(), (String)idServizio.getNome(), (Integer)idServizio.getVersione());
                        value = uri.toString();
                        if (soloOperativi) {
                            String nomePddFromSoggetto = this.getServerFromSoggetto(res.getIdErogatore().getTipo(), res.getIdErogatore().getNome());
                            add = this.checkTipoPdd(nomePddFromSoggetto, TipoPdD.OPERATIVO);
                        }
                        if (!add) continue;
                        servizi.add(new SelectItem((Object)value, label));
                    }
                }
            }
        }
        catch (RuntimeException e) {
            this.logError("(Runtime) Si e' verificato un errore durante la ricerca dei servizi per l'accordo [" + uriAccordoServizio + "] erogati dal Soggetto [" + tipoSoggetto + "/" + nomeSoggetto + "]");
        }
        catch (Exception e) {
            this.logError("Si e' verificato un errore durante la ricerca dei servizi per l'accordo [" + uriAccordoServizio + "] erogati dal Soggetto [" + tipoSoggetto + "/" + nomeSoggetto + "]");
        }
        return servizi;
    }

    public Integer getLunghezzaSelectList(List<SelectItem> listaSelectItem) {
        return this.getLunghezzaSelectList(listaSelectItem, this.getDefaultFont());
    }

    public Integer getLunghezzaSelectList(List<SelectItem> listaSelectItem, Font font) {
        int lunghezza = 0;
        Integer lunghezzaToRet = 0;
        try {
            if (listaSelectItem != null && !listaSelectItem.isEmpty()) {
                for (SelectItem selectItem : listaSelectItem) {
                    String label = selectItem.getLabel() != null ? selectItem.getLabel() : (String)selectItem.getValue();
                    lunghezza = this.getFontWidth(label, font);
                    lunghezzaToRet = Math.max(lunghezza, lunghezzaToRet);
                }
            }
        }
        catch (Throwable e) {
            this.logError("Si e' verificato un errore durante il calcolo della lunghezza delle select items");
        }
        return lunghezzaToRet;
    }

    public static Integer checkLimits(Integer minValue, Integer maxValue, Integer value) {
        Integer toRet = Math.max(minValue, value);
        toRet = Math.min(toRet, maxValue);
        return toRet;
    }

    public Integer getFontWidth(String text) {
        return this.getFontWidth(text, this.getDefaultFont());
    }

    public Integer getFontWidth(String text, String fontName, int fontStyle, int fontSize) {
        Font fontToCheck = new Font(fontName, fontStyle, fontSize);
        return this.getFontWidth(text, fontToCheck);
    }

    public Integer getFontWidth(String text, Font fontToCheck) {
        if (this.fontRenderContext == null) {
            if (this.affineTransform == null) {
                this.affineTransform = new AffineTransform();
            }
            this.fontRenderContext = new FontRenderContext(this.affineTransform, true, true);
        }
        Rectangle2D rectangle2d = fontToCheck.getStringBounds(text, this.fontRenderContext);
        return (int)rectangle2d.getWidth();
    }

    public Font getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = new Font("Lucida Sans", 0, 14);
        }
        return this.defaultFont;
    }

    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
    }

    public AccordoServizioParteSpecifica getAspsFromValues(String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio) {
        return this.dynamicUtilsService.getAspsFromValues(tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio);
    }

    public List<Soggetto> getListaSoggetti(String tipoProtocollo, TipoPdD tipoPdD) {
        return this.dynamicUtilsService.findElencoSoggettiFromTipoPdD(tipoProtocollo, tipoPdD);
    }

    public List<Soggetto> getSoggettiErogatoreAutoComplete(String tipoProtocollo, String uriAccordoServizio, String input, boolean soloOperativi) {
        List<Soggetto> list = this.dynamicUtilsService.getSoggettiErogatoreAutoComplete(tipoProtocollo, uriAccordoServizio, input);
        if (soloOperativi && list != null && !list.isEmpty()) {
            ArrayList<Soggetto> lstOperativi = new ArrayList<Soggetto>();
            for (Soggetto soggetto : list) {
                if (!this.checkTipoPdd(soggetto.getServer(), TipoPdD.OPERATIVO)) continue;
                lstOperativi.add(soggetto);
            }
            return lstOperativi;
        }
        return new ArrayList<Soggetto>();
    }

    public List<SelectItem> getListaSelectItemsElencoServiziErogazione(String tipoProtocollo, String gruppo, IDAccordo idAccordo, String tipoSoggetto, String nomeSoggetto, String input, boolean distinct) {
        return this._getListaSelectItemsElencoServiziErogazione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, null, null, null, null, null, null, input, false, null, distinct);
    }

    public List<SelectItem> getListaSelectItemsElencoServiziErogazione(String tipoProtocollo, String gruppo, IDAccordo idAccordo, String tipoSoggetto, String nomeSoggetto, String input, boolean soloOperativi, boolean distinct) {
        return this._getListaSelectItemsElencoServiziErogazione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, null, null, null, null, null, null, input, soloOperativi, null, distinct);
    }

    public List<SelectItem> getListaSelectItemsElencoConfigurazioneServiziErogazione(String tipoProtocollo, String gruppo, IDAccordo idAccordo, String tipoSoggetto, String nomeSoggetto, String input, boolean soloOperativi, PermessiUtenteOperatore permessiUtenteOperatore, boolean distinct) {
        return this._getListaSelectItemsElencoServiziErogazione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, null, null, null, null, null, null, input, soloOperativi, permessiUtenteOperatore, distinct);
    }

    public List<SelectItem> getListaSelectItemsElencoConfigurazioneServiziErogazione(String tipoProtocollo, String gruppo, IDAccordo idAccordo, String tipoSoggetto, String nomeSoggetto, String tipoErogatore, String nomeErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String nomeAzione, String input, boolean soloOperativi, PermessiUtenteOperatore permessiUtenteOperatore, boolean distinct) {
        return this._getListaSelectItemsElencoServiziErogazione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, tipoErogatore, nomeErogatore, tipoServizio, nomeServizio, versioneServizio, nomeAzione, input, soloOperativi, permessiUtenteOperatore, distinct);
    }

    private List<SelectItem> _getListaSelectItemsElencoServiziErogazione(String tipoProtocollo, String gruppo, IDAccordo idAccordo, String tipoSoggetto, String nomeSoggetto, String tipoErogatore, String nomeErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String nomeAzione, String input, boolean soloOperativi, PermessiUtenteOperatore permessiUtenteOperatore, boolean distinct) {
        ArrayList<SelectItem> servizi = new ArrayList<SelectItem>();
        try {
            UserDetailsBean user = Utility.getLoggedUser();
            PermessiUtenteOperatore permessiUtenteOperatoreRecheck = null;
            if (permessiUtenteOperatore != null) {
                permessiUtenteOperatoreRecheck = permessiUtenteOperatore;
            } else if (user != null && !user.isAdmin()) {
                permessiUtenteOperatoreRecheck = new PermessiUtenteOperatore();
                if (user.getUtenteSoggettoList() != null && !user.getUtenteSoggettoList().isEmpty()) {
                    permessiUtenteOperatoreRecheck.getListIDSoggetti().addAll(user.getUtenteSoggettoList());
                }
                if (user.getUtenteServizioList() != null && !user.getUtenteServizioList().isEmpty()) {
                    permessiUtenteOperatoreRecheck.getListIDServizi().addAll(user.getUtenteServizioList());
                }
            }
            List<IDServizio> servizi2 = null;
            servizi2 = permessiUtenteOperatore != null ? (nomeServizio != null ? this.dynamicUtilsService.getConfigurazioneServiziErogazione(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, input, false, permessiUtenteOperatoreRecheck, distinct) : this.dynamicUtilsService.getConfigurazioneServiziErogazione(tipoProtocollo, tipoSoggetto, nomeSoggetto, input, false, permessiUtenteOperatoreRecheck, distinct)) : (nomeServizio != null ? this.dynamicUtilsService.getServiziErogazione(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, input, false, permessiUtenteOperatoreRecheck, distinct) : this.dynamicUtilsService.getServiziErogazione(tipoProtocollo, tipoSoggetto, nomeSoggetto, input, false, permessiUtenteOperatoreRecheck, distinct));
            IDAccordoFactory idAccordoFactory = null;
            if (idAccordo != null) {
                idAccordoFactory = IDAccordoFactory.getInstance();
            }
            ArrayList<String> lstLabelOrdinate = new ArrayList<String>();
            HashMap<String, String> mapElementi = new HashMap<String, String>();
            if (servizi2 != null && servizi2.size() > 0) {
                for (IDServizio res : servizi2) {
                    if (gruppo != null && !"".equals(gruppo) || idAccordo != null) {
                        IDAccordo idAccordoDB;
                        AccordoServizioParteComune aspc = this.dynamicUtilsService.getAccordoServizio(tipoProtocollo, res.getSoggettoErogatore(), res.getTipo(), res.getNome(), res.getVersione());
                        if (idAccordo != null && !idAccordo.equals((Object)(idAccordoDB = idAccordoFactory.getIDAccordoFromValues(aspc.getNome(), aspc.getIdReferente().getTipo(), aspc.getIdReferente().getNome(), aspc.getVersione())))) continue;
                        if (gruppo != null && !"".equals(gruppo)) {
                            IdAccordoServizioParteComune idAspc = new IdAccordoServizioParteComune();
                            idAspc.setIdSoggetto(aspc.getIdReferente());
                            idAspc.setNome(aspc.getNome());
                            idAspc.setVersione(aspc.getVersione());
                            List<IdAccordoServizioParteComuneGruppo> lGruppi = this.dynamicUtilsService.getAccordoServizioGruppi(idAspc);
                            boolean found = false;
                            if (lGruppi != null && !lGruppi.isEmpty()) {
                                for (IdAccordoServizioParteComuneGruppo gruppoCheck : lGruppi) {
                                    if (!gruppoCheck.getIdGruppo().getNome().equals(gruppo)) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) continue;
                        }
                    }
                    boolean add = true;
                    String value = null;
                    StringBuilder uri = new StringBuilder();
                    String nomeAsps = res.getNome();
                    String tipoAsps = res.getTipo();
                    if (tipoAsps != null) {
                        uri.append(tipoAsps).append("/");
                    }
                    uri.append(nomeAsps).append(":").append(res.getVersione());
                    uri.append(" (").append(res.getSoggettoErogatore().getTipo()).append("/").append(res.getSoggettoErogatore().getNome()).append(")");
                    IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipoAsps, nomeAsps, res.getSoggettoErogatore().getTipo(), res.getSoggettoErogatore().getNome(), res.getVersione().intValue());
                    String label = StringUtils.isEmpty((String)nomeSoggetto) ? NamingUtils.getLabelAccordoServizioParteSpecifica((String)tipoProtocollo, (IDServizio)idServizio) : NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((String)tipoProtocollo, (String)idServizio.getTipo(), (String)idServizio.getNome(), (Integer)idServizio.getVersione());
                    value = uri.toString();
                    if (soloOperativi) {
                        String nomePddFromSoggetto = this.getServerFromSoggetto(res.getSoggettoErogatore().getTipo(), res.getSoggettoErogatore().getNome());
                        add = this.checkTipoPdd(nomePddFromSoggetto, TipoPdD.OPERATIVO);
                    }
                    if (!add) continue;
                    lstLabelOrdinate.add(label);
                    mapElementi.put(label, value);
                }
            }
            if (lstLabelOrdinate.size() > 0) {
                Collections.sort(lstLabelOrdinate);
                for (String string : lstLabelOrdinate) {
                    servizi.add(new SelectItem(mapElementi.get(string), string));
                }
            }
        }
        catch (RuntimeException e) {
            this.logError("(Runtime) Si e' verificato un errore durante la ricerca dei servizi erogati dal Soggetto [" + tipoSoggetto + "/" + nomeSoggetto + "]");
        }
        catch (Exception e) {
            this.logError("Si e' verificato un errore durante la ricerca dei servizi erogati dal Soggetto [" + tipoSoggetto + "/" + nomeSoggetto + "]");
        }
        return servizi;
    }

    public List<SelectItem> getListaSelectItemsElencoServiziFruizione(String tipoProtocollo, String gruppo, IDAccordo idAccordo, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String input, boolean distinct) {
        return this._getListaSelectItemsElencoServiziFruizione(tipoProtocollo, gruppo, idAccordo, null, null, tipoSoggettoErogatore, nomeSoggettoErogatore, null, null, null, null, input, false, null, distinct);
    }

    public List<SelectItem> getListaSelectItemsElencoServiziFruizione(String tipoProtocollo, String gruppo, IDAccordo idAccordo, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String input, boolean soloOperativi, boolean distinct) {
        return this._getListaSelectItemsElencoServiziFruizione(tipoProtocollo, gruppo, idAccordo, null, null, tipoSoggettoErogatore, nomeSoggettoErogatore, null, null, null, null, input, soloOperativi, null, distinct);
    }

    public List<SelectItem> getListaSelectItemsElencoConfigurazioneServiziFruizione(String tipoProtocollo, String gruppo, IDAccordo idAccordo, String tipoSoggetto, String nomeSoggetto, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String input, boolean soloOperativi, PermessiUtenteOperatore permessiUtenteOperatore, boolean distinct) {
        return this._getListaSelectItemsElencoServiziFruizione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, tipoSoggettoErogatore, nomeSoggettoErogatore, null, null, null, null, input, soloOperativi, permessiUtenteOperatore, distinct);
    }

    public List<SelectItem> getListaSelectItemsElencoConfigurazioneServiziFruizione(String tipoProtocollo, String gruppo, IDAccordo idAccordo, String tipoSoggetto, String nomeSoggetto, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String nomeAzione, String input, boolean soloOperativi, PermessiUtenteOperatore permessiUtenteOperatore, boolean distinct) {
        return this._getListaSelectItemsElencoServiziFruizione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio, nomeAzione, input, soloOperativi, permessiUtenteOperatore, distinct);
    }

    private List<SelectItem> _getListaSelectItemsElencoServiziFruizione(String tipoProtocollo, String gruppo, IDAccordo idAccordo, String tipoSoggetto, String nomeSoggetto, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String nomeAzione, String input, boolean soloOperativi, PermessiUtenteOperatore permessiUtenteOperatore, boolean distinct) {
        ArrayList<SelectItem> servizi = new ArrayList<SelectItem>();
        try {
            UserDetailsBean user = Utility.getLoggedUser();
            PermessiUtenteOperatore permessiUtenteOperatoreRecheck = null;
            if (permessiUtenteOperatore != null) {
                permessiUtenteOperatoreRecheck = permessiUtenteOperatore;
            } else if (user != null && !user.isAdmin()) {
                permessiUtenteOperatoreRecheck = new PermessiUtenteOperatore();
                if (user.getUtenteSoggettoList() != null && !user.getUtenteSoggettoList().isEmpty()) {
                    permessiUtenteOperatoreRecheck.getListIDSoggetti().addAll(user.getUtenteSoggettoList());
                }
                if (user.getUtenteServizioList() != null && !user.getUtenteServizioList().isEmpty()) {
                    permessiUtenteOperatoreRecheck.getListIDServizi().addAll(user.getUtenteServizioList());
                }
            }
            List<IDServizio> servizi2 = null;
            servizi2 = tipoSoggetto != null && nomeSoggetto != null ? (nomeServizio != null ? this.dynamicUtilsService.getConfigurazioneServiziFruizione(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoSoggettoErogatore, nomeSoggettoErogatore, versioneServizio, nomeAzione, input, false, permessiUtenteOperatoreRecheck, distinct) : this.dynamicUtilsService.getConfigurazioneServiziFruizione(tipoProtocollo, tipoSoggetto, nomeSoggetto, null, null, tipoSoggettoErogatore, nomeSoggettoErogatore, null, null, input, false, permessiUtenteOperatoreRecheck, distinct)) : (nomeServizio != null ? this.dynamicUtilsService.getServiziFruizione(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio, nomeAzione, input, false, permessiUtenteOperatoreRecheck, distinct) : this.dynamicUtilsService.getServiziFruizione(tipoProtocollo, tipoSoggettoErogatore, nomeSoggettoErogatore, input, false, permessiUtenteOperatoreRecheck, distinct));
            IDAccordoFactory idAccordoFactory = null;
            if (idAccordo != null) {
                idAccordoFactory = IDAccordoFactory.getInstance();
            }
            ArrayList<String> lstLabelOrdinate = new ArrayList<String>();
            HashMap<String, String> mapElementi = new HashMap<String, String>();
            if (servizi2 != null && servizi2.size() > 0) {
                for (IDServizio res : servizi2) {
                    if (gruppo != null && !"".equals(gruppo) || idAccordo != null) {
                        IDAccordo idAccordoDB;
                        AccordoServizioParteComune aspc = this.dynamicUtilsService.getAccordoServizio(tipoProtocollo, res.getSoggettoErogatore(), res.getTipo(), res.getNome(), res.getVersione());
                        if (idAccordo != null && !idAccordo.equals((Object)(idAccordoDB = idAccordoFactory.getIDAccordoFromValues(aspc.getNome(), aspc.getIdReferente().getTipo(), aspc.getIdReferente().getNome(), aspc.getVersione())))) continue;
                        if (gruppo != null && !"".equals(gruppo)) {
                            IdAccordoServizioParteComune idAspc = new IdAccordoServizioParteComune();
                            idAspc.setIdSoggetto(aspc.getIdReferente());
                            idAspc.setNome(aspc.getNome());
                            idAspc.setVersione(aspc.getVersione());
                            List<IdAccordoServizioParteComuneGruppo> lGruppi = this.dynamicUtilsService.getAccordoServizioGruppi(idAspc);
                            boolean found = false;
                            if (lGruppi != null && !lGruppi.isEmpty()) {
                                for (IdAccordoServizioParteComuneGruppo gruppoCheck : lGruppi) {
                                    if (!gruppoCheck.getIdGruppo().getNome().equals(gruppo)) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) continue;
                        }
                    }
                    boolean add = true;
                    String value = null;
                    StringBuilder uri = new StringBuilder();
                    String nomeAsps = res.getNome();
                    String tipoAsps = res.getTipo();
                    if (tipoAsps != null) {
                        uri.append(tipoAsps).append("/");
                    }
                    uri.append(nomeAsps).append(":").append(res.getVersione());
                    uri.append(" (").append(res.getSoggettoErogatore().getTipo()).append("/").append(res.getSoggettoErogatore().getNome()).append(")");
                    IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipoAsps, nomeAsps, res.getSoggettoErogatore().getTipo(), res.getSoggettoErogatore().getNome(), res.getVersione().intValue());
                    String label = StringUtils.isEmpty((String)nomeSoggettoErogatore) ? NamingUtils.getLabelAccordoServizioParteSpecifica((String)tipoProtocollo, (IDServizio)idServizio) : NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((String)tipoProtocollo, (String)idServizio.getTipo(), (String)idServizio.getNome(), (Integer)idServizio.getVersione());
                    value = uri.toString();
                    if (soloOperativi) {
                        String nomePddFromSoggetto = this.getServerFromSoggetto(res.getSoggettoErogatore().getTipo(), res.getSoggettoErogatore().getNome());
                        add = this.checkTipoPdd(nomePddFromSoggetto, TipoPdD.OPERATIVO);
                    }
                    if (!add) continue;
                    lstLabelOrdinate.add(label);
                    mapElementi.put(label, value);
                }
            }
            if (lstLabelOrdinate.size() > 0) {
                Collections.sort(lstLabelOrdinate);
                for (String string : lstLabelOrdinate) {
                    servizi.add(new SelectItem(mapElementi.get(string), string));
                }
            }
        }
        catch (RuntimeException e) {
            this.logError("(Runtime) Si e' verificato un errore durante la ricerca dei servizi erogati dal Soggetto [" + tipoSoggettoErogatore + "/" + nomeSoggettoErogatore + "]");
        }
        catch (Exception e) {
            this.logError("Si e' verificato un errore durante la ricerca dei servizi erogati dal Soggetto [" + tipoSoggettoErogatore + "/" + nomeSoggettoErogatore + "]");
        }
        return servizi;
    }

    public PortaDelegata getPortaDelegata(String nomePorta) {
        return this.dynamicUtilsService.getPortaDelegata(nomePorta);
    }

    public PortaApplicativa getPortaApplicativa(String nomePorta) {
        return this.dynamicUtilsService.getPortaApplicativa(nomePorta);
    }

    public MappingFruizionePortaDelegata getMappingFruizione(IDServizio idServizio, IDSoggetto idSoggetto, IDPortaDelegata idPortaDelegata) {
        return this.dynamicUtilsService.getMappingFruizione(idServizio, idSoggetto, idPortaDelegata);
    }

    public MappingErogazionePortaApplicativa getMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa) {
        return this.dynamicUtilsService.getMappingErogazione(idServizio, idPortaApplicativa);
    }

    public Plugin getPlugin(IdPlugin idPlugin) {
        return this.dynamicUtilsService.getPlugin(idPlugin);
    }

    public boolean existsFaseTracciamentoDBRequestIn(boolean erogazioni, boolean fruizioni) {
        return this.dynamicUtilsService.existsFaseTracciamentoDBRequestIn(erogazioni, fruizioni);
    }

    public boolean existsFaseTracciamentoDBRequestOut(boolean erogazioni, boolean fruizioni) {
        return this.dynamicUtilsService.existsFaseTracciamentoDBRequestOut(erogazioni, fruizioni);
    }

    public boolean existsFaseTracciamentoDBResponseOut(boolean erogazioni, boolean fruizioni) {
        return this.dynamicUtilsService.existsFaseTracciamentoDBResponseOut(erogazioni, fruizioni);
    }
}

