/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.utils;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;

public class MessageManager {
    private static MessageManager instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageManager getInstance() {
        if (instance != null) return instance;
        Class<MessageManager> clazz = MessageManager.class;
        synchronized (MessageManager.class) {
            MessageManager.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static synchronized void init() {
        if (instance == null) {
            instance = new MessageManager();
        }
    }

    public String getMessage(String key) {
        return this.getMessageFromResourceBundle(key);
    }

    private String getMessageFromJSFBundle(String key) {
        return (String)MessageManager.resolveExpression("#{msg['" + key + "']}");
    }

    public static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }

    public static Object resolveExpression(String expression) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application app = facesContext.getApplication();
        ExpressionFactory elFactory = app.getExpressionFactory();
        ELContext elContext = facesContext.getELContext();
        ValueExpression valueExp = elFactory.createValueExpression(elContext, expression, Object.class);
        return valueExp.getValue(elContext);
    }

    public String getMessageFromResourceBundle(String bundleName, String key, Object[] params, Locale locale) {
        Object text = null;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, this.getCurrentClassLoader(params));
            text = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            text = "?? key " + key + " not found ??";
            LoggerWrapperFactory.getLogger(MessageManager.class).error((String)text, (Throwable)e);
        }
        if (params != null) {
            MessageFormat mf = new MessageFormat((String)text, locale);
            text = mf.format(params, new StringBuffer(), (FieldPosition)null).toString();
        }
        return text;
    }

    public ClassLoader getCurrentClassLoader(Object defaultObject) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = defaultObject.getClass().getClassLoader();
        }
        return loader;
    }

    public Locale getLocale() {
        Locale locale = null;
        try {
            UIViewRoot viewRoot;
            FacesContext currentInstance = FacesContext.getCurrentInstance();
            if (currentInstance != null && (viewRoot = currentInstance.getViewRoot()) != null) {
                locale = viewRoot.getLocale();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (locale == null) {
            locale = ApplicationBean.getInstance().getLocale();
        }
        return locale;
    }

    public String getMessageFromResourceBundle(String key) {
        Locale locale = this.getLocale();
        return this.getMessageFromResourceBundle("messages", key, null, locale);
    }

    public String getMessageWithParamsFromResourceBundle(String key, Object ... params) {
        Locale locale = this.getLocale();
        return this.getMessageFromResourceBundle("messages", key, params, locale);
    }

    public String getMessageFromResourceBundle(String key, Locale locale) {
        return this.getMessageFromResourceBundle("messages", key, null, locale);
    }

    public String getMessageFromResourceBundle(String key, String bundleName) {
        Locale locale = this.getLocale();
        if (bundleName == null) {
            bundleName = "messages";
        }
        return this.getMessageFromResourceBundle(bundleName, key, null, locale);
    }

    public String getMessageFromResourceBundle(String key, String bundleName, Locale locale) {
        if (locale == null) {
            locale = this.getLocale();
        }
        if (bundleName == null) {
            bundleName = "messages";
        }
        return this.getMessageFromResourceBundle(bundleName, key, null, locale);
    }
}

