/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.utils;

import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.ContentType;
import org.apache.commons.codec.binary.Base64;
import org.openspcoop2.utils.mime.MimeTypes;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class MimeTypeUtils {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static List<String> classMimesTypes = new ArrayList<String>();

    public static String getBaseType(String mime) {
        try {
            ContentType ct = new ContentType(mime);
            return ct.getBaseType();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean isBase64(byte[] content) {
        try {
            return Base64.isBase64((byte[])content);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static String fileExtensionForMIMEType(String mime) {
        try {
            return MimeTypeUtils.fileExtensionForMIMEType(mime, false);
        }
        catch (Exception e) {
            return "bin";
        }
    }

    public static String fileExtensionForMIMEType(String mimeParam, boolean throwExeptionIfMappingNotFound) throws Exception {
        try {
            ContentType ct = new ContentType(mimeParam);
            MimeTypes mimeTypes = MimeTypes.getInstance();
            String ext = mimeTypes.getExtension(ct.getBaseType());
            if (ext == null && throwExeptionIfMappingNotFound) {
                throw new Exception("Mapping per il mime type (base:" + ct.getBaseType() + " - full:" + mimeParam + ") non trovato.");
            }
            if (ext == null && !throwExeptionIfMappingNotFound) {
                ext = "bin";
            }
            return ext;
        }
        catch (Exception e) {
            log.error("Errore durante la ricerca di un mapping per il mime type:" + mimeParam, (Throwable)e);
            throw e;
        }
    }

    public static String getMimeTypeImageClass(String mimeType) {
        if (mimeType != null && (mimeType = MimeTypeUtils.getBaseType(mimeType)) != null && classMimesTypes.contains(mimeType)) {
            return mimeType;
        }
        return "application/octet-stream";
    }

    static {
        classMimesTypes.add("application/pdf");
        classMimesTypes.add("application/postscript");
        classMimesTypes.add("text/plain");
        classMimesTypes.add("image/bmp");
        classMimesTypes.add("image/cgm");
        classMimesTypes.add("image/dcm");
        classMimesTypes.add("image/dds");
        classMimesTypes.add("image/exr");
        classMimesTypes.add("image/gif");
        classMimesTypes.add("image/hdr");
        classMimesTypes.add("image/ico");
        classMimesTypes.add("image/jng");
        classMimesTypes.add("image/jp2");
        classMimesTypes.add("image/jpeg");
        classMimesTypes.add("image/jpg");
        classMimesTypes.add("image/pbm");
        classMimesTypes.add("image/pbmraw");
        classMimesTypes.add("image/pcd");
        classMimesTypes.add("image/pcx");
        classMimesTypes.add("image/pgm");
        classMimesTypes.add("image/pgmraw");
        classMimesTypes.add("image/pic");
        classMimesTypes.add("image/png");
        classMimesTypes.add("image/pnm");
        classMimesTypes.add("image/psd");
        classMimesTypes.add("image/raw");
        classMimesTypes.add("image/rgb");
        classMimesTypes.add("image/rgba");
        classMimesTypes.add("image/tga");
        classMimesTypes.add("image/tif");
        classMimesTypes.add("image/tiff");
        classMimesTypes.add("image/xbm");
        classMimesTypes.add("image/xcf");
        classMimesTypes.add("image/xpm");
        classMimesTypes.add("text/html");
        classMimesTypes.add("text/htm");
        classMimesTypes.add("text/sgml");
        classMimesTypes.add("text/xhtml");
        classMimesTypes.add("text/xml");
        classMimesTypes.add("video/mpeg");
        classMimesTypes.add("video/quicktime");
        classMimesTypes.add("video/x-msvideo");
        classMimesTypes.add("file-ttf");
        classMimesTypes.add("file-otf");
        classMimesTypes.add("application/msword");
        classMimesTypes.add("application/x-excel");
        classMimesTypes.add("application/x-javascript");
        classMimesTypes.add("text/css");
        classMimesTypes.add("application/x-7z");
        classMimesTypes.add("application/x-a");
        classMimesTypes.add("application/x-ace");
        classMimesTypes.add("application/x-arj");
        classMimesTypes.add("application/x-bz");
        classMimesTypes.add("application/x-bz2");
        classMimesTypes.add("application/x-cpio");
        classMimesTypes.add("application/x-gz");
        classMimesTypes.add("application/x-rar");
        classMimesTypes.add("application/x-tnf");
        classMimesTypes.add("application/x-compress");
        classMimesTypes.add("application/x-zip");
        classMimesTypes.add("application/x-zoo");
        classMimesTypes.add("application/x-tar");
        classMimesTypes.add("application/zip");
        classMimesTypes.add("application/mspowerpoint");
        classMimesTypes.add("application/octet-stream");
        classMimesTypes.add("application/properties");
    }
}

