/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.utils;

import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.driver.IDServizioFactory;

public class ParseUtility {
    public static String parseNomeServizio(String servizio) {
        if (servizio == null) {
            return null;
        }
        String[] res = StringUtils.split((String)servizio, (String)":");
        if (res.length > 0) {
            return res[0];
        }
        return null;
    }

    public static Integer parseVersione(String servizio) {
        if (servizio == null) {
            return null;
        }
        String[] res = StringUtils.split((String)servizio, (String)":");
        if (res.length > 1) {
            return Integer.parseInt(res[1]);
        }
        return null;
    }

    public static String parseNomeSoggetto(String tipoNomeSoggetto) {
        if (tipoNomeSoggetto == null) {
            return null;
        }
        String[] res = StringUtils.split((String)tipoNomeSoggetto, (String)"/");
        if (res.length > 1) {
            return res[1];
        }
        return res[0];
    }

    public static String parseTipoSoggetto(String tipoNomeSoggetto) {
        if (tipoNomeSoggetto == null) {
            return null;
        }
        String[] res = StringUtils.split((String)tipoNomeSoggetto, (String)"/");
        return res[0];
    }

    public static IDServizio parseSoggettoServizio(String input) {
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        String tipoServizio = null;
        String nomeServizio = null;
        Integer versioneServizio = 1;
        if (input.contains(" (")) {
            String[] split = input.split(" \\(");
            String tipoNomeSoggetto = split[0];
            String tipoNomeServizio = split[1].substring(0, split[1].indexOf(")"));
            tipoSoggetto = ParseUtility.parseTipoSoggetto(tipoNomeSoggetto);
            nomeSoggetto = ParseUtility.parseNomeSoggetto(tipoNomeSoggetto);
            tipoServizio = ParseUtility.parseTipoSoggetto(tipoNomeServizio);
            nomeServizio = ParseUtility.parseNomeSoggetto(tipoNomeServizio);
            versioneServizio = ParseUtility.parseVersione(nomeServizio);
            nomeServizio = ParseUtility.parseNomeServizio(nomeServizio);
        } else {
            tipoSoggetto = ParseUtility.parseTipoSoggetto(input);
            nomeSoggetto = ParseUtility.parseNomeSoggetto(input);
        }
        return IDServizioFactory.getInstance().getIDServizioFromValuesWithoutCheck(tipoServizio, nomeServizio, tipoSoggetto, nomeSoggetto, versioneServizio.intValue());
    }

    public static String convertToSoggettoServizio(IDServizio idServizio) {
        StringBuilder uri = new StringBuilder();
        uri.append(idServizio.getSoggettoErogatore().toString());
        if (idServizio.getNome() != null) {
            uri.append(" (");
            String nomeAsps = idServizio.getNome();
            String tipoAsps = idServizio.getTipo();
            if (tipoAsps != null) {
                uri.append(tipoAsps).append("/");
            }
            uri.append(nomeAsps);
            uri.append(":");
            uri.append(idServizio.getVersione());
            uri.append(")");
        }
        return uri.toString();
    }

    public static IDServizio parseServizioSoggetto(String input) throws CoreException {
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        String tipoServizio = null;
        String nomeServizio = null;
        Integer versioneServizio = 1;
        if (!input.contains(" (")) {
            throw new CoreException("Input format [" + input + "] errato; atteso input nella forma 'tipo/nomeServizio (tipo/nomeSoggetto)'");
        }
        String[] split = input.split(" \\(");
        String tipoNomeServizio = split[0];
        String tipoNomeSoggetto = split[1].substring(0, split[1].indexOf(")"));
        tipoSoggetto = ParseUtility.parseTipoSoggetto(tipoNomeSoggetto);
        nomeSoggetto = ParseUtility.parseNomeSoggetto(tipoNomeSoggetto);
        tipoServizio = ParseUtility.parseTipoSoggetto(tipoNomeServizio);
        nomeServizio = ParseUtility.parseNomeSoggetto(tipoNomeServizio);
        versioneServizio = ParseUtility.parseVersione(nomeServizio);
        nomeServizio = ParseUtility.parseNomeServizio(nomeServizio);
        return IDServizioFactory.getInstance().getIDServizioFromValuesWithoutCheck(tipoServizio, nomeServizio, tipoSoggetto, nomeSoggetto, versioneServizio.intValue());
    }

    public static String convertToServizioSoggetto(IDServizio idServizio) throws CoreException {
        StringBuilder uri = new StringBuilder();
        if (idServizio.getNome() == null) {
            throw new CoreException("Input format [" + idServizio + "] errato; atteso input per generare informazione 'tipo/nomeServizio (tipo/nomeSoggetto)'");
        }
        uri.append(idServizio.getTipo());
        uri.append("/");
        uri.append(idServizio.getNome());
        uri.append(":");
        uri.append(idServizio.getVersione());
        uri.append(" (");
        uri.append(idServizio.getSoggettoErogatore().toString());
        uri.append(")");
        return uri.toString();
    }
}

