/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.utils.xml.XPathNotValidException;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class XPathValidator
implements Validator {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        try {
            XPathExpressionEngine xpathEngine = new XPathExpressionEngine(OpenSPCoop2MessageFactory.getDefaultMessageFactory());
            String xpath = (String)value;
            xpathEngine.validate(xpath);
        }
        catch (XPathNotValidException e) {
            log.error(e.getMessage(), (Throwable)e);
            FacesMessage message = new FacesMessage();
            message.setSummary(e.getMessage());
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            throw new ValidatorException(message);
        }
    }
}

