/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config.vault.cli;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.byok.BYOKWrappedValue;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.pdd.config.vault.cli.VaultEncDecConfig;
import org.openspcoop2.pdd.config.vault.cli.VaultTools;
import org.openspcoop2.pdd.core.byok.DriverBYOK;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKInstance;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.slf4j.Logger;

public class VaultEncDecUtilities {
    private VaultEncDecConfig encDecConfig = null;

    public VaultEncDecUtilities(VaultEncDecConfig c) {
        this.encDecConfig = c;
    }

    public void process() throws CoreException {
        try {
            byte[] input = null;
            VaultTools.logCoreDebug("Lettura input ...");
            input = this.encDecConfig.isInSystemMode() ? this.encDecConfig.getInText().getBytes() : FileSystemUtilities.readBytesFromFile((String)this.encDecConfig.getInFilePath());
            VaultTools.logCoreDebug("Lettura input completata");
            byte[] output = null;
            output = this.encDecConfig.isSecurityMode() ? this.processBySecurity(input) : this.processByKms(input);
            VaultTools.logCoreDebug("Serializzazione output ...");
            if (this.encDecConfig.isOutSystemMode()) {
                VaultTools.logOutput(new String(output));
            } else if (this.encDecConfig.isOutFileMode()) {
                File f = new File(this.encDecConfig.getOutFilePath());
                FileSystemUtilities.writeFile((File)f, (byte[])output);
                String op = this.encDecConfig.isEncode() ? "Encrypted" : "Decrypted";
                VaultTools.logOutput(op + " content in '" + f.getAbsolutePath() + "'");
            } else {
                throw new CoreException("Unsupported mode");
            }
            VaultTools.logCoreDebug("Serializzazione output completata");
        }
        catch (Exception t) {
            VaultTools.logCoreError(t.getMessage(), t);
            throw new CoreException(t.getMessage(), (Throwable)t);
        }
    }

    public byte[] processBySecurity(byte[] input) throws UtilsException {
        String policy = this.encDecConfig.getId();
        if (policy == null || StringUtils.isEmpty((String)policy)) {
            policy = BYOKManager.getSecurityRemoteEngineGovWayPolicy();
        }
        if (policy == null || StringUtils.isEmpty((String)policy)) {
            policy = BYOKManager.getSecurityEngineGovWayPolicy();
        }
        VaultTools.logCoreDebug("Cifratura tramite security policy '" + policy + "' ...");
        DriverBYOK driver = new DriverBYOK(VaultTools.getLogCore(), policy, policy);
        byte[] output = null;
        if (this.encDecConfig.isEncode()) {
            BYOKWrappedValue v = driver.wrap(input);
            output = v.getWrappedValue().getBytes();
        } else {
            output = driver.unwrap(input);
        }
        if (Arrays.equals(input, output)) {
            throw new UtilsException("Unwrap failed");
        }
        VaultTools.logCoreDebug("Cifratura tramite security policy '" + policy + "' completata");
        return output;
    }

    public byte[] processByKms(byte[] input) throws UtilsException {
        String kmsId = this.encDecConfig.getId();
        VaultTools.logCoreDebug("Cifratura tramite kms '" + kmsId + "' ...");
        Map dynamicMap = DriverBYOK.buildDynamicMap((Logger)VaultTools.getLogCore());
        HashMap inputMap = new HashMap();
        BYOKRequestParams requestParams = BYOKRequestParams.getBYOKRequestParamsByKmsId((String)kmsId, inputMap, (Map)dynamicMap);
        BYOKInstance instance = BYOKInstance.newInstance((Logger)VaultTools.getLogCore(), (BYOKRequestParams)requestParams, (byte[])input);
        byte[] output = DriverBYOK.processInstance((BYOKInstance)instance, (boolean)true);
        VaultTools.logCoreDebug("Cifratura tramite kms '" + kmsId + "' completata");
        return output;
    }
}

