/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config.vault.cli;

import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.core.commons.CoreException;

public class VaultProperties {
    private static VaultProperties staticInstance = null;
    private static final String PROPERTIES_FILE = "/govway_vault.cli.properties";
    private String protocolloDefault = null;
    private boolean securityLoadBouncyCastleProvider = false;
    private String envMapConfig = null;
    private boolean envMapConfigRequired = false;
    private String hsmConfig = null;
    private boolean hsmRequired = false;
    private boolean hsmKeyPasswordConfigurable = false;
    private String byokConfigurazione = null;
    private boolean byokRequired = false;
    private String byokEnvSecretsConfig = null;
    private boolean byokEnvSecretsConfigRequired = false;

    private static synchronized void init() throws CoreException {
        if (staticInstance == null) {
            staticInstance = new VaultProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VaultProperties getInstance() throws CoreException {
        if (staticInstance != null) return staticInstance;
        Class<VaultProperties> clazz = VaultProperties.class;
        synchronized (VaultProperties.class) {
            VaultProperties.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return staticInstance;
        }
    }

    private static String getPropertyPrefix(String name) {
        return "Property '" + name + "'";
    }

    private VaultProperties() throws CoreException {
        Properties props = new Properties();
        try {
            InputStream is = VaultProperties.class.getResourceAsStream(PROPERTIES_FILE);
            props.load(is);
        }
        catch (Exception e) {
            throw new CoreException("Errore durante l'init delle properties", (Throwable)e);
        }
        this.protocolloDefault = this.getProperty(props, "protocolloDefault", true);
        this.securityLoadBouncyCastleProvider = this.getBooleanProperty(props, "security.addBouncyCastleProvider", false);
        this.envMapConfig = this.getProperty(props, "env.map.config", false);
        this.envMapConfigRequired = this.getBooleanProperty(props, "env.map.required", false);
        this.hsmConfig = this.getProperty(props, "hsm.config", false);
        this.hsmRequired = this.getBooleanProperty(props, "hsm.required", false);
        this.hsmKeyPasswordConfigurable = this.getBooleanProperty(props, "hsm.keyPassword", false);
        this.byokConfigurazione = this.getProperty(props, "byok.config", false);
        this.byokRequired = this.getBooleanProperty(props, "byok.required", false);
        this.byokEnvSecretsConfig = this.getProperty(props, "byok.env.secrets.config", false);
        this.byokEnvSecretsConfigRequired = this.getBooleanProperty(props, "byok.env.secrets.required", false);
    }

    private String getProperty(Properties props, String name, boolean required) throws CoreException {
        String tmp = props.getProperty(name);
        if (tmp == null) {
            if (required) {
                throw new CoreException(VaultProperties.getPropertyPrefix(name) + " not found");
            }
            return null;
        }
        return tmp.trim();
    }

    private boolean getBooleanProperty(Properties props, String name, boolean required) throws CoreException {
        String tmp = this.getProperty(props, name, required);
        if (tmp != null) {
            try {
                return Boolean.parseBoolean(tmp);
            }
            catch (Exception e) {
                throw new CoreException(VaultProperties.getPropertyPrefix(name) + " wrong int format: " + e.getMessage());
            }
        }
        return false;
    }

    private int getIntProperty(Properties props, String name, boolean required) throws CoreException {
        String tmp = this.getProperty(props, name, required);
        if (tmp != null) {
            try {
                return Integer.valueOf(tmp);
            }
            catch (Exception e) {
                throw new CoreException(VaultProperties.getPropertyPrefix(name) + " wrong int format: " + e.getMessage());
            }
        }
        return -1;
    }

    public String getProtocolloDefault() {
        return this.protocolloDefault;
    }

    public boolean isSecurityLoadBouncyCastleProvider() {
        return this.securityLoadBouncyCastleProvider;
    }

    public String getEnvMapConfig() {
        return this.envMapConfig;
    }

    public boolean isEnvMapConfigRequired() {
        return this.envMapConfigRequired;
    }

    public String getHSMConfigurazione() {
        return this.hsmConfig;
    }

    public boolean isHSMRequired() {
        return this.hsmRequired;
    }

    public boolean isHSMKeyPasswordConfigurable() {
        return this.hsmKeyPasswordConfigurable;
    }

    public String getBYOKConfigurazione() {
        return this.byokConfigurazione;
    }

    public boolean isBYOKRequired() {
        return this.byokRequired;
    }

    public String getBYOKEnvSecretsConfig() {
        return this.byokEnvSecretsConfig;
    }

    public boolean isBYOKEnvSecretsConfigRequired() {
        return this.byokEnvSecretsConfigRequired;
    }
}

