/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config.vault.cli;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.pdd.config.vault.cli.VaultEncDecConfig;
import org.openspcoop2.pdd.config.vault.cli.VaultEncDecUtilities;
import org.openspcoop2.pdd.config.vault.cli.VaultOperationType;
import org.openspcoop2.pdd.config.vault.cli.VaultProperties;
import org.openspcoop2.pdd.config.vault.cli.VaultUpdateConfig;
import org.openspcoop2.pdd.config.vault.cli.VaultUpdateConfigUtilities;
import org.openspcoop2.pdd.core.byok.BYOKMapProperties;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.hsm.HSMManager;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.properties.MapProperties;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.security.ProviderUtils;
import org.slf4j.Logger;

public class VaultTools {
    private static Logger logCore = LoggerWrapperFactory.getLogger(VaultTools.class);
    private static Logger logOutput = LoggerWrapperFactory.getLogger(VaultTools.class);

    public static Logger getLogCore() {
        return logCore;
    }

    public static void logCoreDebug(String msg) {
        logCore.debug(msg);
    }

    public static void logCoreInfo(String msg) {
        logCore.info(msg);
    }

    public static void logCoreError(String msg, Exception e) {
        logCore.error(msg, (Throwable)e);
    }

    public static void logOutput(String msg) {
        logOutput.info(msg);
    }

    public static void main(String[] args) throws CoreException {
        VaultOperationType opType = null;
        VaultUpdateConfig updateConfig = null;
        VaultEncDecConfig encDecConfig = null;
        String[] argsConfig = null;
        String utilizzoErrato = null;
        try {
            VaultTools.initLogger();
            logCore = LoggerWrapperFactory.getLogger((String)"govway_vault.core");
            logOutput = LoggerWrapperFactory.getLogger((String)"govway_vault.output");
            VaultTools.logCoreDebug("Raccolta parametri in corso...");
            utilizzoErrato = "Usage error: VaultTools <operationType> <options>\n- <operationType>: " + VaultOperationType.UPDATE_CONFIG.getValue() + "," + VaultOperationType.ENCRYPT.getValue() + "," + VaultOperationType.DECRYPT.getValue() + "\n- <options>: \n\t- " + VaultOperationType.UPDATE_CONFIG.getValue() + ": " + VaultUpdateConfig.getUsage() + "\n\t- " + VaultOperationType.ENCRYPT.getValue() + ": " + VaultEncDecConfig.getUsage() + "\n\t- " + VaultOperationType.DECRYPT.getValue() + ": " + VaultEncDecConfig.getUsage();
        }
        catch (Exception t) {
            if (logCore != null) {
                logCore.error(t.getMessage(), (Throwable)t);
            }
            throw new CoreException(t.getMessage(), (Throwable)t);
        }
        if (args.length < 1 || args[0] == null) {
            throw new CoreException(utilizzoErrato);
        }
        try {
            opType = VaultTools.parseOperationType(utilizzoErrato, args);
            argsConfig = new String[args.length - 1];
            System.arraycopy(args, 1, argsConfig, 0, args.length - 1);
        }
        catch (Exception t) {
            if (logCore != null) {
                logCore.error(t.getMessage(), (Throwable)t);
            }
            throw new CoreException(t.getMessage(), (Throwable)t);
        }
        switch (opType) {
            case UPDATE_CONFIG: {
                utilizzoErrato = "Usage error: update " + VaultUpdateConfig.getUsage();
                updateConfig = new VaultUpdateConfig(argsConfig, utilizzoErrato);
                break;
            }
            case ENCRYPT: {
                utilizzoErrato = "Usage error: encrypt " + VaultEncDecConfig.getUsage();
                encDecConfig = new VaultEncDecConfig(argsConfig, utilizzoErrato, true);
                break;
            }
            case DECRYPT: {
                utilizzoErrato = "Usage error: decrypt " + VaultEncDecConfig.getUsage();
                encDecConfig = new VaultEncDecConfig(argsConfig, utilizzoErrato, false);
            }
        }
        try {
            VaultTools.process(updateConfig, encDecConfig);
        }
        catch (Exception t) {
            if (logCore != null) {
                logCore.error(t.getMessage(), (Throwable)t);
            }
            throw new CoreException(t.getMessage(), (Throwable)t);
        }
    }

    private static void process(VaultUpdateConfig updateConfig, VaultEncDecConfig encDecConfig) throws CoreException {
        VaultTools.logCoreDebug("Raccolta parametri terminata");
        VaultProperties vaultProperties = VaultProperties.getInstance();
        String protocolloDefault = vaultProperties.getProtocolloDefault();
        VaultTools.disableCheckSingleConnectionDataSource();
        VaultTools.initMap(vaultProperties);
        if (vaultProperties.isSecurityLoadBouncyCastleProvider()) {
            VaultTools.initBouncyCastle();
        }
        VaultTools.initHsm(vaultProperties);
        BYOKManager byokManager = VaultTools.initBYOK(vaultProperties);
        VaultTools.initSecrets(vaultProperties, byokManager);
        VaultTools.logCoreDebug("Inizializzazione risorse libreria in corso...");
        VaultTools.initProtocolFactory(protocolloDefault);
        VaultTools.initExtendedInfoManager();
        VaultTools.logCoreDebug("Inizializzazione risorse libreria terminata");
        if (updateConfig != null) {
            VaultTools.logCoreInfo("Aggiornamento informazioni sensibili in corso ...");
            updateConfig.validate(byokManager);
            VaultUpdateConfigUtilities utils = new VaultUpdateConfigUtilities(updateConfig);
            utils.process();
            VaultTools.logCoreInfo("Aggiornamento informazioni sensibili completato");
        } else if (encDecConfig != null) {
            String op = encDecConfig.isEncode() ? "Cifratura" : "Decrifratura";
            VaultTools.logCoreInfo(op + " in corso ...");
            encDecConfig.validate(byokManager);
            VaultEncDecUtilities utils = new VaultEncDecUtilities(encDecConfig);
            utils.process();
            VaultTools.logCoreInfo(op + " completata");
        }
    }

    private static void initLogger() throws CoreException {
        Properties propertiesLog4j = new Properties();
        try (InputStream inPropLog4j = VaultTools.class.getResourceAsStream("/govway_vault.cli.log4j2.properties");){
            propertiesLog4j.load(inPropLog4j);
            LoggerWrapperFactory.setLogConfiguration((Properties)propertiesLog4j);
        }
        catch (Exception e) {
            throw new CoreException("Impossibile leggere i dati dal file 'govway_vault.cli.log4j2.properties': " + e.getMessage());
        }
    }

    private static VaultOperationType parseOperationType(String utilizzoErrato, String[] args) throws CoreException {
        VaultOperationType opType = null;
        try {
            opType = VaultOperationType.toEnumConstant(args[0].trim(), true);
        }
        catch (Exception e) {
            throw new CoreException(utilizzoErrato + "\nIl tipo di operazione indicato (" + args[0].trim() + ") non \u00e8 gestito, valori ammessi: " + VaultOperationType.UPDATE_CONFIG.getValue() + "," + VaultOperationType.ENCRYPT.getValue() + "," + VaultOperationType.DECRYPT.getValue());
        }
        return opType;
    }

    private static void initBouncyCastle() throws CoreException {
        try {
            ProviderUtils.addBouncyCastleAfterSun((boolean)true);
            VaultTools.logCoreInfo("Aggiunto Security Provider org.bouncycastle.jce.provider.BouncyCastleProvider");
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    private static void disableCheckSingleConnectionDataSource() throws CoreException {
        try {
            Logger logR = logCore;
            ServicesUtils.initCheckConnectionDB((Logger)logR, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            VaultTools.doError("Inizializzazione controlli connessione non riuscita", e);
        }
    }

    private static void initMap(VaultProperties loaderProperties) throws CoreException {
        try {
            String mapConfig = loaderProperties.getEnvMapConfig();
            if (StringUtils.isNotEmpty((String)mapConfig)) {
                VaultTools.logCoreInfo("Inizializzazione environment in corso...");
                MapProperties.initialize((Logger)logCore, (String)mapConfig, (boolean)loaderProperties.isEnvMapConfigRequired());
                MapProperties mapProperties = MapProperties.getInstance();
                mapProperties.initEnvironment();
                String msgInit = "Environment inizializzato con le variabili definite nel file '" + mapConfig + "'\n\tJavaProperties: " + mapProperties.getJavaMap().keys() + "\n\tEnvProperties: " + mapProperties.getEnvMap().keys() + "\n\tObfuscateMode: " + mapProperties.getObfuscateModeDescription() + "\n\tObfuscatedJavaKeys: " + mapProperties.getObfuscatedJavaKeys() + "\n\tObfuscatedEnvKeys: " + mapProperties.getObfuscatedEnvKeys();
                VaultTools.logCoreInfo(msgInit);
            }
        }
        catch (Exception e) {
            VaultTools.doError("Errore durante l'inizializzazione dell'ambiente", e);
        }
    }

    private static void initHsm(VaultProperties loaderProperties) throws CoreException {
        try {
            String hsmConfig = loaderProperties.getHSMConfigurazione();
            if (StringUtils.isNotEmpty((String)hsmConfig)) {
                VaultTools.logCoreInfo("Inizializzazione HSM in corso...");
                File f = new File(hsmConfig);
                HSMManager.init((File)f, (boolean)loaderProperties.isHSMRequired(), (Logger)logCore, (boolean)false);
                HSMUtils.setHsmConfigurableKeyPassword((boolean)loaderProperties.isHSMKeyPasswordConfigurable());
                VaultTools.logCoreInfo("Inizializzazione HSM effettuata con successo");
            }
        }
        catch (Exception e) {
            VaultTools.doError("Errore durante l'inizializzazione del manager HSM", e);
        }
    }

    private static BYOKManager initBYOK(VaultProperties loaderProperties) throws CoreException {
        BYOKManager byokManager = null;
        try {
            String byokConfig = loaderProperties.getBYOKConfigurazione();
            if (StringUtils.isNotEmpty((String)byokConfig)) {
                VaultTools.logCoreInfo("Inizializzazione BYOK in corso...");
                File f = new File(byokConfig);
                BYOKManager.init((File)f, (boolean)loaderProperties.isBYOKRequired(), (Logger)logCore);
                byokManager = BYOKManager.getInstance();
                String msgInit = "Gestore BYOK inizializzato;\n\tHSM registrati: " + byokManager.getKeystoreTypes() + "\n\tSecurityEngine registrati: " + byokManager.getSecurityEngineTypes() + "\n\tGovWaySecurityEngine: " + byokManager.getSecurityEngineGovWayDescription();
                VaultTools.logCoreInfo(msgInit);
            }
        }
        catch (Exception e) {
            VaultTools.doError("Errore durante l'inizializzazione del manager BYOK", e);
        }
        return byokManager;
    }

    private static void initSecrets(VaultProperties loaderProperties, BYOKManager byokManager) throws CoreException {
        try {
            String secretsConfig = loaderProperties.getBYOKEnvSecretsConfig();
            if (byokManager != null && StringUtils.isNotEmpty((String)secretsConfig)) {
                VaultTools.logCoreInfo("Inizializzazione secrets in corso...");
                HashMap dynamicMap = new HashMap();
                DynamicInfo dynamicInfo = new DynamicInfo();
                DynamicUtils.fillDynamicMap((Logger)logCore, dynamicMap, (DynamicInfo)dynamicInfo);
                BYOKMapProperties.initialize((Logger)logCore, (String)secretsConfig, (boolean)loaderProperties.isBYOKEnvSecretsConfigRequired(), (boolean)true, dynamicMap, (boolean)true);
                BYOKMapProperties secretsProperties = BYOKMapProperties.getInstance();
                secretsProperties.initEnvironment();
                String msgInit = "Environment inizializzato con i secrets definiti nel file '" + secretsConfig + "'\n\tJavaProperties: " + secretsProperties.getJavaMap().keys() + "\n\tEnvProperties: " + secretsProperties.getEnvMap().keys() + "\n\tObfuscateMode: " + secretsProperties.getObfuscateModeDescription();
                VaultTools.logCoreInfo(msgInit);
            }
        }
        catch (Exception e) {
            VaultTools.doError("Errore durante l'inizializzazione dell'ambiente (secrets)", e);
        }
    }

    private static ConfigurazionePdD initProtocolFactory(String protocolloDefault) throws CoreException {
        ConfigurazionePdD configPdD = null;
        try {
            configPdD = new ConfigurazionePdD();
            configPdD.setAttesaAttivaJDBC(-1L);
            configPdD.setCheckIntervalJDBC(-1);
            configPdD.setLoader(new Loader(VaultTools.class.getClassLoader()));
            configPdD.setLog(logCore);
            ProtocolFactoryManager.initialize((Logger)logCore, (ConfigurazionePdD)configPdD, (String)protocolloDefault);
        }
        catch (Exception e) {
            throw new CoreException("Errore (InitConfigurazione - ProtocolFactoryManager): " + e.getMessage(), (Throwable)e);
        }
        return configPdD;
    }

    private static void initExtendedInfoManager() throws CoreException {
        try {
            ExtendedInfoManager.initialize((Loader)new Loader(VaultTools.class.getClassLoader()), null, null, null);
        }
        catch (Exception e) {
            throw new CoreException("Inizializzazione [ExtendedInfoManager] fallita", (Throwable)e);
        }
    }

    private static void doError(String msg, Exception e) throws CoreException {
        String msgErrore = msg + ": " + e.getMessage();
        VaultTools.logCoreError(msgErrore, e);
        throw new CoreException(msgErrore, (Throwable)e);
    }
}

