/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config.vault.cli;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.byok.BYOKUtilities;
import org.openspcoop2.core.byok.BYOKWrappedValue;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.CostantiConnettori;
import org.openspcoop2.core.constants.CostantiProprieta;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.pdd.config.vault.cli.VaultDatabaseProperties;
import org.openspcoop2.pdd.config.vault.cli.VaultTools;
import org.openspcoop2.pdd.config.vault.cli.VaultUpdateConfig;
import org.openspcoop2.pdd.config.vault.cli.VaultUpdateConfigPlainEnc;
import org.openspcoop2.pdd.config.vault.cli.VaultUpdateConfigValue;
import org.openspcoop2.pdd.core.byok.DriverBYOK;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.LikeConfig;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class VaultUpdateConfigUtilities {
    private VaultUpdateConfig config;
    private DriverBYOK inDriverBYOK = null;
    private DriverBYOK outDriverBYOK = null;
    private String tipoDatabase;
    private String driver;
    private String username;
    private String password;
    private String connectionURL;
    private static final String LOG_ORIG_SKIPPED = "\t!skyp! wrapped with other policy:";
    private static final String LOG_ORIG_SKIPPED_NO_WRAPPED = "\t!skyp! no wrapped value:";
    private static final String LOG_ORIG_SKIPPED_ALREADY_WRAPPED = "\t!skyp! already wrapped value:";
    private static final String LOG_ORIG_SKIPPED_WITH_POLICY = "\t!skyp! wrapped with policy:";
    private static final String LOG_ORIG = "\torig:";
    private static final String LOG_NEW = "\tnew:";
    private static final String LOG_ROW_UPDATE = "\trow-update:";
    private static final String CONDITION_WHERE_ID = "id = ?";
    private static final String CONDITION_JOIN_ID = ".id = ";
    private static final String ALIAS_PLAIN_VALUE = "plainValue";
    private static final String ALIAS_ENC_VALUE = "encValue";

    public VaultUpdateConfigUtilities(VaultUpdateConfig config) {
        this.config = config;
    }

    public void process() throws CoreException {
        try {
            VaultTools.logCoreDebug("Inizializzazione connessione database in corso...");
            VaultDatabaseProperties databaseProperties = VaultDatabaseProperties.getInstance();
            this.tipoDatabase = databaseProperties.getTipoDatabase();
            this.driver = databaseProperties.getDriver();
            this.username = databaseProperties.getUsername();
            this.password = databaseProperties.getPassword();
            this.connectionURL = databaseProperties.getConnectionUrl();
            VaultTools.logCoreDebug("Inizializzazione connessione database terminata");
            VaultTools.logCoreDebug("Inizializzazione driver ...");
            if (this.config.isInSecurityMode()) {
                this.inDriverBYOK = new DriverBYOK(VaultTools.getLogCore(), this.config.getInId(), this.config.getInId());
            }
            if (this.config.isOutSecurityMode()) {
                this.outDriverBYOK = new DriverBYOK(VaultTools.getLogCore(), this.config.getOutId(), this.config.getOutId());
            }
            VaultTools.logCoreDebug("Inizializzazione driver terminata");
            StringBuilder output = null;
            if (this.config.getReportPath() != null) {
                output = new StringBuilder();
            }
            this.processConnettori(output);
            this.processServiziApplicativi(output);
            this.processSecurity(output);
            this.processGenericProperties(output);
            this.processProtocolProperties(output);
            this.processProperties(output);
            if (this.config.getReportPath() != null && output != null) {
                FileSystemUtilities.writeFile((String)this.config.getReportPath(), (byte[])output.toString().getBytes());
            }
        }
        catch (Exception t) {
            VaultTools.logCoreError(t.getMessage(), t);
            throw new CoreException(t.getMessage(), (Throwable)t);
        }
    }

    private void processConnettori(StringBuilder output) throws CoreException {
        VaultTools.logCoreDebug("Conversione connettori ...");
        if (output != null) {
            if (output.length() > 0) {
                output.append("\n\n");
            }
            output.append("=== Connettori ===\n\n");
        }
        this.updateConnettori("password", "enc_password", output);
        this.updateConnettori("proxy_password", "enc_proxy_password", output);
        this.updateConnettori("api_key", null, output);
        if (output != null) {
            output.append("\n\n");
            output.append("=== Connettori Custom ===\n\n");
        }
        for (String nomeProprieta : CostantiConnettori.getConfidentials()) {
            this.updateConnettoriCustom(nomeProprieta, output);
        }
        VaultTools.logCoreDebug("Conversione connettori terminata");
    }

    private void processServiziApplicativi(StringBuilder output) throws CoreException {
        VaultTools.logCoreDebug("Conversione applicativi ...");
        if (output != null) {
            if (output.length() > 0) {
                output.append("\n\n");
            }
            output.append("=== Applicativi ===\n\n");
        }
        this.updateServiziApplicativi("passwordrisp", "enc_passwordrisp", output);
        this.updateServiziApplicativi("passwordinv", "enc_passwordinv", output);
        VaultTools.logCoreDebug("Conversione applicativi terminata");
    }

    private void processSecurity(StringBuilder output) throws CoreException {
        VaultTools.logCoreDebug("Conversione message security ...");
        List messageSecurityIds = CostantiProprieta.getMessageSecurityIds();
        this.processSecurityFruizioni(messageSecurityIds, output);
        this.processSecurityErogazioni(messageSecurityIds, output);
        VaultTools.logCoreDebug("Conversione message security terminata");
    }

    private void processSecurityFruizioni(List<String> messageSecurityIds, StringBuilder output) throws CoreException {
        if (output != null) {
            if (output.length() > 0) {
                output.append("\n\n");
            }
            output.append("=== Message Security (Fruizioni request-flow) ===\n\n");
        }
        this.processSecurity(messageSecurityIds, output, "porte_delegate", "pd_security_request", "nome", "valore", "enc_value");
        if (output != null) {
            output.append("\n\n");
            output.append("=== Message Security (Fruizioni response-flow) ===\n\n");
        }
        this.processSecurity(messageSecurityIds, output, "porte_delegate", "pd_security_response", "nome", "valore", "enc_value");
    }

    private void processSecurityErogazioni(List<String> messageSecurityIds, StringBuilder output) throws CoreException {
        if (output != null) {
            output.append("\n\n");
            output.append("=== Message Security (Erogazioni request-flow) ===\n\n");
        }
        this.processSecurity(messageSecurityIds, output, "porte_applicative", "pa_security_request", "nome", "valore", "enc_value");
        if (output != null) {
            output.append("\n\n");
            output.append("=== Message Security (Erogazioni response-flow) ===\n\n");
        }
        this.processSecurity(messageSecurityIds, output, "porte_applicative", "pa_security_response", "nome", "valore", "enc_value");
    }

    private void processSecurity(List<String> messageSecurityIds, StringBuilder output, String tabellaPadre, String tabella, String nomeColonnaNomeProprieta, String nomeColonnaPlain, String nomeColonnaCodificata) throws CoreException {
        if (messageSecurityIds != null && !messageSecurityIds.isEmpty()) {
            ArrayList<String> lnomiProp = new ArrayList<String>();
            for (String id : messageSecurityIds) {
                List l = CostantiProprieta.getMessageSecurityProperties((String)id);
                for (String nomeProprieta : l) {
                    if (lnomiProp.contains(nomeProprieta)) continue;
                    lnomiProp.add(nomeProprieta);
                }
            }
            for (String nomeProprieta : lnomiProp) {
                this.updateMessageSecurity(tabellaPadre, tabella, nomeColonnaNomeProprieta, nomeColonnaPlain, nomeColonnaCodificata, nomeProprieta, output);
            }
        }
    }

    private void processGenericProperties(StringBuilder output) throws CoreException {
        VaultTools.logCoreDebug("Conversione generic properties ...");
        if (output != null) {
            if (output.length() > 0) {
                output.append("\n\n");
            }
            output.append("=== TokenPolicy Validazione ===\n\n");
        }
        for (String nomeProprieta : CostantiProprieta.getTokenValidationProperties()) {
            this.updateGenericProperties("validationToken", nomeProprieta, output);
        }
        if (output != null) {
            output.append("\n\n");
            output.append("=== TokenPolicy Negoziazione ===\n\n");
        }
        for (String nomeProprieta : CostantiProprieta.getTokenRetrieveProperties()) {
            this.updateGenericProperties("retrieveToken", nomeProprieta, output);
        }
        if (output != null) {
            output.append("\n\n");
            output.append("=== Attribute Authority ===\n\n");
        }
        for (String nomeProprieta : CostantiProprieta.getAttributeAuthorityProperties()) {
            this.updateGenericProperties("attributeAuthority", nomeProprieta, output);
        }
        VaultTools.logCoreDebug("Conversione generic properties terminata");
    }

    private void processProtocolProperties(StringBuilder output) throws CoreException {
        VaultTools.logCoreDebug("Conversione protocol properties ...");
        if (output != null) {
            if (output.length() > 0) {
                output.append("\n\n");
            }
            output.append("=== ProtocolProperties ===\n\n");
        }
        this.updateProtocolProperties("modipaKeystorePassword", false, output);
        this.updateProtocolProperties("modipaKeyPassword", false, output);
        this.updateProtocolProperties("modipaTruststorePassword", false, output);
        this.updateProtocolProperties("modipaSslTruststorePassword", false, output);
        this.updateProtocolProperties("modipaKeystoreArchive", true, output);
        VaultTools.logCoreDebug("Conversione protocol properties terminata");
    }

    private void processProperties(StringBuilder output) throws CoreException {
        VaultTools.logCoreDebug("Conversione properties ...");
        if (output != null) {
            if (output.length() > 0) {
                output.append("\n\n");
            }
            output.append("=== Soggetti properties ===\n\n");
        }
        this.updateProperties("soggetti_properties", "nome", "valore", "enc_value", output, false, false);
        if (output != null) {
            output.append("\n\n");
            output.append("=== Applicativi properties ===\n\n");
        }
        this.updateProperties("sa_properties", "nome", "valore", "enc_value", output, false, false);
        if (output != null) {
            output.append("\n\n");
            output.append("=== Configurazione properties ===\n\n");
        }
        this.updateProperties("pdd_sys_props", "nome", "valore", "enc_value", output, false, false);
        this.processErogazioniProperties(output);
        this.processFruizioniProperties(output);
        VaultTools.logCoreDebug("Conversione properties terminata");
    }

    private void processErogazioniProperties(StringBuilder output) throws CoreException {
        if (output != null) {
            output.append("\n\n");
            output.append("=== Erogazioni message security request properties ===\n\n");
        }
        this.updateProperties("pa_security_request", "nome", "valore", "enc_value", output, true, false);
        if (output != null) {
            output.append("\n\n");
            output.append("=== Erogazioni message security response properties ===\n\n");
        }
        this.updateProperties("pa_security_response", "nome", "valore", "enc_value", output, false, true);
        if (output != null) {
            output.append("\n\n");
            output.append("=== Erogazioni autenticazione properties ===\n\n");
        }
        this.updateProperties("pa_auth_properties", "nome", "valore", "enc_value", output, false, false);
        if (output != null) {
            output.append("\n\n");
            output.append("=== Erogazioni autorizzazione properties ===\n\n");
        }
        this.updateProperties("pa_authz_properties", "nome", "valore", "enc_value", output, false, false);
        if (output != null) {
            output.append("\n\n");
            output.append("=== Erogazioni autorizzazione contenuti properties ===\n\n");
        }
        this.updateProperties("pa_authzc_properties", "nome", "valore", "enc_value", output, false, false);
        if (output != null) {
            output.append("\n\n");
            output.append("=== Erogazioni properties ===\n\n");
        }
        this.updateProperties("pa_properties", "nome", "valore", "enc_value", output, false, false);
    }

    private void processFruizioniProperties(StringBuilder output) throws CoreException {
        if (output != null) {
            output.append("\n\n");
            output.append("=== Fruizioni message security request properties ===\n\n");
        }
        this.updateProperties("pd_security_request", "nome", "valore", "enc_value", output, true, false);
        if (output != null) {
            output.append("\n\n");
            output.append("=== Fruizioni message security response properties ===\n\n");
        }
        this.updateProperties("pd_security_response", "nome", "valore", "enc_value", output, false, true);
        if (output != null) {
            output.append("\n\n");
            output.append("=== Fruizioni autenticazione properties ===\n\n");
        }
        this.updateProperties("pd_auth_properties", "nome", "valore", "enc_value", output, false, false);
        if (output != null) {
            output.append("\n\n");
            output.append("=== Fruizioni autorizzazione properties ===\n\n");
        }
        this.updateProperties("pd_authz_properties", "nome", "valore", "enc_value", output, false, false);
        if (output != null) {
            output.append("\n\n");
            output.append("=== Fruizioni autorizzazione contenuti properties ===\n\n");
        }
        this.updateProperties("pd_authzc_properties", "nome", "valore", "enc_value", output, false, false);
        if (output != null) {
            output.append("\n\n");
            output.append("=== Fruizioni properties ===\n\n");
        }
        this.updateProperties("pd_properties", "nome", "valore", "enc_value", output, false, false);
    }

    private Connection getConnection() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, SQLException {
        Connection connectionSQL = null;
        Loader.getInstance().newInstance(this.driver);
        connectionSQL = this.username != null && this.password != null ? DriverManager.getConnection(this.connectionURL, this.username, this.password) : DriverManager.getConnection(this.connectionURL);
        return connectionSQL;
    }

    private void closeConnection(Connection connectionSQL) {
        if (connectionSQL != null) {
            try {
                connectionSQL.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void skip(StringBuilder output, String prefix, String value, boolean wrapped) {
        if (output != null) {
            output.append(prefix).append("\n");
            output.append(wrapped ? LOG_ORIG_SKIPPED : LOG_ORIG_SKIPPED_NO_WRAPPED).append(value).append("\n");
        }
    }

    private void skipWithPolicy(StringBuilder output, String prefix, String value) {
        if (output != null) {
            output.append(prefix).append("\n");
            output.append(LOG_ORIG_SKIPPED_WITH_POLICY).append(value).append("\n");
        }
    }

    private void skipAlreadyWrapped(StringBuilder output, String prefix, String value) {
        if (output != null) {
            output.append(prefix).append("\n");
            output.append(LOG_ORIG_SKIPPED_ALREADY_WRAPPED).append(value).append("\n");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateValue(Connection connectionSQL, ResultSet rs, String nomeColonna, String prefix, StringBuilder output, VaultUpdateConfigValue c) throws UtilsException, SQLException, SQLQueryObjectException {
        String plainStringValue = rs.getString(nomeColonna);
        String updatedValue = null;
        if (this.inDriverBYOK != null && plainStringValue != null && StringUtils.isNotEmpty((String)plainStringValue)) {
            if (!BYOKUtilities.isWrappedValue((String)plainStringValue)) {
                this.skip(output, prefix, plainStringValue, false);
                return;
            }
            if (!this.inDriverBYOK.isWrappedWithInternalPolicy(plainStringValue)) {
                this.skip(output, prefix, plainStringValue, true);
                return;
            }
            updatedValue = this.inDriverBYOK.unwrapAsString(plainStringValue);
        } else if (plainStringValue != null && StringUtils.isNotEmpty((String)plainStringValue) && BYOKUtilities.isWrappedValue((String)plainStringValue)) {
            this.skipWithPolicy(output, prefix, plainStringValue);
            return;
        }
        if (this.outDriverBYOK != null || updatedValue != null) {
            this.updateValue(connectionSQL, output, plainStringValue, updatedValue, c, prefix);
        }
    }

    private void updateValue(Connection connectionSQL, StringBuilder output, String plainStringValue, String updatedValue, VaultUpdateConfigValue c, String prefix) throws SQLQueryObjectException, SQLException, UtilsException {
        if (this.outDriverBYOK != null) {
            String v;
            String string = v = updatedValue != null ? updatedValue : plainStringValue;
            if (this.outDriverBYOK.isWrappedWithInternalPolicy(v)) {
                this.skipAlreadyWrapped(output, prefix, v);
                return;
            }
        }
        if (output != null) {
            output.append(prefix).append("\n");
            output.append(LOG_ORIG).append(plainStringValue).append("\n");
        }
        this.updateValue(connectionSQL, output, plainStringValue, updatedValue, c);
        if (output != null) {
            output.append("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValue(Connection connectionSQL, StringBuilder output, String plainStringValue, String updatedValue, VaultUpdateConfigValue updateConfig) throws SQLQueryObjectException, SQLException, UtilsException {
        PreparedStatement stmUpdate = null;
        try {
            BYOKWrappedValue wrappedValue = null;
            if (this.outDriverBYOK != null) {
                wrappedValue = this.outDriverBYOK.wrap(updatedValue != null ? updatedValue : plainStringValue);
            }
            ISQLQueryObject sqlQueryObjectUpdate = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObjectUpdate.addUpdateTable(updateConfig.tabella);
            sqlQueryObjectUpdate.addUpdateField(updateConfig.nomeColonna, "?");
            sqlQueryObjectUpdate.addWhereCondition(CONDITION_WHERE_ID);
            sqlQueryObjectUpdate.setANDLogicOperator(true);
            String sqlUpdate = sqlQueryObjectUpdate.createSQLUpdate();
            stmUpdate = connectionSQL.prepareStatement(sqlUpdate);
            int index = 1;
            if (wrappedValue != null) {
                stmUpdate.setString(index++, wrappedValue.getWrappedValue());
                if (output != null) {
                    output.append(LOG_NEW).append(wrappedValue.getWrappedValue()).append("\n");
                }
            } else {
                stmUpdate.setString(index++, updatedValue);
                if (output != null) {
                    output.append(LOG_NEW).append(updatedValue).append("\n");
                }
            }
            stmUpdate.setLong(index++, updateConfig.id);
            int row = stmUpdate.executeUpdate();
            if (output != null) {
                output.append(LOG_ROW_UPDATE).append(row).append("\n");
            }
            stmUpdate.close();
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(stmUpdate);
            throw throwable;
        }
        JDBCUtilities.closeResources((PreparedStatement)stmUpdate);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updatePlainEncValue(Connection connectionSQL, ResultSet rs, String nomeColonnaPlain, String nomeColonnaCodificata, String prefix, StringBuilder output, VaultUpdateConfigPlainEnc c) throws UtilsException, SQLException, SQLQueryObjectException {
        String updatedValue;
        String encStringValue;
        String plainStringValue;
        block6: {
            plainStringValue = rs.getString(nomeColonnaPlain);
            encStringValue = rs.getString(nomeColonnaCodificata);
            updatedValue = null;
            if (this.inDriverBYOK != null) {
                if (encStringValue != null && StringUtils.isNotEmpty((String)encStringValue)) {
                    if (!this.inDriverBYOK.isWrappedWithInternalPolicy(encStringValue)) {
                        this.skip(output, prefix, encStringValue, true);
                        return;
                    }
                    updatedValue = this.inDriverBYOK.unwrapAsString(encStringValue);
                    break block6;
                } else {
                    this.skip(output, prefix, plainStringValue, false);
                    return;
                }
            }
            if (encStringValue != null && StringUtils.isNotEmpty((String)encStringValue)) {
                this.skipWithPolicy(output, prefix, encStringValue);
                return;
            }
        }
        if (this.outDriverBYOK != null || updatedValue != null) {
            this.updatePlainEncValue(connectionSQL, output, plainStringValue, encStringValue, updatedValue, c, prefix);
        }
    }

    private void updatePlainEncValue(Connection connectionSQL, StringBuilder output, String plainStringValue, String encStringValue, String updatedValue, VaultUpdateConfigPlainEnc c, String prefix) throws SQLQueryObjectException, SQLException, UtilsException {
        if (this.outDriverBYOK != null) {
            String v;
            String string = v = updatedValue != null ? updatedValue : plainStringValue;
            if (this.outDriverBYOK.isWrappedWithInternalPolicy(v)) {
                this.skipAlreadyWrapped(output, prefix, v);
                return;
            }
        }
        if (output != null) {
            output.append(prefix).append("\n");
            output.append(LOG_ORIG).append(encStringValue != null && StringUtils.isNotEmpty((String)encStringValue) ? encStringValue : plainStringValue).append("\n");
        }
        this.updatePlainEncValue(connectionSQL, output, plainStringValue, updatedValue, c);
        if (output != null) {
            output.append("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePlainEncValue(Connection connectionSQL, StringBuilder output, String plainStringValue, String updatedValue, VaultUpdateConfigPlainEnc plainEncConfig) throws SQLQueryObjectException, SQLException, UtilsException {
        PreparedStatement stmUpdate = null;
        try {
            BYOKWrappedValue wrappedValue = null;
            if (this.outDriverBYOK != null) {
                wrappedValue = this.outDriverBYOK.wrap(updatedValue != null ? updatedValue : plainStringValue);
            }
            ISQLQueryObject sqlQueryObjectUpdate = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObjectUpdate.addUpdateTable(plainEncConfig.tabella);
            sqlQueryObjectUpdate.addUpdateField(plainEncConfig.nomeColonnaPlain, "?");
            sqlQueryObjectUpdate.addUpdateField(plainEncConfig.nomeColonnaCodificata, "?");
            sqlQueryObjectUpdate.addWhereCondition(CONDITION_WHERE_ID);
            sqlQueryObjectUpdate.setANDLogicOperator(true);
            String sqlUpdate = sqlQueryObjectUpdate.createSQLUpdate();
            stmUpdate = connectionSQL.prepareStatement(sqlUpdate);
            int index = 1;
            if (wrappedValue != null) {
                stmUpdate.setString(index++, wrappedValue.getWrappedPlainValue());
                stmUpdate.setString(index++, wrappedValue.getWrappedValue());
                if (output != null) {
                    output.append(LOG_NEW).append(wrappedValue.getWrappedValue()).append("\n");
                }
            } else {
                stmUpdate.setString(index++, updatedValue);
                stmUpdate.setString(index++, null);
                if (output != null) {
                    output.append(LOG_NEW).append(updatedValue).append("\n");
                }
            }
            stmUpdate.setLong(index++, plainEncConfig.id);
            int row = stmUpdate.executeUpdate();
            if (output != null) {
                output.append(LOG_ROW_UPDATE).append(row).append("\n");
            }
            stmUpdate.close();
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(stmUpdate);
            throw throwable;
        }
        JDBCUtilities.closeResources((PreparedStatement)stmUpdate);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateBinaryProtocolProperty(IJDBCAdapter jdbcAdapter, Connection connectionSQL, ResultSet rs, String nomeColonna, String prefix, StringBuilder output, VaultUpdateConfigValue c) throws UtilsException, SQLException, SQLQueryObjectException {
        byte[] binaryValue = jdbcAdapter.getBinaryData(rs, nomeColonna);
        byte[] updateValue = null;
        if (this.inDriverBYOK != null && binaryValue != null && binaryValue.length > 0) {
            if (!BYOKUtilities.isWrappedValue((byte[])binaryValue)) {
                this.skip(output, prefix, "--binary-value--", false);
                return;
            }
            if (!this.inDriverBYOK.isWrappedWithInternalPolicy(binaryValue)) {
                this.skip(output, prefix, BYOKUtilities.extractPrefixWrappedValue((byte[])binaryValue), true);
                return;
            }
            updateValue = this.inDriverBYOK.unwrap(binaryValue);
        } else if (binaryValue != null && binaryValue.length > 0 && BYOKUtilities.isWrappedValue((byte[])binaryValue)) {
            this.skipWithPolicy(output, prefix, BYOKUtilities.extractPrefixWrappedValue((byte[])binaryValue));
            return;
        }
        if (this.outDriverBYOK != null || updateValue != null) {
            this.updateBinaryValue(jdbcAdapter, connectionSQL, output, binaryValue, updateValue, c, prefix);
        }
    }

    private void updateBinaryValue(IJDBCAdapter jdbcAdapter, Connection connectionSQL, StringBuilder output, byte[] binaryValue, byte[] updateValue, VaultUpdateConfigValue c, String prefix) throws UtilsException, SQLQueryObjectException, SQLException {
        if (this.outDriverBYOK != null) {
            byte[] v;
            byte[] byArray = v = updateValue != null ? updateValue : binaryValue;
            if (this.outDriverBYOK.isWrappedWithInternalPolicy(v)) {
                this.skipAlreadyWrapped(output, prefix, BYOKUtilities.extractPrefixWrappedValue((byte[])v));
                return;
            }
        }
        if (output != null) {
            output.append(prefix).append("\n");
            String base64 = Base64Utilities.encodeAsString((byte[])binaryValue);
            output.append(LOG_ORIG).append(base64).append("\n");
        }
        this.updateBinaryValue(jdbcAdapter, connectionSQL, output, binaryValue, updateValue, c);
        if (output != null) {
            output.append("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBinaryValue(IJDBCAdapter jdbcAdapter, Connection connectionSQL, StringBuilder output, byte[] binaryValue, byte[] updateValue, VaultUpdateConfigValue binaryConfig) throws UtilsException, SQLQueryObjectException, SQLException {
        PreparedStatement stmUpdate = null;
        try {
            String base64;
            BYOKWrappedValue wrappedValue = null;
            if (this.outDriverBYOK != null) {
                wrappedValue = this.outDriverBYOK.wrap(updateValue != null ? updateValue : binaryValue);
            }
            ISQLQueryObject sqlQueryObjectUpdate = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObjectUpdate.addUpdateTable(binaryConfig.tabella);
            sqlQueryObjectUpdate.addUpdateField(binaryConfig.nomeColonna, "?");
            sqlQueryObjectUpdate.addWhereCondition(CONDITION_WHERE_ID);
            sqlQueryObjectUpdate.setANDLogicOperator(true);
            String sqlUpdate = sqlQueryObjectUpdate.createSQLUpdate();
            stmUpdate = connectionSQL.prepareStatement(sqlUpdate);
            int index = 1;
            if (wrappedValue != null) {
                jdbcAdapter.setBinaryData(stmUpdate, index++, wrappedValue.getWrappedValue().getBytes());
                if (output != null) {
                    base64 = Base64Utilities.encodeAsString((byte[])wrappedValue.getWrappedValue().getBytes());
                    output.append(LOG_NEW).append(base64).append("\n");
                }
            } else {
                jdbcAdapter.setBinaryData(stmUpdate, index++, updateValue);
                if (output != null) {
                    base64 = Base64Utilities.encodeAsString((byte[])updateValue);
                    output.append(LOG_NEW).append(base64).append("\n");
                }
            }
            stmUpdate.setLong(index++, binaryConfig.id);
            int row = stmUpdate.executeUpdate();
            if (output != null) {
                output.append(LOG_ROW_UPDATE).append(row).append("\n");
            }
            stmUpdate.close();
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(stmUpdate);
            throw throwable;
        }
        JDBCUtilities.closeResources((PreparedStatement)stmUpdate);
    }

    private void updateConnettori(String nomeColonnaPlain, String nomeColonnaCodificata, StringBuilder output) throws CoreException {
        PreparedStatement stmRead = null;
        ResultSet rs = null;
        Connection connectionSQL = null;
        try {
            connectionSQL = this.getConnection();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addWhereIsNotNullCondition(nomeColonnaPlain);
            if (!TipiDatabase.ORACLE.equals(this.tipoDatabase)) {
                sqlQueryObject.addWhereIsNotEmptyCondition(nomeColonnaPlain);
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome_connettore");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmRead = connectionSQL.prepareStatement(sqlQuery);
            rs = stmRead.executeQuery();
            while (rs.next()) {
                Object c;
                long id = rs.getLong("id");
                String nomeConnettore = rs.getString("nome_connettore");
                String endpointtype = rs.getString("endpointtype");
                String prefix = "[" + nomeConnettore + "][tipoConnettore:" + endpointtype + "][idConnettore:" + id + "] '" + nomeColonnaPlain + "' ";
                if (nomeColonnaCodificata != null) {
                    c = new VaultUpdateConfigPlainEnc();
                    ((VaultUpdateConfigPlainEnc)c).tabella = "connettori";
                    ((VaultUpdateConfigPlainEnc)c).nomeColonnaPlain = nomeColonnaPlain;
                    ((VaultUpdateConfigPlainEnc)c).nomeColonnaCodificata = nomeColonnaCodificata;
                    ((VaultUpdateConfigPlainEnc)c).id = id;
                    this.updatePlainEncValue(connectionSQL, rs, nomeColonnaPlain, nomeColonnaCodificata, prefix, output, (VaultUpdateConfigPlainEnc)c);
                    continue;
                }
                c = new VaultUpdateConfigValue();
                ((VaultUpdateConfigValue)c).tabella = "connettori";
                ((VaultUpdateConfigValue)c).nomeColonna = nomeColonnaPlain;
                ((VaultUpdateConfigValue)c).id = id;
                this.updateValue(connectionSQL, rs, nomeColonnaPlain, prefix, output, (VaultUpdateConfigValue)c);
            }
        }
        catch (Exception se) {
            try {
                throw new CoreException("[updateConnettori] failed: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmRead);
                this.closeConnection(connectionSQL);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmRead);
        this.closeConnection(connectionSQL);
    }

    private void updateConnettoriCustom(String nomeProprieta, StringBuilder output) throws CoreException {
        PreparedStatement stmRead = null;
        ResultSet rs = null;
        Connection connectionSQL = null;
        try {
            connectionSQL = this.getConnection();
            String aliasIdConnettore = "idCon";
            String aliasNomeConnettore = "nomeCon";
            String aliasTipoConnettore = "tipoCon";
            String aliasIdConnettoreCustsom = "idConCustom";
            String aliasNomeConnettoreCustsom = "nomeConCustom";
            String aliasPlanValueConnettoreCustsom = "plainConCustom";
            String aliasEncValueConnettoreCustsom = "encConCustom";
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addFromTable("connettori_custom");
            sqlQueryObject.addSelectAliasField("connettori", "nome_connettore", aliasNomeConnettore);
            sqlQueryObject.addSelectAliasField("connettori", "endpointtype", aliasTipoConnettore);
            sqlQueryObject.addSelectAliasField("connettori", "id", aliasIdConnettore);
            sqlQueryObject.addSelectAliasField("connettori_custom", "id", aliasIdConnettoreCustsom);
            sqlQueryObject.addSelectAliasField("connettori_custom", "name", aliasNomeConnettoreCustsom);
            sqlQueryObject.addSelectAliasField("connettori_custom", "value", aliasPlanValueConnettoreCustsom);
            sqlQueryObject.addSelectAliasField("connettori_custom", "enc_value", aliasEncValueConnettoreCustsom);
            sqlQueryObject.addWhereCondition("connettori.id = connettori_custom.id_connettore");
            sqlQueryObject.addWhereCondition("connettori_custom.name=?");
            sqlQueryObject.addWhereIsNotNullCondition("connettori_custom.value");
            if (!TipiDatabase.ORACLE.equals(this.tipoDatabase)) {
                sqlQueryObject.addWhereIsNotEmptyCondition("connettori_custom.value");
            }
            sqlQueryObject.addWhereCondition(true, true, new String[]{"connettori_custom.value='-'"});
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome_connettore");
            sqlQueryObject.setSelectDistinct(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmRead = connectionSQL.prepareStatement(sqlQuery);
            stmRead.setString(1, nomeProprieta);
            rs = stmRead.executeQuery();
            while (rs.next()) {
                long idCustom = rs.getLong(aliasIdConnettoreCustsom);
                long idConnettore = rs.getLong(aliasIdConnettore);
                String nomeConnettore = rs.getString(aliasNomeConnettore);
                String endpointtype = rs.getString(aliasTipoConnettore);
                String prefix = "[" + nomeConnettore + "][tipoConnettore:" + endpointtype + "][idConnettore:" + idConnettore + "][idCustomProp:" + idCustom + "] '" + nomeProprieta + "' ";
                VaultUpdateConfigPlainEnc c = new VaultUpdateConfigPlainEnc();
                c.tabella = "connettori_custom";
                c.nomeColonnaPlain = "value";
                c.nomeColonnaCodificata = "enc_value";
                c.id = idCustom;
                this.updatePlainEncValue(connectionSQL, rs, aliasPlanValueConnettoreCustsom, aliasEncValueConnettoreCustsom, prefix, output, c);
            }
        }
        catch (Exception se) {
            try {
                throw new CoreException("[updateConnettoriCustom] failed: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmRead);
                this.closeConnection(connectionSQL);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmRead);
        this.closeConnection(connectionSQL);
    }

    private void updateServiziApplicativi(String nomeColonnaPlain, String nomeColonnaCodificata, StringBuilder output) throws CoreException {
        PreparedStatement stmRead = null;
        ResultSet rs = null;
        Connection connectionSQL = null;
        try {
            connectionSQL = this.getConnection();
            String aliasNomeSA = "nomeSA";
            String aliasTipoSoggetto = "tipoSogg";
            String aliasNomeSoggetto = "nomeSogg";
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectAliasField("servizi_applicativi", "id", "idSA");
            sqlQueryObject.addSelectAliasField("servizi_applicativi", "nome", aliasNomeSA);
            sqlQueryObject.addSelectAliasField("servizi_applicativi", "tipo", "tipoSA");
            sqlQueryObject.addSelectAliasField("soggetti", "tipo_soggetto", aliasTipoSoggetto);
            sqlQueryObject.addSelectAliasField("soggetti", "nome_soggetto", aliasNomeSoggetto);
            sqlQueryObject.addSelectAliasField("servizi_applicativi", nomeColonnaPlain, ALIAS_PLAIN_VALUE);
            sqlQueryObject.addSelectAliasField("servizi_applicativi", nomeColonnaCodificata, ALIAS_ENC_VALUE);
            sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereIsNotNullCondition(nomeColonnaPlain);
            if (!TipiDatabase.ORACLE.equals(this.tipoDatabase)) {
                sqlQueryObject.addWhereIsNotEmptyCondition(nomeColonnaPlain);
            }
            sqlQueryObject.addOrderBy(aliasTipoSoggetto);
            sqlQueryObject.addOrderBy(aliasNomeSoggetto);
            sqlQueryObject.addOrderBy(aliasNomeSA);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.setSelectDistinct(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmRead = connectionSQL.prepareStatement(sqlQuery);
            rs = stmRead.executeQuery();
            while (rs.next()) {
                long idSA = rs.getLong("idSA");
                String nome = rs.getString(aliasNomeSA);
                String tipo = rs.getString("tipoSA");
                String tipoSoggetto = rs.getString(aliasTipoSoggetto);
                String nomeSoggetto = rs.getString(aliasNomeSoggetto);
                String prefix = "[" + nome + "][soggetto:" + tipoSoggetto + "/" + nomeSoggetto + "][tipoSA:" + tipo + "][idSA:" + idSA + "] '" + nomeColonnaPlain + "' ";
                VaultUpdateConfigPlainEnc c = new VaultUpdateConfigPlainEnc();
                c.tabella = "servizi_applicativi";
                c.nomeColonnaPlain = nomeColonnaPlain;
                c.nomeColonnaCodificata = nomeColonnaCodificata;
                c.id = idSA;
                this.updatePlainEncValue(connectionSQL, rs, ALIAS_PLAIN_VALUE, ALIAS_ENC_VALUE, prefix, output, c);
            }
        }
        catch (Exception se) {
            try {
                throw new CoreException("[updateServiziApplicativi] failed: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmRead);
                this.closeConnection(connectionSQL);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmRead);
        this.closeConnection(connectionSQL);
    }

    private void updateMessageSecurity(String tabellaPadre, String tabella, String nomeColonnaNomeProprieta, String nomeColonnaPlain, String nomeColonnaCodificata, String nomeProprieta, StringBuilder output) throws CoreException {
        PreparedStatement stmRead = null;
        ResultSet rs = null;
        Connection connectionSQL = null;
        try {
            connectionSQL = this.getConnection();
            String aliasIdSecProp = "idSecProp";
            String aliasIdPorta = "idP";
            String aliasNomePorta = "nomeP";
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable(tabellaPadre);
            sqlQueryObject.addFromTable(tabella);
            sqlQueryObject.addSelectAliasField(tabellaPadre, "id", aliasIdPorta);
            sqlQueryObject.addSelectAliasField(tabellaPadre, "nome_porta", aliasNomePorta);
            sqlQueryObject.addSelectAliasField(tabella, "id", aliasIdSecProp);
            sqlQueryObject.addSelectAliasField(tabella, nomeColonnaPlain, ALIAS_PLAIN_VALUE);
            sqlQueryObject.addSelectAliasField(tabella, nomeColonnaCodificata, ALIAS_ENC_VALUE);
            sqlQueryObject.addWhereCondition(tabellaPadre + CONDITION_JOIN_ID + tabella + ".id_porta");
            ISQLQueryObject sqlQueryObjectOrName = sqlQueryObject.newSQLQueryObject();
            sqlQueryObjectOrName.addFromTable(tabella);
            sqlQueryObjectOrName.addWhereCondition(tabella + "." + nomeColonnaNomeProprieta + " = ?");
            sqlQueryObjectOrName.addWhereLikeCondition(tabella + "." + nomeColonnaNomeProprieta, "_@@@_" + nomeProprieta, LikeConfig.endsWith((boolean)false));
            sqlQueryObjectOrName.addWhereLikeCondition(tabella + "." + nomeColonnaNomeProprieta, "_@@_" + nomeProprieta, LikeConfig.endsWith((boolean)false));
            sqlQueryObjectOrName.setANDLogicOperator(false);
            sqlQueryObject.addWhereCondition(sqlQueryObjectOrName.createSQLConditions());
            sqlQueryObject.addWhereIsNotNullCondition(nomeColonnaPlain);
            if (!TipiDatabase.ORACLE.equals(this.tipoDatabase)) {
                sqlQueryObject.addWhereIsNotEmptyCondition(nomeColonnaPlain);
            }
            sqlQueryObject.addWhereCondition(true, true, new String[]{sqlQueryObject.getWhereLikeCondition(tabella + "." + nomeColonnaPlain, "-", true)});
            sqlQueryObject.addOrderBy(aliasNomePorta);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.setSelectDistinct(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmRead = connectionSQL.prepareStatement(sqlQuery);
            stmRead.setString(1, nomeProprieta);
            rs = stmRead.executeQuery();
            while (rs.next()) {
                long idSecProp = rs.getLong(aliasIdSecProp);
                String nome = rs.getString(aliasNomePorta);
                long idPorta = rs.getLong(aliasIdPorta);
                String prefix = "[" + nome + "][idPorta:" + idPorta + "][idSecProp:" + idSecProp + "] '" + nomeProprieta + "' ";
                VaultUpdateConfigPlainEnc c = new VaultUpdateConfigPlainEnc();
                c.tabella = tabella;
                c.nomeColonnaPlain = nomeColonnaPlain;
                c.nomeColonnaCodificata = nomeColonnaCodificata;
                c.id = idSecProp;
                this.updatePlainEncValue(connectionSQL, rs, ALIAS_PLAIN_VALUE, ALIAS_ENC_VALUE, prefix, output, c);
            }
        }
        catch (Exception se) {
            try {
                throw new CoreException("[updateMessageSecurity] failed: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmRead);
                this.closeConnection(connectionSQL);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmRead);
        this.closeConnection(connectionSQL);
    }

    private void updateGenericProperties(String tipologia, String nomeProprieta, StringBuilder output) throws CoreException {
        PreparedStatement stmRead = null;
        ResultSet rs = null;
        Connection connectionSQL = null;
        try {
            connectionSQL = this.getConnection();
            String aliasNomeConfig = "nomeConfig";
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("generic_property");
            sqlQueryObject.addFromTable("generic_properties");
            sqlQueryObject.addSelectAliasField("generic_property", "id", "idProp");
            sqlQueryObject.addSelectAliasField("generic_properties", "nome", aliasNomeConfig);
            sqlQueryObject.addSelectAliasField("generic_property", "valore", ALIAS_PLAIN_VALUE);
            sqlQueryObject.addSelectAliasField("generic_property", "enc_value", ALIAS_ENC_VALUE);
            sqlQueryObject.addWhereCondition("generic_properties.id = generic_property.id_props");
            sqlQueryObject.addWhereCondition("generic_properties.tipo = ?");
            ISQLQueryObject sqlQueryObjectOrName = sqlQueryObject.newSQLQueryObject();
            sqlQueryObjectOrName.addFromTable("generic_property");
            sqlQueryObjectOrName.addWhereCondition("generic_property.nome = ?");
            sqlQueryObjectOrName.addWhereLikeCondition("generic_property.nome", "_@@@_" + nomeProprieta, LikeConfig.endsWith((boolean)false));
            sqlQueryObjectOrName.addWhereLikeCondition("generic_property.nome", "_@@_" + nomeProprieta, LikeConfig.endsWith((boolean)false));
            sqlQueryObjectOrName.setANDLogicOperator(false);
            sqlQueryObject.addWhereCondition(sqlQueryObjectOrName.createSQLConditions());
            sqlQueryObject.addWhereIsNotNullCondition("generic_property.valore");
            if (!TipiDatabase.ORACLE.equals(this.tipoDatabase)) {
                sqlQueryObject.addWhereIsNotEmptyCondition("generic_property.valore");
            }
            sqlQueryObject.addWhereCondition(true, true, new String[]{"generic_property.valore='-'"});
            sqlQueryObject.addOrderBy(aliasNomeConfig);
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmRead = connectionSQL.prepareStatement(sqlQuery);
            stmRead.setString(1, tipologia);
            stmRead.setString(2, nomeProprieta);
            rs = stmRead.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("idProp");
                String nomeConfig = rs.getString(aliasNomeConfig);
                String prefix = "[config:" + nomeConfig + "][tipo:" + tipologia + "][idGP:" + id + "] '" + nomeProprieta + "' ";
                VaultUpdateConfigPlainEnc c = new VaultUpdateConfigPlainEnc();
                c.tabella = "generic_property";
                c.nomeColonnaPlain = "valore";
                c.nomeColonnaCodificata = "enc_value";
                c.id = id;
                this.updatePlainEncValue(connectionSQL, rs, ALIAS_PLAIN_VALUE, ALIAS_ENC_VALUE, prefix, output, c);
            }
        }
        catch (Exception se) {
            try {
                throw new CoreException("[updateGenericProperties] failed: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmRead);
                this.closeConnection(connectionSQL);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmRead);
        this.closeConnection(connectionSQL);
    }

    private void updateProtocolProperties(String nomeProprieta, boolean binary, StringBuilder output) throws CoreException {
        PreparedStatement stmRead = null;
        ResultSet rs = null;
        Connection connectionSQL = null;
        try {
            connectionSQL = this.getConnection();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("protocol_properties");
            sqlQueryObject.addWhereCondition("name = ?");
            if (binary) {
                sqlQueryObject.addWhereIsNotNullCondition("value_binary");
            } else {
                sqlQueryObject.addWhereIsNotNullCondition("value_string");
                if (!TipiDatabase.ORACLE.equals(this.tipoDatabase)) {
                    sqlQueryObject.addWhereIsNotEmptyCondition("value_string");
                }
                sqlQueryObject.addWhereCondition(true, true, new String[]{"value_string='-'"});
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("tipo_proprietario");
            sqlQueryObject.addOrderBy("id_proprietario");
            sqlQueryObject.addOrderBy("name");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmRead = connectionSQL.prepareStatement(sqlQuery);
            stmRead.setString(1, nomeProprieta);
            rs = stmRead.executeQuery();
            IJDBCAdapter jdbcAdapter = null;
            if (binary) {
                jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.tipoDatabase);
            }
            while (rs.next()) {
                Object c;
                long id = rs.getLong("id");
                long idProprietario = rs.getLong("id_proprietario");
                String proprietario = rs.getString("tipo_proprietario");
                String identificativoOggetto = this.getIdentificativoOggettoProtocolProperties(proprietario, idProprietario, id);
                String prefix = "[tipoProprietario:" + proprietario + "][idProprietario:" + idProprietario + "][" + identificativoOggetto + "][idProp:" + id + "] '" + nomeProprieta + "' ";
                if (binary) {
                    c = new VaultUpdateConfigValue();
                    ((VaultUpdateConfigValue)c).tabella = "protocol_properties";
                    ((VaultUpdateConfigValue)c).nomeColonna = "value_binary";
                    ((VaultUpdateConfigValue)c).id = id;
                    this.updateBinaryProtocolProperty(jdbcAdapter, connectionSQL, rs, "value_binary", prefix, output, (VaultUpdateConfigValue)c);
                    continue;
                }
                c = new VaultUpdateConfigPlainEnc();
                ((VaultUpdateConfigPlainEnc)c).tabella = "protocol_properties";
                ((VaultUpdateConfigPlainEnc)c).nomeColonnaPlain = "value_string";
                ((VaultUpdateConfigPlainEnc)c).nomeColonnaCodificata = "enc_value_string";
                ((VaultUpdateConfigPlainEnc)c).id = id;
                this.updatePlainEncValue(connectionSQL, rs, "value_string", "enc_value_string", prefix, output, (VaultUpdateConfigPlainEnc)c);
            }
        }
        catch (Exception se) {
            try {
                throw new CoreException("[updateProtocolProperties] failed: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmRead);
                this.closeConnection(connectionSQL);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmRead);
        this.closeConnection(connectionSQL);
    }

    private String getIdentificativoOggettoProtocolProperties(String proprietario, long id, long idProp) throws CoreException {
        String sqlQuery;
        ProprietariProtocolProperty proprietarioProtocolProperty;
        Connection connectionSQL;
        ResultSet rs;
        PreparedStatement stmRead;
        block5: {
            stmRead = null;
            rs = null;
            connectionSQL = null;
            connectionSQL = this.getConnection();
            proprietarioProtocolProperty = ProprietariProtocolProperty.valueOf((String)proprietario);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            this.addTableProtocolProperties(sqlQueryObject, proprietarioProtocolProperty);
            sqlQueryObject.addWhereCondition(CONDITION_WHERE_ID);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stmRead = connectionSQL.prepareStatement(sqlQuery);
            stmRead.setLong(1, id);
            rs = stmRead.executeQuery();
            if (!rs.next()) break block5;
            String string = this.readInfoProtocolProperties(connectionSQL, rs, proprietarioProtocolProperty);
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmRead);
            this.closeConnection(connectionSQL);
            return string;
        }
        try {
            try {
                throw new CoreException("Entry not found for (idProp:" + idProp + ") '" + proprietarioProtocolProperty + "' (" + sqlQuery + " id:" + id + ")");
            }
            catch (Exception se) {
                throw new CoreException(se.getMessage(), (Throwable)se);
            }
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(rs, stmRead);
            this.closeConnection(connectionSQL);
            throw throwable;
        }
    }

    private void addTableProtocolProperties(ISQLQueryObject sqlQueryObject, ProprietariProtocolProperty proprietarioProtocolProperty) throws SQLQueryObjectException {
        switch (proprietarioProtocolProperty) {
            case ACCORDO_COOPERAZIONE: {
                sqlQueryObject.addFromTable("accordi_cooperazione");
                break;
            }
            case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                sqlQueryObject.addFromTable("accordi");
                break;
            }
            case ACCORDO_SERVIZIO_PARTE_SPECIFICA: {
                sqlQueryObject.addFromTable("servizi");
                break;
            }
            case AZIONE_ACCORDO: {
                sqlQueryObject.addFromTable("accordi_azioni");
                break;
            }
            case OPERATION: {
                sqlQueryObject.addFromTable("port_type_azioni");
                break;
            }
            case PORT_TYPE: {
                sqlQueryObject.addFromTable("port_type");
                break;
            }
            case RESOURCE: {
                sqlQueryObject.addFromTable("api_resources");
                break;
            }
            case FRUITORE: {
                sqlQueryObject.addFromTable("servizi_fruitori");
                break;
            }
            case SERVIZIO_APPLICATIVO: {
                sqlQueryObject.addFromTable("servizi_applicativi");
                break;
            }
            case SOGGETTO: {
                sqlQueryObject.addFromTable("soggetti");
                break;
            }
        }
    }

    private String readInfoProtocolProperties(Connection connectionSQL, ResultSet rs, ProprietariProtocolProperty proprietarioProtocolProperty) throws SQLException, CoreException, DriverRegistroServiziException {
        switch (proprietarioProtocolProperty) {
            case ACCORDO_COOPERAZIONE: {
                return rs.getString("nome");
            }
            case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                String nome = rs.getString("nome");
                long idSoggetto = rs.getLong("id_referente");
                int versione = rs.getInt("versione");
                IDSoggetto idS = DBUtils.getIdSoggetto((long)idSoggetto, (Connection)connectionSQL, (String)this.tipoDatabase);
                return IDAccordoFactory.getInstance().getUriFromValues(nome, idS, Integer.valueOf(versione));
            }
            case ACCORDO_SERVIZIO_PARTE_SPECIFICA: {
                String tipoServizio = rs.getString("tipo_servizio");
                String nomeServizio = rs.getString("nome_servizio");
                int versioneServizio = rs.getInt("versione_servizio");
                long idSoggetto = rs.getLong("id_soggetto");
                IDSoggetto idS = DBUtils.getIdSoggetto((long)idSoggetto, (Connection)connectionSQL, (String)this.tipoDatabase);
                return IDServizioFactory.getInstance().getUriFromValues(tipoServizio, nomeServizio, idS, versioneServizio);
            }
            case AZIONE_ACCORDO: {
                String nome = rs.getString("nome");
                long idAccordo = rs.getLong("id_accordo");
                return "api:" + this.readDatiAccordo(connectionSQL, idAccordo) + " azione:" + nome;
            }
            case OPERATION: {
                String nome = rs.getString("nome");
                long idPortType = rs.getLong("id_port_type");
                return "api:" + this.readDatiPT(connectionSQL, idPortType) + " operation:" + nome;
            }
            case PORT_TYPE: {
                String nome = rs.getString("nome");
                long idAccordo = rs.getLong("id_accordo");
                return "api:" + this.readDatiAccordo(connectionSQL, idAccordo) + " portType:" + nome;
            }
            case RESOURCE: {
                String nome = rs.getString("nome");
                long idAccordo = rs.getLong("id_accordo");
                return "api:" + this.readDatiAccordo(connectionSQL, idAccordo) + " resource:" + nome;
            }
            case FRUITORE: {
                long idServizio = rs.getLong("id_servizio");
                long idSoggetto = rs.getLong("id_soggetto");
                IDSoggetto idS = DBUtils.getIdSoggetto((long)idSoggetto, (Connection)connectionSQL, (String)this.tipoDatabase);
                return idS.toString() + " -> " + this.readDatiServizio(connectionSQL, idServizio);
            }
            case SERVIZIO_APPLICATIVO: {
                String nome = rs.getString("nome");
                long idSoggetto = rs.getLong("id_soggetto");
                IDSoggetto idS = DBUtils.getIdSoggetto((long)idSoggetto, (Connection)connectionSQL, (String)this.tipoDatabase);
                return idS.toString() + " sa:" + nome;
            }
            case SOGGETTO: {
                String tipoSoggetto = rs.getString("tipo_soggetto");
                String nomeSoggetto = rs.getString("nome_soggetto");
                return new IDSoggetto(tipoSoggetto, nomeSoggetto).toString();
            }
        }
        return null;
    }

    private void updateProperties(String tabella, String nomeColonna, String nomeColonnaPlain, String nomeColonnaCodificata, StringBuilder output, boolean checkRequestSec, boolean checkResponseCheck) throws CoreException {
        PreparedStatement stmRead = null;
        ResultSet rs = null;
        Connection connectionSQL = null;
        try {
            connectionSQL = this.getConnection();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable(tabella);
            sqlQueryObject.addWhereIsNotNullCondition(nomeColonnaCodificata);
            if (!TipiDatabase.ORACLE.equals(this.tipoDatabase)) {
                sqlQueryObject.addWhereIsNotEmptyCondition(nomeColonnaCodificata);
            }
            sqlQueryObject.addOrderBy(nomeColonna);
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmRead = connectionSQL.prepareStatement(sqlQuery);
            rs = stmRead.executeQuery();
            while (rs.next()) {
                long idP = rs.getLong("id");
                String nomeProprieta = rs.getString(nomeColonna);
                if (checkRequestSec || checkResponseCheck) {
                    String sec;
                    long idPorta = rs.getLong("id_porta");
                    String tabellaPorta = "porte_delegate";
                    if ("pa_security_request".equals(tabella) || "pa_security_response".equals(tabella)) {
                        tabellaPorta = "porte_applicative";
                    }
                    if ((sec = this.readMessageSecurityPorta(connectionSQL, idPorta, tabellaPorta, checkRequestSec)) != null && StringUtils.isNotEmpty((String)sec) && !"-".equals(sec) && !"default".equals(sec)) continue;
                }
                String identificativoOggetto = this.getIdentificativoOggettoProperties(tabella, connectionSQL, rs);
                String prefix = "[proprietario:" + tabella + "][" + identificativoOggetto + "][idProp:" + idP + "] '" + nomeProprieta + "' ";
                VaultUpdateConfigPlainEnc c = new VaultUpdateConfigPlainEnc();
                c.tabella = tabella;
                c.nomeColonnaPlain = nomeColonnaPlain;
                c.nomeColonnaCodificata = nomeColonnaCodificata;
                c.id = idP;
                this.updatePlainEncValue(connectionSQL, rs, nomeColonnaPlain, nomeColonnaCodificata, prefix, output, c);
            }
        }
        catch (Exception se) {
            try {
                throw new CoreException("[updateProperties-" + tabella + "] failed: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmRead);
                this.closeConnection(connectionSQL);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmRead);
        this.closeConnection(connectionSQL);
    }

    private String getIdentificativoOggettoProperties(String tabella, Connection connectionSQL, ResultSet rs) throws SQLException, CoreException {
        if ("soggetti_properties".equals(tabella)) {
            long idSoggetto = rs.getLong("id_soggetto");
            IDSoggetto idS = DBUtils.getIdSoggetto((long)idSoggetto, (Connection)connectionSQL, (String)this.tipoDatabase);
            return idS.toString();
        }
        if ("sa_properties".equals(tabella)) {
            long idSA = rs.getLong("id_servizio_applicativo");
            return this.readDatiSA(connectionSQL, idSA);
        }
        if ("pdd_sys_props".equals(tabella)) {
            return "configurazione-generale";
        }
        if ("pa_security_request".equals(tabella) || "pa_security_response".equals(tabella) || "pa_auth_properties".equals(tabella) || "pa_authz_properties".equals(tabella) || "pa_authzc_properties".equals(tabella) || "pa_properties".equals(tabella)) {
            long idPorta = rs.getLong("id_porta");
            return this.readDatiPortaApplicativa(connectionSQL, idPorta);
        }
        if ("pd_security_request".equals(tabella) || "pd_security_response".equals(tabella) || "pd_auth_properties".equals(tabella) || "pd_authz_properties".equals(tabella) || "pd_authzc_properties".equals(tabella) || "pd_properties".equals(tabella)) {
            long idPorta = rs.getLong("id_porta");
            return this.readDatiPortaDelegata(connectionSQL, idPorta);
        }
        return null;
    }

    private String readDatiAccordo(Connection connectionSQL, long idAccordo) throws CoreException {
        String string;
        ResultSet rsInternal;
        PreparedStatement stmReadInternal;
        block5: {
            stmReadInternal = null;
            rsInternal = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addWhereCondition(CONDITION_WHERE_ID);
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmReadInternal = connectionSQL.prepareStatement(sqlQuery);
            stmReadInternal.setLong(1, idAccordo);
            rsInternal = stmReadInternal.executeQuery();
            String nome = rsInternal.getString("nome");
            if (!rsInternal.next()) break block5;
            long idSoggetto = rsInternal.getLong("id_referente");
            int versione = rsInternal.getInt("versione");
            IDSoggetto idS = DBUtils.getIdSoggetto((long)idSoggetto, (Connection)connectionSQL, (String)this.tipoDatabase);
            String string2 = IDAccordoFactory.getInstance().getUriFromValues(nome, idS, Integer.valueOf(versione));
            JDBCUtilities.closeResources((ResultSet)rsInternal, (PreparedStatement)stmReadInternal);
            return string2;
        }
        try {
            string = null;
        }
        catch (Exception se) {
            try {
                throw new CoreException(se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rsInternal, stmReadInternal);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rsInternal, (PreparedStatement)stmReadInternal);
        return string;
    }

    private String readDatiPT(Connection connectionSQL, long idPortType) throws CoreException {
        String string;
        ResultSet rsInternal;
        PreparedStatement stmReadInternal;
        block5: {
            stmReadInternal = null;
            rsInternal = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addWhereCondition(CONDITION_WHERE_ID);
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmReadInternal = connectionSQL.prepareStatement(sqlQuery);
            stmReadInternal.setLong(1, idPortType);
            rsInternal = stmReadInternal.executeQuery();
            if (!rsInternal.next()) break block5;
            String nome = rsInternal.getString("nome");
            long idAccordo = rsInternal.getLong("id_accordo");
            String string2 = this.readDatiAccordo(connectionSQL, idAccordo) + " portType:" + nome;
            JDBCUtilities.closeResources((ResultSet)rsInternal, (PreparedStatement)stmReadInternal);
            return string2;
        }
        try {
            string = null;
        }
        catch (Exception se) {
            try {
                throw new CoreException(se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rsInternal, stmReadInternal);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rsInternal, (PreparedStatement)stmReadInternal);
        return string;
    }

    private String readDatiServizio(Connection connectionSQL, long idServizio) throws CoreException {
        String string;
        ResultSet rsInternal;
        PreparedStatement stmReadInternal;
        block5: {
            stmReadInternal = null;
            rsInternal = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addWhereCondition(CONDITION_WHERE_ID);
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmReadInternal = connectionSQL.prepareStatement(sqlQuery);
            stmReadInternal.setLong(1, idServizio);
            rsInternal = stmReadInternal.executeQuery();
            if (!rsInternal.next()) break block5;
            String tipoServizio = rsInternal.getString("tipo_servizio");
            String nomeServizio = rsInternal.getString("nome_servizio");
            int versioneServizio = rsInternal.getInt("versione_servizio");
            long idSoggetto = rsInternal.getLong("id_soggetto");
            IDSoggetto idS = DBUtils.getIdSoggetto((long)idSoggetto, (Connection)connectionSQL, (String)this.tipoDatabase);
            String string2 = IDServizioFactory.getInstance().getUriFromValues(tipoServizio, nomeServizio, idS, versioneServizio);
            JDBCUtilities.closeResources((ResultSet)rsInternal, (PreparedStatement)stmReadInternal);
            return string2;
        }
        try {
            string = null;
        }
        catch (Exception se) {
            try {
                throw new CoreException(se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rsInternal, stmReadInternal);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rsInternal, (PreparedStatement)stmReadInternal);
        return string;
    }

    private String readDatiSA(Connection connectionSQL, long idServizioApplicativo) throws CoreException {
        String string;
        ResultSet rsInternal;
        PreparedStatement stmReadInternal;
        block5: {
            stmReadInternal = null;
            rsInternal = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addWhereCondition(CONDITION_WHERE_ID);
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmReadInternal = connectionSQL.prepareStatement(sqlQuery);
            stmReadInternal.setLong(1, idServizioApplicativo);
            rsInternal = stmReadInternal.executeQuery();
            if (!rsInternal.next()) break block5;
            String nome = rsInternal.getString("nome");
            long idSoggetto = rsInternal.getLong("id_soggetto");
            IDSoggetto idS = DBUtils.getIdSoggetto((long)idSoggetto, (Connection)connectionSQL, (String)this.tipoDatabase);
            String string2 = idS.toString() + " sa:" + nome;
            JDBCUtilities.closeResources((ResultSet)rsInternal, (PreparedStatement)stmReadInternal);
            return string2;
        }
        try {
            string = null;
        }
        catch (Exception se) {
            try {
                throw new CoreException(se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rsInternal, stmReadInternal);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rsInternal, (PreparedStatement)stmReadInternal);
        return string;
    }

    private String readDatiPortaDelegata(Connection connectionSQL, long idPorta) throws CoreException {
        return this.readDatiPorta(connectionSQL, idPorta, "porte_delegate");
    }

    private String readDatiPortaApplicativa(Connection connectionSQL, long idPorta) throws CoreException {
        return this.readDatiPorta(connectionSQL, idPorta, "porte_applicative");
    }

    private String readDatiPorta(Connection connectionSQL, long idPorta, String tabella) throws CoreException {
        String string;
        ResultSet rsInternal;
        PreparedStatement stmReadInternal;
        block5: {
            stmReadInternal = null;
            rsInternal = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable(tabella);
            sqlQueryObject.addWhereCondition(CONDITION_WHERE_ID);
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmReadInternal = connectionSQL.prepareStatement(sqlQuery);
            stmReadInternal.setLong(1, idPorta);
            rsInternal = stmReadInternal.executeQuery();
            if (!rsInternal.next()) break block5;
            String string2 = rsInternal.getString("nome_porta");
            JDBCUtilities.closeResources((ResultSet)rsInternal, (PreparedStatement)stmReadInternal);
            return string2;
        }
        try {
            string = null;
        }
        catch (Exception se) {
            try {
                throw new CoreException(se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rsInternal, stmReadInternal);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rsInternal, (PreparedStatement)stmReadInternal);
        return string;
    }

    private String readMessageSecurityPorta(Connection connectionSQL, long idPorta, String tabella, boolean request) throws CoreException {
        String string;
        ResultSet rsInternal;
        PreparedStatement stmReadInternal;
        block5: {
            stmReadInternal = null;
            rsInternal = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
            sqlQueryObject.addFromTable(tabella);
            sqlQueryObject.addWhereCondition(CONDITION_WHERE_ID);
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmReadInternal = connectionSQL.prepareStatement(sqlQuery);
            stmReadInternal.setLong(1, idPorta);
            rsInternal = stmReadInternal.executeQuery();
            if (!rsInternal.next()) break block5;
            String string2 = rsInternal.getString(request ? "security_request_mode" : "security_response_mode");
            JDBCUtilities.closeResources((ResultSet)rsInternal, (PreparedStatement)stmReadInternal);
            return string2;
        }
        try {
            string = null;
        }
        catch (Exception se) {
            try {
                throw new CoreException(se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rsInternal, stmReadInternal);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rsInternal, (PreparedStatement)stmReadInternal);
        return string;
    }
}

