/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import com.google.common.io.CharStreams;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.io.output.WriterOutputStream;
import org.openspcoop2.utils.CopyStreamMethod;
import org.openspcoop2.utils.UtilsException;

public class CopyCharStream {
    public static void copy(Reader reader, OutputStream out) throws UtilsException {
        CopyCharStream.copy(CopyStreamMethod.AUTO, reader, out);
    }

    public static void copy(CopyStreamMethod method, Reader reader, OutputStream out) throws UtilsException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            CopyCharStream.copy(method, reader, writer);
            out.flush();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copy(Reader reader, Writer writer) throws UtilsException {
        CopyCharStream.copy(CopyStreamMethod.AUTO, reader, writer);
    }

    public static void copy(CopyStreamMethod method, Reader reader, Writer writer) throws UtilsException {
        switch (method) {
            case JAVA: {
                CopyCharStream.copyBuffer(reader, writer);
                break;
            }
            case JAVA_TRANSFER_TO: {
                CopyCharStream.transferTo(reader, writer);
                break;
            }
            case JAVA_NIO: {
                CopyCharStream.copyChannels(reader, writer);
                break;
            }
            case GUAVA: {
                CopyCharStream.copyGuava(reader, writer);
                break;
            }
            case COMMONS_IO: {
                CopyCharStream.copyCommonsIO(reader, writer);
                break;
            }
            case AUTO: {
                CopyCharStream.transferTo(reader, writer);
            }
        }
    }

    public static void copyBuffer(Reader reader, Writer writer) throws UtilsException {
        try {
            char[] buffer = new char[65536];
            int letti = 0;
            while ((letti = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, letti);
            }
            writer.flush();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void transferTo(Reader reader, Writer writer) throws UtilsException {
        try {
            reader.transferTo(writer);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copyGuava(Reader reader, Writer writer) throws UtilsException {
        try {
            CharStreams.copy((Readable)reader, (Appendable)writer);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copyCommonsIO(Reader reader, Writer writer) throws UtilsException {
        try {
            IOUtils.copy((Reader)reader, (Writer)writer);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copyChannels(Reader reader, Writer writer) throws UtilsException {
        try (ReaderInputStream src = ((ReaderInputStream.Builder)((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(reader)).setCharset("UTF-8")).get();
             WriterOutputStream dest = ((WriterOutputStream.Builder)WriterOutputStream.builder().setWriter(writer)).setCharset("UTF-8").get();){
            ReadableByteChannel inputChannel = Channels.newChannel((InputStream)src);
            WritableByteChannel outputChannel = Channels.newChannel((OutputStream)dest);
            CopyCharStream.copyChannels(inputChannel, outputChannel);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copyChannels(ReadableByteChannel src, WritableByteChannel dest) throws UtilsException {
        try {
            ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
            while (src.read(buffer) != -1) {
                buffer.flip();
                dest.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                dest.write(buffer);
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copy(File from, Writer writer) throws UtilsException {
        try (WriterOutputStream dest = ((WriterOutputStream.Builder)WriterOutputStream.builder().setWriter(writer)).setCharset("UTF-8").get();){
            Files.copy(from.toPath(), (OutputStream)dest);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copy(File from, File to) throws UtilsException {
        try {
            Files.copy(from.toPath(), to.toPath(), new CopyOption[0]);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copy(File from, File to, CopyOption ... options) throws UtilsException {
        try {
            Files.copy(from.toPath(), to.toPath(), options);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copy(Reader reader, File to) throws UtilsException {
        try (ReaderInputStream from = ((ReaderInputStream.Builder)((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(reader)).setCharset("UTF-8")).get();){
            Files.copy((InputStream)from, to.toPath(), new CopyOption[0]);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copy(Reader reader, File to, CopyOption ... options) throws UtilsException {
        try (ReaderInputStream from = ((ReaderInputStream.Builder)((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(reader)).setCharset("UTF-8")).get();){
            Files.copy((InputStream)from, to.toPath(), options);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

