/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Date;
import org.openspcoop2.utils.CopyCharStream;
import org.openspcoop2.utils.CopyStreamMethod;
import org.openspcoop2.utils.Utilities;

public class TestCopyCharStream {
    public static void main(String[] args) throws Exception {
        int size = 0x40000000;
        TestCopyCharStream.test(size);
        size = 0x100000;
        TestCopyCharStream.test(size);
        size = 1024;
        TestCopyCharStream.test(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(int size) throws Exception {
        System.out.println("======================");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            char c = 'a';
            sb.append(c);
        }
        CopyStreamMethod[] methods = CopyStreamMethod.values();
        System.out.println("Creato buffer di dimensione: " + Utilities.convertBytesToFormatString(sb.length(), true, " "));
        File fSRC = File.createTempFile("testCopyString", ".bin");
        try {
            FileWriter fos = new FileWriter(fSRC);
            fos.write(sb.toString());
            fos.flush();
            fos.close();
            System.out.println("Creato file di dimensione: " + Utilities.convertBytesToFormatString(fSRC.length(), true, " "));
            for (int i = 0; i < 2; ++i) {
                String tipoTest = "wrap manuale";
                int wrapping = 1;
                if (i == 1) {
                    tipoTest = "wrap da libreria";
                    wrapping = 0;
                }
                System.out.println("\n");
                for (CopyStreamMethod CopyStreamMethod2 : methods) {
                    try (StringReader bin = new StringReader(sb.toString());){
                        TestCopyCharStream.testBuffer("Buffer (" + tipoTest + ")", CopyStreamMethod2, bin, size, wrapping != 0);
                    }
                }
                System.out.println("\n");
                for (CopyStreamMethod CopyStreamMethod2 : methods) {
                    try (FileReader fin = new FileReader(fSRC);){
                        TestCopyCharStream.testBuffer("File (" + tipoTest + ")", CopyStreamMethod2, fin, size, wrapping != 0);
                    }
                }
            }
            TestCopyCharStream.testBuffer("File", fSRC, size);
            System.out.println("\n");
            for (CopyStreamMethod CopyStreamMethod3 : methods) {
                File fout = File.createTempFile("testCopyStringOut", ".bin");
                try (StringReader bin = new StringReader(sb.toString());){
                    TestCopyCharStream.testFile("Buffer", CopyStreamMethod3, bin, fout, size);
                }
                finally {
                    fout.delete();
                }
            }
            File fout = File.createTempFile("testCopyFileOut", ".bin");
            try (CopyStreamMethod[] bin = new StringReader(sb.toString());){
                String path = fout.getAbsolutePath();
                fout.delete();
                TestCopyCharStream.testFile("Buffer", (Reader)bin, new File(path), size);
            }
            finally {
                fout.delete();
            }
            System.out.println("\n");
            for (CopyStreamMethod CopyStreamMethod4 : methods) {
                fout = File.createTempFile("testCopyStringOut", ".bin");
                try (FileReader fin = new FileReader(fSRC);){
                    TestCopyCharStream.testFile("File", CopyStreamMethod4, fin, fout, size);
                }
                finally {
                    fout.delete();
                }
            }
            fout = File.createTempFile("testCopyStringOut", ".bin");
            try {
                String path = fout.getAbsolutePath();
                fout.delete();
                TestCopyCharStream.testFile("File", fSRC, new File(path), size);
            }
            finally {
                fout.delete();
            }
        }
        finally {
            fSRC.delete();
        }
    }

    private static void testBuffer(String src, CopyStreamMethod method, Reader reader, int size, boolean wrapping) throws Exception {
        Date startDate = new Date();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (wrapping) {
            OutputStreamWriter writer = new OutputStreamWriter(bout);
            CopyCharStream.copy(method, reader, writer);
            bout.flush();
            ((Writer)writer).close();
        } else {
            CopyCharStream.copy(method, reader, bout);
        }
        bout.flush();
        bout.close();
        Date endDate = new Date();
        long time = endDate.getTime() - startDate.getTime();
        if (bout.size() != size) {
            throw new Exception("Buffer destinazione con dimensione differente (expected: " + size + ", found: " + bout.size() + ")");
        }
        System.out.println("[" + src + "->Buffer][" + method + "] " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true));
    }

    private static void testBuffer(String src, File is, int size) throws Exception {
        Date startDate = new Date();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(bout);
        CopyCharStream.copy(is, (Writer)writer);
        bout.flush();
        ((Writer)writer).close();
        bout.close();
        Date endDate = new Date();
        long time = endDate.getTime() - startDate.getTime();
        if (bout.size() != size) {
            throw new Exception("Buffer destinazione con dimensione differente (expected: " + size + ", found: " + bout.size() + ")");
        }
        System.out.println("[" + src + "->Buffer][COPY-FILE] " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true));
    }

    private static void testFile(String src, CopyStreamMethod method, Reader reader, File f, int size) throws Exception {
        Date startDate = new Date();
        FileOutputStream fout = new FileOutputStream(f);
        OutputStreamWriter writer = new OutputStreamWriter(fout);
        CopyCharStream.copy(method, reader, writer);
        fout.flush();
        ((Writer)writer).close();
        fout.close();
        Date endDate = new Date();
        long time = endDate.getTime() - startDate.getTime();
        if (f.length() != (long)size) {
            throw new Exception("File destinazione con dimensione differente (expected: " + size + ", found: " + f.length() + ")");
        }
        System.out.println("[" + src + "->File][" + method + "] " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true));
    }

    private static void testFile(String src, Reader reader, File f, int size) throws Exception {
        Date startDate = new Date();
        CopyCharStream.copy(reader, f);
        Date endDate = new Date();
        long time = endDate.getTime() - startDate.getTime();
        if (f.length() != (long)size) {
            throw new Exception("File destinazione con dimensione differente (expected: " + size + ", found: " + f.length() + ")");
        }
        System.out.println("[" + src + "->File][COPY-FILE] " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true));
    }

    private static void testFile(String src, File is, File f, int size) throws Exception {
        Date startDate = new Date();
        CopyCharStream.copy(is, f);
        Date endDate = new Date();
        long time = endDate.getTime() - startDate.getTime();
        if (f.length() != (long)size) {
            throw new Exception("File destinazione con dimensione differente (expected: " + size + ", found: " + f.length() + ")");
        }
        System.out.println("[" + src + "->File][COPY-FILE] " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true));
    }
}

