/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.jcs3.admin.CountingOnlyOutputStream;
import org.apache.commons.jcs3.engine.CacheStatus;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.cache.ICacheImpl;

public abstract class AbstractCacheImpl
implements ICacheImpl {
    protected String cacheName = null;
    protected CacheType cacheType = null;
    private boolean errorOccursCountingBytes_debug = false;
    private boolean errorOccursCountingBytes = false;

    public AbstractCacheImpl() {
    }

    public AbstractCacheImpl(CacheType cacheType, String cacheName) {
        this.cacheType = cacheType;
        this.cacheName = cacheName;
    }

    @Override
    public CacheType getType() {
        return this.cacheType;
    }

    @Override
    public String getName() {
        return this.cacheName;
    }

    @Override
    public boolean isEternal() throws UtilsException {
        return true;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        try {
            bf.append("CACHE SIZE[" + this.getCacheSize() + "] ITEM_COUNT[" + this.getItemCount() + "] ITEM_IDLE_TIME[" + this.getItemIdleTime() + "] ITEM_IDLE_LIFE[" + this.getItemLifeTime() + "] IS_ETERNAL[" + this.isEternal() + "] CACHE_ALGO[" + this.getCacheAlgoritm() + "] STATS{" + this.printStats("") + "}");
            return bf.toString();
        }
        catch (UtilsException e) {
            return "NonDisponibile";
        }
    }

    @Override
    public String printKeys(String separator) throws UtilsException {
        StringBuilder bf = new StringBuilder();
        List<String> keys = this.keys();
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            if (i > 0) {
                bf.append(separator);
            }
            bf.append("Cache[" + i + "]=[" + key + "]");
        }
        return bf.toString();
    }

    @Override
    public String printStats(String separator) throws UtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.printStats(bout, separator);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    protected String _printStats(String separator, boolean thisCache) throws UtilsException {
        try {
            long sizeAttuale = -1L;
            for (int tentativi = 0; tentativi < 10; ++tentativi) {
                sizeAttuale = this.getByteCount();
                if (!this.errorOccursCountingBytes || !thisCache) break;
            }
            StringBuilder bf = new StringBuilder();
            bf.append("Nome:");
            bf.append(this.cacheName);
            bf.append(" ");
            bf.append(separator);
            bf.append("Tipo:");
            bf.append((Object)this.cacheType);
            bf.append(" ");
            bf.append(separator);
            bf.append("Stato:");
            bf.append(CacheStatus.ALIVE);
            bf.append(" ");
            bf.append(separator);
            bf.append("Algoritmo:");
            CacheAlgorithm cacheEnum = this.getCacheAlgoritm();
            if (cacheEnum != null) {
                bf.append(cacheEnum.name());
            } else {
                bf.append("-");
            }
            bf.append(" ");
            bf.append(separator);
            bf.append("Dimensione:");
            bf.append(this.getCacheSize());
            bf.append(" ");
            bf.append(separator);
            bf.append("ElementiInCache:");
            bf.append(this.getItemCount());
            bf.append(" ");
            bf.append(separator);
            bf.append("MemoriaOccupata:");
            bf.append(Utilities.convertBytesToFormatString(sizeAttuale));
            bf.append(" ");
            bf.append(separator);
            bf.append("IdleTime:");
            long idleTime = this.getItemIdleTime();
            if (idleTime > 0L) {
                bf.append(Utilities.convertSystemTimeIntoStringMillisecondi(idleTime * 1000L, false));
            } else if (idleTime == 0L) {
                bf.append("0");
            } else if (idleTime < 0L) {
                bf.append("Infinito");
            }
            bf.append(" ");
            bf.append(separator);
            bf.append("LifeTime:");
            long lifeTime = this.getItemLifeTime();
            if (lifeTime > 0L) {
                bf.append(Utilities.convertSystemTimeIntoStringMillisecondi(lifeTime * 1000L, false));
            } else if (lifeTime == 0L) {
                bf.append("0");
            } else if (lifeTime < 0L) {
                if (this.isEternal()) {
                    bf.append("Infinito");
                } else {
                    bf.append("Infinito (NoEternal?)");
                }
            }
            bf.append(" ");
            bf.append(separator);
            return bf.toString();
        }
        catch (Throwable e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    protected void _printStats(OutputStream out, String separator, boolean thisCache) throws UtilsException {
        try {
            out.write(this._printStats(separator, thisCache).getBytes());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getByteCount() {
        this.errorOccursCountingBytes = false;
        long size = 0L;
        try {
            for (String key : this.keys()) {
                Object element = null;
                try {
                    element = this.get(key);
                }
                catch (Throwable e) {
                    if (this.errorOccursCountingBytes_debug) {
                        System.err.println("[" + this.cacheName + "] Element cache get");
                        e.printStackTrace(System.err);
                    }
                    this.errorOccursCountingBytes = true;
                    continue;
                }
                if (element == null) continue;
                CountingOnlyOutputStream counter = new CountingOnlyOutputStream();
                try (ObjectOutputStream out2 = new ObjectOutputStream((OutputStream)counter);){
                    out2.writeObject(element);
                }
                catch (Throwable e) {
                    if (this.errorOccursCountingBytes_debug) {
                        System.err.println("[" + this.cacheName + "] Element cache writeObject (" + element.getClass().getName() + ")");
                        e.printStackTrace(System.err);
                    }
                    this.errorOccursCountingBytes = true;
                    continue;
                }
                finally {
                    try {
                        counter.close();
                    }
                    catch (IOException out2) {}
                    continue;
                }
                size += (long)(counter.getCount() - 4);
            }
        }
        catch (Exception e) {
            System.err.println("Problem getting byte count (Modified by GovWay).  Likley cause is a non serilizable object." + e.getMessage());
            e.printStackTrace(System.err);
        }
        return size;
    }
}

