/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;

public class AuthorityInformationAccess {
    private static final String CA_ISSUERS = "1.3.6.1.5.5.7.48.2";
    private static final String OCSP = "1.3.6.1.5.5.7.48.1";
    private List<GeneralName> caIssuers = new ArrayList<GeneralName>();
    private List<GeneralName> ocsps = new ArrayList<GeneralName>();

    public List<GeneralName> getObjectCAIssuers() {
        return this.caIssuers;
    }

    public GeneralName getObjectCAIssuer(int index) {
        return this.caIssuers != null && this.caIssuers.size() > index ? this.caIssuers.get(index) : null;
    }

    public List<String> getCAIssuers() {
        ArrayList<String> s = new ArrayList<String>();
        if (this.caIssuers != null && !this.caIssuers.isEmpty()) {
            for (GeneralName o : this.caIssuers) {
                if (o.getName() == null) continue;
                s.add(o.getName().toString());
            }
        }
        return s;
    }

    public String getCAIssuer(int index) {
        if (this.caIssuers != null && this.caIssuers.size() > index) {
            return this.caIssuers.get(index) != null && this.caIssuers.get(index).getName() != null ? this.caIssuers.get(index).getName().toString() : null;
        }
        return null;
    }

    public boolean containsCAIssuer(String name) throws CertificateParsingException {
        return this.containsCAIssuerEngine(null, name);
    }

    public boolean containsCAIssuer(int tagNum, String name) throws CertificateParsingException {
        return this.containsCAIssuerEngine(tagNum, name);
    }

    private boolean containsCAIssuerEngine(Integer tagNum, String name) throws CertificateParsingException {
        if (name == null) {
            throw new CertificateParsingException("Param name undefined");
        }
        if (this.caIssuers != null && !this.caIssuers.isEmpty()) {
            for (GeneralName o : this.caIssuers) {
                if (!this.isEquals(o, tagNum, name)) continue;
                return true;
            }
        }
        return false;
    }

    public List<GeneralName> getObjectOCSPs() {
        return this.ocsps;
    }

    public GeneralName getObjectOCSP(int index) {
        return this.ocsps != null && this.ocsps.size() > index ? this.ocsps.get(index) : null;
    }

    public List<String> getOCSPs() {
        ArrayList<String> s = new ArrayList<String>();
        if (this.ocsps != null && !this.ocsps.isEmpty()) {
            for (GeneralName o : this.ocsps) {
                if (o.getName() == null) continue;
                s.add(o.getName().toString());
            }
        }
        return s;
    }

    public String getOCSP(int index) {
        if (this.ocsps != null && this.ocsps.size() > index) {
            return this.ocsps.get(index) != null && this.ocsps.get(index).getName() != null ? this.ocsps.get(index).getName().toString() : null;
        }
        return null;
    }

    public boolean containsOCSP(String name) throws CertificateParsingException {
        return this.containsOCSPEngine(null, name);
    }

    public boolean containsOCSP(int tagNum, String name) throws CertificateParsingException {
        return this.containsOCSPEngine(tagNum, name);
    }

    private boolean containsOCSPEngine(Integer tagNum, String name) throws CertificateParsingException {
        if (name == null) {
            throw new CertificateParsingException("Param name undefined");
        }
        if (this.ocsps != null && !this.ocsps.isEmpty()) {
            for (GeneralName o : this.ocsps) {
                if (!this.isEquals(o, tagNum, name)) continue;
                return true;
            }
        }
        return false;
    }

    public static AuthorityInformationAccess getAuthorityInformationAccess(byte[] encoded) {
        org.bouncycastle.asn1.x509.AuthorityInformationAccess auth;
        Certificate c = Certificate.getInstance((Object)encoded);
        Extensions exts = c.getTBSCertificate().getExtensions();
        if (exts != null && (auth = org.bouncycastle.asn1.x509.AuthorityInformationAccess.fromExtensions((Extensions)exts)) != null) {
            return AuthorityInformationAccess.readAIA(auth);
        }
        return null;
    }

    private static AuthorityInformationAccess readAIA(org.bouncycastle.asn1.x509.AuthorityInformationAccess auth) {
        AuthorityInformationAccess aia = null;
        if (auth.getAccessDescriptions() != null && auth.getAccessDescriptions().length > 0) {
            aia = new AuthorityInformationAccess();
            for (int i = 0; i < auth.getAccessDescriptions().length; ++i) {
                AccessDescription ad = auth.getAccessDescriptions()[i];
                if (ad.getAccessMethod() == null) continue;
                if (CA_ISSUERS.equals(ad.getAccessMethod().getId())) {
                    aia.caIssuers.add(ad.getAccessLocation());
                    continue;
                }
                if (!OCSP.equals(ad.getAccessMethod().getId())) continue;
                aia.ocsps.add(ad.getAccessLocation());
            }
        }
        return aia;
    }

    private boolean isEquals(GeneralName o, Integer tagNum, String name) {
        if (o.getName() != null && name.equals(o.getName().toString())) {
            if (tagNum == null) {
                return true;
            }
            if (tagNum.intValue() == o.getTagNo()) {
                return true;
            }
        }
        return false;
    }
}

