/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.certificate.CertificateInfo;

public class Certificate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<CertificateInfo> certificateChain = new ArrayList<CertificateInfo>();
    private CertificateInfo certificateInfo = null;

    public Certificate(String name, X509Certificate cParam) {
        this.init(name, cParam, null);
    }

    public Certificate(String name, X509Certificate cParam, List<X509Certificate> chainParam) {
        X509Certificate[] chainParamArray = null;
        if (chainParam != null && !chainParam.isEmpty()) {
            chainParamArray = chainParam.toArray(new X509Certificate[1]);
        }
        this.init(name, cParam, chainParamArray);
    }

    public Certificate(String name, X509Certificate cParam, X509Certificate[] chainParam) {
        this.init(name, cParam, chainParam);
    }

    private void init(String name, X509Certificate cParam, X509Certificate[] chainParam) {
        this.certificateInfo = new CertificateInfo(cParam, name);
        if (chainParam != null && chainParam.length > 0) {
            for (int i = 0; i < chainParam.length; ++i) {
                this.certificateChain.add(new CertificateInfo(chainParam[i], name + "-chain-" + i));
            }
        }
    }

    public List<CertificateInfo> getChain() {
        return this.certificateChain;
    }

    public List<CertificateInfo> getCertificateChain() {
        return this.certificateChain;
    }

    public void setCertificateChain(List<CertificateInfo> certificateChain) {
        this.certificateChain = certificateChain;
    }

    public CertificateInfo getCertificate() {
        return this.certificateInfo;
    }

    public void setCertificate(CertificateInfo certificate) {
        this.certificateInfo = certificate;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append(this.certificateInfo.toString());
        if (this.certificateChain != null) {
            bf.append("\n\n certificate chains:\n");
            for (CertificateInfo certificateChainInfo : this.certificateChain) {
                bf.append("\n");
                bf.append(certificateChainInfo.toString());
            }
        }
        return bf.toString();
    }
}

