/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateException;

public class CertificateFactory {
    private static boolean useBouncyCastleProvider = false;
    private static Provider provider = null;
    private static String certPathDefaultType = null;

    private CertificateFactory() {
    }

    public static boolean isUseBouncyCastleProvider() {
        return useBouncyCastleProvider;
    }

    public static void setUseBouncyCastleProvider(boolean useBouncyCastleProvider) {
        CertificateFactory.useBouncyCastleProvider = useBouncyCastleProvider;
    }

    private static synchronized Provider getProviderEngine() {
        if (provider == null) {
            provider = Security.getProvider("BC");
        }
        return provider;
    }

    private static Provider getProvider() {
        Provider p = null;
        if (!useBouncyCastleProvider) {
            return p;
        }
        if (provider == null) {
            return CertificateFactory.getProviderEngine();
        }
        return provider;
    }

    public static java.security.cert.CertificateFactory getCertificateFactory() throws CertificateException {
        java.security.cert.CertificateFactory certificateFactory = null;
        certificateFactory = useBouncyCastleProvider ? java.security.cert.CertificateFactory.getInstance("X.509", CertificateFactory.getProvider()) : java.security.cert.CertificateFactory.getInstance("X.509");
        return certificateFactory;
    }

    private static synchronized String getCertPathDefaultTypeEngine() {
        if (certPathDefaultType == null) {
            certPathDefaultType = CertPathValidator.getDefaultType();
        }
        return certPathDefaultType;
    }

    private static String getCertPathDefaultType() {
        if (certPathDefaultType == null) {
            return CertificateFactory.getCertPathDefaultTypeEngine();
        }
        return certPathDefaultType;
    }

    public static CertPathValidator getCertPathValidator() throws NoSuchAlgorithmException {
        CertPathValidator certPathValidator = null;
        certPathValidator = useBouncyCastleProvider ? CertPathValidator.getInstance(CertificateFactory.getCertPathDefaultType(), CertificateFactory.getProvider()) : CertPathValidator.getInstance(CertificateFactory.getCertPathDefaultType());
        return certPathValidator;
    }
}

