/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.ldap.LdapName;
import org.apache.xml.security.utils.RFC2253Parser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateDecodeConfig;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.resources.Charset;
import org.slf4j.Logger;
import org.springframework.web.util.UriUtils;

public class CertificateUtils {
    private static final boolean TRIM_VALUE_BEFORE_SAVE_DB = true;

    private CertificateUtils() {
    }

    public static void printCertificate(StringBuilder bf, List<X509Certificate> certs) {
        CertificateUtils.printCertificate(bf, certs, false);
    }

    public static void printCertificate(StringBuilder bf, List<X509Certificate> certs, boolean addPrefix) {
        if (!certs.isEmpty()) {
            X509Certificate[] certsArray = certs.toArray(new X509Certificate[1]);
            CertificateUtils.printCertificate(bf, certsArray, addPrefix);
        } else {
            bf.append("X509Certificates: 0\n");
        }
    }

    public static void printCertificate(StringBuilder bf, X509Certificate[] certs) {
        CertificateUtils.printCertificate(bf, certs, false);
    }

    public static void printCertificate(StringBuilder bf, X509Certificate[] certs, boolean addPrefix) {
        bf.append("X509Certificates: " + certs.length + "\n");
        for (int i = 0; i < certs.length; ++i) {
            X509Certificate cert = certs[i];
            CertificateUtils.printCertificate(bf, cert, "" + i, addPrefix);
        }
    }

    public static void printCertificate(StringBuilder bf, X509Certificate cert, String name) {
        CertificateUtils.printCertificate(bf, cert, name, false);
    }

    public static void printCertificate(StringBuilder bf, X509Certificate cert, String name, boolean addPrefix) {
        Object prefix = "";
        if (addPrefix) {
            prefix = "Cert[" + name + "].";
        }
        bf.append("#### X509Certificate[" + name + "]\n");
        bf.append("\t" + (String)prefix + "toString()=" + cert.toString() + "\n");
        bf.append("\t" + (String)prefix + "getType()=" + cert.getType() + "\n");
        bf.append("\t" + (String)prefix + "getVersion()=" + cert.getVersion() + "\n");
        if (cert.getIssuerDN() != null) {
            bf.append("\t" + (String)prefix + "cert.getIssuerDN().toString()=" + cert.getIssuerDN().toString() + "\n");
            bf.append("\t" + (String)prefix + "cert.getIssuerDN().getName()=" + cert.getIssuerDN().getName() + "\n");
        } else {
            bf.append("\t" + (String)prefix + "cert.getIssuerDN() is null\n");
        }
        if (cert.getIssuerX500Principal() != null) {
            bf.append("\t" + (String)prefix + "getIssuerX500Principal().toString()=" + cert.getIssuerX500Principal().toString() + "\n");
            bf.append("\t" + (String)prefix + "getIssuerX500Principal().getName()=" + cert.getIssuerX500Principal().getName() + "\n");
            bf.append("\t" + (String)prefix + "getIssuerX500Principal().getName(X500Principal.CANONICAL)=" + cert.getIssuerX500Principal().getName("CANONICAL") + "\n");
            bf.append("\t" + (String)prefix + "getIssuerX500Principal().getName(X500Principal.RFC1779)=" + cert.getIssuerX500Principal().getName("RFC1779") + "\n");
            bf.append("\t" + (String)prefix + "getIssuerX500Principal().getName(X500Principal.RFC2253)=" + cert.getIssuerX500Principal().getName("RFC2253") + "\n");
        } else {
            bf.append("\t" + (String)prefix + "cert.getIssuerX500Principal() is null\n");
        }
        if (cert.getSubjectDN() != null) {
            bf.append("\t" + (String)prefix + "getSubjectDN().toString()=" + cert.getSubjectDN().toString() + "\n");
            bf.append("\t" + (String)prefix + "getSubjectDN().getName()=" + cert.getSubjectDN().getName() + "\n");
        } else {
            bf.append("\t" + (String)prefix + "cert.getSubjectDN() is null\n");
        }
        bf.append("\t" + (String)prefix + "getSerialNumber()=" + cert.getSerialNumber() + "\n");
        bf.append("\t" + (String)prefix + "getNotAfter()=" + cert.getNotAfter() + "\n");
        bf.append("\t" + (String)prefix + "getNotBefore()=" + cert.getNotBefore() + "\n");
        if (cert.getSubjectX500Principal() != null) {
            bf.append("\t" + (String)prefix + "getSubjectX500Principal().toString()=" + cert.getSubjectX500Principal().toString() + "\n");
            bf.append("\t" + (String)prefix + "getSubjectX500Principal().getName()=" + cert.getSubjectX500Principal().getName() + "\n");
            bf.append("\t" + (String)prefix + "getSubjectX500Principal().getName(X500Principal.CANONICAL)=" + cert.getSubjectX500Principal().getName("CANONICAL") + "\n");
            bf.append("\t" + (String)prefix + "getSubjectX500Principal().getName(X500Principal.RFC1779)=" + cert.getSubjectX500Principal().getName("RFC1779") + "\n");
            bf.append("\t" + (String)prefix + "getSubjectX500Principal().getName(X500Principal.RFC2253)=" + cert.getSubjectX500Principal().getName("RFC2253") + "\n");
        } else {
            bf.append("\t" + (String)prefix + "cert.getSubjectX500Principal() is null\n");
        }
    }

    private static void debug(Logger log, String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    private static String getAnalisiTypePrefixString(String principal, PrincipalType type) {
        return "(" + principal + ") Analisi " + type + " ";
    }

    public static boolean sslVerify(String principalPresenteNellaConfigurazione, String principalArrivatoConnessioneSSL, PrincipalType type, Logger log) throws UtilsException {
        Map<String, List<String>> hashPrincipalPresenteNellaConfigurazione;
        Map<String, List<String>> hashPrincipalArrivatoConnessioneSSL;
        if (log != null) {
            CertificateUtils.debug(log, "SSL VERIFY CONF[" + principalPresenteNellaConfigurazione + "] SSL[" + principalArrivatoConnessioneSSL + "]");
        }
        if (!CertificateUtils.sslVerifyCheckSize(principalPresenteNellaConfigurazione, principalArrivatoConnessioneSSL, type, hashPrincipalArrivatoConnessioneSSL = CertificateUtils.getPrincipalIntoMap(principalArrivatoConnessioneSSL, type), hashPrincipalPresenteNellaConfigurazione = CertificateUtils.getPrincipalIntoMap(principalPresenteNellaConfigurazione, type), log)) {
            return false;
        }
        for (Map.Entry<String, List<String>> entry : hashPrincipalArrivatoConnessioneSSL.entrySet()) {
            String key = entry.getKey();
            if (!hashPrincipalPresenteNellaConfigurazione.containsKey(key)) {
                if (log != null) {
                    ArrayList<String> lKeys = new ArrayList<String>();
                    lKeys.addAll(hashPrincipalPresenteNellaConfigurazione.keySet());
                    CertificateUtils.debug(log, "sslVerify key[" + key + "] non trovata in " + type + " Configurazione[" + principalPresenteNellaConfigurazione + "], key riscontrate: " + lKeys);
                }
                return false;
            }
            List<String> connessioneSSLValueList = hashPrincipalArrivatoConnessioneSSL.get(key);
            List<String> configurazioneInternaValueList = hashPrincipalPresenteNellaConfigurazione.get(key);
            if (connessioneSSLValueList.size() != configurazioneInternaValueList.size()) {
                if (log != null) {
                    CertificateUtils.debug(log, "sslVerify " + type + " key[" + key + "] trovata in Configurazione[" + principalPresenteNellaConfigurazione + "](" + configurazioneInternaValueList.size() + ") SSL[" + principalArrivatoConnessioneSSL + "](" + connessioneSSLValueList.size() + "): lunghezza differente");
                }
                return false;
            }
            Collections.sort(connessioneSSLValueList);
            Collections.sort(configurazioneInternaValueList);
            if (CertificateUtils.sslVerifyCheckValues(key, type, connessioneSSLValueList, configurazioneInternaValueList, log)) continue;
            return false;
        }
        return true;
    }

    private static boolean sslVerifyCheckSize(String principalPresenteNellaConfigurazione, String principalArrivatoConnessioneSSL, PrincipalType type, Map<String, List<String>> hashPrincipalArrivatoConnessioneSSL, Map<String, List<String>> hashPrincipalPresenteNellaConfigurazione, Logger log) {
        if (hashPrincipalArrivatoConnessioneSSL.size() != hashPrincipalPresenteNellaConfigurazione.size()) {
            if (log != null) {
                CertificateUtils.debug(log, "sslVerify " + type + " Configurazione[" + principalPresenteNellaConfigurazione + "](" + hashPrincipalPresenteNellaConfigurazione.size() + ") SSL[" + principalArrivatoConnessioneSSL + "](" + hashPrincipalArrivatoConnessioneSSL.size() + "): lunghezza differente");
            }
            return false;
        }
        return true;
    }

    private static boolean sslVerifyCheckValues(String key, PrincipalType type, List<String> connessioneSSLValueList, List<String> configurazioneInternaValueList, Logger log) {
        for (int i = 0; i < connessioneSSLValueList.size(); ++i) {
            String connessioneSSLValue = connessioneSSLValueList.get(i);
            String configurazioneInternaValue = configurazioneInternaValueList.get(i);
            while (connessioneSSLValue.contains("\\/")) {
                connessioneSSLValue = connessioneSSLValue.replace("\\/", "/");
            }
            while (connessioneSSLValue.contains("\\,")) {
                connessioneSSLValue = connessioneSSLValue.replace("\\,", ",");
            }
            while (configurazioneInternaValue.contains("\\/")) {
                configurazioneInternaValue = configurazioneInternaValue.replace("\\/", "/");
            }
            while (configurazioneInternaValue.contains("\\,")) {
                configurazioneInternaValue = configurazioneInternaValue.replace("\\,", ",");
            }
            if (connessioneSSLValue.equals(configurazioneInternaValue)) continue;
            if (log != null) {
                CertificateUtils.debug(log, "sslVerify key[" + key + "] " + type + " Configurazione[" + configurazioneInternaValue + "] SSL[" + connessioneSSLValue + "] not match");
            }
            return false;
        }
        return true;
    }

    public static String formatPrincipal(String principal, PrincipalType type) throws UtilsException {
        Map<String, List<String>> hashPrincipal = CertificateUtils.getPrincipalIntoMap(principal, type);
        StringBuilder bf = new StringBuilder();
        bf.append("/");
        for (Map.Entry<String, List<String>> entry : hashPrincipal.entrySet()) {
            String key = entry.getKey();
            List<String> listValues = hashPrincipal.get(key);
            for (String value : listValues) {
                bf.append(CertificateUtils.formatKeyPrincipal(key));
                bf.append("=");
                bf.append(CertificateUtils.formatValuePrincipal(value));
                bf.append("/");
            }
        }
        return bf.toString();
    }

    public static Map<String, String> formatPrincipalToMap(String principal, PrincipalType type) throws UtilsException {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Map<String, List<String>> hashPrincipal = CertificateUtils.getPrincipalIntoMap(principal, type);
        for (Map.Entry<String, List<String>> entry : hashPrincipal.entrySet()) {
            String key = entry.getKey();
            List<String> listValues = hashPrincipal.get(key);
            for (String value : listValues) {
                String keyFormat = CertificateUtils.formatKeyPrincipal(key);
                String valueFormat = CertificateUtils.formatValuePrincipal(value);
                returnMap.put(keyFormat, valueFormat);
            }
        }
        return returnMap;
    }

    public static void validaPrincipal(String principalParam, PrincipalType type) throws UtilsException {
        String principal = principalParam;
        UtilsException normalizedException = null;
        try {
            String tmp;
            principal = tmp = CertificateUtils.normalizePrincipal(principalParam);
        }
        catch (UtilsException e) {
            normalizedException = e;
        }
        boolean commaFound = CertificateUtils.contains(principal, ",");
        boolean slashFound = CertificateUtils.contains(principal, "/");
        if (commaFound && slashFound) {
            throw new UtilsException("(" + principal + ") Non possono coesistere i separatore \",\" e \"/\", solo uno dei due tipi deve essere utilizzato come delimitatore (usare eventualmente come carattere di escape '\\')");
        }
        if (!(commaFound || slashFound || principal.contains("="))) {
            throw new UtilsException("(" + principal + ") " + type + " non valido, nemmeno una coppia nome=valore trovata");
        }
        String[] valoriPrincipal = CertificateUtils.getValoriPrincipal(principal, type);
        CertificateUtils.validaPrincipal(valoriPrincipal, principal, type);
        if (normalizedException != null) {
            throw normalizedException;
        }
    }

    private static void validaPrincipal(String[] valoriPrincipal, String principal, PrincipalType type) throws UtilsException {
        boolean campoObbligatorioCN = false;
        boolean campoObbligatorioOU = false;
        boolean campoObbligatorioO = false;
        boolean campoObbligatorioL = false;
        boolean campoObbligatorioST = false;
        boolean campoObbligatorioC = false;
        boolean campoObbligatorioE = false;
        for (int i = 0; i < valoriPrincipal.length; ++i) {
            String[] keyValue = CertificateUtils.getKeyValuePairEngine(valoriPrincipal[i], principal, type);
            if (keyValue[0].trim().contains(" ")) {
                throw new UtilsException(CertificateUtils.getAnalisiTypePrefixString(principal, type) + "fallita: il campo [" + valoriPrincipal[i] + "] contiene spazi nella chiave identificativa [" + keyValue[0].trim() + "]");
            }
            if (CertificateUtils.formatKeyPrincipal(keyValue[0]).equalsIgnoreCase("CN")) {
                campoObbligatorioCN = true;
                continue;
            }
            if (CertificateUtils.formatKeyPrincipal(keyValue[0]).equalsIgnoreCase("OU")) {
                campoObbligatorioOU = true;
                continue;
            }
            if (CertificateUtils.formatKeyPrincipal(keyValue[0]).equalsIgnoreCase("O")) {
                campoObbligatorioO = true;
                continue;
            }
            if (CertificateUtils.formatKeyPrincipal(keyValue[0]).equalsIgnoreCase("L")) {
                campoObbligatorioL = true;
                continue;
            }
            if (CertificateUtils.formatKeyPrincipal(keyValue[0]).equalsIgnoreCase("ST")) {
                campoObbligatorioST = true;
                continue;
            }
            if (CertificateUtils.formatKeyPrincipal(keyValue[0]).equalsIgnoreCase("C")) {
                campoObbligatorioC = true;
                continue;
            }
            if (!CertificateUtils.formatKeyPrincipal(keyValue[0]).equalsIgnoreCase("E")) continue;
            campoObbligatorioE = true;
        }
        if (!(campoObbligatorioCN || campoObbligatorioOU || campoObbligatorioO || campoObbligatorioL || campoObbligatorioST || campoObbligatorioC || campoObbligatorioE)) {
            throw new UtilsException("(" + principal + ") Almeno un attributo di certificato tra 'CN', 'OU', 'O', 'L', 'ST', 'C' e 'E' deve essere valorizzato.");
        }
    }

    public static String normalizePrincipal(String principalParam) throws UtilsException {
        try {
            return RFC2253Parser.normalize((String)principalParam);
        }
        catch (Exception e) {
            throw new UtilsException("(" + principalParam + ") Normalizzazione RFC2253 non riuscita: " + e.getMessage(), e);
        }
    }

    public static String[] getValoriPrincipal(String principalParam, PrincipalType type) throws UtilsException {
        try {
            String principal = CertificateUtils.normalizePrincipal(principalParam);
            return CertificateUtils.getValoriPrincipalEngine(principal, type);
        }
        catch (Exception e) {
            try {
                LdapName prova = new LdapName(principalParam);
                Enumeration<String> ens = prova.getAll();
                ArrayList<String> values = new ArrayList<String>();
                while (ens.hasMoreElements()) {
                    String name = ens.nextElement();
                    values.add(name);
                }
                if (!values.isEmpty()) {
                    return values.toArray(new String[1]);
                }
                throw new UtilsException("Coppie nome/valore non trovate");
            }
            catch (Exception e2Level) {
                throw new UtilsException("(" + principalParam + ") javax.naming.ldap.LdapName reader failed: " + e2Level.getMessage() + ". \nFirst method error: " + e.getMessage(), e);
            }
        }
    }

    private static String[] getValoriPrincipalEngine(String principal, PrincipalType type) throws UtilsException {
        String[] valori;
        boolean commaFound = CertificateUtils.contains(principal, ",");
        boolean slashFound = CertificateUtils.contains(principal, "/");
        if (commaFound) {
            if (principal.startsWith(",")) {
                principal = principal.substring(1);
            }
            if (principal.endsWith(",")) {
                principal = principal.substring(0, principal.length() - 1);
            }
            valori = Utilities.split(principal, ',');
        } else {
            valori = CertificateUtils.getValoriPrincipalEngine(principal, type, slashFound);
        }
        if (valori == null || valori.length < 1) {
            throw new UtilsException(CertificateUtils.getAnalisiTypePrefixString(principal, type) + "interno alla configurazione di OpenSPCoop non riuscita: null??");
        }
        for (int i = 0; i < valori.length; ++i) {
            CertificateUtils.getKeyValuePairEngine(valori[i], principal, type);
        }
        return valori;
    }

    private static String[] getValoriPrincipalEngine(String principal, PrincipalType type, boolean slashFound) throws UtilsException {
        String[] valori = null;
        if (!slashFound) {
            int indexOf = principal.indexOf("=");
            if (indexOf <= 0) {
                throw new UtilsException("(" + principal + ") Separatore validi per il " + type + " interno alla configurazione di OpenSPCoop non trovati:  \",\" o \"/\" e carattere \"=\" non presente");
            }
            if (principal.indexOf("=", indexOf + 1) >= 0) {
                throw new UtilsException("(" + principal + ") Separatore validi per il " + type + " interno alla configurazione di OpenSPCoop non trovati:  \",\" o \"/\"");
            }
            valori = new String[]{principal};
        } else {
            valori = CertificateUtils.getValoriSlashPrincipalEngine(principal);
        }
        return valori;
    }

    private static String[] getValoriSlashPrincipalEngine(String principal) throws UtilsException {
        if (principal.startsWith("/")) {
            principal = principal.substring(1);
        }
        if (principal.endsWith("/")) {
            principal = principal.substring(0, principal.length() - 1);
        }
        String[] tmpValori = Utilities.split(principal, '/');
        ArrayList<String> normalize = new ArrayList<String>();
        StringBuilder bf = new StringBuilder();
        for (String tmp : tmpValori) {
            if (tmp.contains("=")) {
                if (bf.length() > 0) {
                    normalize.add(bf.toString());
                    bf.delete(0, bf.length());
                }
                bf.append(tmp);
                continue;
            }
            bf.append("/").append(tmp);
        }
        if (bf.length() > 0) {
            normalize.add(bf.toString());
            bf.delete(0, bf.length());
        }
        return normalize.toArray(new String[1]);
    }

    public static Map<String, List<String>> getPrincipalIntoMap(String principal, PrincipalType type) throws UtilsException {
        HashMap<String, List<String>> hashPrincipal = new HashMap<String, List<String>>();
        String[] valoriPrincipal = CertificateUtils.getValoriPrincipal(principal, type);
        for (int i = 0; i < valoriPrincipal.length; ++i) {
            if (!valoriPrincipal[i].contains("=")) {
                String fallita = "fallita: [" + valoriPrincipal[i] + "] ";
                throw new UtilsException(CertificateUtils.getAnalisiTypePrefixString(principal, type) + fallita + "non separata dal carattere \"=\"");
            }
            String[] keyValue = CertificateUtils.getKeyValuePairEngine(valoriPrincipal[i], principal, type);
            String formatKey = CertificateUtils.formatKeyPrincipal(keyValue[0]);
            String formatValue = CertificateUtils.formatValuePrincipal(keyValue[1]);
            List<String> listValue = null;
            if (hashPrincipal.containsKey(formatKey)) {
                listValue = (List)hashPrincipal.get(formatKey);
            } else {
                listValue = new ArrayList();
                hashPrincipal.put(formatKey, listValue);
            }
            listValue.add(formatValue);
        }
        return hashPrincipal;
    }

    public static String formatKeyPrincipal(String keyPrincipal) {
        return keyPrincipal.trim().toLowerCase();
    }

    public static String formatValuePrincipal(String valuePrincipal) {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < valuePrincipal.length(); ++i) {
            if (valuePrincipal.charAt(i) == '/') {
                if (i == 0) {
                    bf.append('\\');
                } else if (valuePrincipal.charAt(i - 1) != '\\') {
                    bf.append('\\');
                }
            }
            bf.append(valuePrincipal.charAt(i));
        }
        String value = bf.toString();
        value = value.trim();
        return value;
    }

    private static String[] getKeyValuePairEngine(String keyValue, String principal, PrincipalType type) throws UtilsException {
        if (!keyValue.contains("=")) {
            throw new UtilsException(CertificateUtils.getAnalisiTypePrefixString(principal, type) + "fallita: [" + keyValue + "] non separata dal carattere \"=\". Verificare che non esistano coppie che possiedono valori che contengono il carattere separatore (usare eventualmente come carattere di escape '\\')");
        }
        String[] keyValueReturn = keyValue.split("=");
        if (keyValueReturn.length < 2) {
            if (keyValueReturn.length == 1) {
                String key = keyValueReturn[0];
                keyValueReturn = new String[]{key, ""};
            } else {
                throw new UtilsException(CertificateUtils.getAnalisiTypePrefixString(principal, type) + "fallita: [" + keyValue + "] non contiene un valore? Verificare che non esistano coppie che possiedono valori che contengono il carattere separatore (usare eventualmente come carattere di escape '\\')");
            }
        }
        keyValueReturn[0] = keyValueReturn[0].trim();
        if (keyValueReturn.length == 2) {
            return keyValueReturn;
        }
        String[] keyValueReturnNormalized = new String[]{keyValueReturn[0], CertificateUtils.extractValueFromKeyPairEngine(keyValue)};
        return keyValueReturnNormalized;
    }

    private static String extractValueFromKeyPairEngine(String keyValue) throws UtilsException {
        int indexOf = keyValue.indexOf("=");
        if (indexOf <= 0) {
            throw new UtilsException("Carattere '=' non presente in [" + keyValue + "]");
        }
        return keyValue.substring(indexOf + 1);
    }

    private static boolean contains(String value, String separator) {
        int indexOf = value.indexOf(separator);
        boolean found = false;
        if (indexOf == 0) {
            found = true;
        } else {
            boolean itera = true;
            while (indexOf > 0 && itera) {
                char precedente = value.charAt(indexOf - 1);
                if (precedente == '\\') {
                    if (indexOf + 1 > value.length()) {
                        itera = false;
                        continue;
                    }
                    indexOf = value.indexOf(separator, indexOf + 1);
                    continue;
                }
                found = true;
                itera = false;
            }
        }
        return found;
    }

    public static Certificate readCertificate(CertificateDecodeConfig config, String certificateParam) throws UtilsException {
        return CertificateUtils.readCertificateEngine(config, certificateParam, Charset.UTF_8.getValue());
    }

    public static Certificate readCertificate(CertificateDecodeConfig config, String certificateParam, String charset) throws UtilsException {
        return CertificateUtils.readCertificateEngine(config, certificateParam, charset);
    }

    private static Certificate readCertificateEngine(CertificateDecodeConfig config, String certificateParam, String charset) throws UtilsException {
        if (config.isUrlDecodeOrBase64Decode() || config.isUrlDecodeOrBase64DecodeOrHexDecode()) {
            Exception tUrlDecode = null;
            try {
                config.setUrlDecode(true);
                config.setBase64Decode(false);
                config.setHexDecode(false);
                return CertificateUtils.readCertificateEngineByConfig(config, certificateParam, charset);
            }
            catch (Exception t) {
                tUrlDecode = t;
                Exception tBase64Decode = null;
                try {
                    config.setUrlDecode(false);
                    config.setBase64Decode(true);
                    config.setHexDecode(false);
                    return CertificateUtils.readCertificateEngineByConfig(config, certificateParam, charset);
                }
                catch (Exception t2) {
                    tBase64Decode = t2;
                    Exception tHexDecode = null;
                    if (config.isUrlDecodeOrBase64DecodeOrHexDecode()) {
                        try {
                            config.setUrlDecode(false);
                            config.setBase64Decode(false);
                            config.setHexDecode(true);
                            return CertificateUtils.readCertificateEngineByConfig(config, certificateParam, charset);
                        }
                        catch (Exception t3) {
                            tHexDecode = t3;
                        }
                    }
                    UtilsMultiException uMulti = config.isUrlDecodeOrBase64DecodeOrHexDecode() ? new UtilsMultiException("Decodifica non riuscita", tUrlDecode, tBase64Decode, tHexDecode) : new UtilsMultiException("Decodifica non riuscita", tUrlDecode, tBase64Decode);
                    throw new UtilsException(uMulti.getMessage(), uMulti);
                }
            }
        }
        return CertificateUtils.readCertificateEngineByConfig(config, certificateParam, charset);
    }

    private static Certificate readCertificateEngineByConfig(CertificateDecodeConfig config, String certificateParam, String charset) throws UtilsException {
        if (certificateParam == null || "".equals(certificateParam)) {
            throw new UtilsException("Certificate non fornito");
        }
        try {
            String certificate = certificateParam;
            if (config.isUrlDecode()) {
                certificate = UriUtils.decode((String)certificate, (String)charset);
            }
            boolean forceEnrichPEMBeginEnd = false;
            if (config.isReplace()) {
                StringBuilder sbNewCertificate = new StringBuilder();
                forceEnrichPEMBeginEnd = CertificateUtils.replaceCharacters(config, certificate, sbNewCertificate);
                certificate = sbNewCertificate.toString();
            }
            if (config.isEnrichPEMBeginEnd() || forceEnrichPEMBeginEnd) {
                certificate = CertificateUtils.addPEMDeclaration(certificate, forceEnrichPEMBeginEnd);
            }
            byte[] certBytes = null;
            certBytes = config.isBase64Decode() ? Base64Utilities.decode(certificate) : (config.isHexDecode() ? HexBinaryUtilities.decode(certificate) : certificate.getBytes(charset));
            return ArchiveLoader.load(certBytes);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private static boolean replaceCharacters(CertificateDecodeConfig config, String certificate, StringBuilder sbNewCertificate) {
        boolean forceEnrichPEMBeginEnd = false;
        if (certificate.startsWith("-----BEGIN CERTIFICATE-----") && certificate.length() > "-----BEGIN CERTIFICATE-----".length()) {
            certificate = certificate.substring("-----BEGIN CERTIFICATE-----".length());
            forceEnrichPEMBeginEnd = true;
        }
        if (certificate.endsWith("-----END CERTIFICATE-----") && certificate.length() > "-----END CERTIFICATE-----".length()) {
            certificate = certificate.substring(0, certificate.length() - "-----END CERTIFICATE-----".length());
        }
        for (int index = 0; certificate.contains(config.getReplaceSource()) && index < 10000; ++index) {
            certificate = certificate.replace(config.getReplaceSource(), config.getReplaceDest());
        }
        sbNewCertificate.append(certificate);
        return forceEnrichPEMBeginEnd;
    }

    private static String addPEMDeclaration(String certificate, boolean forceEnrichPEMBeginEnd) {
        if (!((String)certificate).startsWith("-----BEGIN CERTIFICATE-----")) {
            certificate = "-----BEGIN CERTIFICATE-----" + (forceEnrichPEMBeginEnd ? "" : "\n") + (String)certificate;
        }
        if (!((String)certificate).endsWith("-----END CERTIFICATE-----")) {
            certificate = (String)certificate + (forceEnrichPEMBeginEnd ? "" : "\n") + "-----END CERTIFICATE-----";
        }
        return certificate;
    }

    public static String toPEM(X509Certificate cert) throws UtilsException {
        try {
            StringWriter sw = new StringWriter();
            try (JcaPEMWriter pw = new JcaPEMWriter((Writer)sw);){
                pw.writeObject((Object)cert);
            }
            sw.flush();
            sw.close();
            return sw.toString();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String toPEM(PrivateKey privateKey) throws UtilsException {
        try {
            StringWriter sw = new StringWriter();
            try (JcaPEMWriter pw = new JcaPEMWriter((Writer)sw);){
                pw.writeObject((Object)privateKey);
            }
            sw.flush();
            sw.close();
            return sw.toString();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

