/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.JWK;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.certificate.KeyUtils;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class JWKPrivateKeyConverter {
    public static void main(String[] args) throws UtilsException {
        if (args == null || args.length < 3) {
            throw new UtilsException("ERROR: argomenti non forniti (USAGE: JWKPrivateKeyConverter pathPublicKey pathPrivateKey[:::password] pathJWK [kid] [jwkset(true/false)] [pretty(true/false)])");
        }
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            String pathPublicKey = args[0];
            byte[] publicKey = FileSystemUtilities.readBytesFromFile(pathPublicKey);
            String pathPrivateKey = args[1];
            String passwordPrivateKey = null;
            if (pathPrivateKey.contains(":::")) {
                String[] tmp = pathPrivateKey.split(":::");
                if (tmp.length != 2) {
                    throw new UtilsException("Path private key with wrong format");
                }
                pathPrivateKey = tmp[0];
                passwordPrivateKey = tmp[1];
            }
            byte[] privateKey = FileSystemUtilities.readBytesFromFile(pathPrivateKey);
            KeyUtils keyUtils = new KeyUtils("RSA");
            PublicKey pKey = keyUtils.getPublicKey(publicKey);
            PrivateKey privKey = null;
            privKey = passwordPrivateKey != null ? keyUtils.getPrivateKey(privateKey, passwordPrivateKey) : keyUtils.getPrivateKey(privateKey);
            String pathJWK = args[2];
            String kid = null;
            if (args.length > 3) {
                kid = args[3];
            }
            if (kid == null || StringUtils.isEmpty((String)kid)) {
                kid = UUID.randomUUID().toString();
            }
            if ("#none#".equals(kid)) {
                kid = null;
            }
            boolean jwks = true;
            if (args.length > 4) {
                String tmp = args[4];
                jwks = "true".equals(tmp);
            }
            boolean pretty = false;
            if (args.length > 5) {
                String tmp = args[5];
                pretty = "true".equals(tmp);
            }
            String json = JWKPrivateKeyConverter.convert(pKey, privKey, kid, jwks, pretty);
            FileSystemUtilities.writeFile(pathJWK, json.getBytes());
        }
        catch (Exception t) {
            throw new UtilsException(t.getMessage(), t);
        }
    }

    public static String convert(PublicKey pKey, PrivateKey privKey, String kid, boolean jwks, boolean pretty) throws UtilsException {
        JWK jwk = new JWK(pKey, privKey, kid);
        Object json = null;
        if (jwks) {
            JWKSet jwkSet = new JWKSet();
            jwkSet.addJwk(jwk);
            json = pretty ? jwk.getJsonPretty() : jwk.getJson();
            json = "{\"keys\":[" + (String)json + "]}";
        } else {
            json = pretty ? jwk.getJsonPretty() : jwk.getJson();
        }
        return json;
    }
}

