/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkReaderWriter;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.JWK;
import org.openspcoop2.utils.json.JSONUtils;

public class JWKSet {
    private JwkReaderWriter engineCxf = new JwkReaderWriter();
    private String jwkSetJson;
    private String jwkSetJsonPretty;
    private JsonWebKeys jwkSetCxf;
    private com.nimbusds.jose.jwk.JWKSet jwkSetNimbusds;
    private JsonNode jwkSetNode;
    private List<JWK> jwkSetList = new ArrayList<JWK>();

    public JWKSet(String json) {
        this.jwkSetJson = json;
    }

    public JWKSet(JsonWebKeys jwk) {
        this.jwkSetCxf = jwk;
    }

    public JWKSet(com.nimbusds.jose.jwk.JWKSet jwk) {
        this.jwkSetNimbusds = jwk;
    }

    public JWKSet(List<JWK> list) {
        this.jwkSetList = list;
    }

    public JWKSet() {
    }

    public void addJwk(JWK jwk) {
        this.jwkSetList.add(jwk);
        this.jwkSetJson = null;
        this.jwkSetJsonPretty = null;
        this.jwkSetCxf = null;
        this.jwkSetNimbusds = null;
        this.jwkSetNode = null;
    }

    private synchronized void initJwks() throws UtilsException {
        if (this.jwkSetList == null || this.jwkSetList.isEmpty()) {
            if (this.getJsonWebKeys() == null && this.getJWKSet() == null) {
                throw new UtilsException("JWK Set not defined");
            }
            if (this.jwkSetCxf != null) {
                this.initJwksFromSetCxf();
            } else {
                this.initJwksFromSetNimbusds();
            }
        }
    }

    private synchronized void initJwksFromSetCxf() throws UtilsException {
        try {
            for (JsonWebKey jsonWebKey : this.jwkSetCxf.getKeys()) {
                this.jwkSetList.add(new JWK(jsonWebKey));
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private synchronized void initJwksFromSetNimbusds() throws UtilsException {
        try {
            for (com.nimbusds.jose.jwk.JWK jwk : this.jwkSetNimbusds.getKeys()) {
                this.jwkSetList.add(new JWK(jwk));
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public List<JWK> getJwks() throws UtilsException {
        if (this.jwkSetList == null || this.jwkSetList.isEmpty()) {
            this.initJwks();
        }
        return this.jwkSetList;
    }

    private synchronized void initCxf() throws UtilsException {
        block6: {
            if (this.jwkSetCxf == null) {
                if (this.jwkSetJson == null) {
                    throw new UtilsException("Json not defined");
                }
                try {
                    this.jwkSetCxf = this.engineCxf.jsonToJwkSet(this.jwkSetJson);
                }
                catch (Exception e) {
                    if (e.getMessage() == null || !e.getMessage().contains("String index out of range")) break block6;
                    try {
                        JSONUtils jsonUtils = JSONUtils.getInstance();
                        JsonNode node = jsonUtils.getAsNode(this.jwkSetJson);
                        String sNonPretty = jsonUtils.toString(node);
                        this.jwkSetCxf = this.engineCxf.jsonToJwkSet(sNonPretty);
                    }
                    catch (Exception eCxf) {
                        throw e;
                    }
                }
            }
        }
    }

    public JsonWebKeys getJsonWebKeys() throws UtilsException {
        if (this.jwkSetCxf == null) {
            this.initCxf();
        }
        return this.jwkSetCxf;
    }

    private synchronized void initNimbusds() throws UtilsException {
        if (this.jwkSetNimbusds == null) {
            if (this.jwkSetJson == null) {
                throw new UtilsException("Json not defined");
            }
            try {
                this.jwkSetNimbusds = com.nimbusds.jose.jwk.JWKSet.parse((String)this.jwkSetJson);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }

    public com.nimbusds.jose.jwk.JWKSet getJWKSet() throws UtilsException {
        if (this.jwkSetNimbusds == null) {
            this.initNimbusds();
        }
        return this.jwkSetNimbusds;
    }

    private synchronized void initJson() throws UtilsException {
        if (this.jwkSetJson == null) {
            if ((this.jwkSetList == null || this.jwkSetList.isEmpty()) && this.jwkSetCxf == null && this.jwkSetNimbusds == null) {
                throw new UtilsException("JWK Set not defined");
            }
            if (this.jwkSetList != null && !this.jwkSetList.isEmpty()) {
                this.initJsonFromJwkSetList();
            } else if (this.jwkSetCxf != null) {
                this.initJsonFromJwkSetCxf();
            } else {
                this.initJsonFromJwkSetNimbusds();
            }
        }
    }

    private synchronized void initJsonFromJwkSetList() throws UtilsException {
        ArrayList<com.nimbusds.jose.jwk.JWK> list = new ArrayList<com.nimbusds.jose.jwk.JWK>();
        for (JWK jwkOp : this.jwkSetList) {
            list.add(jwkOp.getJWK());
        }
        StringBuilder sb = new StringBuilder("{\"keys\":[");
        boolean first = true;
        for (JWK jwkOp : this.jwkSetList) {
            if (!first) {
                sb.append(",");
            }
            sb.append(jwkOp.getJWK().toJSONString());
            first = false;
        }
        sb.append("]}");
        this.jwkSetJson = sb.toString();
    }

    private synchronized void initJsonFromJwkSetCxf() throws UtilsException {
        try {
            this.jwkSetJson = this.engineCxf.jwkSetToJson(this.jwkSetCxf);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private synchronized void initJsonFromJwkSetNimbusds() throws UtilsException {
        try {
            this.jwkSetJson = this.jwkSetNimbusds.toString();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public String getJson() throws UtilsException {
        if (this.jwkSetJson == null) {
            this.initJson();
        }
        return this.jwkSetJson;
    }

    private synchronized void initJsonPretty() throws UtilsException {
        if (this.jwkSetJsonPretty == null) {
            try {
                if (this.jwkSetNode == null) {
                    this.initNode();
                }
                this.jwkSetJsonPretty = JSONUtils.getInstance(true).toString(this.jwkSetNode);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }

    public String getJsonPretty() throws UtilsException {
        if (this.jwkSetJsonPretty == null) {
            this.initJsonPretty();
        }
        return this.jwkSetJsonPretty;
    }

    private synchronized void initNode() throws UtilsException {
        if (this.jwkSetNode == null) {
            try {
                if (this.jwkSetJson == null) {
                    this.initJson();
                }
                this.jwkSetNode = JSONUtils.getInstance().getAsNode(this.jwkSetJson);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }

    public JsonNode getNode() throws UtilsException {
        if (this.jwkSetNode == null) {
            this.initNode();
        }
        return this.jwkSetNode;
    }

    public String toString() {
        try {
            return this.getJsonPretty();
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), e);
        }
    }
}

