/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.byok;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.DynamicStringReplace;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKConfig;
import org.openspcoop2.utils.certificate.byok.BYOKConfigParameter;
import org.openspcoop2.utils.certificate.byok.BYOKEncryptionMode;
import org.openspcoop2.utils.certificate.byok.BYOKLocalConfig;
import org.openspcoop2.utils.certificate.byok.BYOKRemoteConfig;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.digest.DigestEncoding;
import org.openspcoop2.utils.digest.DigestUtils;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;

public class BYOKInstance {
    private BYOKConfig config;
    private HttpRequest httpRequest;
    private byte[] localKey;
    private BYOKLocalConfig localConfigResolved;
    private String keyCache;
    private static final String BYOK_REQUEST_PARAMS_UNDEFINED = "BYOKRequestParams undefined";
    private static final String BYOK_REQUEST_PARAMS_CONFIG_UNDEFINED = "BYOKRequestParams config undefined";

    public BYOKInstance(BYOKConfig config, HttpRequest httpRequest, String keyCache) {
        this.config = config;
        this.httpRequest = httpRequest;
        this.keyCache = keyCache;
    }

    public BYOKInstance(BYOKConfig config, BYOKLocalConfig localConfigResolved, byte[] key, String keyCache) {
        this.config = config;
        this.localConfigResolved = localConfigResolved;
        this.localKey = key;
        this.keyCache = keyCache;
    }

    public BYOKConfig getConfig() {
        return this.config;
    }

    public BYOKLocalConfig getLocalConfigResolved() {
        return this.localConfigResolved;
    }

    public byte[] getLocalKey() {
        return this.localKey;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public String getKeyCache() {
        return this.keyCache;
    }

    public static BYOKInstance newInstance(Logger log, BYOKRequestParams requestParams, byte[] key) throws UtilsException {
        if (requestParams == null) {
            throw new UtilsException(BYOK_REQUEST_PARAMS_UNDEFINED);
        }
        if (requestParams.getConfig() == null) {
            throw new UtilsException(BYOK_REQUEST_PARAMS_CONFIG_UNDEFINED);
        }
        if (BYOKEncryptionMode.LOCAL.equals((Object)requestParams.getConfig().getEncryptionMode())) {
            return BYOKInstance.newLocalInstance(log, requestParams, key);
        }
        return BYOKInstance.newRemoteInstance(log, requestParams, key);
    }

    public static BYOKInstance newInstance(Logger log, Map<String, Object> dynamicMap, BYOKConfig config, Map<String, String> inputMap, String keyCache, byte[] key) throws UtilsException {
        if (config == null) {
            throw new UtilsException(BYOK_REQUEST_PARAMS_CONFIG_UNDEFINED);
        }
        if (BYOKEncryptionMode.LOCAL.equals((Object)config.getEncryptionMode())) {
            return BYOKInstance.newLocalInstance(log, dynamicMap, config, inputMap, keyCache, key);
        }
        return BYOKInstance.newRemoteInstance(log, dynamicMap, config, inputMap, key);
    }

    public static BYOKInstance newRemoteInstance(Logger log, BYOKRequestParams requestParams, byte[] key) throws UtilsException {
        if (requestParams == null) {
            throw new UtilsException(BYOK_REQUEST_PARAMS_UNDEFINED);
        }
        return BYOKInstance.newRemoteInstance(log, requestParams.getDynamicMap(), requestParams.getConfig(), requestParams.getInputMap(), key);
    }

    public static BYOKInstance newRemoteInstance(Logger log, Map<String, Object> dynamicMap, BYOKConfig config, Map<String, String> inputMap, byte[] key) throws UtilsException {
        HttpRequest httpRequest = BYOKInstance.buildHttpRequest(log, config, dynamicMap, inputMap, key);
        String keyCache = BYOKInstance.buildKeyCache(httpRequest);
        return new BYOKInstance(config, httpRequest, keyCache);
    }

    public static BYOKInstance newLocalInstance(Logger log, BYOKRequestParams requestParams, byte[] key) throws UtilsException {
        if (requestParams == null) {
            throw new UtilsException(BYOK_REQUEST_PARAMS_UNDEFINED);
        }
        if (requestParams.getKeyIdentity() == null) {
            throw new UtilsException("BYOKRequestParams key identity undefined");
        }
        return BYOKInstance.newLocalInstance(log, requestParams.getDynamicMap(), requestParams.getConfig(), requestParams.getInputMap(), requestParams.getKeyIdentity(), key);
    }

    public static BYOKInstance newLocalInstance(Logger log, Map<String, Object> dynamicMap, BYOKConfig config, Map<String, String> inputMap, String keyCache, byte[] key) throws UtilsException {
        if (log != null) {
            // empty if block
        }
        BYOKLocalConfig localConfig = BYOKInstance.buildBYOKLocalConfig(config, dynamicMap, inputMap, null);
        return new BYOKInstance(config, localConfig, key, keyCache);
    }

    private static BYOKLocalConfig buildBYOKLocalConfig(BYOKConfig config, Map<String, Object> dynamicMap, Map<String, String> inputMap, byte[] key) throws UtilsException {
        BYOKLocalConfig localConfig = new BYOKLocalConfig();
        List<BYOKConfigParameter> inputParameters = config.getInputParameters();
        localConfig.encryptionEngine = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.impl", config.getLocalConfig().encryptionEngine);
        localConfig.keystoreType = config.getLocalConfig().keystoreType;
        localConfig.keystoreHsmType = config.getLocalConfig().keystoreHsmType;
        localConfig.keystorePath = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.keystore.path", config.getLocalConfig().keystorePath);
        localConfig.keystorePassword = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.keystore.password", config.getLocalConfig().keystorePassword);
        localConfig.keyPath = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.key.path", config.getLocalConfig().keyPath);
        localConfig.keyInline = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.key.inline", config.getLocalConfig().keyInline);
        localConfig.keyEncoding = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.key.encoding", config.getLocalConfig().keyEncoding);
        localConfig.keyAlgorithm = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.key.algorithm", config.getLocalConfig().keyAlgorithm);
        localConfig.keyAlias = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.key.alias", config.getLocalConfig().keyAlias);
        localConfig.keyPassword = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.key.password", config.getLocalConfig().keyPassword);
        localConfig.keyId = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.key.id", config.getLocalConfig().keyId);
        localConfig.keyWrap = config.getLocalConfig().keyWrap;
        localConfig.publicKeyPath = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.publicKey.path", config.getLocalConfig().publicKeyPath);
        localConfig.publicKeyInline = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.publicKey.inline", config.getLocalConfig().publicKeyInline);
        localConfig.publicKeyEncoding = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.publicKey.encoding", config.getLocalConfig().publicKeyEncoding);
        localConfig.pw = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.password", config.getLocalConfig().pw);
        localConfig.pwType = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.password.type", config.getLocalConfig().pwType);
        localConfig.pwIteration = config.getLocalConfig().pwIteration;
        localConfig.contentAlgorithm = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.algorithm", config.getLocalConfig().contentAlgorithm);
        localConfig.encoding = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "local.encoding", config.getLocalConfig().encoding);
        localConfig.joseIncludeCert = config.getLocalConfig().joseIncludeCert;
        localConfig.joseIncludePublicKey = config.getLocalConfig().joseIncludePublicKey;
        localConfig.joseIncludeKeyId = config.getLocalConfig().joseIncludeKeyId;
        localConfig.joseIncludeCertSha1 = config.getLocalConfig().joseIncludeCertSha1;
        localConfig.joseIncludeCertSha256 = config.getLocalConfig().joseIncludeCertSha256;
        return localConfig;
    }

    private static HttpRequest buildHttpRequest(Logger log, BYOKConfig configParam, Map<String, Object> dynamicMap, Map<String, String> inputMap, byte[] key) throws UtilsException {
        HttpRequest http = new HttpRequest();
        BYOKRemoteConfig config = configParam.getRemoteConfig();
        List<BYOKConfigParameter> inputParameters = configParam.getInputParameters();
        http.setUrl(BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "http.endpoint", config.getHttpEndpoint()));
        String m = null;
        try {
            m = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "http.method", config.getHttpMethod());
            if (m == null) {
                throw new UtilsException("Undefined");
            }
            http.setMethod(HttpRequestMethod.valueOf(m.toUpperCase()));
        }
        catch (Exception e) {
            throw new UtilsException("Invalid request http method (" + config.getHttpEndpoint() + "; resolved:" + m + "): " + e.getMessage(), e);
        }
        if (config.getHttpConnectionTimeout() != null) {
            http.setConnectTimeout(config.getHttpConnectionTimeout());
        }
        if (config.getHttpReadTimeout() != null) {
            http.setReadTimeout(config.getHttpReadTimeout());
        }
        BYOKInstance.setHttpHeader(config, dynamicMap, inputParameters, inputMap, key, http);
        BYOKInstance.setPayload(config, dynamicMap, inputParameters, inputMap, key, http);
        BYOKInstance.setHttps(log, config, dynamicMap, inputParameters, inputMap, key, http);
        return http;
    }

    private static void setHttpHeader(BYOKRemoteConfig config, Map<String, Object> dynamicMap, List<BYOKConfigParameter> inputParameters, Map<String, String> inputMap, byte[] key, HttpRequest http) throws UtilsException {
        if (config.getHttpHeaders() != null && !config.getHttpHeaders().isEmpty()) {
            for (Map.Entry<String, String> entry : config.getHttpHeaders().entrySet()) {
                String nome = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "http.header.<name>", entry.getKey());
                String valore = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "http.header." + entry.getKey(), entry.getValue());
                if (nome == null || valore == null) continue;
                http.addHeader(nome, valore);
            }
        }
        if (config.getHttpUsername() != null) {
            http.setUsername(BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "http.username", config.getHttpUsername()));
        }
        if (config.getHttpPassword() != null) {
            http.setPassword(BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "http.password", config.getHttpPassword()));
        }
    }

    private static void setPayload(BYOKRemoteConfig config, Map<String, Object> dynamicMap, List<BYOKConfigParameter> inputParameters, Map<String, String> inputMap, byte[] key, HttpRequest http) throws UtilsException {
        String ct;
        if (config.getHttpPayloadInLine() != null) {
            String content = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "http.payload.inline", config.getHttpPayloadInLine());
            if (content != null) {
                http.setContent(content.getBytes());
            }
        } else if (config.getHttpPayloadPath() != null) {
            byte[] fileContent = null;
            try {
                fileContent = FileSystemUtilities.readBytesFromFile(config.getHttpPayloadPath());
            }
            catch (Exception e) {
                throw new UtilsException("Invalid request payload file (" + config.getHttpPayloadPath() + "): " + e.getMessage(), e);
            }
            http.setContent(BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "http.payload.path", fileContent));
        }
        if (http.getContent() != null && ((ct = http.getHeaderFirstValue("Content-Type")) == null || StringUtils.isEmpty((String)ct))) {
            http.setContentType("application/octet-stream");
        }
    }

    private static void setHttps(Logger log, BYOKRemoteConfig config, Map<String, Object> dynamicMap, List<BYOKConfigParameter> inputParameters, Map<String, String> inputMap, byte[] key, HttpRequest http) throws UtilsException {
        if (log != null) {
            // empty if block
        }
        if (config.isHttps()) {
            http.setHostnameVerifier(config.isHttpsHostnameVerifier());
            BYOKInstance.setHttpsServer(config, dynamicMap, inputParameters, inputMap, key, http);
            BYOKInstance.setHttpsClient(config, dynamicMap, inputParameters, inputMap, key, http);
        }
    }

    private static void setHttpsServer(BYOKRemoteConfig config, Map<String, Object> dynamicMap, List<BYOKConfigParameter> inputParameters, Map<String, String> inputMap, byte[] key, HttpRequest http) throws UtilsException {
        if (config.isHttpsServerAuth()) {
            if (config.getHttpsServerAuthTrustStorePath() != null) {
                http.setTrustStorePath(BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "https.serverAuth.trustStore.path", config.getHttpsServerAuthTrustStorePath()));
            }
            if (config.getHttpsServerAuthTrustStoreType() != null) {
                http.setTrustStoreType(BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "https.serverAuth.trustStore.type", config.getHttpsServerAuthTrustStoreType()));
            }
            if (config.getHttpsServerAuthTrustStorePassword() != null) {
                http.setTrustStorePassword(BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "https.serverAuth.trustStore.password", config.getHttpsServerAuthTrustStorePassword()));
            }
            if (config.getHttpsServerAuthTrustStoreCrls() != null) {
                http.setCrlPath(BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "https.serverAuth.trustStore.crls", config.getHttpsServerAuthTrustStoreCrls()));
            }
            if (config.getHttpsServerAuthTrustStoreOcspPolicy() != null) {
                http.setOcspPolicy(BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "https.serverAuth.trustStore.ocspPolicy", config.getHttpsServerAuthTrustStoreOcspPolicy()));
            }
        } else {
            http.setTrustAllCerts(true);
        }
    }

    private static void setHttpsClient(BYOKRemoteConfig config, Map<String, Object> dynamicMap, List<BYOKConfigParameter> inputParameters, Map<String, String> inputMap, byte[] key, HttpRequest http) throws UtilsException {
        if (config.isHttpsClientAuth()) {
            if (config.getHttpsClientAuthKeyStorePath() != null) {
                http.setKeyStorePath(BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "https.clientAuth.keyStore.path", config.getHttpsClientAuthKeyStorePath()));
            }
            if (config.getHttpsClientAuthKeyStoreType() != null) {
                http.setKeyStoreType(BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "https.clientAuth.keyStore.type", config.getHttpsClientAuthKeyStoreType()));
            }
            if (config.getHttpsClientAuthKeyStorePassword() != null) {
                http.setKeyStorePassword(BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "https.clientAuth.keyStore.password", config.getHttpsClientAuthKeyStorePassword()));
            }
            if (config.getHttpsClientAuthKeyAlias() != null) {
                http.setKeyAlias(BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "https.clientAuth.key.alias", config.getHttpsClientAuthKeyAlias()));
            }
            if (config.getHttpsClientAuthKeyPassword() != null) {
                http.setKeyPassword(BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, "https.clientAuth.key.password", config.getHttpsClientAuthKeyPassword()));
            }
        }
    }

    private static String buildKeyCache(HttpRequest httpRequest) throws UtilsException {
        StringBuilder sb = new StringBuilder();
        if (httpRequest != null) {
            sb.append(httpRequest.getMethod()).append("_").append(httpRequest.getUrl());
            BYOKInstance.addKeyCacheHttpHeader(httpRequest, sb);
            if (httpRequest.getContent() != null && httpRequest.getContent().length > 0) {
                String digestAlgorithm = "SHA256";
                String digestAuditValue = DigestUtils.getDigestValue(httpRequest.getContent(), digestAlgorithm, DigestEncoding.HEX, true);
                sb.append("_");
                sb.append(digestAuditValue);
            }
        }
        return sb.toString();
    }

    private static void addKeyCacheHttpHeader(HttpRequest httpRequest, StringBuilder sb) {
        if (httpRequest.getHeadersValues() != null && !httpRequest.getHeadersValues().isEmpty()) {
            for (String name : httpRequest.getHeadersValues().keySet()) {
                List<String> values = httpRequest.getHeadersValues().get(name);
                if (values == null || values.isEmpty()) continue;
                for (String v : values) {
                    sb.append("_");
                    sb.append(name).append(":").append(v);
                }
            }
        }
    }

    private static byte[] resolveKmsConstants(Map<String, Object> dynamicMap, List<BYOKConfigParameter> inputParameters, Map<String, String> inputMap, byte[] key, String name, byte[] value) throws UtilsException {
        byte[] returnArray = null;
        if (value != null) {
            String v = new String(value);
            if ("${kms-key}".equals(v) || "${ksm-key}".equals(v)) {
                returnArray = key;
            } else if ("${kms-urlencoded-key}".equals(v) || "${ksm-urlencoded-key}".equals(v)) {
                returnArray = TransportUtils.urlEncodeParam(v, Charset.UTF_8.getValue()).getBytes();
            } else if ("${kms-base64-key}".equals(v) || "${ksm-base64-key}".equals(v)) {
                returnArray = Base64Utilities.encode(key);
            } else if ("${kms-base64-urlencoded-key}".equals(v) || "${ksm-base64-urlencoded-key}".equals(v)) {
                String base64 = Base64Utilities.encodeAsString(key);
                returnArray = TransportUtils.urlEncodeParam(base64, Charset.UTF_8.getValue()).getBytes();
            } else if ("${kms-hex-key}".equals(v) || "${ksm-hex-key}".equals(v)) {
                returnArray = HexBinaryUtilities.encodeAsString(key).getBytes();
            } else if ("${kms-hex-urlencoded-key}".equals(v) || "${ksm-hex-urlencoded-key}".equals(v)) {
                String hex = HexBinaryUtilities.encodeAsString(key);
                returnArray = TransportUtils.urlEncodeParam(hex, Charset.UTF_8.getValue()).getBytes();
            } else {
                returnArray = BYOKInstance.resolveKmsConstants(dynamicMap, inputParameters, inputMap, key, name, v).getBytes();
            }
        }
        return returnArray;
    }

    private static String resolveKmsConstants(Map<String, Object> dynamicMap, List<BYOKConfigParameter> inputParameters, Map<String, String> inputMap, byte[] key, String name, String value) throws UtilsException {
        if (value == null) {
            return value;
        }
        String newValue = BYOKInstance.resolveKmsConstant(value, "${kms-key}", key);
        newValue = BYOKInstance.resolveKmsConstant(newValue, "${ksm-key}", key);
        newValue = BYOKInstance.resolveKmsConstant(newValue, "${kms-urlencoded-key}", key);
        newValue = BYOKInstance.resolveKmsConstant(newValue, "${ksm-urlencoded-key}", key);
        newValue = BYOKInstance.resolveKmsConstant(newValue, "${kms-base64-key}", key);
        newValue = BYOKInstance.resolveKmsConstant(newValue, "${ksm-base64-key}", key);
        newValue = BYOKInstance.resolveKmsConstant(newValue, "${kms-base64-urlencoded-key}", key);
        newValue = BYOKInstance.resolveKmsConstant(newValue, "${ksm-base64-urlencoded-key}", key);
        newValue = BYOKInstance.resolveKmsConstant(newValue, "${kms-hex-key}", key);
        newValue = BYOKInstance.resolveKmsConstant(newValue, "${ksm-hex-key}", key);
        newValue = BYOKInstance.resolveKmsConstant(newValue, "${kms-hex-urlencoded-key}", key);
        newValue = BYOKInstance.resolveKmsConstant(newValue, "${ksm-hex-urlencoded-key}", key);
        String kmsMapId = null;
        if (newValue.contains("${kms:") && !dynamicMap.containsKey("kms")) {
            kmsMapId = "kms";
        } else if (newValue.contains("${ksm:") && !dynamicMap.containsKey("ksm")) {
            kmsMapId = "ksm";
        }
        if (kmsMapId != null) {
            HashMap<String, String> k = new HashMap<String, String>();
            for (BYOKConfigParameter parameter : inputParameters) {
                if (inputMap == null || !inputMap.containsKey(parameter.getName())) continue;
                String paramValue = inputMap.get(parameter.getName());
                String valueResolved = BYOKInstance.resolve(parameter.getName(), paramValue, dynamicMap);
                k.put(parameter.getName(), valueResolved);
            }
            dynamicMap.put(kmsMapId, k);
        }
        return BYOKInstance.resolve(name, newValue, dynamicMap);
    }

    private static String resolveKmsConstant(String value, String constant, byte[] key) throws UtilsException {
        if (value != null && value.contains(constant)) {
            String replaceValue = null;
            if ("${kms-key}".equals(constant) || "${ksm-key}".equals(constant) || "${kms-urlencoded-key}".equals(constant) || "${ksm-urlencoded-key}".equals(constant)) {
                replaceValue = new String(key);
            } else if ("${kms-base64-key}".equals(constant) || "${ksm-base64-key}".equals(constant) || "${kms-base64-urlencoded-key}".equals(constant) || "${ksm-base64-urlencoded-key}".equals(constant)) {
                replaceValue = Base64Utilities.encodeAsString(key);
            } else if ("${kms-hex-key}".equals(constant) || "${ksm-hex-key}".equals(constant) || "${kms-hex-urlencoded-key}".equals(constant) || "${ksm-hex-urlencoded-key}".equals(constant)) {
                replaceValue = HexBinaryUtilities.encodeAsString(key);
            }
            if ("${kms-urlencoded-key}".equals(constant) || "${ksm-urlencoded-key}".equals(constant) || "${kms-base64-urlencoded-key}".equals(constant) || "${ksm-base64-urlencoded-key}".equals(constant) || "${kms-hex-urlencoded-key}".equals(constant) || "${ksm-hex-urlencoded-key}".equals(constant)) {
                replaceValue = TransportUtils.urlEncodeParam(replaceValue, Charset.UTF_8.getValue());
            }
            while (value.contains(constant)) {
                value = value.replace(constant, replaceValue);
            }
        }
        return value;
    }

    private static String resolve(String name, String value, Map<String, Object> dynamicMap) throws UtilsException {
        try {
            return DynamicStringReplace.replace(value, dynamicMap, true);
        }
        catch (Exception e) {
            String prefix = "[" + name + "] contiene un valore non corretto: ";
            throw new UtilsException(prefix + e.getMessage(), e);
        }
    }
}

