/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.byok;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKConfig;
import org.openspcoop2.utils.certificate.byok.BYOKEncryptionMode;
import org.openspcoop2.utils.certificate.byok.BYOKMode;
import org.openspcoop2.utils.certificate.byok.BYOKSecurityConfig;
import org.openspcoop2.utils.certificate.byok.BYOKSecurityConfigParameter;
import org.openspcoop2.utils.properties.PropertiesReader;
import org.slf4j.Logger;

public class BYOKManager {
    private static BYOKManager staticInstance;
    private HashMap<String, BYOKConfig> kmsKeystoreMapIDtoConfig = new HashMap();
    private HashMap<String, String> kmsKeystoreMapLabelToID = new HashMap();
    private HashMap<String, String> kmsKeystoreMapTypeToID = new HashMap();
    private List<String> unwrapTypes = new ArrayList<String>();
    private List<String> unwrapLabels = new ArrayList<String>();
    private List<String> wrapTypes = new ArrayList<String>();
    private List<String> wrapLabels = new ArrayList<String>();
    private static final String UNKNOWN = "unknown";
    private HashMap<String, BYOKSecurityConfig> securityMapIDtoConfig = new HashMap();
    private String securityEngineGovWay = null;
    private String securityRemoteEngineGovWay = null;

    public static synchronized void init(File f, boolean throwNotExists, Logger log) throws UtilsException {
        if (staticInstance == null) {
            staticInstance = new BYOKManager(f, throwNotExists, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BYOKManager getInstance() {
        if (staticInstance != null) return staticInstance;
        Class<BYOKManager> clazz = BYOKManager.class;
        synchronized (BYOKManager.class) {
            if (staticInstance != null) return staticInstance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    public static String getSecurityEngineGovWayPolicy() {
        if (staticInstance != null) {
            return staticInstance.getSecurityEngineGovWay();
        }
        return null;
    }

    public static String getSecurityRemoteEngineGovWayPolicy() {
        if (staticInstance != null) {
            return staticInstance.getSecurityRemoteEngineGovWay();
        }
        return null;
    }

    public static boolean isEnabledBYOK() {
        String securityManagerPolicy = BYOKManager.getSecurityEngineGovWayPolicy();
        return securityManagerPolicy != null && StringUtils.isNotEmpty((String)securityManagerPolicy);
    }

    private BYOKManager(File f, boolean throwNotExists, Logger log) throws UtilsException {
        String prefixFile = "File '" + f.getAbsolutePath() + "'";
        if (!f.exists()) {
            if (throwNotExists) {
                throw new UtilsException(prefixFile + " not exists");
            }
        } else {
            if (!f.canRead()) {
                throw new UtilsException(prefixFile + " cannot read");
            }
            Properties p = new Properties();
            try (FileInputStream fin = new FileInputStream(f);){
                p.load(fin);
            }
            catch (Exception t) {
                throw new UtilsException(prefixFile + "; initialize error: " + t.getMessage(), t);
            }
            this.init(p, log);
        }
    }

    private void init(Properties p, Logger log) throws UtilsException {
        ArrayList<String> idKeystore = new ArrayList<String>();
        ArrayList<String> securityKeystore = new ArrayList<String>();
        if (p != null && !p.isEmpty()) {
            this.init(p, idKeystore, securityKeystore);
        }
        if (!idKeystore.isEmpty()) {
            for (String idK : idKeystore) {
                this.init(p, log, idK);
            }
        } else {
            log.warn("La configurazione fornita per KMS non contiene alcun keystore");
        }
        if (!securityKeystore.isEmpty()) {
            for (String idK : securityKeystore) {
                this.initSecurity(p, log, idK);
            }
        } else {
            log.warn("La configurazione fornita per KMS non contiene alcun security manager");
        }
        this.initSecurityGovWay(p);
    }

    private void init(Properties p, List<String> idKeystore, List<String> securityKeystore) {
        Enumeration<Object> enKeys = p.keys();
        while (enKeys.hasMoreElements()) {
            Object object = enKeys.nextElement();
            if (!(object instanceof String)) continue;
            String key = (String)object;
            this.init(key, idKeystore, securityKeystore);
        }
    }

    private void init(String key, List<String> idKeystore, List<String> securityKeystore) {
        boolean isIdKeystore = this.initEngine(key, idKeystore, "kms.");
        if (!isIdKeystore) {
            isIdKeystore = this.initEngine(key, idKeystore, "ksm.");
        }
        if (!isIdKeystore) {
            this.initEngine(key, securityKeystore, "security.");
        }
    }

    private boolean initEngine(String key, List<String> list, String prefix) {
        if (key.startsWith(prefix) && key.length() > prefix.length()) {
            String idK;
            int indeoOf;
            String tmp = key.substring(prefix.length());
            if (tmp != null && tmp.contains(".") && (indeoOf = tmp.indexOf(".")) > 0 && !list.contains(idK = tmp.substring(0, indeoOf))) {
                list.add(idK);
            }
            return true;
        }
        return false;
    }

    private void init(Properties p, Logger log, String idK) throws UtilsException {
        String byokPropertyPrefix = "kms.";
        String prefix = byokPropertyPrefix + idK + ".";
        Properties pKeystore = Utilities.readProperties(prefix, p);
        if (pKeystore == null || pKeystore.isEmpty()) {
            byokPropertyPrefix = "ksm.";
            prefix = byokPropertyPrefix + idK + ".";
            pKeystore = Utilities.readProperties(prefix, p);
        }
        BYOKConfig kmsKeystore = new BYOKConfig(idK, pKeystore, log, byokPropertyPrefix);
        boolean alreadyExists = false;
        for (String l : this.kmsKeystoreMapLabelToID.keySet()) {
            if (!kmsKeystore.getLabel().equalsIgnoreCase(l)) continue;
            alreadyExists = true;
            break;
        }
        if (alreadyExists) {
            throw new UtilsException("Same label found for kms '" + this.kmsKeystoreMapLabelToID.get(kmsKeystore.getLabel()) + "' e '" + idK + "'");
        }
        this.kmsKeystoreMapLabelToID.put(kmsKeystore.getLabel(), idK);
        alreadyExists = false;
        for (String type : this.kmsKeystoreMapTypeToID.keySet()) {
            if (!kmsKeystore.getType().equalsIgnoreCase(type)) continue;
            alreadyExists = true;
            break;
        }
        if (alreadyExists) {
            throw new UtilsException("Same type found for kms '" + this.kmsKeystoreMapTypeToID.get(kmsKeystore.getType()) + "' e '" + idK + "'");
        }
        this.kmsKeystoreMapTypeToID.put(kmsKeystore.getType(), idK);
        if (BYOKMode.UNWRAP.equals((Object)kmsKeystore.getMode())) {
            this.unwrapTypes.add(kmsKeystore.getType());
            this.unwrapLabels.add(kmsKeystore.getLabel());
        } else {
            this.wrapTypes.add(kmsKeystore.getType());
            this.wrapLabels.add(kmsKeystore.getLabel());
        }
        this.kmsKeystoreMapIDtoConfig.put(idK, kmsKeystore);
        String d = "KMS " + idK + " registrato (type:" + kmsKeystore.getType() + ") label:" + kmsKeystore.getLabel();
        log.info(d);
    }

    private void initSecurity(Properties p, Logger log, String idK) throws UtilsException {
        String prefix = "security." + idK + ".";
        Properties pKeystore = Utilities.readProperties(prefix, p);
        BYOKSecurityConfig securityConfig = new BYOKSecurityConfig(idK, pKeystore, log);
        this.securityMapIDtoConfig.put(idK, securityConfig);
        String d = "Security manager " + idK + " registrato";
        log.info(d);
    }

    private void initSecurityGovWay(Properties p) throws UtilsException {
        PropertiesReader pReader = new PropertiesReader(p, true);
        this.securityEngineGovWay = pReader.getValue_convertEnvProperties("govway.security");
        if (this.securityEngineGovWay != null && StringUtils.isEmpty((String)this.securityEngineGovWay)) {
            this.securityEngineGovWay = null;
        }
        this.securityRemoteEngineGovWay = pReader.getValue_convertEnvProperties("govway.security.runtime");
        if (this.securityRemoteEngineGovWay != null && StringUtils.isEmpty((String)this.securityRemoteEngineGovWay)) {
            this.securityRemoteEngineGovWay = null;
        }
    }

    public BYOKConfig getKMSConfigByType(String type) throws UtilsException {
        if (!this.kmsKeystoreMapTypeToID.containsKey(type)) {
            throw new UtilsException("KMS type '" + type + "' unknown");
        }
        String idK = this.kmsKeystoreMapTypeToID.get(type);
        if (!this.kmsKeystoreMapIDtoConfig.containsKey(idK)) {
            throw new UtilsException("KMS config for type '" + type + "' unknown ? (id:" + idK + ")");
        }
        return this.kmsKeystoreMapIDtoConfig.get(idK);
    }

    public BYOKConfig getKMSConfigByLabel(String label) throws UtilsException {
        if (!this.kmsKeystoreMapLabelToID.containsKey(label)) {
            throw new UtilsException("KMS label '" + label + "' unknown");
        }
        String idK = this.kmsKeystoreMapLabelToID.get(label);
        if (!this.kmsKeystoreMapIDtoConfig.containsKey(idK)) {
            throw new UtilsException("KMS config for label '" + label + "' unknown ? (id:" + idK + ")");
        }
        return this.kmsKeystoreMapIDtoConfig.get(idK);
    }

    public List<String> getKeystoreTypes() {
        ArrayList<String> l = new ArrayList<String>();
        if (!this.kmsKeystoreMapLabelToID.isEmpty()) {
            for (String type : this.kmsKeystoreMapLabelToID.keySet()) {
                l.add(type);
            }
        }
        return l;
    }

    public SortedMap<String> getKeystoreWrapConfigTypesLabels() throws UtilsException {
        return this.getKeystoreConfigTypesLabels(true);
    }

    public SortedMap<String> getKeystoreUnwrapConfigTypesLabels() throws UtilsException {
        return this.getKeystoreConfigTypesLabels(false);
    }

    private SortedMap<String> getKeystoreConfigTypesLabels(boolean wrap) throws UtilsException {
        List<String> labels;
        SortedMap<String> sMap = new SortedMap<String>();
        List<String> types = wrap ? this.wrapTypes : this.unwrapTypes;
        List<String> list = labels = wrap ? this.wrapLabels : this.unwrapLabels;
        if (types != null && !types.isEmpty()) {
            ArrayList<String> labelsDaOrdinare = new ArrayList<String>();
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = 0; i < types.size(); ++i) {
                String type = types.get(i);
                String label = labels.get(i);
                m.put(label, type);
                labelsDaOrdinare.add(label);
            }
            Collections.sort(labelsDaOrdinare);
            for (String l : labelsDaOrdinare) {
                sMap.add((String)m.get(l), l);
            }
        }
        return sMap;
    }

    public boolean isKMSUsedInSecurityWrapConfig(String id, StringBuilder securityId) {
        return this.isKMSUsedInSecurityConfig(true, id, securityId);
    }

    public boolean isKMSUsedInSecurityUnwrapConfig(String id, StringBuilder securityId) {
        return this.isKMSUsedInSecurityConfig(false, id, securityId);
    }

    private boolean isKMSUsedInSecurityConfig(boolean wrap, String id, StringBuilder securityId) {
        if (!this.securityMapIDtoConfig.isEmpty()) {
            for (Map.Entry<String, BYOKSecurityConfig> entry : this.securityMapIDtoConfig.entrySet()) {
                String confKmsId = wrap ? entry.getValue().getWrapId() : entry.getValue().getUnwrapId();
                if (!id.equals(confKmsId)) continue;
                if (securityId != null) {
                    securityId.append(entry.getKey());
                }
                return true;
            }
        }
        return false;
    }

    public boolean existsKMSConfigByType(String type) {
        if (type == null) {
            return false;
        }
        for (String i : this.kmsKeystoreMapTypeToID.keySet()) {
            if (!type.equalsIgnoreCase(i)) continue;
            return true;
        }
        return false;
    }

    public boolean existsKMSConfigByLabel(String label) {
        if (label == null) {
            return false;
        }
        for (String i : this.kmsKeystoreMapLabelToID.keySet()) {
            if (!label.equalsIgnoreCase(i)) continue;
            return true;
        }
        return false;
    }

    public List<String> getUnwrapTypes() {
        return this.unwrapTypes;
    }

    public List<String> getUnwrapLabels() {
        return this.unwrapLabels;
    }

    public List<String> getWrapTypes() {
        return this.wrapTypes;
    }

    public List<String> getWrapLabels() {
        return this.wrapLabels;
    }

    public BYOKSecurityConfig getKMSSecurityConfig(String type) throws UtilsException {
        if (!this.securityMapIDtoConfig.containsKey(type)) {
            throw new UtilsException("KMS security config type '" + type + "' unknown");
        }
        BYOKSecurityConfig c = this.securityMapIDtoConfig.get(type);
        if (c == null) {
            throw new UtilsException("KMS security config type '" + type + "' unknown");
        }
        return c;
    }

    public List<String> getSecurityEngineTypes() {
        ArrayList<String> l = new ArrayList<String>();
        if (!this.securityMapIDtoConfig.isEmpty()) {
            for (String type : this.securityMapIDtoConfig.keySet()) {
                l.add(type);
            }
        }
        return l;
    }

    public boolean existsSecurityEngineByType(String type) {
        if (type == null) {
            return false;
        }
        for (String i : this.securityMapIDtoConfig.keySet()) {
            if (!type.equalsIgnoreCase(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isBYOKRemoteGovWayNodeUnwrapConfig() throws UtilsException {
        return this.isBYOKRemoteGovWayNodeConfig(BYOKManager.getSecurityEngineGovWayPolicy(), false, true);
    }

    public boolean isBYOKRemoteGovWayNodeWrapConfig() throws UtilsException {
        return this.isBYOKRemoteGovWayNodeConfig(BYOKManager.getSecurityEngineGovWayPolicy(), true, false);
    }

    public boolean isBYOKRemoteGovWayNodeUnwrapConfig(String securityManagerPolicy) throws UtilsException {
        return this.isBYOKRemoteGovWayNodeConfig(securityManagerPolicy, false, true);
    }

    public boolean isBYOKRemoteGovWayNodeWrapConfig(String securityManagerPolicy) throws UtilsException {
        return this.isBYOKRemoteGovWayNodeConfig(securityManagerPolicy, true, false);
    }

    public boolean isBYOKRemoteGovWayNodeConfig(String securityManagerPolicy) throws UtilsException {
        return this.isBYOKRemoteGovWayNodeConfig(securityManagerPolicy, true, true);
    }

    public boolean isBYOKRemoteGovWayNodeConfig(String securityManagerPolicy, boolean wrap, boolean unwrap) throws UtilsException {
        if (securityManagerPolicy == null || StringUtils.isEmpty((String)securityManagerPolicy)) {
            return false;
        }
        BYOKSecurityConfig secConfig = this.getKMSSecurityConfig(securityManagerPolicy);
        boolean govwayRuntime = false;
        if (secConfig.getInputParameters() != null && !secConfig.getInputParameters().isEmpty()) {
            for (BYOKSecurityConfigParameter sec : secConfig.getInputParameters()) {
                if (!sec.getValue().contains("${govway-runtime:")) continue;
                govwayRuntime = true;
                break;
            }
        }
        if (!govwayRuntime) {
            return false;
        }
        return this.isBYOKRemoteGovWayNodeConfig(secConfig, wrap, unwrap);
    }

    private boolean isBYOKRemoteGovWayNodeConfig(BYOKSecurityConfig secConfig, boolean wrap, boolean unwrap) throws UtilsException {
        BYOKConfig c;
        if (wrap && BYOKEncryptionMode.REMOTE.equals((Object)(c = this.getKMSConfigByType(secConfig.getWrapId())).getEncryptionMode())) {
            return true;
        }
        return unwrap && BYOKEncryptionMode.REMOTE.equals((Object)(c = this.getKMSConfigByType(secConfig.getUnwrapId())).getEncryptionMode());
    }

    private String getSecurityEngineGovWay() {
        if (this.securityEngineGovWay == null || StringUtils.isEmpty((String)this.securityEngineGovWay)) {
            return null;
        }
        return this.securityEngineGovWay;
    }

    private String getSecurityRemoteEngineGovWay() {
        if (this.securityRemoteEngineGovWay == null || StringUtils.isEmpty((String)this.securityRemoteEngineGovWay)) {
            return null;
        }
        return this.securityRemoteEngineGovWay;
    }

    public String getSecurityEngineGovWayDescription() {
        if (this.securityEngineGovWay == null || StringUtils.isEmpty((String)this.securityEngineGovWay)) {
            return "unactive";
        }
        StringBuilder sb = new StringBuilder(this.securityEngineGovWay);
        if (this.securityRemoteEngineGovWay != null && StringUtils.isNotEmpty((String)this.securityRemoteEngineGovWay) && !this.securityEngineGovWay.equals(this.securityRemoteEngineGovWay)) {
            sb.append(" (remote:").append(this.securityRemoteEngineGovWay).append(")");
        }
        return sb.toString();
    }
}

