/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.ocsp;

import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.AuthorityInformationAccess;
import org.openspcoop2.utils.certificate.CRLCertstore;
import org.openspcoop2.utils.certificate.CRLDistributionPoint;
import org.openspcoop2.utils.certificate.CRLDistributionPoints;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.ocsp.CertificateSource;
import org.openspcoop2.utils.certificate.ocsp.IOCSPResourceReader;
import org.openspcoop2.utils.certificate.ocsp.OCSPConfig;
import org.openspcoop2.utils.transport.TransportUtils;

public class CRLParams {
    private KeyStore crlTrustStore;
    private CertStore crlCertstore;

    public KeyStore getCrlTrustStore() {
        return this.crlTrustStore;
    }

    public void setCrlTrustStore(KeyStore crlTrustStore) {
        this.crlTrustStore = crlTrustStore;
    }

    public CertStore getCrlCertstore() {
        return this.crlCertstore;
    }

    public void setCrlCertstore(CertStore crlCertstore) {
        this.crlCertstore = crlCertstore;
    }

    public static CRLParams build(LoggerBuffer log, X509Certificate certificate, String crlInputConfig, KeyStore trustStore, OCSPConfig config, IOCSPResourceReader reader) throws UtilsException {
        CertificateInfo cer = new CertificateInfo(certificate, "ocspVerifica");
        return CRLParams.build(log, cer, crlInputConfig, trustStore, config, reader);
    }

    /*
     * WARNING - void declaration
     */
    public static CRLParams build(LoggerBuffer log, CertificateInfo certificate, String crlInputConfig, KeyStore trustStore, OCSPConfig config, IOCSPResourceReader reader) throws UtilsException {
        List<CRLDistributionPoint> crlsList;
        CRLDistributionPoints crls;
        if (config == null) {
            throw new UtilsException("Param config is null");
        }
        if (certificate == null) {
            throw new UtilsException("Param certificate is null");
        }
        ArrayList<String> crlPaths = new ArrayList<String>();
        HashMap<String, byte[]> localResources = new HashMap<String, byte[]>();
        if (config.getCrlSource() != null && !config.getCrlSource().isEmpty()) {
            ArrayList<Throwable> listExceptions = new ArrayList<Throwable>();
            for (CertificateSource s : config.getCrlSource()) {
                String p;
                List<String> l;
                if (CertificateSource.CONFIG.equals(s)) {
                    if (crlInputConfig != null) {
                        if (TransportUtils.isRemoteResource(crlInputConfig)) {
                            CRLParams.readCrlPath(crlInputConfig.trim(), crlPaths, localResources, listExceptions, reader, log);
                        } else {
                            l = CRLCertstore.readCrlPaths(crlInputConfig);
                            if (l != null && !l.isEmpty()) {
                                for (String string : l) {
                                    p = string.trim();
                                    if (crlPaths.contains(p)) continue;
                                    crlPaths.add(p);
                                    log.debug("OCSP-CRL: add config path '" + p + "'");
                                }
                            }
                        }
                    }
                    if (crlPaths.isEmpty()) continue;
                    break;
                }
                if (CertificateSource.ALTERNATIVE_CONFIG.equals(s)) {
                    l = null;
                    if (config.getCrlAlternative() != null) {
                        l = config.getCrlAlternative();
                    }
                    if (l != null && !l.isEmpty()) {
                        for (String string : l) {
                            p = string.trim();
                            if (crlPaths.contains(p)) continue;
                            crlPaths.add(p);
                            log.debug("OCSP-CRL: add alternative config path '" + p + "'");
                        }
                    }
                    if (crlPaths.isEmpty()) continue;
                    break;
                }
                if (!CertificateSource.AUTHORITY_INFORMATION_ACCESS.equals(s)) continue;
                try {
                    crls = certificate.getCRLDistributionPoints();
                    if (crls != null && (crlsList = crls.getCRLDistributionPoints()) != null && !crlsList.isEmpty()) {
                        for (CRLDistributionPoint crlDP : crlsList) {
                            List<String> l2 = crlDP.getDistributionPointNames();
                            if (l2 == null) continue;
                            for (String string : l2) {
                                CRLParams.readCrlPath(string, crlPaths, localResources, listExceptions, reader, log);
                            }
                        }
                    }
                }
                catch (Exception t) {
                    throw new UtilsException(t.getMessage(), t);
                }
                if (crlPaths.isEmpty()) continue;
                break;
            }
            if (crlPaths.isEmpty()) {
                boolean reject = false;
                boolean isCA = false;
                try {
                    isCA = certificate.isCA();
                }
                catch (Exception t) {
                    throw new UtilsException(t.getMessage(), t);
                }
                reject = isCA ? config.isRejectsCAWithoutCRL() : config.isRejectsCertificateWithoutCRL();
                if (reject) {
                    if (!listExceptions.isEmpty()) {
                        if (listExceptions.size() == 1 && (t = (Throwable)listExceptions.get(0)) != null) {
                            throw new UtilsException("Crl retrieve failed; " + t.getMessage(), t);
                        }
                        UtilsMultiException multi = new UtilsMultiException("Crl retrieve failed", listExceptions.toArray(new Throwable[1]));
                        throw new UtilsException("Crl retrieve failed;\n" + multi.getMultiMessage(), multi);
                    }
                    throw new UtilsException("Crl retrieve failed");
                }
            }
        }
        KeyStore crlTrustStore = null;
        if (!crlPaths.isEmpty() && config.getCrlTrustStoreSource() != null && !config.getCrlTrustStoreSource().isEmpty()) {
            for (CertificateSource s : config.getCrlTrustStoreSource()) {
                if (CertificateSource.CONFIG.equals(s)) {
                    if (trustStore == null) continue;
                    try {
                        if (crlTrustStore == null) {
                            java.security.KeyStore ks = java.security.KeyStore.getInstance(KeystoreType.JKS.getNome());
                            ks.load(null, null);
                            crlTrustStore = new KeyStore(ks);
                        }
                    }
                    catch (Exception t) {
                        String msgError = "OCSP-CRL [crlssuer: CONFIG] retrieve failed: " + t.getMessage();
                        log.debug(msgError, t);
                    }
                    if (crlTrustStore != null) {
                        crlTrustStore.putAllCertificate(trustStore, false);
                    }
                    log.debug("OCSP-CRL: add certificate in truststore config");
                    continue;
                }
                if (CertificateSource.ALTERNATIVE_CONFIG.equals(s)) {
                    KeyStore alternativeTrustStore = null;
                    if (config.getAlternativeTrustStoreCRLPath() != null) {
                        alternativeTrustStore = reader.getCrlAlternativeTrustStore();
                    }
                    if (alternativeTrustStore == null) continue;
                    try {
                        if (crlTrustStore == null) {
                            java.security.KeyStore ks = java.security.KeyStore.getInstance(KeystoreType.JKS.getNome());
                            ks.load(null, null);
                            crlTrustStore = new KeyStore(ks);
                        }
                    }
                    catch (Exception t) {
                        String string = "OCSP-CRL [crlssuer: ALTERNATIVE_CONFIG] retrieve failed: " + t.getMessage();
                        log.debug(string, t);
                    }
                    if (crlTrustStore != null) {
                        crlTrustStore.putAllCertificate(alternativeTrustStore, false);
                    }
                    log.debug("OCSP-CRL: add certificate in alternative truststore config");
                    continue;
                }
                if (!CertificateSource.AUTHORITY_INFORMATION_ACCESS.equals(s)) continue;
                try {
                    crls = certificate.getCRLDistributionPoints();
                    if (crls != null) {
                        crlsList = crls.getCRLDistributionPoints();
                        boolean bl = false;
                        if (crlsList != null && !crlsList.isEmpty()) {
                            for (CRLDistributionPoint crlDP : crlsList) {
                                List<String> l = crlDP.getCRLIssuers();
                                if (l == null) continue;
                                for (String crlPath : l) {
                                    if (crlPaths.contains(crlPath)) continue;
                                    try {
                                        void var13_27;
                                        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
                                        reader.readExternalResource(crlPath, map);
                                        byte[] issuer = null;
                                        if (!map.isEmpty()) {
                                            issuer = (byte[])map.get(crlPath);
                                        }
                                        if (issuer == null || issuer.length <= 0) {
                                            throw new UtilsException("empty resource");
                                        }
                                        Certificate cer = ArchiveLoader.load(issuer);
                                        if (cer == null || cer.getCertificate() == null) continue;
                                        if (crlTrustStore == null) {
                                            java.security.KeyStore ks = java.security.KeyStore.getInstance(KeystoreType.JKS.getNome());
                                            ks.load(null, null);
                                            crlTrustStore = new KeyStore(ks);
                                        }
                                        crlTrustStore.putCertificate("crlIssuerCert-" + (int)var13_27, cer.getCertificate().getCertificate(), false);
                                        ++var13_27;
                                        log.debug("OCSP-CRL: add certificate retrieved from '" + crlPath + "'");
                                    }
                                    catch (Exception t) {
                                        String msgError = "OCSP-CRL [crlssuer: " + crlPath + "] retrieve failed: " + t.getMessage();
                                        log.debug(msgError, t);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception t) {
                    throw new UtilsException(t.getMessage(), t);
                }
                try {
                    AuthorityInformationAccess aia = certificate.getAuthorityInformationAccess();
                    if (aia == null) continue;
                    List<String> issuer = aia.getCAIssuers();
                    boolean bl = false;
                    if (issuer == null || issuer.isEmpty()) continue;
                    for (String urlIssuer : issuer) {
                        void var13_29;
                        Certificate cer;
                        byte[] byArray;
                        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
                        reader.readExternalResource(urlIssuer, map);
                        if (map.isEmpty() || (byArray = (byte[])map.get(urlIssuer)) == null || (cer = ArchiveLoader.load(byArray)) == null || cer.getCertificate() == null) continue;
                        if (crlTrustStore == null) {
                            java.security.KeyStore ks = java.security.KeyStore.getInstance(KeystoreType.JKS.getNome());
                            ks.load(null, null);
                            crlTrustStore = new KeyStore(ks);
                        }
                        crlTrustStore.putCertificate("aiaIssuerCert-" + (int)var13_29, cer.getCertificate().getCertificate(), false);
                        ++var13_29;
                        log.debug("OCSP-CRL-AIA: add certificate retrieved from '" + urlIssuer + "'");
                    }
                }
                catch (Exception t) {
                    throw new UtilsException(t.getMessage(), t);
                }
            }
        }
        CRLParams params = new CRLParams();
        if (!crlPaths.isEmpty()) {
            params.crlCertstore = reader.readCRL(crlPaths, localResources).getCertStore();
            params.crlTrustStore = crlTrustStore;
        }
        return params;
    }

    private static void readCrlPath(String crlPath, List<String> crlPaths, Map<String, byte[]> localResources, List<Throwable> listExceptions, IOCSPResourceReader reader, LoggerBuffer log) {
        if (!crlPaths.contains(crlPath)) {
            try {
                HashMap<String, byte[]> map = new HashMap<String, byte[]>();
                reader.readExternalResource(crlPath, map);
                byte[] crl = null;
                if (!map.isEmpty()) {
                    crl = (byte[])map.get(crlPath);
                }
                if (crl == null || crl.length <= 0) {
                    throw new UtilsException("empty resource");
                }
                localResources.put(crlPath, crl);
                crlPaths.add(crlPath);
                log.debug("OCSP-CRL: add external resource '" + crlPath + "'");
            }
            catch (Exception t) {
                String msgError = "[crl: " + crlPath + "] retrieve failed: " + t.getMessage();
                log.debug("OCSP-CRL " + msgError, t);
                listExceptions.add(new Exception(msgError, t));
            }
        }
    }
}

