/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.ocsp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ExtendedKeyUsage;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.ocsp.CertificateSource;
import org.openspcoop2.utils.certificate.ocsp.OCSPResponseCode;
import org.openspcoop2.utils.random.SecureRandomAlgorithm;
import org.slf4j.Logger;

public class OCSPConfig {
    private String id;
    private String type;
    private String label;
    private boolean certificateChainVerify = true;
    private boolean checkValidity = true;
    private boolean checkCAValidity = true;
    private List<CertificateSource> caSource = new ArrayList<CertificateSource>();
    private String alternativeTrustStoreCAPath;
    private String alternativeTrustStoreCAPassword;
    private String alternativeTrustStoreCAType;
    private boolean rejectsCertificateWithoutCA = true;
    private String trustStoreSignerPath;
    private String trustStoreSignerPassword;
    private String trustStoreSignerType;
    private String aliasCertificateSigner;
    private boolean nonce;
    private List<CertificateSource> responderUrlSource = new ArrayList<CertificateSource>();
    private List<String> alternativeResponderUrl;
    private List<String> alternativeResponderUrlCA;
    private boolean rejectsCertificateWithoutResponderUrl = true;
    private boolean rejectsCAWithoutResponderUrl = false;
    private List<OCSPResponseCode> responderBreakStatus = null;
    private List<Integer> responderReturnCodeOk = null;
    private List<ExtendedKeyUsage> extendedKeyUsageRequired = null;
    private int readTimeout = 120000;
    private int connectTimeout = 10000;
    private boolean externalResourcesHostnameVerifier = true;
    private boolean externalResourcesTrustAllCerts = false;
    private String externalResourcesTrustStorePath;
    private String externalResourcesTrustStorePassword;
    private String externalResourcesTrustStoreType;
    private String externalResourcesKeyStorePath;
    private String externalResourcesKeyStorePassword;
    private String externalResourcesKeyStoreType;
    private String externalResourcesKeyAlias;
    private String externalResourcesKeyPassword;
    private String externalResourcesUsername;
    private String externalResourcesPassword;
    private String forwardProxyUrl;
    private String forwardProxyHeader;
    private String forwardProxyQueryParameter;
    private boolean forwardProxyBase64;
    private SecureRandomAlgorithm secureRandomAlgorithm;
    private int responseCheckDateToleranceMilliseconds;
    private boolean crlSigningCertCheck = false;
    private boolean crlCaCheck = false;
    private boolean crl = false;
    private List<CertificateSource> crlSource = new ArrayList<CertificateSource>();
    private List<String> crlAlternative = null;
    private boolean rejectsCertificateWithoutCRL = false;
    private boolean rejectsCAWithoutCRL = false;
    private List<CertificateSource> crlTrustStoreSource = new ArrayList<CertificateSource>();
    private String alternativeTrustStoreCRLPath;
    private String alternativeTrustStoreCRLPassword;
    private String alternativeTrustStoreCRLType;

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isCertificateChainVerify() {
        return this.certificateChainVerify;
    }

    public boolean isCheckValidity() {
        return this.checkValidity;
    }

    public boolean isCheckCAValidity() {
        return this.checkCAValidity;
    }

    public List<CertificateSource> getCaSource() {
        return this.caSource;
    }

    public String getAlternativeTrustStoreCAPath() {
        return this.alternativeTrustStoreCAPath;
    }

    public String getAlternativeTrustStoreCAPassword() {
        return this.alternativeTrustStoreCAPassword;
    }

    public String getAlternativeTrustStoreCAType() {
        return this.alternativeTrustStoreCAType;
    }

    public boolean isRejectsCertificateWithoutCA() {
        return this.rejectsCertificateWithoutCA;
    }

    public String getTrustStoreSignerPath() {
        return this.trustStoreSignerPath;
    }

    public String getTrustStoreSignerPassword() {
        return this.trustStoreSignerPassword;
    }

    public String getTrustStoreSignerType() {
        return this.trustStoreSignerType;
    }

    public String getAliasCertificateSigner() {
        return this.aliasCertificateSigner;
    }

    public boolean isNonce() {
        return this.nonce;
    }

    public List<CertificateSource> getResponderUrlSource() {
        return this.responderUrlSource;
    }

    public List<String> getAlternativeResponderUrl() {
        return this.alternativeResponderUrl;
    }

    public List<String> getAlternativeResponderUrlCA() {
        return this.alternativeResponderUrlCA;
    }

    public boolean isRejectsCertificateWithoutResponderUrl() {
        return this.rejectsCertificateWithoutResponderUrl;
    }

    public boolean isRejectsCAWithoutResponderUrl() {
        return this.rejectsCAWithoutResponderUrl;
    }

    public List<OCSPResponseCode> getResponderBreakStatus() {
        return this.responderBreakStatus;
    }

    public List<Integer> getResponderReturnCodeOk() {
        return this.responderReturnCodeOk;
    }

    public List<ExtendedKeyUsage> getExtendedKeyUsageRequired() {
        return this.extendedKeyUsageRequired;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isExternalResourcesHostnameVerifier() {
        return this.externalResourcesHostnameVerifier;
    }

    public boolean isExternalResourcesTrustAllCerts() {
        return this.externalResourcesTrustAllCerts;
    }

    public String getExternalResourcesTrustStorePath() {
        return this.externalResourcesTrustStorePath;
    }

    public String getExternalResourcesTrustStorePassword() {
        return this.externalResourcesTrustStorePassword;
    }

    public String getExternalResourcesTrustStoreType() {
        return this.externalResourcesTrustStoreType;
    }

    public String getExternalResourcesKeyStorePath() {
        return this.externalResourcesKeyStorePath;
    }

    public String getExternalResourcesKeyStorePassword() {
        return this.externalResourcesKeyStorePassword;
    }

    public String getExternalResourcesKeyStoreType() {
        return this.externalResourcesKeyStoreType;
    }

    public String getExternalResourcesKeyAlias() {
        return this.externalResourcesKeyAlias;
    }

    public String getExternalResourcesKeyPassword() {
        return this.externalResourcesKeyPassword;
    }

    public String getExternalResourcesUsername() {
        return this.externalResourcesUsername;
    }

    public String getExternalResourcesPassword() {
        return this.externalResourcesPassword;
    }

    public String getForwardProxyUrl() {
        return this.forwardProxyUrl;
    }

    public String getForwardProxyHeader() {
        return this.forwardProxyHeader;
    }

    public String getForwardProxyQueryParameter() {
        return this.forwardProxyQueryParameter;
    }

    public boolean isForwardProxyBase64() {
        return this.forwardProxyBase64;
    }

    public SecureRandomAlgorithm getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public int getResponseCheckDateToleranceMilliseconds() {
        return this.responseCheckDateToleranceMilliseconds;
    }

    public boolean isCrlSigningCertCheck() {
        return this.crlSigningCertCheck;
    }

    public boolean isCrlCaCheck() {
        return this.crlCaCheck;
    }

    public boolean isCrl() {
        return this.crl;
    }

    public List<CertificateSource> getCrlSource() {
        return this.crlSource;
    }

    public List<String> getCrlAlternative() {
        return this.crlAlternative;
    }

    public boolean isRejectsCertificateWithoutCRL() {
        return this.rejectsCertificateWithoutCRL;
    }

    public boolean isRejectsCAWithoutCRL() {
        return this.rejectsCAWithoutCRL;
    }

    public List<CertificateSource> getCrlTrustStoreSource() {
        return this.crlTrustStoreSource;
    }

    public String getAlternativeTrustStoreCRLPath() {
        return this.alternativeTrustStoreCRLPath;
    }

    public String getAlternativeTrustStoreCRLPassword() {
        return this.alternativeTrustStoreCRLPassword;
    }

    public String getAlternativeTrustStoreCRLType() {
        return this.alternativeTrustStoreCRLType;
    }

    protected OCSPConfig(String id, Properties p, Logger log) throws UtilsException {
        String tmp;
        this.id = id;
        if (log != null) {
            // empty if block
        }
        if (p == null || p.isEmpty()) {
            throw new UtilsException("Properties 'ocsp." + id + ".*' undefined");
        }
        this.type = OCSPConfig.getProperty(id, p, "type", true);
        this.label = OCSPConfig.getProperty(id, p, "label", true);
        this.certificateChainVerify = OCSPConfig.getBooleanProperty(id, p, "certificateChainVerify", false, true);
        this.checkValidity = OCSPConfig.getBooleanProperty(id, p, "checkValidity", false, true);
        this.checkCAValidity = OCSPConfig.getBooleanProperty(id, p, "checkCAValidity", false, true);
        this.caSource = OCSPConfig.getCertificateSourceProperty(id, p, "ca.source", true, null);
        this.alternativeTrustStoreCAPath = OCSPConfig.getProperty(id, p, "ca.alternativeTrustStore", false);
        if (this.alternativeTrustStoreCAPath != null && StringUtils.isNotEmpty((String)this.alternativeTrustStoreCAPath)) {
            this.alternativeTrustStoreCAPassword = OCSPConfig.getProperty(id, p, "ca.alternativeTrustStore.password", true);
            this.alternativeTrustStoreCAType = OCSPConfig.getProperty(id, p, "ca.alternativeTrustStore.type", false);
            if (this.alternativeTrustStoreCAType == null || StringUtils.isEmpty((String)this.alternativeTrustStoreCAType)) {
                this.alternativeTrustStoreCAType = KeystoreType.JKS.getNome();
            }
        }
        this.rejectsCertificateWithoutCA = OCSPConfig.getBooleanProperty(id, p, "ca.notFound.rejectsCertificate", false, true);
        this.trustStoreSignerPath = OCSPConfig.getProperty(id, p, "signer.trustStore", false);
        if (this.trustStoreSignerPath != null && StringUtils.isNotEmpty((String)this.trustStoreSignerPath)) {
            this.trustStoreSignerPassword = OCSPConfig.getProperty(id, p, "signer.trustStore.password", true);
            this.trustStoreSignerType = OCSPConfig.getProperty(id, p, "signer.trustStore.type", false);
            if (this.trustStoreSignerType == null || StringUtils.isEmpty((String)this.trustStoreSignerType)) {
                this.trustStoreSignerType = KeystoreType.JKS.getNome();
            }
        }
        String prefix = "Property 'ocsp." + id + ".";
        this.aliasCertificateSigner = OCSPConfig.getProperty(id, p, "signer.alias", false);
        if (this.aliasCertificateSigner != null && StringUtils.isNotEmpty((String)this.aliasCertificateSigner) && (this.trustStoreSignerPath == null || StringUtils.isEmpty((String)this.trustStoreSignerPath))) {
            throw new UtilsException(prefix + "signer.alias' require property 'ocsp." + id + ".signer.trustStore'");
        }
        this.nonce = OCSPConfig.getBooleanProperty(id, p, "nonce.enabled", false, true);
        this.crl = OCSPConfig.getBooleanProperty(id, p, "crl.enabled", false, false);
        this.responderUrlSource = this.crl ? OCSPConfig.getCertificateSourceProperty(id, p, "url.source", false, null) : OCSPConfig.getCertificateSourceProperty(id, p, "url.source", true, null);
        if (this.responderUrlSource != null && this.responderUrlSource.contains(CertificateSource.CONFIG)) {
            throw new UtilsException(prefix + "url.source' declare unsupported '" + CertificateSource.CONFIG + "' mode");
        }
        this.alternativeResponderUrl = OCSPConfig.getListProperty(id, p, "url.alternative", false, null);
        this.alternativeResponderUrlCA = OCSPConfig.getListProperty(id, p, "url.alternative.ca", false, null);
        this.rejectsCertificateWithoutResponderUrl = OCSPConfig.getBooleanProperty(id, p, "url.notFound.rejectsCertificate", false, true);
        this.rejectsCAWithoutResponderUrl = OCSPConfig.getBooleanProperty(id, p, "url.notFound.rejectsCA", false, false);
        this.responderBreakStatus = OCSPConfig.getOCSPResponseCodeProperty(id, p, "url.breakStatus", false, null);
        this.responderReturnCodeOk = OCSPConfig.getListIntProperty(id, p, "url.returnCodeOk", false, null);
        ArrayList<ExtendedKeyUsage> extendedKeyUsageRequiredDefault = new ArrayList<ExtendedKeyUsage>();
        extendedKeyUsageRequiredDefault.add(ExtendedKeyUsage.OCSP_SIGNING);
        this.extendedKeyUsageRequired = OCSPConfig.getExtendedKeyUsageProperty(id, p, "extendedKeyUsage", extendedKeyUsageRequiredDefault);
        this.readTimeout = OCSPConfig.getIntProperty(id, p, "readTimeout", false, 15000);
        this.connectTimeout = OCSPConfig.getIntProperty(id, p, "connectTimeout", false, 10000);
        this.externalResourcesHostnameVerifier = OCSPConfig.getBooleanProperty(id, p, "https.hostnameVerifier", false, true);
        this.externalResourcesTrustAllCerts = OCSPConfig.getBooleanProperty(id, p, "https.trustAllCerts", false, false);
        this.externalResourcesTrustStorePath = OCSPConfig.getProperty(id, p, "https.trustStore", false);
        if (this.externalResourcesTrustStorePath != null && StringUtils.isNotEmpty((String)this.externalResourcesTrustStorePath)) {
            this.externalResourcesTrustStorePassword = OCSPConfig.getProperty(id, p, "https.trustStore.password", true);
            this.externalResourcesTrustStoreType = OCSPConfig.getProperty(id, p, "https.trustStore.type", false);
            if (this.externalResourcesTrustStoreType == null || StringUtils.isEmpty((String)this.externalResourcesTrustStoreType)) {
                this.externalResourcesTrustStoreType = KeystoreType.JKS.getNome();
            }
        }
        this.externalResourcesKeyStorePath = OCSPConfig.getProperty(id, p, "https.keyStore", false);
        if (this.externalResourcesKeyStorePath != null && StringUtils.isNotEmpty((String)this.externalResourcesKeyStorePath)) {
            this.externalResourcesKeyStorePassword = OCSPConfig.getProperty(id, p, "https.keyStore.password", true);
            this.externalResourcesKeyStoreType = OCSPConfig.getProperty(id, p, "https.keyStore.type", false);
            if (this.externalResourcesKeyStoreType == null || StringUtils.isEmpty((String)this.externalResourcesKeyStoreType)) {
                this.externalResourcesKeyStoreType = KeystoreType.JKS.getNome();
            }
            this.externalResourcesKeyPassword = OCSPConfig.getProperty(id, p, "https.key.password", true);
            this.externalResourcesKeyAlias = OCSPConfig.getProperty(id, p, "https.key.alias", false);
        }
        this.externalResourcesUsername = OCSPConfig.getProperty(id, p, "username", false);
        if (this.externalResourcesUsername != null && StringUtils.isNotEmpty((String)this.externalResourcesUsername)) {
            this.externalResourcesPassword = OCSPConfig.getProperty(id, p, "password", false);
        }
        this.forwardProxyUrl = OCSPConfig.getProperty(id, p, "forwardProxy.url", false);
        if (this.forwardProxyUrl != null && StringUtils.isNotEmpty((String)this.forwardProxyUrl)) {
            this.forwardProxyHeader = OCSPConfig.getProperty(id, p, "forwardProxy.header", false);
            this.forwardProxyQueryParameter = OCSPConfig.getProperty(id, p, "forwardProxy.queryParameter", false);
            if (this.forwardProxyHeader == null && this.forwardProxyQueryParameter == null) {
                throw new UtilsException("ForwardProxy property 'ocsp." + id + ".forwardProxy.url' require 'ocsp." + id + ".forwardProxy.header' o 'ocsp." + id + ".forwardProxy.queryParameter'");
            }
            this.forwardProxyBase64 = OCSPConfig.getBooleanProperty(id, p, "forwardProxy.base64", false, true);
        }
        if ((tmp = OCSPConfig.getProperty(id, p, "secureRandomAlgorithm", false)) != null && StringUtils.isNotEmpty((String)tmp)) {
            try {
                this.secureRandomAlgorithm = SecureRandomAlgorithm.valueOf(tmp);
            }
            catch (Exception t) {
                throw new UtilsException("SecureRandomAlgorithm property 'ocsp." + id + ".secureRandomAlgorithm' invalid (found value:[" + tmp + "]): " + t.getMessage(), t);
            }
        }
        if (this.secureRandomAlgorithm == null) {
            this.secureRandomAlgorithm = SecureRandomAlgorithm.SHA1PRNG;
        }
        int defaultTolerance = 600000;
        this.responseCheckDateToleranceMilliseconds = OCSPConfig.getIntProperty(id, p, "response.date.toleranceMilliseconds", false, defaultTolerance);
        this.crlSigningCertCheck = OCSPConfig.getBooleanProperty(id, p, "crl.signingCert.check", false, false);
        this.crlCaCheck = OCSPConfig.getBooleanProperty(id, p, "crl.ca.check", false, true);
        if (this.crl || this.crlSigningCertCheck || this.crlCaCheck) {
            ArrayList<CertificateSource> defaultValue = new ArrayList<CertificateSource>();
            defaultValue.add(CertificateSource.AUTHORITY_INFORMATION_ACCESS);
            this.crlSource = OCSPConfig.getCertificateSourceProperty(id, p, "crl.source", false, defaultValue);
            if (this.crlSource == null || this.crlSource.isEmpty()) {
                throw new UtilsException(prefix + "crl.source' is empty");
            }
            if (this.crlSigningCertCheck && !this.crlSource.contains(CertificateSource.AUTHORITY_INFORMATION_ACCESS)) {
                throw new UtilsException(prefix + "crl.signingCert.check' require mode '" + CertificateSource.AUTHORITY_INFORMATION_ACCESS + "' defined in property 'ocsp." + id + ".crl.source'");
            }
            if (this.crlCaCheck && !this.crlSource.contains(CertificateSource.AUTHORITY_INFORMATION_ACCESS)) {
                throw new UtilsException(prefix + "crl.ca.check' require mode '" + CertificateSource.AUTHORITY_INFORMATION_ACCESS + "' defined in property 'ocsp." + id + ".crl.source'");
            }
            this.crlAlternative = OCSPConfig.getListProperty(id, p, "crl.alternative", false, null);
            this.rejectsCertificateWithoutCRL = OCSPConfig.getBooleanProperty(id, p, "crl.notFound.rejectsCertificate", false, false);
            this.rejectsCAWithoutCRL = OCSPConfig.getBooleanProperty(id, p, "crl.notFound.rejectsCA", false, false);
            this.crlTrustStoreSource = OCSPConfig.getCertificateSourceProperty(id, p, "crl.trustStore.source", false, defaultValue);
            if (this.crlTrustStoreSource == null || this.crlTrustStoreSource.isEmpty()) {
                throw new UtilsException(prefix + "crl.trustStore.source' is empty");
            }
            this.alternativeTrustStoreCRLPath = OCSPConfig.getProperty(id, p, "crl.alternativeTrustStore", false);
            if (this.alternativeTrustStoreCRLPath != null && StringUtils.isNotEmpty((String)this.alternativeTrustStoreCRLPath)) {
                this.alternativeTrustStoreCRLPassword = OCSPConfig.getProperty(id, p, "crl.alternativeTrustStore.password", true);
                this.alternativeTrustStoreCRLType = OCSPConfig.getProperty(id, p, "crl.alternativeTrustStore.type", false);
                if (this.alternativeTrustStoreCRLType == null || StringUtils.isEmpty((String)this.alternativeTrustStoreCRLType)) {
                    this.alternativeTrustStoreCRLType = KeystoreType.JKS.getNome();
                }
            }
        }
    }

    private static String getProperty(String id, Properties p, String name, boolean required) throws UtilsException {
        String tmp = p.getProperty(name);
        if (tmp != null) {
            return tmp.trim();
        }
        if (required) {
            throw new UtilsException("Property 'ocsp." + id + "." + name + "' notFound");
        }
        return null;
    }

    private static boolean getBooleanProperty(String id, Properties p, String name, boolean required, boolean defaultValue) throws UtilsException {
        String tmp = OCSPConfig.getProperty(id, p, name, required);
        if (tmp != null && StringUtils.isNotEmpty((String)tmp)) {
            try {
                return Boolean.valueOf(tmp);
            }
            catch (Exception t) {
                throw new UtilsException("Boolean property 'ocsp." + id + "." + name + "' invalid (found value:[" + tmp + "]): " + t.getMessage(), t);
            }
        }
        return defaultValue;
    }

    private static int getIntProperty(String id, Properties p, String name, boolean required, int defaultValue) throws UtilsException {
        String tmp = OCSPConfig.getProperty(id, p, name, required);
        if (tmp != null && StringUtils.isNotEmpty((String)tmp)) {
            try {
                return Integer.valueOf(tmp);
            }
            catch (Exception t) {
                throw new UtilsException("Boolean property 'ocsp." + id + "." + name + "' invalid (found value:[" + tmp + "]): " + t.getMessage(), t);
            }
        }
        return defaultValue;
    }

    private static List<String> getListProperty(String id, Properties p, String name, boolean required, List<String> defaultValue) throws UtilsException {
        String tmp = OCSPConfig.getProperty(id, p, name, required);
        if (tmp != null && StringUtils.isNotEmpty((String)tmp)) {
            try {
                ArrayList<String> l = new ArrayList<String>();
                String[] tmpArray = tmp.split(",");
                if (tmpArray == null || tmpArray.length <= 0) {
                    throw new UtilsException("Undefined value");
                }
                for (String s : tmpArray) {
                    if (s == null || !StringUtils.isNotEmpty((String)s.trim())) continue;
                    l.add(s.trim());
                }
                return l;
            }
            catch (Exception t) {
                throw new UtilsException("CertificateSource property 'ocsp." + id + "." + name + "' invalid (found value:[" + tmp + "]): " + t.getMessage(), t);
            }
        }
        return defaultValue;
    }

    private static List<Integer> getListIntProperty(String id, Properties p, String name, boolean required, List<Integer> defaultValue) throws UtilsException {
        List<String> l = OCSPConfig.getListProperty(id, p, name, required, null);
        if (l == null || l.isEmpty()) {
            return defaultValue;
        }
        ArrayList<Integer> lCS = new ArrayList<Integer>();
        for (String certificateSource : l) {
            try {
                int c = Integer.parseInt(certificateSource);
                lCS.add(c);
            }
            catch (Exception t) {
                throw new UtilsException("CertificateSource property 'ocsp." + id + "." + name + "' invalid (found value:[" + certificateSource + "]): " + t.getMessage(), t);
            }
        }
        return lCS;
    }

    private static List<CertificateSource> getCertificateSourceProperty(String id, Properties p, String name, boolean required, List<CertificateSource> defaultValue) throws UtilsException {
        List<String> l = OCSPConfig.getListProperty(id, p, name, required, null);
        if (l == null || l.isEmpty()) {
            return defaultValue;
        }
        ArrayList<CertificateSource> lCS = new ArrayList<CertificateSource>();
        for (String certificateSource : l) {
            try {
                CertificateSource c = CertificateSource.valueOf(certificateSource.toUpperCase());
                lCS.add(c);
            }
            catch (Exception t) {
                throw new UtilsException("CertificateSource property 'ocsp." + id + "." + name + "' invalid (found value:[" + certificateSource + "]): " + t.getMessage(), t);
            }
        }
        if (lCS.isEmpty()) {
            return defaultValue;
        }
        return lCS;
    }

    private static List<OCSPResponseCode> getOCSPResponseCodeProperty(String id, Properties p, String name, boolean required, List<OCSPResponseCode> defaultValue) throws UtilsException {
        List<String> l = OCSPConfig.getListProperty(id, p, name, required, null);
        if (l == null || l.isEmpty()) {
            return defaultValue;
        }
        ArrayList<OCSPResponseCode> lCS = new ArrayList<OCSPResponseCode>();
        for (String certificateSource : l) {
            try {
                OCSPResponseCode c = OCSPResponseCode.valueOf(certificateSource.toUpperCase());
                lCS.add(c);
            }
            catch (Exception t) {
                throw new UtilsException("OCSPResponseCode property 'ocsp." + id + "." + name + "' invalid (found value:[" + certificateSource + "]): " + t.getMessage(), t);
            }
        }
        if (lCS.isEmpty()) {
            return defaultValue;
        }
        return lCS;
    }

    private static List<ExtendedKeyUsage> getExtendedKeyUsageProperty(String id, Properties p, String name, List<ExtendedKeyUsage> defaultValue) throws UtilsException {
        String tmp = OCSPConfig.getProperty(id, p, name, false);
        if (tmp != null && "".equals(tmp)) {
            return new ArrayList<ExtendedKeyUsage>();
        }
        List<String> l = OCSPConfig.getListProperty(id, p, name, false, null);
        if (l == null || l.isEmpty()) {
            return defaultValue;
        }
        ArrayList<ExtendedKeyUsage> lCS = new ArrayList<ExtendedKeyUsage>();
        for (String e : l) {
            try {
                ExtendedKeyUsage c = ExtendedKeyUsage.valueOf(e.toUpperCase());
                lCS.add(c);
            }
            catch (Exception t) {
                throw new UtilsException("ExtendedKeyUsage property 'ocsp." + id + "." + name + "' invalid (found value:[" + e + "]): " + t.getMessage(), t);
            }
        }
        if (lCS.isEmpty()) {
            return defaultValue;
        }
        return lCS;
    }
}

