/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.crypt;

import java.io.InputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.crypt.PasswordVerifier;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;

public class PasswordGenerator
extends PasswordVerifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static PasswordGenerator DEFAULT = new PasswordGenerator();
    private String dictionaryChars = "abcdefghijklmnopqrstuvwxyz";
    private String dictionaryNumbers = "1234567890";
    private String dictionaryAlpha = "!?@#$%^&*()-+<>.:_";
    private int defaultLength = 10;
    private boolean base64 = false;
    private boolean hex = false;
    private String prefix = null;
    private String suffix = null;
    private SecureRandom random = new SecureRandom();

    public static void main(String[] args) throws UtilsException {
        System.out.println(DEFAULT.generate());
    }

    public PasswordGenerator() {
    }

    public PasswordGenerator(String resource) throws UtilsException {
        super(resource);
    }

    public PasswordGenerator(InputStream is) throws UtilsException {
        super(is);
    }

    public PasswordGenerator(Properties p) throws UtilsException {
        super(p);
    }

    public PasswordGenerator(PasswordVerifier pv) throws UtilsException {
        super(pv);
        if (!(this.includeLowerCaseLetter || this.includeUpperCaseLetter || this.includeNumber)) {
            this.includeLowerCaseLetter = DEFAULT.isIncludeLowerCaseLetter();
            this.includeUpperCaseLetter = DEFAULT.isIncludeUpperCaseLetter();
            this.includeNumber = DEFAULT.isIncludeNumber();
        }
    }

    public String getDictionaryChars() {
        return this.dictionaryChars;
    }

    public void setDictionaryChars(String dictionaryChars) {
        this.dictionaryChars = dictionaryChars;
    }

    public String getDictionaryNumbers() {
        return this.dictionaryNumbers;
    }

    public void setDictionaryNumbers(String dictionaryNumbers) {
        this.dictionaryNumbers = dictionaryNumbers;
    }

    public String getDictionaryAlpha() {
        return this.dictionaryAlpha;
    }

    public void setDictionaryAlpha(String dictionaryAlpha) {
        this.dictionaryAlpha = dictionaryAlpha;
    }

    public int getDefaultLength() {
        return this.defaultLength;
    }

    public void setDefaultLength(int defaultLength) {
        this.defaultLength = defaultLength;
    }

    public boolean isBase64() {
        return this.base64;
    }

    public void setBase64(boolean base64) {
        this.base64 = base64;
    }

    public boolean isHex() {
        return this.hex;
    }

    public void setHex(boolean hex) {
        this.hex = hex;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String generate() throws UtilsException {
        if (this.minLenght > 0 && this.defaultLength < this.minLenght) {
            this.defaultLength = this.minLenght;
        }
        if (this.maxLenght > 0 && this.defaultLength > this.maxLenght) {
            this.defaultLength = this.maxLenght;
        }
        return this.generate(this.defaultLength);
    }

    public String generate(int length) throws UtilsException {
        return this.generate("login", length);
    }

    public String generate(String username, int length) throws UtilsException {
        if (this.minLenght > 0 && length < this.minLenght) {
            throw new UtilsException("La password deve essere composta almeno da " + this.minLenght + " caratteri");
        }
        if (this.maxLenght > 0 && length > this.maxLenght) {
            throw new UtilsException("La password non deve essere composta da pi\u00f9 di " + this.minLenght + " caratteri");
        }
        int tentativi = 100;
        for (int i = 0; i < tentativi; ++i) {
            Object password = this._generate(length);
            if (!this.validate(username, (String)password)) continue;
            if (this.base64) {
                password = Base64Utilities.encodeAsString(((String)password).getBytes());
            } else if (this.hex) {
                password = HexBinaryUtilities.encodeAsString(((String)password).getBytes());
            }
            if (this.prefix != null) {
                password = this.prefix + (String)password;
            }
            if (this.suffix != null) {
                password = (String)password + this.suffix;
            }
            return password;
        }
        throw new UtilsException("La generazione non \u00e8 riuscita a produrre una password che soddisfi tutti i vincoli");
    }

    private String _generate(int length) throws UtilsException {
        if (!(this.includeLowerCaseLetter || this.includeUpperCaseLetter || this.includeNumber)) {
            throw new UtilsException("La generazione richiede almeno che l'utilizzo di numeri o caratteri sia abilitato");
        }
        ArrayList<Object> password = new ArrayList<Object>();
        String tmpDictionaryCharsLowerCase = new String(this.dictionaryChars);
        String tmpDictionaryCharsUpperCase = new String(this.dictionaryChars);
        String tmpDictionaryNumbers = new String(this.dictionaryNumbers);
        String tmpDictionaryAlpha = new String(this.dictionaryAlpha);
        int i = 0;
        if (this.includeNotAlphanumericSymbol) {
            int randomOffset = this.random.nextInt(tmpDictionaryAlpha.length());
            String s = "" + tmpDictionaryAlpha.charAt(randomOffset);
            password.add(s);
            ++i;
            if (this.allDistinctCharacters) {
                tmpDictionaryAlpha = tmpDictionaryAlpha.replace(s, "");
            }
        }
        while (i < length) {
            Object s;
            boolean addChar = false;
            if (this.includeLowerCaseLetter && tmpDictionaryCharsLowerCase.length() > 0) {
                int randomOffset = this.random.nextInt(tmpDictionaryCharsLowerCase.length());
                s = "" + tmpDictionaryCharsLowerCase.charAt(randomOffset);
                password.add(s);
                addChar = true;
                ++i;
                if (this.allDistinctCharacters) {
                    tmpDictionaryCharsLowerCase = tmpDictionaryCharsLowerCase.replace((CharSequence)s, "");
                }
            }
            if (i >= length) break;
            if (this.includeUpperCaseLetter && tmpDictionaryCharsUpperCase.length() > 0) {
                int randomOffset = this.random.nextInt(tmpDictionaryCharsUpperCase.length());
                s = "" + tmpDictionaryCharsUpperCase.charAt(randomOffset);
                password.add(((String)s).toUpperCase());
                addChar = true;
                ++i;
                if (this.allDistinctCharacters) {
                    tmpDictionaryCharsUpperCase = tmpDictionaryCharsUpperCase.replace((CharSequence)s, "");
                }
            }
            if (i >= length) break;
            if (this.includeNumber && tmpDictionaryNumbers.length() > 0) {
                int randomOffset = this.random.nextInt(tmpDictionaryNumbers.length());
                s = "" + tmpDictionaryNumbers.charAt(randomOffset);
                password.add(s);
                addChar = true;
                ++i;
                if (this.allDistinctCharacters) {
                    tmpDictionaryNumbers = tmpDictionaryNumbers.replace((CharSequence)s, "");
                }
            }
            if (addChar) continue;
            throw new UtilsException("Sono terminati i caratteri utilizzabili per la generazione della password di lunghezza '" + length + "'");
        }
        Collections.shuffle(password);
        StringBuilder bf = new StringBuilder();
        for (Object s : password) {
            bf.append((String)s);
        }
        return bf.toString();
    }

    static {
        DEFAULT.setIncludeLowerCaseLetter(true);
        DEFAULT.setIncludeUpperCaseLetter(true);
        DEFAULT.setIncludeNumber(true);
        DEFAULT.setIncludeNotAlphanumericSymbol(true);
    }
}

