/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.crypt.test;

import org.openspcoop2.utils.crypt.CodecType;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.CryptFactory;
import org.openspcoop2.utils.crypt.ICrypt;

public class CodecCryptTest {
    public static void main(String[] args) throws Exception {
        CodecCryptTest.test();
    }

    public static void test() throws Exception {
        CodecType[] types;
        for (CodecType cryptType : types = CodecType.values()) {
            CodecCryptTest.test(cryptType, false, null, null);
            CodecCryptTest.test(cryptType, true, null, null);
            for (int i = 1; i <= 5; ++i) {
                CodecCryptTest.test(cryptType, false, 4 * i, null);
                CodecCryptTest.test(cryptType, true, 4 * i, null);
            }
        }
        types = new CodecType[]{CodecType.SHA2_BASED_UNIX_CRYPT_SHA256, CodecType.SHA2_BASED_UNIX_CRYPT_SHA512};
        for (CodecType cryptType : types) {
            int iteration = 1;
            for (int i = 1; i <= 5; ++i) {
                if (i == 2) {
                    iteration = 100;
                } else if (i == 3) {
                    iteration = 1000;
                } else if (i == 4) {
                    iteration = 5000;
                } else if (i == 5) {
                    iteration = 10000;
                }
                CodecCryptTest.test(cryptType, false, 4 * i, iteration);
                CodecCryptTest.test(cryptType, true, 4 * i, iteration);
            }
        }
    }

    public static void test(CodecType type, boolean useSecureRandom, Integer saltLength, Integer iteration) throws Exception {
        boolean verifica;
        String passwordEncrypted;
        StringBuilder sb = new StringBuilder(type.name());
        sb.append(" secureRandom:").append(useSecureRandom);
        if (saltLength != null) {
            sb.append(" saltLength:").append(saltLength);
        }
        if (iteration != null) {
            sb.append(" iteration:").append(iteration);
        }
        System.out.println("\n\n ------------------- " + sb.toString() + " --------------------");
        CryptConfig config = new CryptConfig();
        config.setUseSecureRandom(useSecureRandom);
        if (saltLength != null) {
            config.setSaltLength(saltLength);
        }
        if (iteration != null) {
            config.setIteration(iteration);
        }
        ICrypt passwordEngine = CryptFactory.getCrypt(type.toCryptType(), config);
        if (CodecType.LIBC_CRYPT_MD5.equals((Object)type)) {
            passwordEncrypted = "$1$il$SPDpFtwmXna8U/e.t9IuP.";
            verifica = passwordEngine.check("123456", passwordEncrypted);
            if (!verifica) {
                throw new Exception("[" + sb.toString() + "] Verifica password di default fallita");
            }
            verifica = passwordEngine.check("1234567", passwordEncrypted);
            if (verifica) {
                throw new Exception("[" + sb.toString() + "] Attesa verifica fallita per password di default");
            }
            System.out.println("OK; password di default 123456");
        }
        passwordEncrypted = null;
        switch (type) {
            case LIBC_CRYPT_MD5: {
                passwordEncrypted = "$1$4hG9hTWx$getysg42XDQzoOmMswdX51";
                break;
            }
            case LIBC_CRYPT_MD5_APACHE: {
                passwordEncrypted = "$apr1$JjhIpgEA$DqHJzYnkPMZgk0bm6OLmk0";
                break;
            }
            case SHA2_BASED_UNIX_CRYPT_SHA256: {
                passwordEncrypted = "$5$D7NZJ1aJP6v7z2fc$CVRwPYaZYnCEJbbb9HmGW2dXWVv0mTJ5BLT5.wT8h.0";
                break;
            }
            case SHA2_BASED_UNIX_CRYPT_SHA512: {
                passwordEncrypted = "$6$nO2cyTasmEO/jRKE$x87pBA4H3XEZx1Y9jVZ7JwueMIlBIluxe6rcXPghJO0tuBICx6Ni2g4oxofVrONuOVbHJGp5vQkTYxFo79wx10";
                break;
            }
            case DES_UNIX_CRYPT: {
                passwordEncrypted = "IGN5Kj/UUU.nY";
            }
        }
        verifica = passwordEngine.check("123456", passwordEncrypted);
        if (!verifica) {
            throw new Exception("[" + sb.toString() + "] Verifica password 'openssl' fallita");
        }
        verifica = passwordEngine.check("1234567", passwordEncrypted);
        if (verifica) {
            throw new Exception("[" + sb.toString() + "] Attesa verifica fallita per password 'openssl'");
        }
        System.out.println("OK; verifica openssl: " + passwordEncrypted);
        String password = "Pr@va.diUn@altroDiverso";
        if (CodecType.DES_UNIX_CRYPT.equals((Object)type)) {
            password = "Pr@va";
        }
        passwordEncrypted = passwordEngine.crypt(password);
        String passwordEncrypted2 = passwordEngine.crypt(password);
        String passwordEncrypted3 = passwordEngine.crypt(password);
        if (passwordEncrypted.equals(passwordEncrypted2)) {
            throw new Exception("[" + sb.toString() + "] Attesa generazione di una password cifrata differente; trovata sempre '1' " + passwordEncrypted);
        }
        if (passwordEncrypted.equals(passwordEncrypted3)) {
            throw new Exception("[" + sb.toString() + "] Attesa generazione di una password cifrata differente; trovata sempre '2' " + passwordEncrypted);
        }
        if (passwordEncrypted2.equals(passwordEncrypted3)) {
            throw new Exception("[" + sb.toString() + "] Attesa generazione di una password cifrata differente; trovata sempre '3' " + passwordEncrypted2);
        }
        verifica = passwordEngine.check(password, passwordEncrypted);
        if (!verifica) {
            throw new Exception("[" + sb.toString() + "] Verifica password '" + password + "' fallita");
        }
        verifica = passwordEngine.check(password + "7", passwordEncrypted);
        if (verifica) {
            throw new Exception("[" + sb.toString() + "] Attesa verifica fallita per password '" + password + "7'");
        }
        verifica = passwordEngine.check(password + "ERR", passwordEncrypted);
        if (verifica) {
            throw new Exception("[" + sb.toString() + "] Attesa verifica fallita per password '" + password + "ERR'");
        }
        String salt = null;
        if (!CodecType.DES_UNIX_CRYPT.equals((Object)type)) {
            salt = CodecCryptTest.getCryptoSalt(passwordEncrypted, iteration, type);
            int defaultSaltLength = -1;
            int maxSaltLength = Integer.MAX_VALUE;
            switch (type) {
                case LIBC_CRYPT_MD5: 
                case LIBC_CRYPT_MD5_APACHE: {
                    defaultSaltLength = 8;
                    maxSaltLength = 8;
                    break;
                }
                case SHA2_BASED_UNIX_CRYPT_SHA256: 
                case SHA2_BASED_UNIX_CRYPT_SHA512: {
                    defaultSaltLength = 16;
                    maxSaltLength = 16;
                    break;
                }
                case DES_UNIX_CRYPT: {
                    defaultSaltLength = 2;
                    maxSaltLength = 2;
                }
            }
            int saltLengthVerify = -1;
            saltLengthVerify = saltLength != null ? saltLength : defaultSaltLength;
            if (saltLengthVerify > maxSaltLength) {
                if (salt.length() != defaultSaltLength) {
                    throw new Exception("[" + sb.toString() + "] Lunghezza salt attesa '" + defaultSaltLength + "' (force default) differente da quella trovata '" + salt.length() + "': " + salt);
                }
            } else if (salt.length() != saltLengthVerify) {
                throw new Exception("[" + sb.toString() + "] Lunghezza salt attesa '" + saltLengthVerify + "' differente da quella trovata '" + salt.length() + "': " + salt);
            }
        }
        if (salt != null) {
            System.out.println("salt (" + salt.length() + "): " + salt);
        }
        System.out.println("OK; password generata: " + passwordEncrypted);
    }

    private static String getCryptoSalt(String newS, Integer iteration, CodecType type) {
        StringBuilder sb = new StringBuilder();
        int counter = 0;
        int limit = 3;
        if (iteration != null && (CodecType.SHA2_BASED_UNIX_CRYPT_SHA256.equals((Object)type) || CodecType.SHA2_BASED_UNIX_CRYPT_SHA512.equals((Object)type))) {
            limit = 4;
        }
        for (int i = 0; i < newS.length(); ++i) {
            char c = newS.charAt(i);
            if ('$' == c) {
                if (++counter != limit) continue;
                break;
            }
            if (counter != limit - 1) continue;
            sb.append(c);
        }
        return sb.toString();
    }
}

