/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.crypt.test;

import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.CryptFactory;
import org.openspcoop2.utils.crypt.CryptType;
import org.openspcoop2.utils.crypt.ICrypt;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;

public class OthersCryptTest {
    public static void main(String[] args) throws Exception {
        OthersCryptTest.test();
    }

    public static void test() throws Exception {
        CryptType[] type = new CryptType[]{CryptType.PBE_KEY_SPEC, CryptType.B_CRYPT, CryptType.S_CRYPT, CryptType.PLAIN};
        String[] digestAlgo = new String[]{null, "PBKDF2WithHmacSHA1", "PBKDF2WithHmacSHA224", "PBKDF2WithHmacSHA256", "PBKDF2WithHmacSHA384", "PBKDF2WithHmacSHA512"};
        for (CryptType cryptType : type) {
            if (!CryptType.PBE_KEY_SPEC.equals(cryptType)) {
                OthersCryptTest.test(cryptType, false, null, null, null);
                continue;
            }
            for (int j = 0; j < digestAlgo.length; ++j) {
                String algo = digestAlgo[j];
                OthersCryptTest.test(cryptType, false, null, null, algo);
                OthersCryptTest.test(cryptType, true, null, null, algo);
                for (int i = 1; i <= 5; ++i) {
                    OthersCryptTest.test(cryptType, false, 4 * i, null, algo);
                    OthersCryptTest.test(cryptType, true, 4 * i, null, algo);
                }
                int iteration = 1;
                for (int i = 1; i <= 5; ++i) {
                    if (i == 2) {
                        iteration = 100;
                    } else if (i == 3) {
                        iteration = 1000;
                    } else if (i == 4) {
                        iteration = 5000;
                    } else if (i == 5) {
                        iteration = 10000;
                    }
                    OthersCryptTest.test(cryptType, false, 4 * i, iteration, algo);
                    OthersCryptTest.test(cryptType, true, 4 * i, iteration, algo);
                }
            }
        }
    }

    public static void test(CryptType type, boolean useSecureRandom, Integer saltLength, Integer iteration, String digestAlgo) throws Exception {
        boolean verifica;
        StringBuilder sb = new StringBuilder(type.name());
        CryptConfig config = null;
        if (CryptType.PBE_KEY_SPEC.equals(type)) {
            sb.append(" secureRandom:").append(useSecureRandom);
            if (saltLength != null) {
                sb.append(" saltLength:").append(saltLength);
            }
            if (iteration != null) {
                sb.append(" iteration:").append(iteration);
            }
            if (digestAlgo != null) {
                sb.append(" digestAlgo:").append(digestAlgo);
            }
            config = new CryptConfig();
            config.setUseSecureRandom(useSecureRandom);
            if (saltLength != null) {
                config.setSaltLength(saltLength);
            }
            if (iteration != null) {
                config.setIteration(iteration);
            }
            if (digestAlgo != null) {
                config.setDigestAlgorithm(digestAlgo);
            }
        }
        System.out.println("\n\n ------------------- " + sb.toString() + " --------------------");
        ICrypt passwordEngine = CryptFactory.getCrypt(type, config);
        System.out.println("CLASS: " + passwordEngine.getClass().getName());
        String password = "Pr@va.diUn@altroDiverso";
        boolean verificaPasswordDiversa = true;
        if (CryptType.PLAIN.equals(type)) {
            verificaPasswordDiversa = false;
        }
        String passwordEncrypted = passwordEngine.crypt(password);
        if (verificaPasswordDiversa) {
            String passwordEncrypted2 = passwordEngine.crypt(password);
            String passwordEncrypted3 = passwordEngine.crypt(password);
            if (passwordEncrypted.equals(passwordEncrypted2)) {
                throw new Exception("Attesa generazione di una password cifrata differente; trovata sempre '1' " + passwordEncrypted);
            }
            if (passwordEncrypted.equals(passwordEncrypted3)) {
                throw new Exception("Attesa generazione di una password cifrata differente; trovata sempre '2' " + passwordEncrypted);
            }
            if (passwordEncrypted2.equals(passwordEncrypted3)) {
                throw new Exception("Attesa generazione di una password cifrata differente; trovata sempre '3' " + passwordEncrypted2);
            }
        }
        if (!(verifica = passwordEngine.check(password, passwordEncrypted))) {
            throw new Exception("Verifica password '" + password + "' fallita");
        }
        verifica = passwordEngine.check(password + "7", passwordEncrypted);
        if (verifica) {
            throw new Exception("Attesa verifica fallita per password '" + password + "7'");
        }
        verifica = passwordEngine.check(password + "ERR", passwordEncrypted);
        if (verifica) {
            throw new Exception("Attesa verifica fallita per password '" + password + "ERR'");
        }
        if (config != null && CryptType.PBE_KEY_SPEC.equals(type)) {
            config.setUseBase64Encoding(false);
            passwordEngine = CryptFactory.getCrypt(type, config);
            String passwordEncryptedHex = passwordEngine.crypt(password);
            verifica = passwordEngine.check(password, passwordEncryptedHex);
            if (!verifica) {
                throw new Exception("Verifica password hex '" + password + "' fallita");
            }
            if (passwordEncrypted.equals(passwordEncryptedHex)) {
                throw new Exception("Attesa generazione di una password cifrata 'hex' differente; trovata sempre '1' " + passwordEncrypted);
            }
            String[] split = passwordEncrypted.split(":");
            try {
                Base64Utilities.decode(split[1]);
            }
            catch (Exception e) {
                throw new Exception("Verifica fallita della struttura base64 della password cifrata  [" + passwordEncrypted + "] split[1][" + split[1] + "]: " + e.getMessage(), e);
            }
            try {
                Base64Utilities.decode(split[2]);
            }
            catch (Exception e) {
                throw new Exception("Verifica fallita della struttura base64 della password cifrata  [" + passwordEncrypted + "] split[2][" + split[2] + "]: " + e.getMessage(), e);
            }
            split = passwordEncryptedHex.split(":");
            try {
                HexBinaryUtilities.decode(split[1]);
            }
            catch (Exception e) {
                throw new Exception("Verifica fallita della struttura hex della password cifrata  [" + passwordEncryptedHex + "] split[1][" + split[1] + "]: " + e.getMessage(), e);
            }
            try {
                HexBinaryUtilities.decode(split[2]);
            }
            catch (Exception e) {
                throw new Exception("Verifica fallita della struttura hex della password cifrata  [" + passwordEncryptedHex + "] split[2][" + split[2] + "]: " + e.getMessage(), e);
            }
            System.out.println("password generata 'hex': " + passwordEncryptedHex);
        }
        System.out.println("password generata 'base64': " + passwordEncrypted);
        System.out.println("OK");
    }
}

